/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.SslError;
import android.os.Bundle;
import java.net.MalformedURLException;
import java.net.URL;

final class SslCertLookupTable {
    private static SslCertLookupTable sTable;
    private final Bundle table = new Bundle();

    public static SslCertLookupTable getInstance() {
        if (sTable == null) {
            sTable = new SslCertLookupTable();
        }
        return sTable;
    }

    private SslCertLookupTable() {
    }

    public void setIsAllowed(SslError sslError) {
        String host;
        try {
            host = new URL(sslError.getUrl()).getHost();
        }
        catch (MalformedURLException e) {
            return;
        }
        this.table.putInt(host, sslError.getPrimaryError());
    }

    public boolean isAllowed(SslError sslError) {
        String host;
        try {
            host = new URL(sslError.getUrl()).getHost();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return this.table.containsKey(host) && sslError.getPrimaryError() <= this.table.getInt(host);
    }

    public void clear() {
        this.table.clear();
    }
}

