/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.Point;
import android.graphics.Region;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ViewStateSerializer {
    private static final int WORKING_STREAM_STORAGE = 16384;
    static final int VERSION = 1;

    static boolean serializeViewState(OutputStream stream, WebView web) throws IOException {
        int baseLayer = web.getBaseLayer();
        if (baseLayer == 0) {
            return false;
        }
        DataOutputStream dos = new DataOutputStream(stream);
        dos.writeInt(1);
        dos.writeInt(web.getContentWidth());
        dos.writeInt(web.getContentHeight());
        return ViewStateSerializer.nativeSerializeViewState(baseLayer, dos, new byte[16384]);
    }

    static WebViewCore.DrawData deserializeViewState(InputStream stream, WebView web) throws IOException {
        DataInputStream dis = new DataInputStream(stream);
        int version = dis.readInt();
        if (version != 1) {
            throw new IOException("Unexpected version: " + version);
        }
        int contentWidth = dis.readInt();
        int contentHeight = dis.readInt();
        int baseLayer = ViewStateSerializer.nativeDeserializeViewState(dis, new byte[16384]);
        WebViewCore.DrawData draw = new WebViewCore.DrawData();
        draw.mViewState = new WebViewCore.ViewState();
        int viewWidth = web.getViewWidth();
        int viewHeight = web.getViewHeightWithTitle() - web.getTitleHeight();
        draw.mViewSize = new Point(viewWidth, viewHeight);
        draw.mContentSize = new Point(contentWidth, contentHeight);
        draw.mViewState.mDefaultScale = web.getDefaultZoomScale();
        draw.mBaseLayer = baseLayer;
        draw.mInvalRegion = new Region(0, 0, contentWidth, contentHeight);
        return draw;
    }

    private static native boolean nativeSerializeViewState(int var0, OutputStream var1, byte[] var2);

    private static native int nativeDeserializeViewState(InputStream var0, byte[] var1);

    private ViewStateSerializer() {
    }
}

