/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.provider.Browser;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

public final class WebIconDatabase {
    private static final String LOGTAG = "WebIconDatabase";
    private static WebIconDatabase sIconDatabase;
    private final EventHandler mEventHandler = new EventHandler();

    public void open(String path) {
        if (path != null) {
            File db = new File(path);
            if (!db.exists()) {
                db.mkdirs();
            }
            this.mEventHandler.postMessage(Message.obtain(null, 0, db.getAbsolutePath()));
        }
    }

    public void close() {
        this.mEventHandler.postMessage(Message.obtain(null, 1));
    }

    public void removeAllIcons() {
        this.mEventHandler.postMessage(Message.obtain(null, 2));
    }

    public void requestIconForPageUrl(String url, IconListener listener) {
        if (listener == null || url == null) {
            return;
        }
        Message msg = Message.obtain(null, 3, listener);
        msg.getData().putString("url", url);
        this.mEventHandler.postMessage(msg);
    }

    public void bulkRequestIconForPageUrl(ContentResolver cr, String where, IconListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mEventHandler.hasHandler()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contentResolver", cr);
            map.put("where", where);
            map.put("listener", listener);
            Message msg = Message.obtain(null, 6, map);
            this.mEventHandler.postMessage(msg);
        }
    }

    public void retainIconForPageUrl(String url) {
        if (url != null) {
            this.mEventHandler.postMessage(Message.obtain(null, 4, url));
        }
    }

    public void releaseIconForPageUrl(String url) {
        if (url != null) {
            this.mEventHandler.postMessage(Message.obtain(null, 5, url));
        }
    }

    public static WebIconDatabase getInstance() {
        if (sIconDatabase == null) {
            sIconDatabase = new WebIconDatabase();
        }
        return sIconDatabase;
    }

    void createHandler() {
        this.mEventHandler.createHandler();
    }

    private WebIconDatabase() {
    }

    private static native void nativeOpen(String var0);

    private static native void nativeClose();

    private static native void nativeRemoveAllIcons();

    private static native Bitmap nativeIconForPageUrl(String var0);

    private static native void nativeRetainIconForPageUrl(String var0);

    private static native void nativeReleaseIconForPageUrl(String var0);

    public static interface IconListener {
        public void onReceivedIcon(String var1, Bitmap var2);
    }

    private static class EventHandler
    extends Handler {
        static final int OPEN = 0;
        static final int CLOSE = 1;
        static final int REMOVE_ALL = 2;
        static final int REQUEST_ICON = 3;
        static final int RETAIN_ICON = 4;
        static final int RELEASE_ICON = 5;
        static final int BULK_REQUEST_ICON = 6;
        private static final int ICON_RESULT = 10;
        private Handler mHandler;
        private Vector<Message> mMessages = new Vector();

        private EventHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    ((IconResult)msg.obj).dispatch();
                }
            }
        }

        private synchronized void createHandler() {
            if (this.mHandler == null) {
                this.mHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                WebIconDatabase.nativeOpen((String)msg.obj);
                                break;
                            }
                            case 1: {
                                WebIconDatabase.nativeClose();
                                break;
                            }
                            case 2: {
                                WebIconDatabase.nativeRemoveAllIcons();
                                break;
                            }
                            case 3: {
                                IconListener l = (IconListener)msg.obj;
                                String url = msg.getData().getString("url");
                                EventHandler.this.requestIconAndSendResult(url, l);
                                break;
                            }
                            case 6: {
                                EventHandler.this.bulkRequestIcons(msg);
                                break;
                            }
                            case 4: {
                                WebIconDatabase.nativeRetainIconForPageUrl((String)msg.obj);
                                break;
                            }
                            case 5: {
                                WebIconDatabase.nativeReleaseIconForPageUrl((String)msg.obj);
                            }
                        }
                    }
                };
                for (int size = this.mMessages.size(); size > 0; --size) {
                    this.mHandler.sendMessage(this.mMessages.remove(0));
                }
                this.mMessages = null;
            }
        }

        private synchronized boolean hasHandler() {
            return this.mHandler != null;
        }

        private synchronized void postMessage(Message msg) {
            if (this.mMessages != null) {
                this.mMessages.add(msg);
            } else {
                this.mHandler.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulkRequestIcons(Message msg) {
            HashMap map = (HashMap)msg.obj;
            IconListener listener = (IconListener)map.get("listener");
            ContentResolver cr = (ContentResolver)map.get("contentResolver");
            String where = (String)map.get("where");
            Cursor c = null;
            try {
                c = cr.query(Browser.BOOKMARKS_URI, new String[]{"url"}, where, null, null);
                if (c.moveToFirst()) {
                    do {
                        String url = c.getString(0);
                        this.requestIconAndSendResult(url, listener);
                    } while (c.moveToNext());
                }
            }
            catch (IllegalStateException e) {
                Log.e(WebIconDatabase.LOGTAG, "BulkRequestIcons", e);
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }

        private void requestIconAndSendResult(String url, IconListener listener) {
            Bitmap icon = WebIconDatabase.nativeIconForPageUrl(url);
            if (icon != null) {
                this.sendMessage(this.obtainMessage(10, new IconResult(url, icon, listener)));
            }
        }

        private class IconResult {
            private final String mUrl;
            private final Bitmap mIcon;
            private final IconListener mListener;

            IconResult(String url, Bitmap icon, IconListener l) {
                this.mUrl = url;
                this.mIcon = icon;
                this.mListener = l;
            }

            void dispatch() {
                this.mListener.onReceivedIcon(this.mUrl, this.mIcon);
            }
        }
    }
}

