/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.text.BoringLayout;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.Selection;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebTextView
extends AutoCompleteTextView
implements AdapterView.OnItemClickListener {
    static final String LOGTAG = "webtextview";
    private int mRingInset;
    private WebView mWebView;
    private boolean mSingle;
    private int mWidthSpec;
    private int mHeightSpec;
    private int mNodePointer;
    private boolean mGotEnterDown;
    private int mMaxLength;
    private String mPreChange;
    private float mDragStartX;
    private float mDragStartY;
    private long mDragStartTime;
    private boolean mDragSent;
    private boolean mScrolled;
    private boolean mFromWebKit;
    private boolean mFromFocusChange;
    private boolean mFromSetInputType;
    private boolean mGotTouchDown;
    private boolean mHasPerformedLongClick;
    private boolean mInSetTextAndKeepSelection;
    private char[] mCharacter = new char[1];
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private boolean mGotDelete;
    private int mDelSelStart;
    private int mDelSelEnd;
    static final int FORM_NOT_AUTOFILLABLE = -1;
    private boolean mAutoFillable;
    private int mQueryId;
    private boolean mAutoFillProfileIsSet;
    private boolean mInsideRemove;
    private MyResultReceiver mReceiver;
    private static final int NORMAL_TEXT_FIELD = 0;
    private static final int TEXT_AREA = 1;
    private static final int PASSWORD = 2;
    private static final int SEARCH = 3;
    private static final int EMAIL = 4;
    private static final int NUMBER = 5;
    private static final int TELEPHONE = 6;
    private static final int URL = 7;
    private static final int AUTOFILL_FORM = 100;
    private Handler mHandler;

    WebTextView(Context context, WebView webView, int autoFillQueryId) {
        super(context, null, 16843449);
        this.mWebView = webView;
        this.mMaxLength = -1;
        this.setAutoFillable(autoFillQueryId);
        TextPaint paint = this.getPaint();
        int flags = paint.getFlags() & 0xFFFFFEFF | 0x80 | 4;
        paint.setFlags(flags);
        this.setTextColor(-16777216);
        this.setBackgroundDrawable(new ColorDrawable(-1));
        this.setIncludeFontPadding(false);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        WebTextView.this.mWebView.autoFillForm(WebTextView.this.mQueryId);
                    }
                }
            }
        };
        this.mReceiver = new MyResultReceiver(this.mHandler);
        float ringWidth = 2.0f * context.getResources().getDisplayMetrics().density;
        this.mRingInset = (int)ringWidth;
        this.setBackgroundDrawable(new BackgroundDrawable(this.mRingInset));
        this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
    }

    public void setAutoFillable(int queryId) {
        this.mAutoFillable = this.mWebView.getSettings().getAutoFillEnabled() && queryId != -1;
        this.mQueryId = queryId;
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left + this.mRingInset, top + this.mRingInset, right + this.mRingInset, bottom + this.mRingInset);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.isSystem()) {
            return super.dispatchKeyEvent(event);
        }
        boolean down = event.getAction() != 1;
        int keyCode = event.getKeyCode();
        boolean isArrowKey = false;
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                isArrowKey = true;
            }
        }
        if (61 == keyCode) {
            if (down) {
                this.onEditorAction(5);
            }
            return true;
        }
        Editable text = this.getText();
        int oldStart = Selection.getSelectionStart(text);
        int oldEnd = Selection.getSelectionEnd(text);
        if (67 == keyCode) {
            if (oldStart == 0 && oldEnd == 0) {
                this.sendDomEvent(event);
                return true;
            }
            if (down) {
                this.mGotDelete = true;
                this.mDelSelStart = oldStart;
                this.mDelSelEnd = oldEnd;
            }
        }
        if (this.mSingle && (66 == keyCode || 160 == keyCode)) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, keyCode));
                this.sendDomEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }
        if (23 == keyCode) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                this.mWebView.centerKeyPressOnTextField();
            }
            return super.dispatchKeyEvent(event);
        }
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        int oldLength = text.length();
        boolean maxedOut = this.mMaxLength != -1 && oldLength == this.mMaxLength;
        String oldText = maxedOut && oldEnd != oldStart ? text.toString() : "";
        if (super.dispatchKeyEvent(event)) {
            if (66 == keyCode || 160 == keyCode) {
                this.mGotEnterDown = true;
            }
            if (maxedOut && !isArrowKey && keyCode != 67) {
                if (oldEnd == oldStart) {
                    return true;
                }
                if (!oldText.equals(this.getText().toString())) {
                    Editable span = this.getText();
                    int newStart = Selection.getSelectionStart(span);
                    int newEnd = Selection.getSelectionEnd(span);
                    this.mWebView.replaceTextfieldText(0, oldLength, span.toString(), newStart, newEnd);
                    return true;
                }
            }
            return true;
        }
        if (this.mGotEnterDown && !down) {
            return true;
        }
        if (isArrowKey) {
            this.mWebView.resetTrackballTime();
            return down ? this.mWebView.onKeyDown(keyCode, event) : this.mWebView.onKeyUp(keyCode, event);
        }
        return false;
    }

    void ensureLayout() {
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
            AbsoluteLayout.LayoutParams params = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
            if (params != null) {
                this.layout(params.x, params.y, params.x + params.width, params.y + params.height);
            }
        }
    }

    ResultReceiver getResultReceiver() {
        return this.mReceiver;
    }

    boolean isSameTextField(int ptr) {
        return ptr == this.mNodePointer;
    }

    private void lineUpScroll() {
        Layout layout2 = this.getLayout();
        if (this.mWebView != null && layout2 != null) {
            if (this.mSingle) {
                float maxScrollX = layout2.getLineRight(0) - (float)this.getWidth();
                this.mWebView.scrollFocusedTextInputX(maxScrollX > 0.0f ? (float)this.mScrollX / maxScrollX : 0.0f);
            } else {
                this.mWebView.scrollFocusedTextInputY(this.mScrollY);
            }
        }
    }

    @Override
    protected void makeNewLayout(int w, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        super.makeNewLayout(w, hintWidth, boring, hintBoring, ellipsisWidth, bringIntoView);
        this.lineUpScroll();
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        if (this.mWebView != null) {
            outAttrs.fieldName = this.mWebView.nativeFocusCandidateName() + "\\" + this.mWebView.getUrl();
        }
        return connection;
    }

    @Override
    public void onEditorAction(int actionCode) {
        switch (actionCode) {
            case 5: {
                if (!this.mWebView.nativeMoveCursorToNextTextInput()) break;
                this.mWebView.rebuildWebTextView();
                this.setDefaultSelection();
                this.mWebView.invalidate();
                break;
            }
            case 6: {
                super.onEditorAction(actionCode);
                break;
            }
            case 2: 
            case 3: {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, 66));
                this.sendDomEvent(new KeyEvent(1, 66));
            }
        }
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        this.mFromFocusChange = true;
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.mWebView.setActive(true);
        } else if (!this.mInsideRemove) {
            this.mWebView.setActive(false);
        }
        this.mFromFocusChange = false;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (id2 == 0L && position == 0) {
            this.replaceText("");
            WebSettings settings = this.mWebView.getSettings();
            if (this.mAutoFillProfileIsSet) {
                this.mWebView.autoFillForm(this.mQueryId);
            } else {
                this.mWebView.getWebChromeClient().setupAutoFill(this.mHandler.obtainMessage(100));
            }
        }
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.lineUpScroll();
    }

    @Override
    protected void onSelectionChanged(int selStart, int selEnd) {
        if (!(this.mFromWebKit || this.mFromFocusChange || this.mFromSetInputType || this.mWebView == null || this.mInSetTextAndKeepSelection)) {
            this.mWebView.setSelection(selStart, selEnd);
            this.lineUpScroll();
        }
    }

    @Override
    protected void onTextChanged(CharSequence s, int start, int before, int count) {
        boolean useKeyEvents;
        String replacedString;
        String replaceButOne;
        super.onTextChanged(s, start, before, count);
        String postChange = ((Object)s).toString();
        if (this.mPreChange == null || this.mPreChange.equals(postChange) || this.mMaxLength > -1 && this.mPreChange.length() > this.mMaxLength && this.mPreChange.substring(0, this.mMaxLength).equals(postChange)) {
            return;
        }
        if (0 == count) {
            if (before > 0) {
                this.updateCachedTextfield();
                if (this.mGotDelete) {
                    this.mGotDelete = false;
                    int oldEnd = start + before;
                    if (this.mDelSelEnd == oldEnd && (this.mDelSelStart == start || this.mDelSelStart == oldEnd && before == 1)) {
                        this.sendDomEvent(new KeyEvent(0, 67));
                        this.sendDomEvent(new KeyEvent(1, 67));
                        return;
                    }
                }
                this.mWebView.deleteSelection(start, start + before);
            }
            this.mGotDelete = false;
            return;
        }
        this.mGotDelete = false;
        if (count > 1 && before == count - 1 && (replaceButOne = ((Object)this.mPreChange.subSequence(start, start + before)).toString()).equals(replacedString = ((Object)s.subSequence(start, start + before)).toString())) {
            start += before;
            before = 0;
            count = 1;
        }
        this.mPreChange = postChange;
        KeyEvent[] events = null;
        if (count == 1) {
            TextUtils.getChars(s, start + count - 1, start + count, this.mCharacter, 0);
            KeyCharacterMap kmap = KeyCharacterMap.load(-1);
            events = kmap.getEvents(this.mCharacter);
        }
        boolean bl = useKeyEvents = events != null;
        if (useKeyEvents) {
            if (!this.mInSetTextAndKeepSelection) {
                this.mWebView.setSelection(start, start + before);
            }
            int length = events.length;
            for (int i = 0; i < length; ++i) {
                if (KeyEvent.isModifierKey(events[i].getKeyCode())) continue;
                this.sendDomEvent(events[i]);
            }
        } else {
            String replace = ((Object)s.subSequence(start, start + count)).toString();
            this.mWebView.replaceTextfieldText(start, start + before, replace, start + count, start + count);
        }
        this.updateCachedTextfield();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                super.onTouchEvent(event);
                this.mDragStartX = event.getX();
                this.mDragStartY = event.getY();
                this.mDragStartTime = event.getEventTime();
                this.mDragSent = false;
                this.mScrolled = false;
                this.mGotTouchDown = true;
                this.mHasPerformedLongClick = false;
                break;
            }
            case 2: {
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                int slop = ViewConfiguration.get(this.mContext).getScaledTouchSlop();
                Editable buffer = this.getText();
                int initialScrollX = Touch.getInitialScrollX(this, buffer);
                int initialScrollY = Touch.getInitialScrollY(this, buffer);
                super.onTouchEvent(event);
                int dx = Math.abs(this.mScrollX - initialScrollX);
                int dy = Math.abs(this.mScrollY - initialScrollY);
                int smallerSlop = slop / 2;
                if (dx > smallerSlop || dy > smallerSlop) {
                    this.mScrolled = true;
                    this.cancelLongPress();
                    return true;
                }
                if (Math.abs((float)((int)event.getX()) - this.mDragStartX) < (float)slop && Math.abs((float)((int)event.getY()) - this.mDragStartY) < (float)slop) {
                    return true;
                }
                if (this.mWebView != null) {
                    boolean scrolled;
                    if (!this.mDragSent) {
                        this.mWebView.initiateTextFieldDrag(this.mDragStartX, this.mDragStartY, this.mDragStartTime);
                        this.mDragSent = true;
                    }
                    if (scrolled = this.mWebView.textFieldDrag(event)) {
                        this.mScrolled = true;
                        this.cancelLongPress();
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 3: {
                super.onTouchEvent(event);
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                if (!this.mScrolled) {
                    this.cancelLongPress();
                    if (this.mGotTouchDown && this.mWebView != null) {
                        this.mWebView.touchUpOnTextField(event);
                    }
                }
                if (this.mWebView != null && this.mDragSent) {
                    this.mWebView.onTouchEvent(event);
                }
                this.mGotTouchDown = false;
                break;
            }
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        if (this.isPopupShowing()) {
            return super.onTrackballEvent(event);
        }
        if (event.getAction() != 2) {
            return false;
        }
        Editable text = this.getText();
        MovementMethod move = this.getMovementMethod();
        return move != null && this.getLayout() != null && move.onTrackballEvent(this, text, event);
    }

    @Override
    public boolean performLongClick() {
        this.mHasPerformedLongClick = true;
        return super.performLongClick();
    }

    void remove() {
        InputMethodManager imm = InputMethodManager.getInstance(this.mContext);
        if (imm.isActive(this)) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        this.mInsideRemove = true;
        boolean isFocused = this.hasFocus();
        this.mWebView.removeView(this);
        if (isFocused) {
            this.mWebView.requestFocus();
        }
        this.mInsideRemove = false;
        this.mHandler.removeCallbacksAndMessages(null);
    }

    @Override
    public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
        return true;
    }

    private void sendDomEvent(KeyEvent event) {
        this.mWebView.passToJavaScript(this.getText().toString(), event);
    }

    public void setAdapterCustom(AutoCompleteAdapter adapter) {
        if (adapter != null) {
            this.setInputType(this.getInputType() | 0x10000);
            adapter.setTextView(this);
            if (this.mAutoFillable) {
                this.setOnItemClickListener(this);
            } else {
                this.setOnItemClickListener(null);
            }
            this.showDropDown();
        } else {
            this.dismissDropDown();
        }
        super.setAdapter(adapter);
    }

    void setDefaultSelection() {
        int selection;
        Editable text = this.getText();
        int n = selection = this.mSingle ? text.length() : 0;
        if (Selection.getSelectionStart(text) == selection && Selection.getSelectionEnd(text) == selection) {
            if (this.mWebView != null) {
                this.mWebView.setSelection(selection, selection);
            }
        } else {
            Selection.setSelection(text, selection, selection);
        }
        if (this.mWebView != null) {
            this.mWebView.incrementTextGeneration();
        }
    }

    @Override
    public void setInputType(int type) {
        this.mFromSetInputType = true;
        super.setInputType(type);
        this.mFromSetInputType = false;
    }

    private void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        if (-1 == maxLength) {
            this.setFilters(NO_FILTERS);
        } else {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
    }

    void setNodePointer(int ptr) {
        if (ptr != this.mNodePointer) {
            this.mNodePointer = ptr;
            this.setAdapterCustom(null);
        }
    }

    void setRect(int x, int y, int width, int height) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
        x -= this.mRingInset;
        y -= this.mRingInset;
        width += 2 * this.mRingInset;
        height += 2 * this.mRingInset;
        boolean needsUpdate = false;
        if (null == lp) {
            lp = new AbsoluteLayout.LayoutParams(width, height, x, y);
        } else if (lp.x != x || lp.y != y || lp.width != width || lp.height != height) {
            needsUpdate = true;
            lp.x = x;
            lp.y = y;
            lp.width = width;
            lp.height = height;
        }
        if (this.getParent() == null) {
            this.mWebView.addView((View)this, 0, lp);
        } else if (needsUpdate) {
            this.setLayoutParams(lp);
        }
        this.mWidthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        this.mHeightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
    }

    void setSelectionFromWebKit(int start, int end) {
        if (start < 0 || end < 0) {
            return;
        }
        Editable text = this.getText();
        int length = text.length();
        if (start > length || end > length) {
            return;
        }
        this.mFromWebKit = true;
        Selection.setSelection(text, start, end);
        this.mFromWebKit = false;
    }

    void updateTextSize() {
        Assert.assertNotNull((String)"updateTextSize should only be called from mWebView, so mWebView should never be null!", (Object)this.mWebView);
        float size = this.mWebView.nativeFocusCandidateTextSize() * this.mWebView.getScale();
        this.setTextSize(0, size);
    }

    void setTextAndKeepSelection(String text) {
        Editable edit = this.getText();
        this.mPreChange = text;
        if (edit.toString().equals(text)) {
            return;
        }
        int selStart = Selection.getSelectionStart(edit);
        int selEnd = Selection.getSelectionEnd(edit);
        this.mInSetTextAndKeepSelection = true;
        edit.replace(0, edit.length(), text);
        int newLength = edit.length();
        if (selStart > newLength) {
            selStart = newLength;
        }
        if (selEnd > newLength) {
            selEnd = newLength;
        }
        Selection.setSelection(edit, selStart, selEnd);
        this.mInSetTextAndKeepSelection = false;
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null && imm.isActive(this)) {
            imm.restartInput(this);
        }
        this.updateCachedTextfield();
    }

    void setType(int type) {
        if (this.mWebView == null) {
            return;
        }
        boolean single = true;
        int maxLength = -1;
        int inputType = 161;
        int imeOptions = 0x12000000;
        if (!this.mWebView.nativeFocusCandidateIsSpellcheck()) {
            inputType |= 0x80000;
        }
        if (1 != type && this.mWebView.nativeFocusCandidateHasNextTextfield()) {
            imeOptions |= 0x8000000;
        }
        switch (type) {
            case 0: {
                imeOptions |= 2;
                break;
            }
            case 1: {
                single = false;
                inputType |= 0x2C000;
                imeOptions |= 1;
                break;
            }
            case 2: {
                inputType |= 0xE0;
                imeOptions |= 2;
                break;
            }
            case 3: {
                imeOptions |= 3;
                break;
            }
            case 4: {
                inputType = 209;
                imeOptions |= 2;
                break;
            }
            case 5: {
                inputType = 12290;
                imeOptions |= 5;
                break;
            }
            case 6: {
                inputType = 3;
                imeOptions |= 5;
                break;
            }
            case 7: {
                imeOptions |= 2;
                break;
            }
            default: {
                imeOptions |= 2;
            }
        }
        this.setHint(null);
        this.setThreshold(1);
        boolean autoComplete = false;
        if (single) {
            String name;
            this.mWebView.requestLabel(this.mWebView.nativeFocusCandidateFramePointer(), this.mNodePointer);
            maxLength = this.mWebView.nativeFocusCandidateMaxLength();
            autoComplete = this.mWebView.nativeFocusCandidateIsAutoComplete();
            if (type != 2 && (this.mAutoFillable || autoComplete) && (name = this.mWebView.nativeFocusCandidateName()) != null && name.length() > 0) {
                this.mWebView.requestFormData(name, this.mNodePointer, this.mAutoFillable, autoComplete);
            }
        }
        this.mSingle = single;
        this.setMaxLength(maxLength);
        this.setHorizontallyScrolling(single);
        this.setInputType(inputType);
        this.clearComposingText();
        this.setImeOptions(imeOptions);
        this.setVisibility(0);
        if (!autoComplete) {
            this.setAdapterCustom(null);
        }
    }

    void updateCachedTextfield() {
        this.mWebView.updateCachedTextfield(this.getText().toString());
    }

    void setAutoFillProfileIsSet(boolean autoFillProfileIsSet) {
        this.mAutoFillProfileIsSet = autoFillProfileIsSet;
    }

    static String urlForAutoCompleteData(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            Log.e(LOGTAG, "Unable to parse URL " + url);
        }
        return url != null ? url.getProtocol() + "://" + url.getHost() + url.getPath() : null;
    }

    public void setGravityForRtl(boolean rtl) {
        int gravity = rtl ? 5 : 3;
        this.setGravity(gravity |= this.mSingle ? 16 : 48);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoCompleteAdapter
    extends ArrayAdapter<String> {
        private TextView mTextView;

        public AutoCompleteAdapter(Context context, ArrayList<String> entries) {
            super(context, 17367218, entries);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView tv = (TextView)super.getView(position, convertView, parent);
            if (tv != null && this.mTextView != null) {
                tv.setTextSize(0, this.mTextView.getTextSize());
            }
            return tv;
        }

        private void setTextView(TextView tv) {
            this.mTextView = tv;
        }
    }

    private static class WebTextViewLayout
    extends DynamicLayout {
        private float mLineHeight;
        private float mDifference;

        public WebTextViewLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingMult, float spacingAdd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, float lineHeight) {
            super(base, display, paint, width, align, spacingMult, spacingAdd, includepad, ellipsize, ellipsizedWidth);
            float paintLineHeight = paint.descent() - paint.ascent();
            if (lineHeight == -1.0f) {
                this.mLineHeight = paintLineHeight;
                this.mDifference = 0.0f;
            } else {
                this.mLineHeight = lineHeight;
                this.mDifference = (lineHeight - paintLineHeight) / 2.0f;
            }
        }

        public int getLineTop(int line) {
            return Math.round(this.mLineHeight * (float)line - this.mDifference);
        }
    }

    private static class BackgroundDrawable
    extends Drawable {
        private Paint mPaint = new Paint();
        private int mBorderWidth;
        private Rect mInsetRect = new Rect();

        public BackgroundDrawable(int width) {
            this.mPaint = new Paint();
            this.mPaint.setStrokeWidth(width);
            this.mBorderWidth = width;
        }

        public void draw(Canvas canvas) {
            this.mPaint.setColor(1714664933);
            canvas.drawRect(this.getBounds(), this.mPaint);
            this.mInsetRect.left = this.getBounds().left + this.mBorderWidth;
            this.mInsetRect.top = this.getBounds().top + this.mBorderWidth;
            this.mInsetRect.right = this.getBounds().right - this.mBorderWidth;
            this.mInsetRect.bottom = this.getBounds().bottom - this.mBorderWidth;
            this.mPaint.setColor(-1);
            canvas.drawRect(this.mInsetRect, this.mPaint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -3;
        }
    }

    private class MyResultReceiver
    extends ResultReceiver {
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (resultCode == 2 && WebTextView.this.mWebView != null) {
                WebTextView.this.mWebView.revealSelection();
            }
        }

        public MyResultReceiver(Handler handler) {
            super(handler);
        }
    }
}

