/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.MediaFile;
import android.net.ProxyProperties;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CookieManager;
import android.webkit.DeviceMotionAndOrientationManager;
import android.webkit.DeviceMotionService;
import android.webkit.DeviceOrientationService;
import android.webkit.GeolocationPermissions;
import android.webkit.JniUtil;
import android.webkit.Network;
import android.webkit.PluginManager;
import android.webkit.SslCertLookupTable;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebIconDatabase;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebViewCore {
    private static final String LOGTAG = "webcore";
    private WebView mWebView;
    private final CallbackProxy mCallbackProxy;
    private final WebSettings mSettings;
    private final Context mContext;
    private int mNativeClass;
    private BrowserFrame mBrowserFrame;
    private Map<String, Object> mJavascriptInterfaces;
    private int mViewportWidth = -1;
    private int mViewportHeight = -1;
    private int mViewportInitialScale = 0;
    private int mViewportMinimumScale = 0;
    private int mViewportMaximumScale = 0;
    private boolean mViewportUserScalable = true;
    private int mViewportDensityDpi = -1;
    private boolean mIsRestored = false;
    private float mRestoredScale = 0.0f;
    private float mRestoredTextWrapScale = 0.0f;
    private int mRestoredX = 0;
    private int mRestoredY = 0;
    private DeviceMotionAndOrientationManager mDeviceMotionAndOrientationManager = new DeviceMotionAndOrientationManager(this);
    private DeviceMotionService mDeviceMotionService;
    private DeviceOrientationService mDeviceOrientationService;
    private int mLowMemoryUsageThresholdMb;
    private int mHighMemoryUsageThresholdMb;
    private int mHighUsageDeltaMb;
    static final String THREAD_NAME = "WebViewCoreThread";
    private final EventHub mEventHub;
    private static Handler sWebCoreHandler;
    static final int ACTION_LONGPRESS = 256;
    static final int ACTION_DOUBLETAP = 512;
    static final String[] HandlerDebugString;
    private int mCurrentViewWidth = 0;
    private int mCurrentViewHeight = 0;
    private float mCurrentViewScale = 1.0f;
    private boolean mDrawIsScheduled;
    private boolean mDrawLayersIsScheduled;
    private boolean mSplitPictureIsScheduled;
    private boolean mDrawIsPaused;
    private ViewState mInitialViewState = null;
    private boolean mFirstLayoutForNonStandardLoad;
    DrawData mLastDrawData = null;
    private static boolean mRepaintScheduled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewCore(Context context, WebView w, CallbackProxy proxy, Map<String, Object> javascriptInterfaces) {
        this.mCallbackProxy = proxy;
        this.mWebView = w;
        this.mJavascriptInterfaces = javascriptInterfaces;
        this.mContext = context;
        Class<WebViewCore> clazz = WebViewCore.class;
        synchronized (WebViewCore.class) {
            if (sWebCoreHandler == null) {
                Thread t = new Thread(new WebCoreThread());
                t.setName(THREAD_NAME);
                t.start();
                try {
                    WebViewCore.class.wait();
                }
                catch (InterruptedException e) {
                    Log.e(LOGTAG, "Caught exception while waiting for thread creation.");
                    Log.e(LOGTAG, Log.getStackTraceString(e));
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.mEventHub = new EventHub();
            this.mSettings = new WebSettings(this.mContext, this.mWebView);
            WebIconDatabase.getInstance();
            WebStorage.getInstance().createUIHandler();
            GeolocationPermissions.getInstance().createUIHandler();
            ActivityManager manager = (ActivityManager)this.mContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(memInfo);
            this.mLowMemoryUsageThresholdMb = manager.getLargeMemoryClass();
            this.mHighMemoryUsageThresholdMb = (int)((double)this.mLowMemoryUsageThresholdMb * 1.5);
            this.mHighUsageDeltaMb = this.mLowMemoryUsageThresholdMb / 32;
            Message init = sWebCoreHandler.obtainMessage(0, this);
            sWebCoreHandler.sendMessage(init);
            return;
        }
    }

    private void initialize() {
        this.mBrowserFrame = new BrowserFrame(this.mContext, this, this.mCallbackProxy, this.mSettings, this.mJavascriptInterfaces);
        this.mJavascriptInterfaces = null;
        this.mSettings.syncSettingsAndCreateHandler(this.mBrowserFrame);
        WebIconDatabase.getInstance().createHandler();
        WebStorage.getInstance().createHandler();
        GeolocationPermissions.getInstance().createHandler();
        this.mEventHub.transferMessages();
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 107, this.mNativeClass, 0).sendToTarget();
        }
    }

    void initializeSubwindow() {
        this.initialize();
        sWebCoreHandler.removeMessages(0, this);
    }

    synchronized BrowserFrame getBrowserFrame() {
        return this.mBrowserFrame;
    }

    public static void pauseTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.pause();
    }

    public static void resumeTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.resume();
    }

    public WebSettings getSettings() {
        return this.mSettings;
    }

    static boolean isSupportedMediaMimeType(String mimeType) {
        int fileType = MediaFile.getFileTypeForMimeType(mimeType);
        return MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isPlayListFileType(fileType) || mimeType != null && mimeType.startsWith("video/m4v");
    }

    protected void addMessageToConsole(String message, int lineNumber, String sourceID, int msgLevel) {
        this.mCallbackProxy.addMessageToConsole(message, lineNumber, sourceID, msgLevel);
    }

    protected void jsAlert(String url, String message) {
        this.mCallbackProxy.onJsAlert(url, message);
    }

    private void formDidBlur(int nodePointer) {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 124, nodePointer, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String openFileChooser(String acceptType) {
        uri = this.mCallbackProxy.openFileChooser(acceptType);
        if (uri != null) {
            filePath = "";
            cursor = this.mContext.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (cursor != null) {
                try {
                    if (!cursor.moveToNext()) ** GOTO lbl14
                    filePath = cursor.getString(0);
                }
                finally {
                    cursor.close();
                }
            } else {
                filePath = uri.getLastPathSegment();
            }
lbl14:
            // 3 sources

            uriString = uri.toString();
            BrowserFrame.sJavaBridge.storeFilePathForContentUri(filePath, uriString);
            return uriString;
        }
        return "";
    }

    protected void exceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize) {
        this.mCallbackProxy.onExceededDatabaseQuota(url, databaseIdentifier, currentQuota, estimatedSize, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            public void updateQuota(long quota) {
                WebViewCore.this.nativeSetNewStorageLimit(quota);
            }
        });
    }

    protected void reachedMaxAppCacheSize(long spaceNeeded) {
        this.mCallbackProxy.onReachedMaxAppCacheSize(spaceNeeded, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            public void updateQuota(long quota) {
                WebViewCore.this.nativeSetNewStorageLimit(quota);
            }
        });
    }

    protected void populateVisitedLinks() {
        ValueCallback<String[]> callback = new ValueCallback<String[]>(){

            @Override
            public void onReceiveValue(String[] value) {
                WebViewCore.this.sendMessage(181, value);
            }
        };
        this.mCallbackProxy.getVisitedHistory(callback);
    }

    protected void geolocationPermissionsShowPrompt(String origin) {
        this.mCallbackProxy.onGeolocationPermissionsShowPrompt(origin, new GeolocationPermissions.Callback(){

            public void invoke(String origin, boolean allow, boolean remember) {
                GeolocationPermissionsData data = new GeolocationPermissionsData();
                data.mOrigin = origin;
                data.mAllow = allow;
                data.mRemember = remember;
                WebViewCore.this.sendMessage(180, data);
            }
        });
    }

    protected void geolocationPermissionsHidePrompt() {
        this.mCallbackProxy.onGeolocationPermissionsHidePrompt();
    }

    protected boolean jsConfirm(String url, String message) {
        return this.mCallbackProxy.onJsConfirm(url, message);
    }

    protected String jsPrompt(String url, String message, String defaultValue) {
        return this.mCallbackProxy.onJsPrompt(url, message, defaultValue);
    }

    protected boolean jsUnload(String url, String message) {
        return this.mCallbackProxy.onJsBeforeUnload(url, message);
    }

    protected boolean jsInterrupt() {
        return this.mCallbackProxy.onJsTimeout();
    }

    protected void setInstallableWebApp() {
        this.mCallbackProxy.setInstallableWebApp();
    }

    protected void enterFullscreenForVideoLayer(int layerId, String url) {
        if (this.mWebView == null) {
            return;
        }
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 137, layerId, 0);
        message.obj = url;
        message.sendToTarget();
    }

    static native String nativeFindAddress(String var0, boolean var1);

    private native void nativeClearContent();

    private native void nativeContentInvalidateAll();

    private native int nativeRecordContent(Region var1, Point var2);

    private native boolean nativeUpdateLayers(int var1, int var2);

    private native void nativeNotifyAnimationStarted(int var1);

    private native boolean nativeFocusBoundsChanged();

    private native void nativeSplitContent(int var1);

    private native boolean nativeKey(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7);

    private native void nativeClick(int var1, int var2, boolean var3);

    private native void nativeSendListBoxChoices(boolean[] var1, int var2);

    private native void nativeSendListBoxChoice(int var1);

    private native void nativeCloseIdleConnections();

    private native void nativeSetSize(int var1, int var2, int var3, float var4, int var5, int var6, int var7, int var8, boolean var9);

    private native int nativeGetContentMinPrefWidth();

    private native void nativeReplaceTextfieldText(int var1, int var2, String var3, int var4, int var5, int var6);

    private native void passToJs(int var1, String var2, int var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8);

    private native void nativeSetFocusControllerActive(boolean var1);

    private native void nativeSaveDocumentState(int var1);

    private native void nativeMoveFocus(int var1, int var2);

    private native void nativeMoveMouse(int var1, int var2, int var3);

    private native void nativeMoveMouseIfLatest(int var1, int var2, int var3, int var4);

    private native String nativeRetrieveHref(int var1, int var2);

    private native String nativeRetrieveAnchorText(int var1, int var2);

    private native String nativeRetrieveImageSource(int var1, int var2);

    private native void nativeStopPaintingCaret();

    private native void nativeTouchUp(int var1, int var2, int var3, int var4, int var5);

    private native boolean nativeHandleTouchEvent(int var1, int[] var2, int[] var3, int[] var4, int var5, int var6, int var7);

    private native void nativeUpdateFrameCache();

    private native void nativeSetBackgroundColor(int var1);

    private native void nativeDumpDomTree(boolean var1);

    private native void nativeDumpRenderTree(boolean var1);

    private native void nativeDumpNavTree();

    private native void nativeDumpV8Counters();

    private native void nativeSetJsFlags(String var1);

    private native void nativeDeleteSelection(int var1, int var2, int var3);

    private native void nativeSetSelection(int var1, int var2);

    private native void nativeRegisterURLSchemeAsLocal(String var1);

    private native void nativeSetNewStorageLimit(long var1);

    private native void nativeGeolocationPermissionsProvide(String var1, boolean var2, boolean var3);

    private native void nativeProvideVisitedHistory(String[] var1);

    private native String nativeModifySelection(int var1, int var2);

    void stopLoading() {
        if (this.mBrowserFrame != null) {
            this.mBrowserFrame.stopLoading();
        }
    }

    public void sendMessage(Message msg) {
        this.mEventHub.sendMessage(msg);
    }

    void sendMessage(int what) {
        this.mEventHub.sendMessage(Message.obtain(null, what));
    }

    void sendMessage(int what, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, obj));
    }

    void sendMessage(int what, int arg1) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, 0));
    }

    void sendMessage(int what, int arg1, int arg2) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, arg2));
    }

    void sendMessage(int what, int arg1, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, 0, obj));
    }

    void sendMessage(int what, int arg1, int arg2, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, arg2, obj));
    }

    void sendMessageAtFrontOfQueue(int what, Object obj) {
        this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, what, obj));
    }

    void sendMessageDelayed(int what, Object obj, long delay) {
        this.mEventHub.sendMessageDelayed(Message.obtain(null, what, obj), delay);
    }

    void removeMessages(int what) {
        this.mEventHub.removeMessages(what);
    }

    void removeMessages() {
        this.mEventHub.removeMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        EventHub eventHub = this.mEventHub;
        synchronized (eventHub) {
            this.mEventHub.mDestroying = true;
            this.mEventHub.sendMessage(Message.obtain(null, 200));
            this.mEventHub.blockMessages();
        }
    }

    private void clearCache(boolean includeDiskFiles) {
        this.mBrowserFrame.clearCache();
        if (includeDiskFiles) {
            CacheManager.removeAllCacheFiles();
        }
    }

    private void loadUrl(String url, Map<String, String> extraHeaders) {
        this.mBrowserFrame.loadUrl(url, extraHeaders);
    }

    private String saveWebArchive(String filename, boolean autoname) {
        return this.mBrowserFrame.saveWebArchive(filename, autoname);
    }

    private void key(KeyEvent evt, boolean isDown) {
        int keyCode = evt.getKeyCode();
        int unicodeChar = evt.getUnicodeChar();
        if (keyCode == 0 && evt.getCharacters() != null && evt.getCharacters().length() > 0) {
            unicodeChar = evt.getCharacters().codePointAt(0);
        }
        if (!this.nativeKey(keyCode, unicodeChar, evt.getRepeatCount(), evt.isShiftPressed(), evt.isAltPressed(), evt.isSymPressed(), isDown) && keyCode != 66) {
            if (keyCode >= 19 && keyCode <= 22) {
                if (this.mWebView != null && evt.isDown()) {
                    Message.obtain(this.mWebView.mPrivateHandler, 110, keyCode, 0).sendToTarget();
                }
                return;
            }
            this.mCallbackProxy.onUnhandledKeyEvent(evt);
        }
    }

    private void viewSizeChanged(WebView.ViewSizeData data) {
        int w = data.mWidth;
        int h = data.mHeight;
        int textwrapWidth = data.mTextWrapWidth;
        float scale = data.mScale;
        if (w == 0) {
            Log.w(LOGTAG, "skip viewSizeChanged as w is 0");
            return;
        }
        int width = this.calculateWindowWidth(w);
        int height = h;
        if (width != w) {
            float heightWidthRatio = data.mHeightWidthRatio;
            float ratio = heightWidthRatio > 0.0f ? heightWidthRatio : (float)h / (float)w;
            height = Math.round(ratio * (float)width);
        }
        this.nativeSetSize(width, height, textwrapWidth, scale, w, data.mActualViewHeight > 0 ? data.mActualViewHeight : h, data.mAnchorX, data.mAnchorY, data.mIgnoreHeight);
        boolean needInvalidate = this.mCurrentViewWidth == 0;
        this.mCurrentViewWidth = w;
        this.mCurrentViewHeight = h;
        this.mCurrentViewScale = scale;
        if (needInvalidate) {
            this.contentDraw();
        }
        this.mEventHub.sendMessage(Message.obtain(null, 117));
    }

    private int calculateWindowWidth(int viewWidth) {
        int width = viewWidth;
        if (this.mSettings.getUseWideViewPort()) {
            width = this.mViewportWidth == -1 ? 980 : (this.mViewportWidth > 0 ? this.mViewportWidth : Math.round((float)this.mWebView.getViewWidth() / this.mWebView.getDefaultZoomScale()));
        }
        return width;
    }

    private void sendUpdateTextEntry() {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 106).sendToTarget();
        }
    }

    private long getUsedQuota() {
        WebStorage webStorage = WebStorage.getInstance();
        Collection<WebStorage.Origin> origins = webStorage.getOriginsSync();
        if (origins == null) {
            return 0L;
        }
        long usedQuota = 0L;
        for (WebStorage.Origin website : origins) {
            usedQuota += website.getQuota();
        }
        return usedQuota;
    }

    void splitContent(int content) {
        if (!this.mSplitPictureIsScheduled) {
            this.mSplitPictureIsScheduled = true;
            this.sendMessage(133, content, 0);
        }
    }

    private void webkitDrawLayers() {
        this.mDrawLayersIsScheduled = false;
        if (this.mDrawIsScheduled || this.mLastDrawData == null) {
            this.removeMessages(130);
            this.webkitDraw();
            return;
        }
        if (this.nativeUpdateLayers(this.mNativeClass, this.mLastDrawData.mBaseLayer)) {
            this.webkitDraw();
        }
        this.mWebView.mPrivateHandler.removeMessages(117);
        this.mWebView.mPrivateHandler.sendMessageAtFrontOfQueue(this.mWebView.mPrivateHandler.obtainMessage(117));
    }

    private void webkitDraw() {
        this.mDrawIsScheduled = false;
        DrawData draw = new DrawData();
        draw.mBaseLayer = this.nativeRecordContent(draw.mInvalRegion, draw.mContentSize);
        if (draw.mBaseLayer == 0) {
            if (this.mWebView != null && !this.mWebView.isPaused()) {
                this.mEventHub.sendMessage(Message.obtain(null, 130));
            }
            return;
        }
        this.mLastDrawData = draw;
        this.webkitDraw(draw);
    }

    private void webkitDraw(DrawData draw) {
        if (this.mWebView != null) {
            draw.mFocusSizeChanged = this.nativeFocusBoundsChanged();
            draw.mViewSize = new Point(this.mCurrentViewWidth, this.mCurrentViewHeight);
            if (this.mSettings.getUseWideViewPort()) {
                draw.mMinPrefWidth = Math.max(this.mViewportWidth == -1 ? 980 : (this.mViewportWidth == 0 ? this.mCurrentViewWidth : this.mViewportWidth), this.nativeGetContentMinPrefWidth());
            }
            if (this.mInitialViewState != null) {
                draw.mViewState = this.mInitialViewState;
                this.mInitialViewState = null;
            }
            if (this.mFirstLayoutForNonStandardLoad) {
                draw.mFirstLayoutForNonStandardLoad = true;
                this.mFirstLayoutForNonStandardLoad = false;
            }
            Message.obtain(this.mWebView.mPrivateHandler, 105, draw).sendToTarget();
        }
    }

    static void reducePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(1));
    }

    static void resumePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(2));
    }

    static void sendStaticMessage(int messageType, Object argument) {
        if (sWebCoreHandler == null) {
            return;
        }
        sWebCoreHandler.sendMessage(sWebCoreHandler.obtainMessage(messageType, argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pauseUpdatePicture(WebViewCore core) {
        if (core != null) {
            if (!core.getSettings().enableSmoothTransition()) {
                return;
            }
            WebViewCore webViewCore = core;
            synchronized (webViewCore) {
                if (core.mNativeClass == 0) {
                    Log.w(LOGTAG, "Cannot pauseUpdatePicture, core destroyed or not initialized!");
                    return;
                }
                core.nativeSetIsPaused(true);
                core.mDrawIsPaused = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resumeUpdatePicture(WebViewCore core) {
        if (core != null) {
            if (!core.mDrawIsPaused) {
                return;
            }
            WebViewCore webViewCore = core;
            synchronized (webViewCore) {
                if (core.mNativeClass == 0) {
                    Log.w(LOGTAG, "Cannot resumeUpdatePicture, core destroyed!");
                    return;
                }
                core.nativeSetIsPaused(false);
                core.mDrawIsPaused = false;
                core.mDrawIsScheduled = false;
            }
        }
    }

    static boolean isUpdatePicturePaused(WebViewCore core) {
        return core != null ? core.mDrawIsPaused : false;
    }

    private void restoreState(int index) {
        WebBackForwardList list = this.mCallbackProxy.getBackForwardList();
        int size = list.getSize();
        for (int i = 0; i < size; ++i) {
            list.getItemAtIndex(i).inflate(this.mBrowserFrame.mNativeFrame);
        }
        this.mBrowserFrame.mLoadInitFromJava = true;
        WebBackForwardList.restoreIndex(this.mBrowserFrame.mNativeFrame, index);
        this.mBrowserFrame.mLoadInitFromJava = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contentDraw() {
        WebViewCore webViewCore = this;
        synchronized (webViewCore) {
            if (this.mWebView == null || this.mBrowserFrame == null) {
                return;
            }
            if (this.mCurrentViewWidth == 0 || !this.mBrowserFrame.firstLayoutDone()) {
                return;
            }
            if (this.mDrawIsScheduled) {
                return;
            }
            this.mDrawIsScheduled = true;
            this.mEventHub.sendMessage(Message.obtain(null, 130));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void layersDraw() {
        WebViewCore webViewCore = this;
        synchronized (webViewCore) {
            if (this.mDrawLayersIsScheduled) {
                return;
            }
            this.mDrawLayersIsScheduled = true;
            this.mEventHub.sendMessage(Message.obtain(null, 148));
        }
    }

    private void contentScrollTo(int x, int y, boolean animate, boolean onlyIfImeIsShowing) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = x;
            this.mRestoredY = y;
            return;
        }
        if (this.mWebView != null) {
            Message msg = Message.obtain(this.mWebView.mPrivateHandler, 101, animate ? 1 : 0, onlyIfImeIsShowing ? 1 : 0, new Point(x, y));
            if (this.mDrawIsScheduled) {
                this.mEventHub.sendMessage(Message.obtain(null, 125, msg));
            } else {
                msg.sendToTarget();
            }
        }
    }

    private void sendNotifyProgressFinished() {
        this.sendUpdateTextEntry();
        if (!JniUtil.useChromiumHttpStack()) {
            WebViewWorker.getHandler().removeMessages(110);
            WebViewWorker.getHandler().sendEmptyMessage(110);
        }
        this.contentDraw();
    }

    private void sendViewInvalidate(int left, int top, int right, int bottom) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 117, new Rect(left, top, right, bottom)).sendToTarget();
        }
    }

    void signalRepaintDone() {
        mRepaintScheduled = false;
    }

    WebView getWebView() {
        return this.mWebView;
    }

    private native void setViewportSettingsFromNative();

    private void didFirstLayout(boolean standardLoad) {
        this.mBrowserFrame.didFirstLayout();
        if (this.mWebView == null) {
            return;
        }
        boolean updateViewState = standardLoad || this.mIsRestored;
        this.setupViewport(updateViewState);
        if (!updateViewState) {
            this.mWebView.mViewManager.postReadyToDrawAll();
        }
        if (this.getSettings().supportTouchOnly()) {
            this.mWebView.mPrivateHandler.sendEmptyMessage(131);
        }
        this.mRestoredY = 0;
        this.mRestoredX = 0;
        this.mIsRestored = false;
        this.mRestoredTextWrapScale = 0.0f;
        this.mRestoredScale = 0.0f;
    }

    private void updateViewport() {
        this.setupViewport(true);
    }

    private void setupViewport(boolean updateViewState) {
        int webViewWidth;
        if (this.mWebView == null || this.mSettings == null) {
            return;
        }
        this.setViewportSettingsFromNative();
        if (this.mViewportInitialScale > 0) {
            if (this.mViewportMinimumScale > 0) {
                this.mViewportInitialScale = Math.max(this.mViewportInitialScale, this.mViewportMinimumScale);
            }
            if (this.mViewportMaximumScale > 0) {
                this.mViewportInitialScale = Math.min(this.mViewportInitialScale, this.mViewportMaximumScale);
            }
        }
        if (this.mSettings.forceUserScalable()) {
            this.mViewportUserScalable = true;
            if (this.mViewportInitialScale > 0) {
                if (this.mViewportMinimumScale > 0) {
                    this.mViewportMinimumScale = Math.min(this.mViewportMinimumScale, this.mViewportInitialScale / 2);
                }
                if (this.mViewportMaximumScale > 0) {
                    this.mViewportMaximumScale = Math.max(this.mViewportMaximumScale, this.mViewportInitialScale * 2);
                }
            } else {
                if (this.mViewportMinimumScale > 0) {
                    this.mViewportMinimumScale = Math.min(this.mViewportMinimumScale, 50);
                }
                if (this.mViewportMaximumScale > 0) {
                    this.mViewportMaximumScale = Math.max(this.mViewportMaximumScale, 200);
                }
            }
        }
        float adjust = 1.0f;
        if (this.mViewportDensityDpi == -1) {
            if (this.mWebView != null && (int)(this.mWebView.getDefaultZoomScale() * 100.0f) != 100) {
                adjust = this.mWebView.getDefaultZoomScale();
            }
        } else if (this.mViewportDensityDpi > 0) {
            adjust = (float)this.mContext.getResources().getDisplayMetrics().densityDpi / (float)this.mViewportDensityDpi;
        }
        if (adjust != this.mWebView.getDefaultZoomScale()) {
            Message.obtain(this.mWebView.mPrivateHandler, 139, Float.valueOf(adjust)).sendToTarget();
        }
        int defaultScale = (int)(adjust * 100.0f);
        if (this.mViewportInitialScale > 0) {
            this.mViewportInitialScale = (int)((float)this.mViewportInitialScale * adjust);
        }
        if (this.mViewportMinimumScale > 0) {
            this.mViewportMinimumScale = (int)((float)this.mViewportMinimumScale * adjust);
        }
        if (this.mViewportMaximumScale > 0) {
            this.mViewportMaximumScale = (int)((float)this.mViewportMaximumScale * adjust);
        }
        if (this.mViewportWidth == 0 && this.mViewportInitialScale == 0) {
            this.mViewportInitialScale = defaultScale;
        }
        if (!this.mViewportUserScalable) {
            this.mViewportInitialScale = defaultScale;
            this.mViewportMinimumScale = defaultScale;
            this.mViewportMaximumScale = defaultScale;
        }
        if (this.mViewportMinimumScale > this.mViewportInitialScale && this.mViewportInitialScale != 0) {
            this.mViewportMinimumScale = this.mViewportInitialScale;
        }
        if (this.mViewportMaximumScale > 0 && this.mViewportMaximumScale < this.mViewportInitialScale) {
            this.mViewportMaximumScale = this.mViewportInitialScale;
        }
        if (this.mViewportWidth < 0 && this.mViewportInitialScale == defaultScale) {
            this.mViewportWidth = 0;
        }
        if (this.mViewportWidth != 0 && !updateViewState) {
            this.mFirstLayoutForNonStandardLoad = true;
            ViewState viewState = new ViewState();
            viewState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
            viewState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
            viewState.mDefaultScale = adjust;
            viewState.mMobileSite = false;
            viewState.mScrollX = 0;
            viewState.mShouldStartScrolledRight = false;
            Message.obtain(this.mWebView.mPrivateHandler, 109, viewState).sendToTarget();
            return;
        }
        int viewportWidth = this.mCurrentViewWidth;
        if (viewportWidth == 0) {
            webViewWidth = this.mWebView.getViewWidth();
            viewportWidth = (int)((float)webViewWidth / adjust);
            if (viewportWidth == 0) {
                // empty if block
            }
        } else {
            webViewWidth = Math.round((float)viewportWidth * this.mCurrentViewScale);
        }
        this.mInitialViewState = new ViewState();
        this.mInitialViewState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
        this.mInitialViewState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
        this.mInitialViewState.mDefaultScale = adjust;
        this.mInitialViewState.mScrollX = this.mRestoredX;
        this.mInitialViewState.mScrollY = this.mRestoredY;
        this.mInitialViewState.mShouldStartScrolledRight = this.mRestoredX == 0 && this.mRestoredY == 0 && this.mBrowserFrame != null && this.mBrowserFrame.getShouldStartScrolledRight();
        boolean bl = this.mInitialViewState.mMobileSite = 0 == this.mViewportWidth;
        if (this.mIsRestored) {
            this.mInitialViewState.mIsRestored = true;
            this.mInitialViewState.mViewScale = this.mRestoredScale;
            this.mInitialViewState.mTextWrapScale = this.mRestoredTextWrapScale > 0.0f ? this.mRestoredTextWrapScale : this.mInitialViewState.mViewScale;
        } else if (this.mViewportInitialScale > 0) {
            this.mInitialViewState.mViewScale = this.mInitialViewState.mTextWrapScale = (float)this.mViewportInitialScale / 100.0f;
        } else if (this.mViewportWidth > 0 && this.mViewportWidth < webViewWidth && !this.getSettings().getUseFixedViewport()) {
            this.mInitialViewState.mViewScale = this.mInitialViewState.mTextWrapScale = (float)webViewWidth / (float)this.mViewportWidth;
        } else {
            this.mInitialViewState.mTextWrapScale = adjust;
            this.mInitialViewState.mViewScale = this.mSettings.getUseWideViewPort() ? 0.0f : adjust;
        }
        if (this.mWebView.mHeightCanMeasure) {
            this.mWebView.mLastHeightSent = 0;
            WebView.ViewSizeData data = new WebView.ViewSizeData();
            data.mWidth = this.mWebView.mLastWidthSent;
            data.mHeight = 0;
            data.mTextWrapWidth = data.mWidth;
            data.mScale = -1.0f;
            data.mIgnoreHeight = false;
            data.mAnchorY = 0;
            data.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 105, data));
        } else if (viewportWidth == 0) {
            this.mWebView.mLastWidthSent = 0;
        } else {
            WebView.ViewSizeData data = new WebView.ViewSizeData();
            float tentativeScale = this.mInitialViewState.mViewScale;
            if (tentativeScale == 0.0f) {
                tentativeScale = this.mInitialViewState.mTextWrapScale;
                int tentativeViewWidth = Math.round((float)webViewWidth / tentativeScale);
                int windowWidth = this.calculateWindowWidth(tentativeViewWidth);
                data.mScale = (float)webViewWidth / (float)windowWidth;
                if (!this.mSettings.getLoadWithOverviewMode()) {
                    data.mScale = Math.max(data.mScale, tentativeScale);
                }
                if (this.mSettings.isNarrowColumnLayout()) {
                    this.mInitialViewState.mTextWrapScale = this.mWebView.getReadingLevelScale();
                }
            } else {
                data.mScale = tentativeScale;
            }
            data.mWidth = Math.round((float)webViewWidth / data.mScale);
            data.mHeight = this.mCurrentViewHeight == 0 ? Math.round((float)this.mWebView.getViewHeight() / data.mScale) : Math.round((float)this.mCurrentViewHeight * (float)data.mWidth / (float)viewportWidth);
            data.mTextWrapWidth = Math.round((float)webViewWidth / this.mInitialViewState.mTextWrapScale);
            data.mIgnoreHeight = false;
            data.mAnchorY = 0;
            data.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            this.viewSizeChanged(data);
        }
    }

    private void restoreScale(float scale, float textWrapScale) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mIsRestored = true;
            this.mRestoredScale = scale;
            if (this.mSettings.getUseWideViewPort()) {
                this.mRestoredTextWrapScale = textWrapScale;
            }
        }
    }

    private void needTouchEvents(boolean need) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 116, need ? 1 : 0, 0).sendToTarget();
        }
    }

    private void updateTextfield(int ptr, boolean changeToPassword, String text, int textGeneration) {
        if (this.mWebView != null) {
            Message msg = Message.obtain(this.mWebView.mPrivateHandler, 108, ptr, textGeneration, text);
            msg.getData().putBoolean("password", changeToPassword);
            msg.sendToTarget();
        }
    }

    private void updateTextSelection(int pointer, int start, int end, int textGeneration) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 112, pointer, textGeneration, new TextSelectionData(start, end)).sendToTarget();
        }
    }

    private void clearTextEntry() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 111).sendToTarget();
    }

    private void sendFindAgain() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 126).sendToTarget();
    }

    private native void nativeUpdateFrameCacheIfLoading();

    private native void nativeRevealSelection();

    private native String nativeRequestLabel(int var1, int var2);

    private native void nativeScrollFocusedTextInput(float var1, int var2);

    private native void nativeSetScrollOffset(int var1, boolean var2, int var3, int var4);

    private native void nativeSetGlobalBounds(int var1, int var2, int var3, int var4);

    private void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        if (this.mWebView != null) {
            this.mWebView.requestListBox(array2, enabledArray, selectedArray);
        }
    }

    private void requestListBox(String[] array2, int[] enabledArray, int selection) {
        if (this.mWebView != null) {
            this.mWebView.requestListBox(array2, enabledArray, selection);
        }
    }

    private void requestKeyboardWithSelection(int pointer, int selStart, int selEnd, int textGeneration) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 128, pointer, textGeneration, new TextSelectionData(selStart, selEnd)).sendToTarget();
        }
    }

    private void requestKeyboard(boolean showKeyboard) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 118, showKeyboard ? 1 : 0, 0).sendToTarget();
        }
    }

    private void setWebTextViewAutoFillable(int queryId, String preview) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 133, new AutoFillData(queryId, preview)).sendToTarget();
        }
    }

    Context getContext() {
        return this.mContext;
    }

    private void keepScreenOn(boolean screenOn) {
        if (this.mWebView != null) {
            Message message = this.mWebView.mPrivateHandler.obtainMessage(136);
            message.arg1 = screenOn ? 1 : 0;
            message.sendToTarget();
        }
    }

    private Class<?> getPluginClass(String libName, String clsName) {
        if (this.mWebView == null) {
            return null;
        }
        PluginManager pluginManager = PluginManager.getInstance(null);
        String pkgName = pluginManager.getPluginsAPKName(libName);
        if (pkgName == null) {
            Log.w(LOGTAG, "Unable to resolve " + libName + " to a plugin APK");
            return null;
        }
        try {
            return pluginManager.getPluginClass(pkgName, clsName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOGTAG, "Unable to find plugin classloader for the apk (" + pkgName + ")");
        }
        catch (ClassNotFoundException e) {
            Log.e(LOGTAG, "Unable to find plugin class (" + clsName + ") in the apk (" + pkgName + ")");
        }
        return null;
    }

    private void showFullScreenPlugin(ViewManager.ChildView childView, int orientation, int npp) {
        if (this.mWebView == null) {
            return;
        }
        Message message = this.mWebView.mPrivateHandler.obtainMessage(120);
        message.obj = childView.mView;
        message.arg1 = orientation;
        message.arg2 = npp;
        message.sendToTarget();
    }

    private void hideFullScreenPlugin() {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    private ViewManager.ChildView createSurface(View pluginView) {
        if (this.mWebView == null) {
            return null;
        }
        if (pluginView == null) {
            Log.e(LOGTAG, "Attempted to add an empty plugin view to the view hierarchy");
            return null;
        }
        pluginView.setWillNotDraw(false);
        if (pluginView instanceof SurfaceView) {
            ((SurfaceView)pluginView).setZOrderOnTop(true);
        }
        ViewManager.ChildView view = this.mWebView.mViewManager.createView();
        view.mView = pluginView;
        return view;
    }

    private ViewManager.ChildView addSurface(View pluginView, int x, int y, int width, int height) {
        ViewManager.ChildView view = this.createSurface(pluginView);
        view.attachView(x, y, width, height);
        return view;
    }

    private void updateSurface(ViewManager.ChildView childView, int x, int y, int width, int height) {
        childView.attachView(x, y, width, height);
    }

    private void destroySurface(ViewManager.ChildView childView) {
        childView.removeView();
    }

    private void showRect(int left, int top, int width, int height, int contentWidth, int contentHeight, float xPercentInDoc, float xPercentInView, float yPercentInDoc, float yPercentInView) {
        if (this.mWebView != null) {
            ShowRectData data = new ShowRectData();
            data.mLeft = left;
            data.mTop = top;
            data.mWidth = width;
            data.mHeight = height;
            data.mContentWidth = contentWidth;
            data.mContentHeight = contentHeight;
            data.mXPercentInDoc = xPercentInDoc;
            data.mXPercentInView = xPercentInView;
            data.mYPercentInDoc = yPercentInDoc;
            data.mYPercentInView = yPercentInView;
            Message.obtain(this.mWebView.mPrivateHandler, 113, data).sendToTarget();
        }
    }

    private void centerFitRect(int x, int y, int width, int height) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(127, new Rect(x, y, x + width, y + height)).sendToTarget();
    }

    private void setScrollbarModes(int hMode, int vMode) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(129, hMode, vMode).sendToTarget();
    }

    private void selectAt(int x, int y) {
        if (this.mWebView != null) {
            this.mWebView.mPrivateHandler.obtainMessage(135, x, y).sendToTarget();
        }
    }

    private void useMockDeviceOrientation() {
        this.mDeviceMotionAndOrientationManager.useMock();
    }

    public void setMockDeviceOrientation(boolean canProvideAlpha, double alpha, boolean canProvideBeta, double beta, boolean canProvideGamma, double gamma) {
        this.mDeviceMotionAndOrientationManager.setMockOrientation(canProvideAlpha, alpha, canProvideBeta, beta, canProvideGamma, gamma);
    }

    protected DeviceMotionService getDeviceMotionService() {
        if (this.mDeviceMotionService == null) {
            this.mDeviceMotionService = new DeviceMotionService(this.mDeviceMotionAndOrientationManager, this.mContext);
        }
        return this.mDeviceMotionService;
    }

    protected DeviceOrientationService getDeviceOrientationService() {
        if (this.mDeviceOrientationService == null) {
            this.mDeviceOrientationService = new DeviceOrientationService(this.mDeviceMotionAndOrientationManager, this.mContext);
        }
        return this.mDeviceOrientationService;
    }

    private native void nativeSetIsPaused(boolean var1);

    private native void nativePause();

    private native void nativeResume();

    private native void nativeFreeMemory();

    private native void nativeFullScreenPluginHidden(int var1);

    private native void nativePluginSurfaceReady();

    private native boolean nativeValidNodeAndBounds(int var1, int var2, Rect var3);

    private native ArrayList<Rect> nativeGetTouchHighlightRects(int var1, int var2, int var3);

    private native void nativeAutoFillForm(int var1);

    private native void nativeScrollLayer(int var1, Rect var2);

    static {
        try {
            System.loadLibrary(LOGTAG);
            System.loadLibrary("chromium_net");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e(LOGTAG, "Unable to load native support libraries.");
        }
        HandlerDebugString = new String[]{"REVEAL_SELECTION", "REQUEST_LABEL", "UPDATE_FRAME_CACHE_IF_LOADING", "SCROLL_TEXT_INPUT", "LOAD_URL", "STOP_LOADING", "RELOAD", "KEY_DOWN", "KEY_UP", "VIEW_SIZE_CHANGED", "GO_BACK_FORWARD", "SET_SCROLL_OFFSET", "RESTORE_STATE", "PAUSE_TIMERS", "RESUME_TIMERS", "CLEAR_CACHE", "CLEAR_HISTORY", "SET_SELECTION", "REPLACE_TEXT", "PASS_TO_JS", "SET_GLOBAL_BOUNDS", "UPDATE_CACHE_AND_TEXT_ENTRY", "CLICK", "SET_NETWORK_STATE", "DOC_HAS_IMAGES", "FAKE_CLICK", "DELETE_SELECTION", "LISTBOX_CHOICES", "SINGLE_LISTBOX_CHOICE", "MESSAGE_RELAY", "SET_BACKGROUND_COLOR", "SET_MOVE_FOCUS", "SAVE_DOCUMENT_STATE", "129", "WEBKIT_DRAW", "131", "POST_URL", "SPLIT_PICTURE_SET", "CLEAR_CONTENT", "SET_MOVE_MOUSE", "SET_MOVE_MOUSE_IF_LATEST", "REQUEST_CURSOR_HREF", "ADD_JS_INTERFACE", "LOAD_DATA", "TOUCH_UP", "TOUCH_EVENT", "SET_ACTIVE", "ON_PAUSE", "ON_RESUME", "FREE_MEMORY", "VALID_NODE_BOUNDS", "SAVE_WEBARCHIVE", "WEBKIT_DRAW_LAYERS", "REMOVE_JS_INTERFACE"};
        mRepaintScheduled = false;
    }

    static class ShowRectData {
        int mLeft;
        int mTop;
        int mWidth;
        int mHeight;
        int mContentWidth;
        int mContentHeight;
        float mXPercentInDoc;
        float mXPercentInView;
        float mYPercentInDoc;
        float mYPercentInView;

        ShowRectData() {
        }
    }

    static class DrawData {
        int mBaseLayer = 0;
        Region mInvalRegion = new Region();
        Point mViewSize;
        Point mContentSize = new Point();
        int mMinPrefWidth;
        ViewState mViewState;
        boolean mFirstLayoutForNonStandardLoad;
        boolean mFocusSizeChanged;

        DrawData() {
        }
    }

    static class ViewState {
        float mMinScale;
        float mMaxScale;
        float mViewScale;
        float mTextWrapScale;
        float mDefaultScale;
        int mScrollX;
        int mScrollY;
        boolean mMobileSite;
        boolean mIsRestored;
        boolean mShouldStartScrolledRight;

        ViewState() {
        }
    }

    public class EventHub {
        static final int REVEAL_SELECTION = 96;
        static final int REQUEST_LABEL = 97;
        static final int UPDATE_FRAME_CACHE_IF_LOADING = 98;
        static final int SCROLL_TEXT_INPUT = 99;
        static final int LOAD_URL = 100;
        static final int STOP_LOADING = 101;
        static final int RELOAD = 102;
        static final int KEY_DOWN = 103;
        static final int KEY_UP = 104;
        static final int VIEW_SIZE_CHANGED = 105;
        static final int GO_BACK_FORWARD = 106;
        static final int SET_SCROLL_OFFSET = 107;
        static final int RESTORE_STATE = 108;
        static final int PAUSE_TIMERS = 109;
        static final int RESUME_TIMERS = 110;
        static final int CLEAR_CACHE = 111;
        static final int CLEAR_HISTORY = 112;
        static final int SET_SELECTION = 113;
        static final int REPLACE_TEXT = 114;
        static final int PASS_TO_JS = 115;
        static final int SET_GLOBAL_BOUNDS = 116;
        static final int UPDATE_CACHE_AND_TEXT_ENTRY = 117;
        static final int CLICK = 118;
        static final int SET_NETWORK_STATE = 119;
        static final int DOC_HAS_IMAGES = 120;
        static final int FAKE_CLICK = 121;
        static final int DELETE_SELECTION = 122;
        static final int LISTBOX_CHOICES = 123;
        static final int SINGLE_LISTBOX_CHOICE = 124;
        public static final int MESSAGE_RELAY = 125;
        static final int SET_BACKGROUND_COLOR = 126;
        static final int SET_MOVE_FOCUS = 127;
        static final int SAVE_DOCUMENT_STATE = 128;
        static final int WEBKIT_DRAW = 130;
        static final int POST_URL = 132;
        static final int SPLIT_PICTURE_SET = 133;
        static final int CLEAR_CONTENT = 134;
        static final int SET_MOVE_MOUSE = 135;
        static final int SET_MOVE_MOUSE_IF_LATEST = 136;
        static final int REQUEST_CURSOR_HREF = 137;
        static final int ADD_JS_INTERFACE = 138;
        static final int LOAD_DATA = 139;
        static final int TOUCH_UP = 140;
        static final int TOUCH_EVENT = 141;
        static final int SET_ACTIVE = 142;
        static final int ON_PAUSE = 143;
        static final int ON_RESUME = 144;
        static final int FREE_MEMORY = 145;
        static final int VALID_NODE_BOUNDS = 146;
        static final int SAVE_WEBARCHIVE = 147;
        static final int WEBKIT_DRAW_LAYERS = 148;
        static final int REMOVE_JS_INTERFACE = 149;
        static final int CLEAR_SSL_PREF_TABLE = 150;
        static final int REQUEST_EXT_REPRESENTATION = 160;
        static final int REQUEST_DOC_AS_TEXT = 161;
        static final int DUMP_DOMTREE = 170;
        static final int DUMP_RENDERTREE = 171;
        static final int DUMP_NAVTREE = 172;
        static final int DUMP_V8COUNTERS = 173;
        static final int SET_JS_FLAGS = 174;
        static final int CONTENT_INVALIDATE_ALL = 175;
        static final int GEOLOCATION_PERMISSIONS_PROVIDE = 180;
        static final int POPULATE_VISITED_LINKS = 181;
        static final int HIDE_FULLSCREEN = 182;
        static final int SET_NETWORK_TYPE = 183;
        static final int ADD_PACKAGE_NAMES = 184;
        static final int ADD_PACKAGE_NAME = 185;
        static final int REMOVE_PACKAGE_NAME = 186;
        static final int GET_TOUCH_HIGHLIGHT_RECTS = 187;
        static final int MODIFY_SELECTION = 190;
        static final int USE_MOCK_DEVICE_ORIENTATION = 191;
        static final int AUTOFILL_FORM = 192;
        static final int PROXY_CHANGED = 193;
        static final int EXECUTE_JS = 194;
        static final int PLUGIN_SURFACE_READY = 195;
        static final int NOTIFY_ANIMATION_STARTED = 196;
        private static final int DESTROY = 200;
        private Handler mHandler;
        private ArrayList<Message> mMessages = new ArrayList();
        private boolean mBlockMessages;
        private boolean mDestroying;
        private int mTid;
        private int mSavedPriority;
        private static final int FIRST_PACKAGE_MSG_ID = 96;
        private static final int LAST_PACKAGE_MSG_ID = 146;

        private EventHub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferMessages() {
            this.mTid = Process.myTid();
            this.mSavedPriority = Process.getThreadPriority(this.mTid);
            this.mHandler = new Handler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    if (WebViewCore.this.mWebView == null || WebViewCore.this.mNativeClass == 0) {
                        return;
                    }
                    if (EventHub.this.mDestroying && msg.what != 110 && msg.what != 109 && msg.what != 200) {
                        return;
                    }
                    switch (msg.what) {
                        case 130: {
                            WebViewCore.this.webkitDraw();
                            break;
                        }
                        case 148: {
                            WebViewCore.this.webkitDrawLayers();
                            break;
                        }
                        case 200: {
                            WebViewCore webViewCore = WebViewCore.this;
                            synchronized (webViewCore) {
                                WebViewCore.this.mBrowserFrame.destroy();
                                WebViewCore.this.mBrowserFrame = null;
                                WebViewCore.this.mSettings.onDestroyed();
                                WebViewCore.this.mNativeClass = 0;
                                WebViewCore.this.mWebView = null;
                                break;
                            }
                        }
                        case 96: {
                            WebViewCore.this.nativeRevealSelection();
                            break;
                        }
                        case 97: {
                            int nodePointer;
                            String label;
                            if (WebViewCore.this.mWebView == null || (label = WebViewCore.this.nativeRequestLabel(msg.arg1, nodePointer = msg.arg2)) == null || label.length() <= 0) break;
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler, 125, nodePointer, 0, label).sendToTarget();
                            break;
                        }
                        case 98: {
                            WebViewCore.this.nativeUpdateFrameCacheIfLoading();
                            break;
                        }
                        case 99: {
                            float xPercent = msg.obj == null ? 0.0f : ((Float)msg.obj).floatValue();
                            WebViewCore.this.nativeScrollFocusedTextInput(xPercent, msg.arg2);
                            break;
                        }
                        case 100: {
                            CookieManager.getInstance().waitForCookieOperationsToComplete();
                            GetUrlData param = (GetUrlData)msg.obj;
                            WebViewCore.this.loadUrl(param.mUrl, param.mExtraHeaders);
                            break;
                        }
                        case 132: {
                            CookieManager.getInstance().waitForCookieOperationsToComplete();
                            PostUrlData param = (PostUrlData)msg.obj;
                            WebViewCore.this.mBrowserFrame.postUrl(param.mUrl, param.mPostData);
                            break;
                        }
                        case 139: {
                            String scheme;
                            int i;
                            CookieManager.getInstance().waitForCookieOperationsToComplete();
                            BaseUrlData loadParams = (BaseUrlData)msg.obj;
                            String baseUrl = loadParams.mBaseUrl;
                            if (!(baseUrl == null || (i = baseUrl.indexOf(58)) <= 0 || (scheme = baseUrl.substring(0, i)).startsWith("http") || scheme.startsWith("ftp") || scheme.startsWith("about") || scheme.startsWith("javascript"))) {
                                WebViewCore.this.nativeRegisterURLSchemeAsLocal(scheme);
                            }
                            WebViewCore.this.mBrowserFrame.loadData(baseUrl, loadParams.mData, loadParams.mMimeType, loadParams.mEncoding, loadParams.mHistoryUrl);
                            WebViewCore.this.nativeContentInvalidateAll();
                            break;
                        }
                        case 101: {
                            if (WebViewCore.this.mBrowserFrame.committed() && !WebViewCore.this.mBrowserFrame.firstLayoutDone()) {
                                WebViewCore.this.mBrowserFrame.didFirstLayout();
                            }
                            WebViewCore.this.stopLoading();
                            break;
                        }
                        case 102: {
                            WebViewCore.this.mBrowserFrame.reload(false);
                            break;
                        }
                        case 103: {
                            WebViewCore.this.key((KeyEvent)msg.obj, true);
                            break;
                        }
                        case 104: {
                            WebViewCore.this.key((KeyEvent)msg.obj, false);
                            break;
                        }
                        case 121: {
                            WebViewCore.this.nativeClick(msg.arg1, msg.arg2, true);
                            break;
                        }
                        case 118: {
                            WebViewCore.this.nativeClick(msg.arg1, msg.arg2, false);
                            break;
                        }
                        case 105: {
                            WebViewCore.this.viewSizeChanged((WebView.ViewSizeData)msg.obj);
                            break;
                        }
                        case 107: {
                            Point pt = (Point)msg.obj;
                            WebViewCore.this.nativeSetScrollOffset(msg.arg1, msg.arg2 == 1, pt.x, pt.y);
                            break;
                        }
                        case 116: {
                            Rect r = (Rect)msg.obj;
                            WebViewCore.this.nativeSetGlobalBounds(r.left, r.top, r.width(), r.height());
                            break;
                        }
                        case 106: {
                            if (!WebViewCore.this.mBrowserFrame.committed() && msg.arg1 == -1 && WebViewCore.this.mBrowserFrame.loadType() == 0) {
                                WebViewCore.this.mBrowserFrame.reload(true);
                                break;
                            }
                            WebViewCore.this.mBrowserFrame.goBackOrForward(msg.arg1);
                            break;
                        }
                        case 108: {
                            WebViewCore.this.stopLoading();
                            WebViewCore.this.restoreState(msg.arg1);
                            break;
                        }
                        case 109: {
                            EventHub.this.mSavedPriority = Process.getThreadPriority(EventHub.this.mTid);
                            Process.setThreadPriority(EventHub.this.mTid, 10);
                            WebViewCore.pauseTimers();
                            if (!JniUtil.useChromiumHttpStack()) {
                                WebViewWorker.getHandler().sendEmptyMessage(111);
                                break;
                            }
                            WebViewCore.this.nativeCloseIdleConnections();
                            break;
                        }
                        case 110: {
                            Process.setThreadPriority(EventHub.this.mTid, EventHub.this.mSavedPriority);
                            WebViewCore.resumeTimers();
                            if (JniUtil.useChromiumHttpStack()) break;
                            WebViewWorker.getHandler().sendEmptyMessage(112);
                            break;
                        }
                        case 143: {
                            WebViewCore.this.nativePause();
                            break;
                        }
                        case 144: {
                            WebViewCore.this.nativeResume();
                            break;
                        }
                        case 145: {
                            WebViewCore.this.clearCache(false);
                            WebViewCore.this.nativeFreeMemory();
                            break;
                        }
                        case 119: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.setNetworkOnLine(msg.arg1 == 1);
                            break;
                        }
                        case 183: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            Map map = (Map)msg.obj;
                            BrowserFrame.sJavaBridge.setNetworkType((String)map.get("type"), (String)map.get("subtype"));
                            break;
                        }
                        case 111: {
                            WebViewCore.this.clearCache(msg.arg1 == 1);
                            break;
                        }
                        case 112: {
                            WebViewCore.this.mCallbackProxy.getBackForwardList().close(((WebViewCore)WebViewCore.this).mBrowserFrame.mNativeFrame);
                            break;
                        }
                        case 114: {
                            ReplaceTextData rep = (ReplaceTextData)msg.obj;
                            WebViewCore.this.nativeReplaceTextfieldText(msg.arg1, msg.arg2, rep.mReplace, rep.mNewStart, rep.mNewEnd, rep.mTextGeneration);
                            break;
                        }
                        case 115: {
                            JSKeyData jsData = (JSKeyData)msg.obj;
                            KeyEvent evt = jsData.mEvent;
                            int keyCode = evt.getKeyCode();
                            int keyValue = evt.getUnicodeChar();
                            int generation = msg.arg1;
                            WebViewCore.this.passToJs(generation, jsData.mCurrentText, keyCode, keyValue, evt.isDown(), evt.isShiftPressed(), evt.isAltPressed(), evt.isSymPressed());
                            break;
                        }
                        case 128: {
                            CursorData cDat = (CursorData)msg.obj;
                            WebViewCore.this.nativeSaveDocumentState(cDat.mFrame);
                            break;
                        }
                        case 150: {
                            if (JniUtil.useChromiumHttpStack()) {
                                SslCertLookupTable.getInstance().clear();
                                WebViewCore.this.nativeCloseIdleConnections();
                                break;
                            }
                            Network.getInstance(WebViewCore.this.mContext).clearUserSslPrefTable();
                            break;
                        }
                        case 140: {
                            TouchUpData touchUpData = (TouchUpData)msg.obj;
                            if (touchUpData.mNativeLayer != 0) {
                                WebViewCore.this.nativeScrollLayer(touchUpData.mNativeLayer, touchUpData.mNativeLayerRect);
                            }
                            WebViewCore.this.nativeTouchUp(touchUpData.mMoveGeneration, touchUpData.mFrame, touchUpData.mNode, touchUpData.mX, touchUpData.mY);
                            break;
                        }
                        case 141: {
                            TouchEventData ted = (TouchEventData)msg.obj;
                            int count = ted.mPoints.length;
                            int[] xArray = new int[count];
                            int[] yArray = new int[count];
                            for (int c = 0; c < count; ++c) {
                                xArray[c] = ted.mPoints[c].x;
                                yArray[c] = ted.mPoints[c].y;
                            }
                            if (ted.mNativeLayer != 0) {
                                WebViewCore.this.nativeScrollLayer(ted.mNativeLayer, ted.mNativeLayerRect);
                            }
                            ted.mNativeResult = WebViewCore.this.nativeHandleTouchEvent(ted.mAction, ted.mIds, xArray, yArray, count, ted.mActionIndex, ted.mMetaState);
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler, 115, ted.mAction, ted.mNativeResult ? 1 : 0, ted).sendToTarget();
                            break;
                        }
                        case 142: {
                            WebViewCore.this.nativeSetFocusControllerActive(msg.arg1 == 1);
                            break;
                        }
                        case 138: {
                            JSInterfaceData jsData = (JSInterfaceData)msg.obj;
                            WebViewCore.this.mBrowserFrame.addJavascriptInterface(jsData.mObject, jsData.mInterfaceName);
                            break;
                        }
                        case 149: {
                            JSInterfaceData jsData = (JSInterfaceData)msg.obj;
                            WebViewCore.this.mBrowserFrame.removeJavascriptInterface(jsData.mInterfaceName);
                            break;
                        }
                        case 160: {
                            WebViewCore.this.mBrowserFrame.externalRepresentation((Message)msg.obj);
                            break;
                        }
                        case 161: {
                            WebViewCore.this.mBrowserFrame.documentAsText((Message)msg.obj);
                            break;
                        }
                        case 127: {
                            CursorData focusData = (CursorData)msg.obj;
                            WebViewCore.this.nativeMoveFocus(focusData.mFrame, focusData.mNode);
                            break;
                        }
                        case 135: {
                            CursorData cursorData = (CursorData)msg.obj;
                            WebViewCore.this.nativeMoveMouse(cursorData.mFrame, cursorData.mX, cursorData.mY);
                            break;
                        }
                        case 136: {
                            CursorData cData = (CursorData)msg.obj;
                            WebViewCore.this.nativeMoveMouseIfLatest(cData.mMoveGeneration, cData.mFrame, cData.mX, cData.mY);
                            if (msg.arg1 != 1) break;
                            WebViewCore.this.nativeStopPaintingCaret();
                            break;
                        }
                        case 137: {
                            Message hrefMsg = (Message)msg.obj;
                            hrefMsg.getData().putString("url", WebViewCore.this.nativeRetrieveHref(msg.arg1, msg.arg2));
                            hrefMsg.getData().putString("title", WebViewCore.this.nativeRetrieveAnchorText(msg.arg1, msg.arg2));
                            hrefMsg.getData().putString("src", WebViewCore.this.nativeRetrieveImageSource(msg.arg1, msg.arg2));
                            hrefMsg.sendToTarget();
                            break;
                        }
                        case 117: {
                            WebViewCore.this.nativeUpdateFrameCache();
                            if (WebViewCore.this.mWebView != null) {
                                WebViewCore.this.mWebView.postInvalidate();
                            }
                            WebViewCore.this.sendUpdateTextEntry();
                            break;
                        }
                        case 120: {
                            Message imageResult = (Message)msg.obj;
                            imageResult.arg1 = WebViewCore.this.mBrowserFrame.documentHasImages() ? 1 : 0;
                            imageResult.sendToTarget();
                            break;
                        }
                        case 122: {
                            TextSelectionData deleteSelectionData = (TextSelectionData)msg.obj;
                            WebViewCore.this.nativeDeleteSelection(deleteSelectionData.mStart, deleteSelectionData.mEnd, msg.arg1);
                            break;
                        }
                        case 113: {
                            WebViewCore.this.nativeSetSelection(msg.arg1, msg.arg2);
                            break;
                        }
                        case 190: {
                            String modifiedSelectionString = WebViewCore.this.nativeModifySelection(msg.arg1, msg.arg2);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(130, modifiedSelectionString).sendToTarget();
                            break;
                        }
                        case 123: {
                            SparseBooleanArray choices = (SparseBooleanArray)msg.obj;
                            int choicesSize = msg.arg1;
                            boolean[] choicesArray = new boolean[choicesSize];
                            for (int c = 0; c < choicesSize; ++c) {
                                choicesArray[c] = choices.get(c);
                            }
                            WebViewCore.this.nativeSendListBoxChoices(choicesArray, choicesSize);
                            break;
                        }
                        case 124: {
                            WebViewCore.this.nativeSendListBoxChoice(msg.arg1);
                            break;
                        }
                        case 126: {
                            WebViewCore.this.nativeSetBackgroundColor(msg.arg1);
                            break;
                        }
                        case 170: {
                            WebViewCore.this.nativeDumpDomTree(msg.arg1 == 1);
                            break;
                        }
                        case 171: {
                            WebViewCore.this.nativeDumpRenderTree(msg.arg1 == 1);
                            break;
                        }
                        case 172: {
                            WebViewCore.this.nativeDumpNavTree();
                            break;
                        }
                        case 173: {
                            WebViewCore.this.nativeDumpV8Counters();
                            break;
                        }
                        case 174: {
                            WebViewCore.this.nativeSetJsFlags((String)msg.obj);
                            break;
                        }
                        case 175: {
                            WebViewCore.this.nativeContentInvalidateAll();
                            break;
                        }
                        case 147: {
                            WebView.SaveWebArchiveMessage saveMessage = (WebView.SaveWebArchiveMessage)msg.obj;
                            saveMessage.mResultFile = WebViewCore.this.saveWebArchive(saveMessage.mBasename, saveMessage.mAutoname);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(132, saveMessage).sendToTarget();
                            break;
                        }
                        case 180: {
                            GeolocationPermissionsData data = (GeolocationPermissionsData)msg.obj;
                            WebViewCore.this.nativeGeolocationPermissionsProvide(data.mOrigin, data.mAllow, data.mRemember);
                            break;
                        }
                        case 133: {
                            WebViewCore.this.nativeSplitContent(msg.arg1);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(123, msg.arg1, 0);
                            WebViewCore.this.mSplitPictureIsScheduled = false;
                            break;
                        }
                        case 134: {
                            WebViewCore.this.nativeClearContent();
                            break;
                        }
                        case 125: {
                            ((Message)msg.obj).sendToTarget();
                            break;
                        }
                        case 181: {
                            WebViewCore.this.nativeProvideVisitedHistory((String[])msg.obj);
                            break;
                        }
                        case 146: {
                            MotionUpData motionUpData = (MotionUpData)msg.obj;
                            if (!WebViewCore.this.nativeValidNodeAndBounds(motionUpData.mFrame, motionUpData.mNode, motionUpData.mBounds)) {
                                WebViewCore.this.nativeUpdateFrameCache();
                            }
                            Message message = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(119, motionUpData.mX, motionUpData.mY);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.sendMessageAtFrontOfQueue(message);
                            break;
                        }
                        case 182: {
                            WebViewCore.this.nativeFullScreenPluginHidden(msg.arg1);
                            break;
                        }
                        case 195: {
                            WebViewCore.this.nativePluginSurfaceReady();
                            break;
                        }
                        case 196: {
                            WebViewCore.this.nativeNotifyAnimationStarted(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 184: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.addPackageNames((Set)msg.obj);
                            break;
                        }
                        case 187: {
                            TouchHighlightData d = (TouchHighlightData)msg.obj;
                            if (d.mNativeLayer != 0) {
                                WebViewCore.this.nativeScrollLayer(d.mNativeLayer, d.mNativeLayerRect);
                            }
                            ArrayList rects = WebViewCore.this.nativeGetTouchHighlightRects(d.mX, d.mY, d.mSlop);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(131, rects).sendToTarget();
                            break;
                        }
                        case 191: {
                            WebViewCore.this.useMockDeviceOrientation();
                            break;
                        }
                        case 192: {
                            WebViewCore.this.nativeAutoFillForm(msg.arg1);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(134, null).sendToTarget();
                            break;
                        }
                        case 194: {
                            if (!(msg.obj instanceof String)) break;
                            WebViewCore.this.mBrowserFrame.stringByEvaluatingJavaScriptFromString((String)msg.obj);
                        }
                    }
                }
            };
            EventHub eventHub = this;
            synchronized (eventHub) {
                int size = this.mMessages.size();
                for (int i = 0; i < size; ++i) {
                    this.mHandler.sendMessage(this.mMessages.get(i));
                }
                this.mMessages = null;
            }
        }

        private synchronized void sendMessage(Message msg) {
            if (this.mBlockMessages) {
                return;
            }
            if (this.mMessages != null) {
                this.mMessages.add(msg);
            } else {
                this.mHandler.sendMessage(msg);
            }
        }

        private synchronized void removeMessages(int what) {
            if (this.mBlockMessages) {
                return;
            }
            if (what == 130) {
                WebViewCore.this.mDrawIsScheduled = false;
            }
            if (this.mMessages != null) {
                Throwable throwable = new Throwable("EventHub.removeMessages(int what = " + what + ") is not supported " + "before the WebViewCore is set up.");
                Log.w(WebViewCore.LOGTAG, Log.getStackTraceString(throwable));
            } else {
                this.mHandler.removeMessages(what);
            }
        }

        private synchronized void sendMessageDelayed(Message msg, long delay) {
            if (this.mBlockMessages) {
                return;
            }
            this.mHandler.sendMessageDelayed(msg, delay);
        }

        private synchronized void sendMessageAtFrontOfQueue(Message msg) {
            if (this.mBlockMessages) {
                return;
            }
            if (this.mMessages != null) {
                this.mMessages.add(0, msg);
            } else {
                this.mHandler.sendMessageAtFrontOfQueue(msg);
            }
        }

        private synchronized void removeMessages() {
            WebViewCore.this.mDrawIsScheduled = false;
            WebViewCore.this.mSplitPictureIsScheduled = false;
            if (this.mMessages != null) {
                this.mMessages.clear();
            } else {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }

        private synchronized void blockMessages() {
            this.mBlockMessages = true;
        }
    }

    static class GeolocationPermissionsData {
        String mOrigin;
        boolean mAllow;
        boolean mRemember;

        GeolocationPermissionsData() {
        }
    }

    static class TouchEventData {
        int mAction;
        int[] mIds;
        Point[] mPoints;
        Point[] mPointsInView;
        int mActionIndex;
        int mMetaState;
        boolean mReprocess;
        MotionEvent mMotionEvent;
        int mNativeLayer;
        Rect mNativeLayerRect = new Rect();
        long mSequence;
        boolean mNativeResult;

        TouchEventData() {
        }
    }

    static class AutoFillData {
        private int mQueryId;
        private String mPreview;

        public AutoFillData() {
            this.mQueryId = -1;
            this.mPreview = "";
        }

        public AutoFillData(int queryId, String preview) {
            this.mQueryId = queryId;
            this.mPreview = preview;
        }

        public int getQueryId() {
            return this.mQueryId;
        }

        public String getPreviewString() {
            return this.mPreview;
        }
    }

    static class TouchHighlightData {
        int mX;
        int mY;
        int mSlop;
        int mNativeLayer;
        Rect mNativeLayerRect;

        TouchHighlightData() {
        }
    }

    static class TouchUpData {
        int mMoveGeneration;
        int mFrame;
        int mNode;
        int mX;
        int mY;
        int mNativeLayer;
        Rect mNativeLayerRect = new Rect();

        TouchUpData() {
        }
    }

    static class TextSelectionData {
        int mStart;
        int mEnd;

        public TextSelectionData(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }
    }

    static class ReplaceTextData {
        String mReplace;
        int mNewStart;
        int mNewEnd;
        int mTextGeneration;

        ReplaceTextData() {
        }
    }

    static class PostUrlData {
        String mUrl;
        byte[] mPostData;

        PostUrlData() {
        }
    }

    static class GetUrlData {
        String mUrl;
        Map<String, String> mExtraHeaders;

        GetUrlData() {
        }
    }

    static class MotionUpData {
        int mFrame;
        int mNode;
        Rect mBounds;
        int mX;
        int mY;

        MotionUpData() {
        }
    }

    static class JSKeyData {
        String mCurrentText;
        KeyEvent mEvent;

        JSKeyData() {
        }
    }

    static class JSInterfaceData {
        Object mObject;
        String mInterfaceName;

        JSInterfaceData() {
        }
    }

    static class CursorData {
        int mMoveGeneration;
        int mFrame;
        int mNode;
        int mX;
        int mY;

        CursorData() {
        }

        CursorData(int frame, int node, int x, int y) {
            this.mFrame = frame;
            this.mNode = node;
            this.mX = x;
            this.mY = y;
        }
    }

    static class BaseUrlData {
        String mBaseUrl;
        String mData;
        String mMimeType;
        String mEncoding;
        String mHistoryUrl;

        BaseUrlData() {
        }
    }

    private static class WebCoreThread
    implements Runnable {
        private static final int INITIALIZE = 0;
        private static final int REDUCE_PRIORITY = 1;
        private static final int RESUME_PRIORITY = 2;

        private WebCoreThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            Assert.assertNull((Object)sWebCoreHandler);
            Class<WebViewCore> clazz = WebViewCore.class;
            synchronized (WebViewCore.class) {
                sWebCoreHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                WebViewCore core = (WebViewCore)msg.obj;
                                core.initialize();
                                break;
                            }
                            case 1: {
                                Process.setThreadPriority(3);
                                break;
                            }
                            case 2: {
                                Process.setThreadPriority(0);
                                break;
                            }
                            case 185: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.addPackageName((String)msg.obj);
                                break;
                            }
                            case 186: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.removePackageName((String)msg.obj);
                                break;
                            }
                            case 193: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.updateProxy((ProxyProperties)msg.obj);
                            }
                        }
                    }
                };
                WebViewCore.class.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Looper.loop();
                return;
            }
        }
    }
}

