/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.RemotableViewMethod;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.Checkable;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import com.google.android.collect.Lists;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RemoteViews.RemoteView
public class ListView
extends AbsListView {
    static final int NO_POSITION = -1;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private static final int MIN_SCROLL_PREVIEW_PIXELS = 2;
    private ArrayList<FixedViewInfo> mHeaderViewInfos = Lists.newArrayList();
    private ArrayList<FixedViewInfo> mFooterViewInfos = Lists.newArrayList();
    Drawable mDivider;
    int mDividerHeight;
    Drawable mOverScrollHeader;
    Drawable mOverScrollFooter;
    private boolean mIsCacheColorOpaque;
    private boolean mDividerIsOpaque;
    private boolean mHeaderDividersEnabled;
    private boolean mFooterDividersEnabled;
    private boolean mAreAllItemsSelectable = true;
    private boolean mItemsCanFocus = false;
    private final Rect mTempRect = new Rect();
    private Paint mDividerPaint;
    private final ArrowScrollFocusResult mArrowScrollFocusResult = new ArrowScrollFocusResult();
    private FocusSelector mFocusSelector;

    public ListView(Context context) {
        this(context, null);
    }

    public ListView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842868);
    }

    public ListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int dividerHeight;
        Drawable osFooter;
        Drawable osHeader;
        Drawable d;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListView, defStyle, 0);
        CharSequence[] entries = a.getTextArray(0);
        if (entries != null) {
            this.setAdapter(new ArrayAdapter<CharSequence>(context, 17367043, entries));
        }
        if ((d = a.getDrawable(1)) != null) {
            this.setDivider(d);
        }
        if ((osHeader = a.getDrawable(5)) != null) {
            this.setOverscrollHeader(osHeader);
        }
        if ((osFooter = a.getDrawable(6)) != null) {
            this.setOverscrollFooter(osFooter);
        }
        if ((dividerHeight = a.getDimensionPixelSize(2, 0)) != 0) {
            this.setDividerHeight(dividerHeight);
        }
        this.mHeaderDividersEnabled = a.getBoolean(3, true);
        this.mFooterDividersEnabled = a.getBoolean(4, true);
        a.recycle();
    }

    public int getMaxScrollAmount() {
        return (int)(0.33f * (float)(this.mBottom - this.mTop));
    }

    private void adjustViewsUpOrDown() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int delta;
            if (!this.mStackFromBottom) {
                View child = this.getChildAt(0);
                delta = child.getTop() - this.mListPadding.top;
                if (this.mFirstPosition != 0) {
                    delta -= this.mDividerHeight;
                }
                if (delta < 0) {
                    delta = 0;
                }
            } else {
                View child = this.getChildAt(childCount - 1);
                delta = child.getBottom() - (this.getHeight() - this.mListPadding.bottom);
                if (this.mFirstPosition + childCount < this.mItemCount) {
                    delta += this.mDividerHeight;
                }
                if (delta > 0) {
                    delta = 0;
                }
            }
            if (delta != 0) {
                this.offsetChildrenTopAndBottom(-delta);
            }
        }
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null && !(this.mAdapter instanceof HeaderViewListAdapter)) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        FixedViewInfo info = new FixedViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeHeader(v)) {
                if (this.mDataSetObserver != null) {
                    this.mDataSetObserver.onChanged();
                }
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private void removeFixedViewInfo(View v, ArrayList<FixedViewInfo> where) {
        int len = where.size();
        for (int i = 0; i < len; ++i) {
            FixedViewInfo info = where.get(i);
            if (info.view != v) continue;
            where.remove(i);
            break;
        }
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        FixedViewInfo info = new FixedViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    @Override
    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeFooter(v)) {
                if (this.mDataSetObserver != null) {
                    this.mDataSetObserver.onChanged();
                }
                result = true;
            }
            this.removeFixedViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    @RemotableViewMethod
    public void setRemoteViewsAdapter(Intent intent) {
        super.setRemoteViewsAdapter(intent);
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter) : adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        super.setAdapter(adapter);
        if (this.mAdapter != null) {
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AbsListView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int position = this.mStackFromBottom ? this.lookForSelectablePosition(this.mItemCount - 1, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.mAreAllItemsSelectable = true;
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    @Override
    void resetList() {
        this.clearRecycledState(this.mHeaderViewInfos);
        this.clearRecycledState(this.mFooterViewInfos);
        super.resetList();
        this.mLayoutMode = 0;
    }

    private void clearRecycledState(ArrayList<FixedViewInfo> infos) {
        if (infos != null) {
            int count = infos.size();
            for (int i = 0; i < count; ++i) {
                View child = infos.get((int)i).view;
                AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
                if (p == null) continue;
                p.recycledHeaderFooter = false;
            }
        }
    }

    private boolean showingTopFadingEdge() {
        int listTop = this.mScrollY + this.mListPadding.top;
        return this.mFirstPosition > 0 || this.getChildAt(0).getTop() > listTop;
    }

    private boolean showingBottomFadingEdge() {
        int childCount = this.getChildCount();
        int bottomOfBottomChild = this.getChildAt(childCount - 1).getBottom();
        int lastVisiblePosition = this.mFirstPosition + childCount - 1;
        int listBottom = this.mScrollY + this.getHeight() - this.mListPadding.bottom;
        return lastVisiblePosition < this.mItemCount - 1 || bottomOfBottomChild < listBottom;
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        boolean scroll;
        int rectTopWithinChild = rect.top;
        rect.offset(child.getLeft(), child.getTop());
        rect.offset(-child.getScrollX(), -child.getScrollY());
        int height = this.getHeight();
        int listUnfadedTop = this.getScrollY();
        int listUnfadedBottom = listUnfadedTop + height;
        int fadingEdge = this.getVerticalFadingEdgeLength();
        if (this.showingTopFadingEdge() && (this.mSelectedPosition > 0 || rectTopWithinChild > fadingEdge)) {
            listUnfadedTop += fadingEdge;
        }
        int childCount = this.getChildCount();
        int bottomOfBottomChild = this.getChildAt(childCount - 1).getBottom();
        if (this.showingBottomFadingEdge() && (this.mSelectedPosition < this.mItemCount - 1 || rect.bottom < bottomOfBottomChild - fadingEdge)) {
            listUnfadedBottom -= fadingEdge;
        }
        int scrollYDelta = 0;
        if (rect.bottom > listUnfadedBottom && rect.top > listUnfadedTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - listUnfadedTop) : (scrollYDelta += rect.bottom - listUnfadedBottom);
            int distanceToBottom = bottomOfBottomChild - listUnfadedBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < listUnfadedTop && rect.bottom < listUnfadedBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= listUnfadedBottom - rect.bottom) : (scrollYDelta -= listUnfadedTop - rect.top);
            int top = this.getChildAt(0).getTop();
            int deltaToTop = top - listUnfadedTop;
            scrollYDelta = Math.max(scrollYDelta, deltaToTop);
        }
        boolean bl = scroll = scrollYDelta != 0;
        if (scroll) {
            this.scrollListItemsBy(-scrollYDelta);
            this.positionSelector(-1, child);
            this.mSelectedTop = child.getTop();
            this.invalidate();
        }
        return scroll;
    }

    @Override
    void fillGap(boolean down) {
        int count = this.getChildCount();
        if (down) {
            int paddingTop = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                paddingTop = this.getListPaddingTop();
            }
            int startOffset = count > 0 ? this.getChildAt(count - 1).getBottom() + this.mDividerHeight : paddingTop;
            this.fillDown(this.mFirstPosition + count, startOffset);
            this.correctTooHigh(this.getChildCount());
        } else {
            int paddingBottom = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                paddingBottom = this.getListPaddingBottom();
            }
            int startOffset = count > 0 ? this.getChildAt(0).getTop() - this.mDividerHeight : this.getHeight() - paddingBottom;
            this.fillUp(this.mFirstPosition - 1, startOffset);
            this.correctTooLow(this.getChildCount());
        }
    }

    private View fillDown(int pos, int nextTop) {
        View selectedView = null;
        int end = this.mBottom - this.mTop;
        if ((this.mGroupFlags & 0x22) == 34) {
            end -= this.mListPadding.bottom;
        }
        while (nextTop < end && pos < this.mItemCount) {
            boolean selected = pos == this.mSelectedPosition;
            View child = this.makeAndAddView(pos, nextTop, true, this.mListPadding.left, selected);
            nextTop = child.getBottom() + this.mDividerHeight;
            if (selected) {
                selectedView = child;
            }
            ++pos;
        }
        return selectedView;
    }

    private View fillUp(int pos, int nextBottom) {
        View selectedView = null;
        int end = 0;
        if ((this.mGroupFlags & 0x22) == 34) {
            end = this.mListPadding.top;
        }
        while (nextBottom > end && pos >= 0) {
            boolean selected = pos == this.mSelectedPosition;
            View child = this.makeAndAddView(pos, nextBottom, false, this.mListPadding.left, selected);
            nextBottom = child.getTop() - this.mDividerHeight;
            if (selected) {
                selectedView = child;
            }
            --pos;
        }
        this.mFirstPosition = pos + 1;
        return selectedView;
    }

    private View fillFromTop(int nextTop) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillDown(this.mFirstPosition, nextTop);
    }

    private View fillFromMiddle(int childrenTop, int childrenBottom) {
        int height = childrenBottom - childrenTop;
        int position = this.reconcileSelectedPosition();
        View sel = this.makeAndAddView(position, childrenTop, true, this.mListPadding.left, true);
        this.mFirstPosition = position;
        int selHeight = sel.getMeasuredHeight();
        if (selHeight <= height) {
            sel.offsetTopAndBottom((height - selHeight) / 2);
        }
        this.fillAboveAndBelow(sel, position);
        if (!this.mStackFromBottom) {
            this.correctTooHigh(this.getChildCount());
        } else {
            this.correctTooLow(this.getChildCount());
        }
        return sel;
    }

    private void fillAboveAndBelow(View sel, int position) {
        int dividerHeight = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            this.fillUp(position - 1, sel.getTop() - dividerHeight);
            this.adjustViewsUpOrDown();
            this.fillDown(position + 1, sel.getBottom() + dividerHeight);
        } else {
            this.fillDown(position + 1, sel.getBottom() + dividerHeight);
            this.adjustViewsUpOrDown();
            this.fillUp(position - 1, sel.getTop() - dividerHeight);
        }
    }

    private View fillFromSelection(int selectedTop, int childrenTop, int childrenBottom) {
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, selectedPosition);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, selectedPosition);
        View sel = this.makeAndAddView(selectedPosition, selectedTop, true, this.mListPadding.left, true);
        if (sel.getBottom() > bottomSelectionPixel) {
            int spaceAbove = sel.getTop() - topSelectionPixel;
            int spaceBelow = sel.getBottom() - bottomSelectionPixel;
            int offset = Math.min(spaceAbove, spaceBelow);
            sel.offsetTopAndBottom(-offset);
        } else if (sel.getTop() < topSelectionPixel) {
            int spaceAbove = topSelectionPixel - sel.getTop();
            int spaceBelow = bottomSelectionPixel - sel.getBottom();
            int offset = Math.min(spaceAbove, spaceBelow);
            sel.offsetTopAndBottom(offset);
        }
        this.fillAboveAndBelow(sel, selectedPosition);
        if (!this.mStackFromBottom) {
            this.correctTooHigh(this.getChildCount());
        } else {
            this.correctTooLow(this.getChildCount());
        }
        return sel;
    }

    private int getBottomSelectionPixel(int childrenBottom, int fadingEdgeLength, int selectedPosition) {
        int bottomSelectionPixel = childrenBottom;
        if (selectedPosition != this.mItemCount - 1) {
            bottomSelectionPixel -= fadingEdgeLength;
        }
        return bottomSelectionPixel;
    }

    private int getTopSelectionPixel(int childrenTop, int fadingEdgeLength, int selectedPosition) {
        int topSelectionPixel = childrenTop;
        if (selectedPosition > 0) {
            topSelectionPixel += fadingEdgeLength;
        }
        return topSelectionPixel;
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollToPosition(int position) {
        super.smoothScrollToPosition(position);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollByOffset(int offset) {
        super.smoothScrollByOffset(offset);
    }

    private View moveSelection(View oldSel, View newSel, int delta, int childrenTop, int childrenBottom) {
        View sel;
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, selectedPosition);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenTop, fadingEdgeLength, selectedPosition);
        if (delta > 0) {
            oldSel = this.makeAndAddView(selectedPosition - 1, oldSel.getTop(), true, this.mListPadding.left, false);
            int dividerHeight = this.mDividerHeight;
            sel = this.makeAndAddView(selectedPosition, oldSel.getBottom() + dividerHeight, true, this.mListPadding.left, true);
            if (sel.getBottom() > bottomSelectionPixel) {
                int spaceAbove = sel.getTop() - topSelectionPixel;
                int spaceBelow = sel.getBottom() - bottomSelectionPixel;
                int halfVerticalSpace = (childrenBottom - childrenTop) / 2;
                int offset = Math.min(spaceAbove, spaceBelow);
                offset = Math.min(offset, halfVerticalSpace);
                oldSel.offsetTopAndBottom(-offset);
                sel.offsetTopAndBottom(-offset);
            }
            if (!this.mStackFromBottom) {
                this.fillUp(this.mSelectedPosition - 2, sel.getTop() - dividerHeight);
                this.adjustViewsUpOrDown();
                this.fillDown(this.mSelectedPosition + 1, sel.getBottom() + dividerHeight);
            } else {
                this.fillDown(this.mSelectedPosition + 1, sel.getBottom() + dividerHeight);
                this.adjustViewsUpOrDown();
                this.fillUp(this.mSelectedPosition - 2, sel.getTop() - dividerHeight);
            }
        } else if (delta < 0) {
            sel = newSel != null ? this.makeAndAddView(selectedPosition, newSel.getTop(), true, this.mListPadding.left, true) : this.makeAndAddView(selectedPosition, oldSel.getTop(), false, this.mListPadding.left, true);
            if (sel.getTop() < topSelectionPixel) {
                int spaceAbove = topSelectionPixel - sel.getTop();
                int spaceBelow = bottomSelectionPixel - sel.getBottom();
                int halfVerticalSpace = (childrenBottom - childrenTop) / 2;
                int offset = Math.min(spaceAbove, spaceBelow);
                offset = Math.min(offset, halfVerticalSpace);
                sel.offsetTopAndBottom(offset);
            }
            this.fillAboveAndBelow(sel, selectedPosition);
        } else {
            int newBottom;
            int oldTop = oldSel.getTop();
            sel = this.makeAndAddView(selectedPosition, oldTop, true, this.mListPadding.left, true);
            if (oldTop < childrenTop && (newBottom = sel.getBottom()) < childrenTop + 20) {
                sel.offsetTopAndBottom(childrenTop - sel.getTop());
            }
            this.fillAboveAndBelow(sel, selectedPosition);
        }
        return sel;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        View focusedChild;
        if (this.getChildCount() > 0 && (focusedChild = this.getFocusedChild()) != null) {
            int childPosition = this.mFirstPosition + this.indexOfChild(focusedChild);
            int childBottom = focusedChild.getBottom();
            int offset = Math.max(0, childBottom - (h - this.mPaddingTop));
            int top = focusedChild.getTop() - offset;
            if (this.mFocusSelector == null) {
                this.mFocusSelector = new FocusSelector();
            }
            this.post(this.mFocusSelector.setup(childPosition, top));
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int childWidth = 0;
        int childHeight = 0;
        int childState = 0;
        int n = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (widthMode == 0 || heightMode == 0)) {
            View child = this.obtainView(0, this.mIsScrap);
            this.measureScrapChild(child, 0, widthMeasureSpec);
            childWidth = child.getMeasuredWidth();
            childHeight = child.getMeasuredHeight();
            childState = ListView.combineMeasuredStates(childState, child.getMeasuredState());
            if (this.recycleOnMeasure() && this.mRecycler.shouldRecycleViewType(((AbsListView.LayoutParams)child.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(child, -1);
            }
        }
        widthSize = widthMode == 0 ? this.mListPadding.left + this.mListPadding.right + childWidth + this.getVerticalScrollbarWidth() : (widthSize |= childState & 0xFF000000);
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getVerticalFadingEdgeLength() * 2;
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = this.measureHeightOfChildren(widthMeasureSpec, 0, -1, heightSize, -1);
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    private void measureScrapChild(View child, int position, int widthMeasureSpec) {
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = new AbsListView.LayoutParams(-1, -2, 0);
            child.setLayoutParams(p);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        p.forceAdd = true;
        int childWidthSpec = ViewGroup.getChildMeasureSpec(widthMeasureSpec, this.mListPadding.left + this.mListPadding.right, p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec(lpHeight, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    @ViewDebug.ExportedProperty(category="list")
    protected boolean recycleOnMeasure() {
        return true;
    }

    final int measureHeightOfChildren(int widthMeasureSpec, int startPosition, int endPosition, int maxHeight, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return this.mListPadding.top + this.mListPadding.bottom;
        }
        int returnedHeight = this.mListPadding.top + this.mListPadding.bottom;
        int dividerHeight = this.mDividerHeight > 0 && this.mDivider != null ? this.mDividerHeight : 0;
        int prevHeightWithoutPartialChild = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        boolean recyle = this.recycleOnMeasure();
        boolean[] isScrap = this.mIsScrap;
        for (int i = startPosition; i <= endPosition; ++i) {
            View child = this.obtainView(i, isScrap);
            this.measureScrapChild(child, i, widthMeasureSpec);
            if (i > 0) {
                returnedHeight += dividerHeight;
            }
            if (recyle && recycleBin.shouldRecycleViewType(((AbsListView.LayoutParams)child.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(child, -1);
            }
            if ((returnedHeight += child.getMeasuredHeight()) >= maxHeight) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedHeight != maxHeight ? prevHeightWithoutPartialChild : maxHeight;
            }
            if (disallowPartialChildPosition < 0 || i < disallowPartialChildPosition) continue;
            prevHeightWithoutPartialChild = returnedHeight;
        }
        return returnedHeight;
    }

    @Override
    int findMotionRow(int y) {
        block4: {
            int childCount = this.getChildCount();
            if (childCount <= 0) break block4;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < childCount; ++i) {
                    View v = this.getChildAt(i);
                    if (y > v.getBottom()) continue;
                    return this.mFirstPosition + i;
                }
            } else {
                for (int i = childCount - 1; i >= 0; --i) {
                    View v = this.getChildAt(i);
                    if (y < v.getTop()) continue;
                    return this.mFirstPosition + i;
                }
            }
        }
        return -1;
    }

    private View fillSpecific(int position, int top) {
        View below;
        View above;
        boolean tempIsSelected = position == this.mSelectedPosition;
        View temp = this.makeAndAddView(position, top, true, this.mListPadding.left, tempIsSelected);
        this.mFirstPosition = position;
        int dividerHeight = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            above = this.fillUp(position - 1, temp.getTop() - dividerHeight);
            this.adjustViewsUpOrDown();
            below = this.fillDown(position + 1, temp.getBottom() + dividerHeight);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooHigh(childCount);
            }
        } else {
            below = this.fillDown(position + 1, temp.getBottom() + dividerHeight);
            this.adjustViewsUpOrDown();
            above = this.fillUp(position - 1, temp.getTop() - dividerHeight);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooLow(childCount);
            }
        }
        if (tempIsSelected) {
            return temp;
        }
        if (above != null) {
            return above;
        }
        return below;
    }

    private void correctTooHigh(int childCount) {
        int lastPosition = this.mFirstPosition + childCount - 1;
        if (lastPosition == this.mItemCount - 1 && childCount > 0) {
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int bottomOffset = end - lastBottom;
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            if (bottomOffset > 0 && (this.mFirstPosition > 0 || firstTop < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    bottomOffset = Math.min(bottomOffset, this.mListPadding.top - firstTop);
                }
                this.offsetChildrenTopAndBottom(bottomOffset);
                if (this.mFirstPosition > 0) {
                    this.fillUp(this.mFirstPosition - 1, firstChild.getTop() - this.mDividerHeight);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private void correctTooLow(int childCount) {
        if (this.mFirstPosition == 0 && childCount > 0) {
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            int start = this.mListPadding.top;
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int topOffset = firstTop - start;
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int lastPosition = this.mFirstPosition + childCount - 1;
            if (topOffset > 0) {
                if (lastPosition < this.mItemCount - 1 || lastBottom > end) {
                    if (lastPosition == this.mItemCount - 1) {
                        topOffset = Math.min(topOffset, lastBottom - end);
                    }
                    this.offsetChildrenTopAndBottom(-topOffset);
                    if (lastPosition < this.mItemCount - 1) {
                        this.fillDown(lastPosition + 1, lastChild.getBottom() + this.mDividerHeight);
                        this.adjustViewsUpOrDown();
                    }
                } else if (lastPosition == this.mItemCount - 1) {
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren() {
        boolean blockLayoutRequests = this.mBlockLayoutRequests;
        if (blockLayoutRequests) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            View sel;
            boolean dataChanged;
            super.layoutChildren();
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            int childrenTop = this.mListPadding.top;
            int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
            int childCount = this.getChildCount();
            int index = 0;
            int delta = 0;
            View oldSel = null;
            View oldFirst = null;
            View newSel = null;
            View focusLayoutRestoreView = null;
            switch (this.mLayoutMode) {
                case 2: {
                    index = this.mNextSelectedPosition - this.mFirstPosition;
                    if (index < 0 || index >= childCount) break;
                    newSel = this.getChildAt(index);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    index = this.mSelectedPosition - this.mFirstPosition;
                    if (index >= 0 && index < childCount) {
                        oldSel = this.getChildAt(index);
                    }
                    oldFirst = this.getChildAt(0);
                    if (this.mNextSelectedPosition >= 0) {
                        delta = this.mNextSelectedPosition - this.mSelectedPosition;
                    }
                    newSel = this.getChildAt(index + delta);
                }
            }
            if (dataChanged = this.mDataChanged) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            if (this.mItemCount != this.mAdapter.getCount()) {
                throw new IllegalStateException("The content of the adapter has changed but ListView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. [in ListView(" + this.getId() + ", " + this.getClass() + ") with Adapter(" + this.mAdapter.getClass() + ")]");
            }
            this.setSelectedPositionInt(this.mNextSelectedPosition);
            int firstPosition = this.mFirstPosition;
            AbsListView.RecycleBin recycleBin = this.mRecycler;
            View focusLayoutRestoreDirectChild = null;
            if (dataChanged) {
                for (int i = 0; i < childCount; ++i) {
                    recycleBin.addScrapView(this.getChildAt(i), firstPosition + i);
                }
            } else {
                recycleBin.fillActiveViews(childCount, firstPosition);
            }
            View focusedChild = this.getFocusedChild();
            if (focusedChild != null) {
                if (!dataChanged || this.isDirectChildHeaderOrFooter(focusedChild)) {
                    focusLayoutRestoreDirectChild = focusedChild;
                    focusLayoutRestoreView = this.findFocus();
                    if (focusLayoutRestoreView != null) {
                        focusLayoutRestoreView.onStartTemporaryDetach();
                    }
                }
                this.requestFocus();
            }
            this.detachAllViewsFromParent();
            switch (this.mLayoutMode) {
                case 2: {
                    if (newSel != null) {
                        sel = this.fillFromSelection(newSel.getTop(), childrenTop, childrenBottom);
                        break;
                    }
                    sel = this.fillFromMiddle(childrenTop, childrenBottom);
                    break;
                }
                case 5: {
                    sel = this.fillSpecific(this.mSyncPosition, this.mSpecificTop);
                    break;
                }
                case 3: {
                    sel = this.fillUp(this.mItemCount - 1, childrenBottom);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 1: {
                    this.mFirstPosition = 0;
                    sel = this.fillFromTop(childrenTop);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 4: {
                    sel = this.fillSpecific(this.reconcileSelectedPosition(), this.mSpecificTop);
                    break;
                }
                case 6: {
                    sel = this.moveSelection(oldSel, newSel, delta, childrenTop, childrenBottom);
                    break;
                }
                default: {
                    if (childCount == 0) {
                        int position;
                        if (!this.mStackFromBottom) {
                            position = this.lookForSelectablePosition(0, true);
                            this.setSelectedPositionInt(position);
                            sel = this.fillFromTop(childrenTop);
                            break;
                        }
                        position = this.lookForSelectablePosition(this.mItemCount - 1, false);
                        this.setSelectedPositionInt(position);
                        sel = this.fillUp(this.mItemCount - 1, childrenBottom);
                        break;
                    }
                    sel = this.mSelectedPosition >= 0 && this.mSelectedPosition < this.mItemCount ? this.fillSpecific(this.mSelectedPosition, oldSel == null ? childrenTop : oldSel.getTop()) : (this.mFirstPosition < this.mItemCount ? this.fillSpecific(this.mFirstPosition, oldFirst == null ? childrenTop : oldFirst.getTop()) : this.fillSpecific(0, childrenTop));
                }
            }
            recycleBin.scrapActiveViews();
            if (sel != null) {
                if (this.mItemsCanFocus && this.hasFocus() && !sel.hasFocus()) {
                    boolean focusWasTaken;
                    boolean bl = focusWasTaken = sel == focusLayoutRestoreDirectChild && focusLayoutRestoreView.requestFocus() || sel.requestFocus();
                    if (!focusWasTaken) {
                        View focused = this.getFocusedChild();
                        if (focused != null) {
                            focused.clearFocus();
                        }
                        this.positionSelector(-1, sel);
                    } else {
                        sel.setSelected(false);
                        this.mSelectorRect.setEmpty();
                    }
                } else {
                    this.positionSelector(-1, sel);
                }
                this.mSelectedTop = sel.getTop();
            } else {
                if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                    View child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                    if (child != null) {
                        this.positionSelector(this.mMotionPosition, child);
                    }
                } else {
                    this.mSelectedTop = 0;
                    this.mSelectorRect.setEmpty();
                }
                if (this.hasFocus() && focusLayoutRestoreView != null) {
                    focusLayoutRestoreView.requestFocus();
                }
            }
            if (focusLayoutRestoreView != null && focusLayoutRestoreView.getWindowToken() != null) {
                focusLayoutRestoreView.onFinishTemporaryDetach();
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            this.mNeedSync = false;
            this.setNextSelectedPositionInt(this.mSelectedPosition);
            this.updateScrollIndicators();
            if (this.mItemCount > 0) {
                this.checkSelectionChanged();
            }
            this.invokeOnItemScrollListener();
        }
        finally {
            if (!blockLayoutRequests) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    private boolean isDirectChildHeaderOrFooter(View child) {
        ArrayList<FixedViewInfo> headers = this.mHeaderViewInfos;
        int numHeaders = headers.size();
        for (int i = 0; i < numHeaders; ++i) {
            if (child != headers.get((int)i).view) continue;
            return true;
        }
        ArrayList<FixedViewInfo> footers = this.mFooterViewInfos;
        int numFooters = footers.size();
        for (int i = 0; i < numFooters; ++i) {
            if (child != footers.get((int)i).view) continue;
            return true;
        }
        return false;
    }

    private View makeAndAddView(int position, int y, boolean flow, int childrenLeft, boolean selected) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.getActiveView(position)) != null) {
            this.setupChild(child, position, y, flow, childrenLeft, selected, true);
            return child;
        }
        child = this.obtainView(position, this.mIsScrap);
        this.setupChild(child, position, y, flow, childrenLeft, selected, this.mIsScrap[0]);
        return child;
    }

    private void setupChild(View child, int position, int y, boolean flowDown, int childrenLeft, boolean selected, boolean recycled) {
        int childTop;
        boolean isSelected = selected && this.shouldShowSelector();
        boolean updateChildSelected = isSelected != child.isSelected();
        int mode = this.mTouchMode;
        boolean isPressed = mode > 0 && mode < 3 && this.mMotionPosition == position;
        boolean updateChildPressed = isPressed != child.isPressed();
        boolean needToMeasure = !recycled || updateChildSelected || child.isLayoutRequested();
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = new AbsListView.LayoutParams(-1, -2, 0);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        if (recycled && !p.forceAdd || p.recycledHeaderFooter && p.viewType == -2) {
            this.attachViewToParent(child, flowDown ? -1 : 0, p);
        } else {
            p.forceAdd = false;
            if (p.viewType == -2) {
                p.recycledHeaderFooter = true;
            }
            this.addViewInLayout(child, flowDown ? -1 : 0, p, true);
        }
        if (updateChildSelected) {
            child.setSelected(isSelected);
        }
        if (updateChildPressed) {
            child.setPressed(isPressed);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            if (child instanceof Checkable) {
                ((Checkable)((Object)child)).setChecked(this.mCheckStates.get(position));
            } else if (this.getContext().getApplicationInfo().targetSdkVersion >= 11) {
                child.setActivated(this.mCheckStates.get(position));
            }
        }
        if (needToMeasure) {
            int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mListPadding.left + this.mListPadding.right, p.width);
            int lpHeight = p.height;
            int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec(lpHeight, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int n = childTop = flowDown ? y : y - h;
        if (needToMeasure) {
            int childRight = childrenLeft + w;
            int childBottom = childTop + h;
            child.layout(childrenLeft, childTop, childRight, childBottom);
        } else {
            child.offsetLeftAndRight(childrenLeft - child.getLeft());
            child.offsetTopAndBottom(childTop - child.getTop());
        }
        if (this.mCachingStarted && !child.isDrawingCacheEnabled()) {
            child.setDrawingCacheEnabled(true);
        }
        if (recycled && ((AbsListView.LayoutParams)child.getLayoutParams()).scrappedFromPosition != position) {
            child.jumpDrawablesToCurrentState();
        }
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    @Override
    public void setSelection(int position) {
        this.setSelectionFromTop(position, 0);
    }

    public void setSelectionFromTop(int position, int y) {
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((position = this.lookForSelectablePosition(position, true)) >= 0) {
                this.setNextSelectedPositionInt(position);
            }
        } else {
            this.mResurrectToPosition = position;
        }
        if (position >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificTop = this.mListPadding.top + y;
            if (this.mNeedSync) {
                this.mSyncPosition = position;
                this.mSyncRowId = this.mAdapter.getItemId(position);
            }
            this.requestLayout();
        }
    }

    @Override
    void setSelectionInt(int position) {
        this.setNextSelectedPositionInt(position);
        boolean awakeScrollbars = false;
        int selectedPosition = this.mSelectedPosition;
        if (selectedPosition >= 0) {
            if (position == selectedPosition - 1) {
                awakeScrollbars = true;
            } else if (position == selectedPosition + 1) {
                awakeScrollbars = true;
            }
        }
        this.layoutChildren();
        if (awakeScrollbars) {
            this.awakenScrollBars();
        }
    }

    @Override
    int lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int count = adapter.getCount();
        if (!this.mAreAllItemsSelectable) {
            if (lookDown) {
                for (position = Math.max(0, position); position < count && !adapter.isEnabled(position); ++position) {
                }
            } else {
                for (position = Math.min(position, count - 1); position >= 0 && !adapter.isEnabled(position); --position) {
                }
            }
            if (position < 0 || position >= count) {
                return -1;
            }
            return position;
        }
        if (position < 0 || position >= count) {
            return -1;
        }
        return position;
    }

    public void setSelectionAfterHeaderView() {
        int count = this.mHeaderViewInfos.size();
        if (count > 0) {
            this.mNextSelectedPosition = 0;
            return;
        }
        if (this.mAdapter != null) {
            this.setSelection(count);
        } else {
            this.mNextSelectedPosition = count;
            this.mLayoutMode = 2;
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        View focused;
        boolean handled = super.dispatchKeyEvent(event);
        if (!handled && (focused = this.getFocusedChild()) != null && event.getAction() == 0) {
            handled = this.onKeyDown(event.getKeyCode(), event);
        }
        return handled;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return this.commonKey(keyCode, repeatCount, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    private boolean commonKey(int keyCode, int count, KeyEvent event) {
        if (this.mAdapter == null || !this.mIsAttached) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        boolean handled = false;
        int action = event.getAction();
        if (action != 1) {
            switch (keyCode) {
                case 19: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded();
                        if (handled) break;
                        while (count-- > 0 && this.arrowScroll(33)) {
                            handled = true;
                        }
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 20: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded();
                        if (handled) break;
                        while (count-- > 0 && this.arrowScroll(130)) {
                            handled = true;
                        }
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 21: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.handleHorizontalFocusWithinListItem(17);
                    break;
                }
                case 22: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.handleHorizontalFocusWithinListItem(66);
                    break;
                }
                case 23: 
                case 66: {
                    if (!event.hasNoModifiers() || (handled = this.resurrectSelectionIfNeeded()) || event.getRepeatCount() != 0 || this.getChildCount() <= 0) break;
                    this.keyPressed();
                    handled = true;
                    break;
                }
                case 62: {
                    if (this.mPopup != null && this.mPopup.isShowing()) break;
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(130);
                    } else if (event.hasModifiers(1)) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(33);
                    }
                    handled = true;
                    break;
                }
                case 92: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(33);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 93: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(130);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 122: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 123: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
            }
        }
        if (handled) {
            return true;
        }
        if (this.sendToTextFilter(keyCode, count, event)) {
            return true;
        }
        switch (action) {
            case 0: {
                return super.onKeyDown(keyCode, event);
            }
            case 1: {
                return super.onKeyUp(keyCode, event);
            }
            case 2: {
                return super.onKeyMultiple(keyCode, count, event);
            }
        }
        return false;
    }

    boolean pageScroll(int direction) {
        int position;
        int nextPage = -1;
        boolean down = false;
        if (direction == 33) {
            nextPage = Math.max(0, this.mSelectedPosition - this.getChildCount() - 1);
        } else if (direction == 130) {
            nextPage = Math.min(this.mItemCount - 1, this.mSelectedPosition + this.getChildCount() - 1);
            down = true;
        }
        if (nextPage >= 0 && (position = this.lookForSelectablePosition(nextPage, down)) >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificTop = this.mPaddingTop + this.getVerticalFadingEdgeLength();
            if (down && position > this.mItemCount - this.getChildCount()) {
                this.mLayoutMode = 3;
            }
            if (!down && position < this.getChildCount()) {
                this.mLayoutMode = 1;
            }
            this.setSelectionInt(position);
            this.invokeOnItemScrollListener();
            if (!this.awakenScrollBars()) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    boolean fullScroll(int direction) {
        boolean moved = false;
        if (direction == 33) {
            if (this.mSelectedPosition != 0) {
                int position = this.lookForSelectablePosition(0, true);
                if (position >= 0) {
                    this.mLayoutMode = 1;
                    this.setSelectionInt(position);
                    this.invokeOnItemScrollListener();
                }
                moved = true;
            }
        } else if (direction == 130 && this.mSelectedPosition < this.mItemCount - 1) {
            int position = this.lookForSelectablePosition(this.mItemCount - 1, true);
            if (position >= 0) {
                this.mLayoutMode = 3;
                this.setSelectionInt(position);
                this.invokeOnItemScrollListener();
            }
            moved = true;
        }
        if (moved && !this.awakenScrollBars()) {
            this.awakenScrollBars();
            this.invalidate();
        }
        return moved;
    }

    private boolean handleHorizontalFocusWithinListItem(int direction) {
        View selectedView;
        if (direction != 17 && direction != 66) {
            throw new IllegalArgumentException("direction must be one of {View.FOCUS_LEFT, View.FOCUS_RIGHT}");
        }
        int numChildren = this.getChildCount();
        if (this.mItemsCanFocus && numChildren > 0 && this.mSelectedPosition != -1 && (selectedView = this.getSelectedView()) != null && selectedView.hasFocus() && selectedView instanceof ViewGroup) {
            View globalNextFocus;
            View currentFocus = selectedView.findFocus();
            View nextFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)selectedView, currentFocus, direction);
            if (nextFocus != null) {
                currentFocus.getFocusedRect(this.mTempRect);
                this.offsetDescendantRectToMyCoords(currentFocus, this.mTempRect);
                this.offsetRectIntoDescendantCoords(nextFocus, this.mTempRect);
                if (nextFocus.requestFocus(direction, this.mTempRect)) {
                    return true;
                }
            }
            if ((globalNextFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)this.getRootView(), currentFocus, direction)) != null) {
                return this.isViewAncestorOf(globalNextFocus, this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean arrowScroll(int direction) {
        try {
            this.mInLayout = true;
            boolean handled = this.arrowScrollImpl(direction);
            if (handled) {
                this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
            }
            boolean bl = handled;
            return bl;
        }
        finally {
            this.mInLayout = false;
        }
    }

    private boolean arrowScrollImpl(int direction) {
        View focused;
        boolean needToRedraw;
        ArrowScrollFocusResult focusResult;
        if (this.getChildCount() <= 0) {
            return false;
        }
        View selectedView = this.getSelectedView();
        int selectedPos = this.mSelectedPosition;
        int nextSelectedPosition = this.lookForSelectablePositionOnScreen(direction);
        int amountToScroll = this.amountToScroll(direction, nextSelectedPosition);
        ArrowScrollFocusResult arrowScrollFocusResult = focusResult = this.mItemsCanFocus ? this.arrowScrollFocused(direction) : null;
        if (focusResult != null) {
            nextSelectedPosition = focusResult.getSelectedPosition();
            amountToScroll = focusResult.getAmountToScroll();
        }
        boolean bl = needToRedraw = focusResult != null;
        if (nextSelectedPosition != -1) {
            this.handleNewSelectionChange(selectedView, direction, nextSelectedPosition, focusResult != null);
            this.setSelectedPositionInt(nextSelectedPosition);
            this.setNextSelectedPositionInt(nextSelectedPosition);
            selectedView = this.getSelectedView();
            selectedPos = nextSelectedPosition;
            if (this.mItemsCanFocus && focusResult == null && (focused = this.getFocusedChild()) != null) {
                focused.clearFocus();
            }
            needToRedraw = true;
            this.checkSelectionChanged();
        }
        if (amountToScroll > 0) {
            this.scrollListItemsBy(direction == 33 ? amountToScroll : -amountToScroll);
            needToRedraw = true;
        }
        if (this.mItemsCanFocus && focusResult == null && selectedView != null && selectedView.hasFocus() && (!this.isViewAncestorOf(focused = selectedView.findFocus(), this) || this.distanceToView(focused) > 0)) {
            focused.clearFocus();
        }
        if (nextSelectedPosition == -1 && selectedView != null && !this.isViewAncestorOf(selectedView, this)) {
            selectedView = null;
            this.hideSelector();
            this.mResurrectToPosition = -1;
        }
        if (needToRedraw) {
            if (selectedView != null) {
                this.positionSelector(selectedPos, selectedView);
                this.mSelectedTop = selectedView.getTop();
            }
            if (!this.awakenScrollBars()) {
                this.invalidate();
            }
            this.invokeOnItemScrollListener();
            return true;
        }
        return false;
    }

    private void handleNewSelectionChange(View selectedView, int direction, int newSelectedPosition, boolean newFocusAssigned) {
        View bottomView;
        View topView;
        int bottomViewIndex;
        int topViewIndex;
        if (newSelectedPosition == -1) {
            throw new IllegalArgumentException("newSelectedPosition needs to be valid");
        }
        boolean topSelected = false;
        int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
        int nextSelectedIndex = newSelectedPosition - this.mFirstPosition;
        if (direction == 33) {
            topViewIndex = nextSelectedIndex;
            bottomViewIndex = selectedIndex;
            topView = this.getChildAt(topViewIndex);
            bottomView = selectedView;
            topSelected = true;
        } else {
            topViewIndex = selectedIndex;
            bottomViewIndex = nextSelectedIndex;
            topView = selectedView;
            bottomView = this.getChildAt(bottomViewIndex);
        }
        int numChildren = this.getChildCount();
        if (topView != null) {
            topView.setSelected(!newFocusAssigned && topSelected);
            this.measureAndAdjustDown(topView, topViewIndex, numChildren);
        }
        if (bottomView != null) {
            bottomView.setSelected(!newFocusAssigned && !topSelected);
            this.measureAndAdjustDown(bottomView, bottomViewIndex, numChildren);
        }
    }

    private void measureAndAdjustDown(View child, int childIndex, int numChildren) {
        int oldHeight = child.getHeight();
        this.measureItem(child);
        if (child.getMeasuredHeight() != oldHeight) {
            this.relayoutMeasuredItem(child);
            int heightDelta = child.getMeasuredHeight() - oldHeight;
            for (int i = childIndex + 1; i < numChildren; ++i) {
                this.getChildAt(i).offsetTopAndBottom(heightDelta);
            }
        }
    }

    private void measureItem(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mListPadding.left + this.mListPadding.right, p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec(lpHeight, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private void relayoutMeasuredItem(View child) {
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int childLeft = this.mListPadding.left;
        int childRight = childLeft + w;
        int childTop = child.getTop();
        int childBottom = childTop + h;
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private int getArrowScrollPreviewLength() {
        return Math.max(2, this.getVerticalFadingEdgeLength());
    }

    private int amountToScroll(int direction, int nextSelectedPosition) {
        int listBottom = this.getHeight() - this.mListPadding.bottom;
        int listTop = this.mListPadding.top;
        int numChildren = this.getChildCount();
        if (direction == 130) {
            int indexToMakeVisible = numChildren - 1;
            if (nextSelectedPosition != -1) {
                indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
            }
            int positionToMakeVisible = this.mFirstPosition + indexToMakeVisible;
            View viewToMakeVisible = this.getChildAt(indexToMakeVisible);
            int goalBottom = listBottom;
            if (positionToMakeVisible < this.mItemCount - 1) {
                goalBottom -= this.getArrowScrollPreviewLength();
            }
            if (viewToMakeVisible.getBottom() <= goalBottom) {
                return 0;
            }
            if (nextSelectedPosition != -1 && goalBottom - viewToMakeVisible.getTop() >= this.getMaxScrollAmount()) {
                return 0;
            }
            int amountToScroll = viewToMakeVisible.getBottom() - goalBottom;
            if (this.mFirstPosition + numChildren == this.mItemCount) {
                int max = this.getChildAt(numChildren - 1).getBottom() - listBottom;
                amountToScroll = Math.min(amountToScroll, max);
            }
            return Math.min(amountToScroll, this.getMaxScrollAmount());
        }
        int indexToMakeVisible = 0;
        if (nextSelectedPosition != -1) {
            indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
        }
        int positionToMakeVisible = this.mFirstPosition + indexToMakeVisible;
        View viewToMakeVisible = this.getChildAt(indexToMakeVisible);
        int goalTop = listTop;
        if (positionToMakeVisible > 0) {
            goalTop += this.getArrowScrollPreviewLength();
        }
        if (viewToMakeVisible.getTop() >= goalTop) {
            return 0;
        }
        if (nextSelectedPosition != -1 && viewToMakeVisible.getBottom() - goalTop >= this.getMaxScrollAmount()) {
            return 0;
        }
        int amountToScroll = goalTop - viewToMakeVisible.getTop();
        if (this.mFirstPosition == 0) {
            int max = listTop - this.getChildAt(0).getTop();
            amountToScroll = Math.min(amountToScroll, max);
        }
        return Math.min(amountToScroll, this.getMaxScrollAmount());
    }

    private int lookForSelectablePositionOnScreen(int direction) {
        int firstPosition = this.mFirstPosition;
        if (direction == 130) {
            int startPos;
            int n = startPos = this.mSelectedPosition != -1 ? this.mSelectedPosition + 1 : firstPosition;
            if (startPos >= this.mAdapter.getCount()) {
                return -1;
            }
            if (startPos < firstPosition) {
                startPos = firstPosition;
            }
            int lastVisiblePos = this.getLastVisiblePosition();
            ListAdapter adapter = this.getAdapter();
            for (int pos = startPos; pos <= lastVisiblePos; ++pos) {
                if (!adapter.isEnabled(pos) || this.getChildAt(pos - firstPosition).getVisibility() != 0) continue;
                return pos;
            }
        } else {
            int startPos;
            int last = firstPosition + this.getChildCount() - 1;
            int n = startPos = this.mSelectedPosition != -1 ? this.mSelectedPosition - 1 : firstPosition + this.getChildCount() - 1;
            if (startPos < 0 || startPos >= this.mAdapter.getCount()) {
                return -1;
            }
            if (startPos > last) {
                startPos = last;
            }
            ListAdapter adapter = this.getAdapter();
            for (int pos = startPos; pos >= firstPosition; --pos) {
                if (!adapter.isEnabled(pos) || this.getChildAt(pos - firstPosition).getVisibility() != 0) continue;
                return pos;
            }
        }
        return -1;
    }

    private ArrowScrollFocusResult arrowScrollFocused(int direction) {
        View newFocus;
        View selectedView = this.getSelectedView();
        if (selectedView != null && selectedView.hasFocus()) {
            View oldFocus = selectedView.findFocus();
            newFocus = FocusFinder.getInstance().findNextFocus(this, oldFocus, direction);
        } else {
            int ySearchPoint;
            if (direction == 130) {
                boolean topFadingEdgeShowing = this.mFirstPosition > 0;
                int listTop = this.mListPadding.top + (topFadingEdgeShowing ? this.getArrowScrollPreviewLength() : 0);
                ySearchPoint = selectedView != null && selectedView.getTop() > listTop ? selectedView.getTop() : listTop;
                this.mTempRect.set(0, ySearchPoint, 0, ySearchPoint);
            } else {
                boolean bottomFadingEdgeShowing = this.mFirstPosition + this.getChildCount() - 1 < this.mItemCount;
                int listBottom = this.getHeight() - this.mListPadding.bottom - (bottomFadingEdgeShowing ? this.getArrowScrollPreviewLength() : 0);
                ySearchPoint = selectedView != null && selectedView.getBottom() < listBottom ? selectedView.getBottom() : listBottom;
                this.mTempRect.set(0, ySearchPoint, 0, ySearchPoint);
            }
            newFocus = FocusFinder.getInstance().findNextFocusFromRect(this, this.mTempRect, direction);
        }
        if (newFocus != null) {
            int maxScrollAmount;
            int selectablePosition;
            int positionOfNewFocus = this.positionOfNewFocus(newFocus);
            if (this.mSelectedPosition != -1 && positionOfNewFocus != this.mSelectedPosition && (selectablePosition = this.lookForSelectablePositionOnScreen(direction)) != -1 && (direction == 130 && selectablePosition < positionOfNewFocus || direction == 33 && selectablePosition > positionOfNewFocus)) {
                return null;
            }
            int focusScroll = this.amountToScrollToNewFocus(direction, newFocus, positionOfNewFocus);
            if (focusScroll < (maxScrollAmount = this.getMaxScrollAmount())) {
                newFocus.requestFocus(direction);
                this.mArrowScrollFocusResult.populate(positionOfNewFocus, focusScroll);
                return this.mArrowScrollFocusResult;
            }
            if (this.distanceToView(newFocus) < maxScrollAmount) {
                newFocus.requestFocus(direction);
                this.mArrowScrollFocusResult.populate(positionOfNewFocus, maxScrollAmount);
                return this.mArrowScrollFocusResult;
            }
        }
        return null;
    }

    private int positionOfNewFocus(View newFocus) {
        int numChildren = this.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            View child = this.getChildAt(i);
            if (!this.isViewAncestorOf(newFocus, child)) continue;
            return this.mFirstPosition + i;
        }
        throw new IllegalArgumentException("newFocus is not a child of any of the children of the list!");
    }

    private boolean isViewAncestorOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && this.isViewAncestorOf((View)((Object)theParent), parent);
    }

    private int amountToScrollToNewFocus(int direction, View newFocus, int positionOfNewFocus) {
        int amountToScroll = 0;
        newFocus.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(newFocus, this.mTempRect);
        if (direction == 33) {
            if (this.mTempRect.top < this.mListPadding.top) {
                amountToScroll = this.mListPadding.top - this.mTempRect.top;
                if (positionOfNewFocus > 0) {
                    amountToScroll += this.getArrowScrollPreviewLength();
                }
            }
        } else {
            int listBottom = this.getHeight() - this.mListPadding.bottom;
            if (this.mTempRect.bottom > listBottom) {
                amountToScroll = this.mTempRect.bottom - listBottom;
                if (positionOfNewFocus < this.mItemCount - 1) {
                    amountToScroll += this.getArrowScrollPreviewLength();
                }
            }
        }
        return amountToScroll;
    }

    private int distanceToView(View descendant) {
        int distance = 0;
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        int listBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
        if (this.mTempRect.bottom < this.mListPadding.top) {
            distance = this.mListPadding.top - this.mTempRect.bottom;
        } else if (this.mTempRect.top > listBottom) {
            distance = this.mTempRect.top - listBottom;
        }
        return distance;
    }

    private void scrollListItemsBy(int amount) {
        this.offsetChildrenTopAndBottom(amount);
        int listBottom = this.getHeight() - this.mListPadding.bottom;
        int listTop = this.mListPadding.top;
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        if (amount < 0) {
            int lastVisiblePosition;
            int numChildren = this.getChildCount();
            View last = this.getChildAt(numChildren - 1);
            while (last.getBottom() < listBottom && (lastVisiblePosition = this.mFirstPosition + numChildren - 1) < this.mItemCount - 1) {
                last = this.addViewBelow(last, lastVisiblePosition);
                ++numChildren;
            }
            if (last.getBottom() < listBottom) {
                this.offsetChildrenTopAndBottom(listBottom - last.getBottom());
            }
            View first = this.getChildAt(0);
            while (first.getBottom() < listTop) {
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)first.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(first);
                    recycleBin.addScrapView(first, this.mFirstPosition);
                } else {
                    this.removeViewInLayout(first);
                }
                first = this.getChildAt(0);
                ++this.mFirstPosition;
            }
        } else {
            View first = this.getChildAt(0);
            while (first.getTop() > listTop && this.mFirstPosition > 0) {
                first = this.addViewAbove(first, this.mFirstPosition);
                --this.mFirstPosition;
            }
            if (first.getTop() > listTop) {
                this.offsetChildrenTopAndBottom(listTop - first.getTop());
            }
            int lastIndex = this.getChildCount() - 1;
            View last = this.getChildAt(lastIndex);
            while (last.getTop() > listBottom) {
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)last.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(last);
                    recycleBin.addScrapView(last, this.mFirstPosition + lastIndex);
                } else {
                    this.removeViewInLayout(last);
                }
                last = this.getChildAt(--lastIndex);
            }
        }
    }

    private View addViewAbove(View theView, int position) {
        int abovePosition = position - 1;
        View view = this.obtainView(abovePosition, this.mIsScrap);
        int edgeOfNewChild = theView.getTop() - this.mDividerHeight;
        this.setupChild(view, abovePosition, edgeOfNewChild, false, this.mListPadding.left, false, this.mIsScrap[0]);
        return view;
    }

    private View addViewBelow(View theView, int position) {
        int belowPosition = position + 1;
        View view = this.obtainView(belowPosition, this.mIsScrap);
        int edgeOfNewChild = theView.getBottom() + this.mDividerHeight;
        this.setupChild(view, belowPosition, edgeOfNewChild, true, this.mListPadding.left, false, this.mIsScrap[0]);
        return view;
    }

    public void setItemsCanFocus(boolean itemsCanFocus) {
        this.mItemsCanFocus = itemsCanFocus;
        if (!itemsCanFocus) {
            this.setDescendantFocusability(393216);
        }
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    @Override
    public boolean isOpaque() {
        boolean retValue;
        boolean bl = retValue = this.mCachingActive && this.mIsCacheColorOpaque && this.mDividerIsOpaque && this.hasOpaqueScrollbars() || super.isOpaque();
        if (retValue) {
            int listTop = this.mListPadding != null ? this.mListPadding.top : this.mPaddingTop;
            View first = this.getChildAt(0);
            if (first == null || first.getTop() > listTop) {
                return false;
            }
            int listBottom = this.getHeight() - (this.mListPadding != null ? this.mListPadding.bottom : this.mPaddingBottom);
            View last = this.getChildAt(this.getChildCount() - 1);
            if (last == null || last.getBottom() < listBottom) {
                return false;
            }
        }
        return retValue;
    }

    @Override
    public void setCacheColorHint(int color2) {
        boolean opaque;
        this.mIsCacheColorOpaque = opaque = color2 >>> 24 == 255;
        if (opaque) {
            if (this.mDividerPaint == null) {
                this.mDividerPaint = new Paint();
            }
            this.mDividerPaint.setColor(color2);
        }
        super.setCacheColorHint(color2);
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable2, Rect bounds) {
        int height = drawable2.getMinimumHeight();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.bottom - bounds.top;
        if (span < height) {
            bounds.top = bounds.bottom - height;
        }
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        canvas.restore();
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable2, Rect bounds) {
        int height = drawable2.getMinimumHeight();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.bottom - bounds.top;
        if (span < height) {
            bounds.bottom = bounds.top + height;
        }
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        canvas.restore();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean drawDividers;
        if (this.mCachingStarted) {
            this.mCachingActive = true;
        }
        int dividerHeight = this.mDividerHeight;
        Drawable overscrollHeader = this.mOverScrollHeader;
        Drawable overscrollFooter = this.mOverScrollFooter;
        boolean drawOverscrollHeader = overscrollHeader != null;
        boolean drawOverscrollFooter = overscrollFooter != null;
        boolean bl = drawDividers = dividerHeight > 0 && this.mDivider != null;
        if (drawDividers || drawOverscrollHeader || drawOverscrollFooter) {
            boolean fillForMissingDividers;
            Rect bounds = this.mTempRect;
            bounds.left = this.mPaddingLeft;
            bounds.right = this.mRight - this.mLeft - this.mPaddingRight;
            int count = this.getChildCount();
            int headerCount = this.mHeaderViewInfos.size();
            int itemCount = this.mItemCount;
            int footerLimit = itemCount - this.mFooterViewInfos.size() - 1;
            boolean headerDividers = this.mHeaderDividersEnabled;
            boolean footerDividers = this.mFooterDividersEnabled;
            int first = this.mFirstPosition;
            boolean areAllItemsSelectable = this.mAreAllItemsSelectable;
            ListAdapter adapter = this.mAdapter;
            boolean bl2 = fillForMissingDividers = this.isOpaque() && !super.isOpaque();
            if (fillForMissingDividers && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                this.mDividerPaint = new Paint();
                this.mDividerPaint.setColor(this.getCacheColorHint());
            }
            Paint paint = this.mDividerPaint;
            int effectivePaddingTop = 0;
            int effectivePaddingBottom = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                effectivePaddingTop = this.mListPadding.top;
                effectivePaddingBottom = this.mListPadding.bottom;
            }
            int listBottom = this.mBottom - this.mTop - effectivePaddingBottom + this.mScrollY;
            if (!this.mStackFromBottom) {
                int bottom = 0;
                int scrollY = this.mScrollY;
                if (count > 0 && scrollY < 0) {
                    if (drawOverscrollHeader) {
                        bounds.bottom = 0;
                        bounds.top = scrollY;
                        this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                    } else if (drawDividers) {
                        bounds.bottom = 0;
                        bounds.top = -dividerHeight;
                        this.drawDivider(canvas, bounds, -1);
                    }
                }
                for (int i = 0; i < count; ++i) {
                    if (!headerDividers && first + i < headerCount || !footerDividers && first + i >= footerLimit) continue;
                    View child = this.getChildAt(i);
                    bottom = child.getBottom();
                    if (!drawDividers || bottom >= listBottom || drawOverscrollFooter && i == count - 1) continue;
                    if (areAllItemsSelectable || adapter.isEnabled(first + i) && (i == count - 1 || adapter.isEnabled(first + i + 1))) {
                        bounds.top = bottom;
                        bounds.bottom = bottom + dividerHeight;
                        this.drawDivider(canvas, bounds, i);
                        continue;
                    }
                    if (!fillForMissingDividers) continue;
                    bounds.top = bottom;
                    bounds.bottom = bottom + dividerHeight;
                    canvas.drawRect(bounds, paint);
                }
                int overFooterBottom = this.mBottom + this.mScrollY;
                if (drawOverscrollFooter && first + count == itemCount && overFooterBottom > bottom) {
                    bounds.top = bottom;
                    bounds.bottom = overFooterBottom;
                    this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                }
            } else {
                int start;
                int scrollY = this.mScrollY;
                if (count > 0 && drawOverscrollHeader) {
                    bounds.top = scrollY;
                    bounds.bottom = this.getChildAt(0).getTop();
                    this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                }
                for (int i = start = drawOverscrollHeader ? 1 : 0; i < count; ++i) {
                    View child;
                    int top;
                    if (!headerDividers && first + i < headerCount || !footerDividers && first + i >= footerLimit || (top = (child = this.getChildAt(i)).getTop()) <= effectivePaddingTop) continue;
                    if (areAllItemsSelectable || adapter.isEnabled(first + i) && (i == count - 1 || adapter.isEnabled(first + i + 1))) {
                        bounds.top = top - dividerHeight;
                        bounds.bottom = top;
                        this.drawDivider(canvas, bounds, i - 1);
                        continue;
                    }
                    if (!fillForMissingDividers) continue;
                    bounds.top = top - dividerHeight;
                    bounds.bottom = top;
                    canvas.drawRect(bounds, paint);
                }
                if (count > 0 && scrollY > 0) {
                    if (drawOverscrollFooter) {
                        int absListBottom;
                        bounds.top = absListBottom = this.mBottom;
                        bounds.bottom = absListBottom + scrollY;
                        this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                    } else if (drawDividers) {
                        bounds.top = listBottom;
                        bounds.bottom = listBottom + dividerHeight;
                        this.drawDivider(canvas, bounds, -1);
                    }
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean more = super.drawChild(canvas, child, drawingTime);
        if (this.mCachingActive && child.mCachingFailed) {
            this.mCachingActive = false;
        }
        return more;
    }

    void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        Drawable divider = this.mDivider;
        divider.setBounds(bounds);
        divider.draw(canvas);
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDivider(Drawable divider) {
        this.mDividerHeight = divider != null ? divider.getIntrinsicHeight() : 0;
        this.mDivider = divider;
        this.mDividerIsOpaque = divider == null || divider.getOpacity() == -1;
        this.requestLayout();
        this.invalidate();
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    public void setDividerHeight(int height) {
        this.mDividerHeight = height;
        this.requestLayout();
        this.invalidate();
    }

    public void setHeaderDividersEnabled(boolean headerDividersEnabled) {
        this.mHeaderDividersEnabled = headerDividersEnabled;
        this.invalidate();
    }

    public void setFooterDividersEnabled(boolean footerDividersEnabled) {
        this.mFooterDividersEnabled = footerDividersEnabled;
        this.invalidate();
    }

    public void setOverscrollHeader(Drawable header) {
        this.mOverScrollHeader = header;
        if (this.mScrollY < 0) {
            this.invalidate();
        }
    }

    public Drawable getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    public void setOverscrollFooter(Drawable footer) {
        this.mOverScrollFooter = footer;
        this.invalidate();
    }

    public Drawable getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        ListAdapter adapter = this.mAdapter;
        int closetChildIndex = -1;
        int closestChildTop = 0;
        if (adapter != null && gainFocus && previouslyFocusedRect != null) {
            previouslyFocusedRect.offset(this.mScrollX, this.mScrollY);
            if (adapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect otherRect = this.mTempRect;
            int minDistance = Integer.MAX_VALUE;
            int childCount = this.getChildCount();
            int firstPosition = this.mFirstPosition;
            for (int i = 0; i < childCount; ++i) {
                if (!adapter.isEnabled(firstPosition + i)) continue;
                View other = this.getChildAt(i);
                other.getDrawingRect(otherRect);
                this.offsetDescendantRectToMyCoords(other, otherRect);
                int distance = ListView.getDistance(previouslyFocusedRect, otherRect, direction);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closetChildIndex = i;
                closestChildTop = other.getTop();
            }
        }
        if (closetChildIndex >= 0) {
            this.setSelectionFromTop(closetChildIndex + this.mFirstPosition, closestChildTop);
        } else {
            this.requestLayout();
        }
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.addHeaderView(this.getChildAt(i));
            }
            this.removeAllViews();
        }
    }

    @Override
    protected View findViewTraversal(int id2) {
        View v = super.findViewTraversal(id2);
        if (v == null) {
            v = this.findViewInHeadersOrFooters(this.mHeaderViewInfos, id2);
            if (v != null) {
                return v;
            }
            v = this.findViewInHeadersOrFooters(this.mFooterViewInfos, id2);
            if (v != null) {
                return v;
            }
        }
        return v;
    }

    View findViewInHeadersOrFooters(ArrayList<FixedViewInfo> where, int id2) {
        if (where != null) {
            int len = where.size();
            for (int i = 0; i < len; ++i) {
                View v = where.get((int)i).view;
                if (v.isRootNamespace() || (v = v.findViewById(id2)) == null) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    protected View findViewWithTagTraversal(Object tag) {
        View v = super.findViewWithTagTraversal(tag);
        if (v == null) {
            v = this.findViewWithTagInHeadersOrFooters(this.mHeaderViewInfos, tag);
            if (v != null) {
                return v;
            }
            v = this.findViewWithTagInHeadersOrFooters(this.mFooterViewInfos, tag);
            if (v != null) {
                return v;
            }
        }
        return v;
    }

    View findViewWithTagInHeadersOrFooters(ArrayList<FixedViewInfo> where, Object tag) {
        if (where != null) {
            int len = where.size();
            for (int i = 0; i < len; ++i) {
                View v = where.get((int)i).view;
                if (v.isRootNamespace() || (v = v.findViewWithTag(tag)) == null) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    protected View findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        View v = super.findViewByPredicateTraversal(predicate, childToSkip);
        if (v == null) {
            v = this.findViewByPredicateInHeadersOrFooters(this.mHeaderViewInfos, predicate, childToSkip);
            if (v != null) {
                return v;
            }
            v = this.findViewByPredicateInHeadersOrFooters(this.mFooterViewInfos, predicate, childToSkip);
            if (v != null) {
                return v;
            }
        }
        return v;
    }

    View findViewByPredicateInHeadersOrFooters(ArrayList<FixedViewInfo> where, Predicate<View> predicate, View childToSkip) {
        if (where != null) {
            int len = where.size();
            for (int i = 0; i < len; ++i) {
                View v = where.get((int)i).view;
                if (v == childToSkip || v.isRootNamespace() || (v = v.findViewByPredicate(predicate)) == null) continue;
                return v;
            }
        }
        return null;
    }

    @Deprecated
    public long[] getCheckItemIds() {
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            return this.getCheckedItemIds();
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null && this.mAdapter != null) {
            SparseBooleanArray states = this.mCheckStates;
            int count = states.size();
            long[] ids = new long[count];
            ListAdapter adapter = this.mAdapter;
            int checkedCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!states.valueAt(i)) continue;
                ids[checkedCount++] = adapter.getItemId(states.keyAt(i));
            }
            if (checkedCount == count) {
                return ids;
            }
            long[] result = new long[checkedCount];
            System.arraycopy(ids, 0, result, 0, checkedCount);
            return result;
        }
        return new long[0];
    }

    private static class ArrowScrollFocusResult {
        private int mSelectedPosition;
        private int mAmountToScroll;

        private ArrowScrollFocusResult() {
        }

        void populate(int selectedPosition, int amountToScroll) {
            this.mSelectedPosition = selectedPosition;
            this.mAmountToScroll = amountToScroll;
        }

        public int getSelectedPosition() {
            return this.mSelectedPosition;
        }

        public int getAmountToScroll() {
            return this.mAmountToScroll;
        }
    }

    private class FocusSelector
    implements Runnable {
        private int mPosition;
        private int mPositionTop;

        private FocusSelector() {
        }

        public FocusSelector setup(int position, int top) {
            this.mPosition = position;
            this.mPositionTop = top;
            return this;
        }

        public void run() {
            ListView.this.setSelectionFromTop(this.mPosition, this.mPositionTop);
        }
    }

    public class FixedViewInfo {
        public View view;
        public Object data;
        public boolean isSelectable;
    }
}

