/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.BoringLayout;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.AllCapsTransformationMethod;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.BaseKeyListener;
import android.text.method.DateKeyListener;
import android.text.method.DateTimeKeyListener;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.LinkMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TextKeyListener;
import android.text.method.TimeKeyListener;
import android.text.method.TransformationMethod;
import android.text.method.TransformationMethod2;
import android.text.method.WordIterator;
import android.text.style.ClickableSpan;
import android.text.style.EasyEditSpan;
import android.text.style.ParagraphStyle;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.text.style.UpdateAppearance;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.FloatMath;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.SpellCheckerSubtype;
import android.view.textservice.TextServicesManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RemoteViews;
import android.widget.Scroller;
import android.widget.SpellChecker;
import com.android.internal.R;
import com.android.internal.util.FastMath;
import com.android.internal.widget.EditableInputConnection;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RemoteViews.RemoteView
public class TextView
extends View
implements ViewTreeObserver.OnPreDrawListener {
    static final String LOG_TAG = "TextView";
    static final boolean DEBUG_EXTRACT = false;
    private static final int PRIORITY = 100;
    private int mCurrentAlpha = 255;
    final int[] mTempCoords = new int[2];
    Rect mTempRect;
    private ColorStateList mTextColor;
    private int mCurTextColor;
    private ColorStateList mHintTextColor;
    private ColorStateList mLinkTextColor;
    private int mCurHintTextColor;
    private boolean mFreezesText;
    private boolean mFrozenWithFocus;
    private boolean mTemporaryDetach;
    private boolean mDispatchTemporaryDetach;
    private boolean mDiscardNextActionUp = false;
    private boolean mIgnoreActionUpEvent = false;
    private Editable.Factory mEditableFactory = Editable.Factory.getInstance();
    private Spannable.Factory mSpannableFactory = Spannable.Factory.getInstance();
    private float mShadowRadius;
    private float mShadowDx;
    private float mShadowDy;
    private static final int PREDRAW_NOT_REGISTERED = 0;
    private static final int PREDRAW_PENDING = 1;
    private static final int PREDRAW_DONE = 2;
    private int mPreDrawState = 0;
    private TextUtils.TruncateAt mEllipsize = null;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private static final int SIGNED = 2;
    private static final int DECIMAL = 4;
    private Drawables mDrawables;
    private CharSequence mError;
    private boolean mErrorWasChanged;
    private ErrorPopup mPopup;
    private boolean mShowErrorAfterAttach;
    private CharWrapper mCharWrapper = null;
    private boolean mSelectionMoved = false;
    private boolean mTouchFocusSelected = false;
    private Marquee mMarquee;
    private boolean mRestartMarquee;
    private int mMarqueeRepeatLimit = 3;
    InputContentType mInputContentType;
    InputMethodState mInputMethodState;
    private int mTextSelectHandleLeftRes;
    private int mTextSelectHandleRightRes;
    private int mTextSelectHandleRes;
    private int mTextEditSuggestionItemLayout;
    private SuggestionsPopupWindow mSuggestionsPopupWindow;
    private SuggestionRangeSpan mSuggestionRangeSpan;
    private int mCursorDrawableRes;
    private final Drawable[] mCursorDrawable = new Drawable[2];
    private int mCursorCount;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    private Drawable mSelectHandleCenter;
    private PositionListener mPositionListener;
    private float mLastDownPositionX;
    private float mLastDownPositionY;
    private ActionMode.Callback mCustomSelectionActionModeCallback;
    private final int mSquaredTouchSlopDistance;
    private boolean mCreatedWithASelection = false;
    private WordIterator mWordIterator;
    private SpellChecker mSpellChecker;
    private boolean mSoftInputShownOnFocus = true;
    private Layout.Alignment mLayoutAlignment;
    private TextAlign mTextAlign = TextAlign.INHERIT;
    private boolean mResolvedDrawables = false;
    private int mMarqueeFadeMode = 0;
    private Layout mSavedMarqueeModeLayout;
    private static final int MARQUEE_FADE_NORMAL = 0;
    private static final int MARQUEE_FADE_SWITCH_SHOW_ELLIPSIS = 1;
    private static final int MARQUEE_FADE_SWITCH_SHOW_FADE = 2;
    static final int EXTRACT_NOTHING = -2;
    static final int EXTRACT_UNKNOWN = -1;
    private static final BoringLayout.Metrics UNKNOWN_BORING;
    private static final int ID_SELECT_ALL = 16908319;
    private static final int ID_CUT = 0x1020020;
    private static final int ID_COPY = 0x1020021;
    private static final int ID_PASTE = 0x1020022;
    @ViewDebug.ExportedProperty(category="text")
    private CharSequence mText = "";
    private CharSequence mTransformed;
    private BufferType mBufferType = BufferType.NORMAL;
    private int mInputType = 0;
    private CharSequence mHint;
    private Layout mHintLayout;
    private KeyListener mInput;
    private MovementMethod mMovement;
    private TransformationMethod mTransformation;
    private boolean mAllowTransformationLengthChange;
    private ChangeWatcher mChangeWatcher;
    private ArrayList<TextWatcher> mListeners = null;
    private final TextPaint mTextPaint;
    private boolean mUserSetTextScaleX;
    private final Paint mHighlightPaint;
    private int mHighlightColor = 1714664933;
    protected Layout mLayout;
    private long mShowCursor;
    private Blink mBlink;
    private boolean mCursorVisible = true;
    private InsertionPointCursorController mInsertionPointCursorController;
    private SelectionModifierCursorController mSelectionModifierCursorController;
    private ActionMode mSelectionActionMode;
    private boolean mInsertionControllerEnabled;
    private boolean mSelectionControllerEnabled;
    private boolean mInBatchEditControllers;
    private boolean mSelectAllOnFocus = false;
    private int mGravity = 0x800033;
    private boolean mHorizontallyScrolling;
    private int mAutoLinkMask;
    private boolean mLinksClickable = true;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private boolean mTextIsSelectable = false;
    private static final int LINES = 1;
    private static final int EMS = 1;
    private static final int PIXELS = 2;
    private int mMaximum = Integer.MAX_VALUE;
    private int mMaxMode = 1;
    private int mMinimum = 0;
    private int mMinMode = 1;
    private int mOldMaximum = this.mMaximum;
    private int mOldMaxMode = this.mMaxMode;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxWidthMode = 2;
    private int mMinWidth = 0;
    private int mMinWidthMode = 2;
    private boolean mSingleLine;
    private int mDesiredHeightAtMeasure = -1;
    private boolean mIncludePad = true;
    private Path mHighlightPath;
    private boolean mHighlightPathBogus = true;
    private static final RectF sTempRect;
    private static final float[] sTmpPosition;
    private static final int VERY_WIDE = 0x100000;
    private static final int BLINK = 500;
    private static final int ANIMATED_SCROLL_GAP = 250;
    private long mLastScroll;
    private Scroller mScroller = null;
    private BoringLayout.Metrics mBoring;
    private BoringLayout.Metrics mHintBoring;
    private BoringLayout mSavedLayout;
    private BoringLayout mSavedHintLayout;
    private TextDirectionHeuristic mTextDir = null;
    private static final InputFilter[] NO_FILTERS;
    private InputFilter[] mFilters = NO_FILTERS;
    private static final Spanned EMPTY_SPANNED;
    private static int DRAG_SHADOW_MAX_TEXT_LENGTH;
    private static long sLastCutOrCopyTime;
    private CorrectionHighlighter mCorrectionHighlighter;
    private static final int[] MULTILINE_STATE_SET;

    public TextView(Context context) {
        this(context, null);
    }

    public TextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        boolean focusable;
        boolean numberPasswordInputType;
        Resources res = this.getResources();
        CompatibilityInfo compat = res.getCompatibilityInfo();
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(compat.applicationScale);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setCompatibilityScaling(compat.applicationScale);
        this.mMovement = this.getDefaultMovementMethod();
        this.mTransformation = null;
        int textColorHighlight = 0;
        ColorStateList textColor = null;
        ColorStateList textColorHint = null;
        ColorStateList textColorLink = null;
        int textSize = 15;
        int typefaceIndex = -1;
        int styleIndex = -1;
        boolean allCaps = false;
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.TextViewAppearance, defStyle, 0);
        TypedArray appearance = null;
        int ap = a.getResourceId(0, -1);
        a.recycle();
        if (ap != -1) {
            appearance = theme.obtainStyledAttributes(ap, R.styleable.TextAppearance);
        }
        if (appearance != null) {
            int n = appearance.getIndexCount();
            block113: for (int i = 0; i < n; ++i) {
                int attr2 = appearance.getIndex(i);
                switch (attr2) {
                    case 4: {
                        textColorHighlight = appearance.getColor(attr2, textColorHighlight);
                        continue block113;
                    }
                    case 3: {
                        textColor = appearance.getColorStateList(attr2);
                        continue block113;
                    }
                    case 5: {
                        textColorHint = appearance.getColorStateList(attr2);
                        continue block113;
                    }
                    case 6: {
                        textColorLink = appearance.getColorStateList(attr2);
                        continue block113;
                    }
                    case 0: {
                        textSize = appearance.getDimensionPixelSize(attr2, textSize);
                        continue block113;
                    }
                    case 1: {
                        typefaceIndex = appearance.getInt(attr2, -1);
                        continue block113;
                    }
                    case 2: {
                        styleIndex = appearance.getInt(attr2, -1);
                        continue block113;
                    }
                    case 7: {
                        allCaps = appearance.getBoolean(attr2, false);
                    }
                }
            }
            appearance.recycle();
        }
        boolean editable = this.getDefaultEditable();
        CharSequence inputMethod = null;
        int numeric = 0;
        CharSequence digits = null;
        boolean phone = false;
        boolean autotext = false;
        int autocap = -1;
        int buffertype = 0;
        boolean selectallonfocus = false;
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        int drawablePadding = 0;
        int ellipsize = -1;
        boolean singleLine = false;
        int maxlength = -1;
        CharSequence text = "";
        CharSequence hint = null;
        int shadowcolor = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float r = 0.0f;
        boolean password = false;
        int inputType = 0;
        a = theme.obtainStyledAttributes(attrs, R.styleable.TextView, defStyle, 0);
        int n = a.getIndexCount();
        block114: for (int i = 0; i < n; ++i) {
            int attr3 = a.getIndex(i);
            switch (attr3) {
                case 46: {
                    editable = a.getBoolean(attr3, editable);
                    continue block114;
                }
                case 43: {
                    inputMethod = a.getText(attr3);
                    continue block114;
                }
                case 40: {
                    numeric = a.getInt(attr3, numeric);
                    continue block114;
                }
                case 41: {
                    digits = a.getText(attr3);
                    continue block114;
                }
                case 42: {
                    phone = a.getBoolean(attr3, phone);
                    continue block114;
                }
                case 45: {
                    autotext = a.getBoolean(attr3, autotext);
                    continue block114;
                }
                case 44: {
                    autocap = a.getInt(attr3, autocap);
                    continue block114;
                }
                case 17: {
                    buffertype = a.getInt(attr3, buffertype);
                    continue block114;
                }
                case 33: {
                    selectallonfocus = a.getBoolean(attr3, selectallonfocus);
                    continue block114;
                }
                case 11: {
                    this.mAutoLinkMask = a.getInt(attr3, 0);
                    continue block114;
                }
                case 12: {
                    this.mLinksClickable = a.getBoolean(attr3, true);
                    continue block114;
                }
                case 50: {
                    drawableLeft = a.getDrawable(attr3);
                    continue block114;
                }
                case 48: {
                    drawableTop = a.getDrawable(attr3);
                    continue block114;
                }
                case 51: {
                    drawableRight = a.getDrawable(attr3);
                    continue block114;
                }
                case 49: {
                    drawableBottom = a.getDrawable(attr3);
                    continue block114;
                }
                case 73: {
                    drawableStart = a.getDrawable(attr3);
                    continue block114;
                }
                case 74: {
                    drawableEnd = a.getDrawable(attr3);
                    continue block114;
                }
                case 52: {
                    drawablePadding = a.getDimensionPixelSize(attr3, drawablePadding);
                    continue block114;
                }
                case 22: {
                    this.setMaxLines(a.getInt(attr3, -1));
                    continue block114;
                }
                case 14: {
                    this.setMaxHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block114;
                }
                case 23: {
                    this.setLines(a.getInt(attr3, -1));
                    continue block114;
                }
                case 24: {
                    this.setHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block114;
                }
                case 25: {
                    this.setMinLines(a.getInt(attr3, -1));
                    continue block114;
                }
                case 16: {
                    this.setMinHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block114;
                }
                case 26: {
                    this.setMaxEms(a.getInt(attr3, -1));
                    continue block114;
                }
                case 13: {
                    this.setMaxWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block114;
                }
                case 27: {
                    this.setEms(a.getInt(attr3, -1));
                    continue block114;
                }
                case 28: {
                    this.setWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block114;
                }
                case 29: {
                    this.setMinEms(a.getInt(attr3, -1));
                    continue block114;
                }
                case 15: {
                    this.setMinWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block114;
                }
                case 10: {
                    this.setGravity(a.getInt(attr3, -1));
                    continue block114;
                }
                case 19: {
                    hint = a.getText(attr3);
                    continue block114;
                }
                case 18: {
                    text = a.getText(attr3);
                    continue block114;
                }
                case 30: {
                    if (!a.getBoolean(attr3, false)) continue block114;
                    this.setHorizontallyScrolling(true);
                    continue block114;
                }
                case 32: {
                    singleLine = a.getBoolean(attr3, singleLine);
                    continue block114;
                }
                case 9: {
                    ellipsize = a.getInt(attr3, ellipsize);
                    continue block114;
                }
                case 55: {
                    this.setMarqueeRepeatLimit(a.getInt(attr3, this.mMarqueeRepeatLimit));
                    continue block114;
                }
                case 34: {
                    if (a.getBoolean(attr3, true)) continue block114;
                    this.setIncludeFontPadding(false);
                    continue block114;
                }
                case 21: {
                    if (a.getBoolean(attr3, true)) continue block114;
                    this.setCursorVisible(false);
                    continue block114;
                }
                case 35: {
                    maxlength = a.getInt(attr3, -1);
                    continue block114;
                }
                case 20: {
                    this.setTextScaleX(a.getFloat(attr3, 1.0f));
                    continue block114;
                }
                case 47: {
                    this.mFreezesText = a.getBoolean(attr3, false);
                    continue block114;
                }
                case 36: {
                    shadowcolor = a.getInt(attr3, 0);
                    continue block114;
                }
                case 37: {
                    dx = a.getFloat(attr3, 0.0f);
                    continue block114;
                }
                case 38: {
                    dy = a.getFloat(attr3, 0.0f);
                    continue block114;
                }
                case 39: {
                    r = a.getFloat(attr3, 0.0f);
                    continue block114;
                }
                case 0: {
                    this.setEnabled(a.getBoolean(attr3, this.isEnabled()));
                    continue block114;
                }
                case 6: {
                    textColorHighlight = a.getColor(attr3, textColorHighlight);
                    continue block114;
                }
                case 5: {
                    textColor = a.getColorStateList(attr3);
                    continue block114;
                }
                case 7: {
                    textColorHint = a.getColorStateList(attr3);
                    continue block114;
                }
                case 8: {
                    textColorLink = a.getColorStateList(attr3);
                    continue block114;
                }
                case 2: {
                    textSize = a.getDimensionPixelSize(attr3, textSize);
                    continue block114;
                }
                case 3: {
                    typefaceIndex = a.getInt(attr3, typefaceIndex);
                    continue block114;
                }
                case 4: {
                    styleIndex = a.getInt(attr3, styleIndex);
                    continue block114;
                }
                case 31: {
                    password = a.getBoolean(attr3, password);
                    continue block114;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr3, (int)this.mSpacingAdd);
                    continue block114;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr3, this.mSpacingMult);
                    continue block114;
                }
                case 56: {
                    inputType = a.getInt(attr3, this.mInputType);
                    continue block114;
                }
                case 59: {
                    if (this.mInputContentType == null) {
                        this.mInputContentType = new InputContentType();
                    }
                    this.mInputContentType.imeOptions = a.getInt(attr3, this.mInputContentType.imeOptions);
                    continue block114;
                }
                case 60: {
                    if (this.mInputContentType == null) {
                        this.mInputContentType = new InputContentType();
                    }
                    this.mInputContentType.imeActionLabel = a.getText(attr3);
                    continue block114;
                }
                case 61: {
                    if (this.mInputContentType == null) {
                        this.mInputContentType = new InputContentType();
                    }
                    this.mInputContentType.imeActionId = a.getInt(attr3, this.mInputContentType.imeActionId);
                    continue block114;
                }
                case 57: {
                    this.setPrivateImeOptions(a.getString(attr3));
                    continue block114;
                }
                case 58: {
                    try {
                        this.setInputExtras(a.getResourceId(attr3, 0));
                    }
                    catch (XmlPullParserException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    catch (IOException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    continue block114;
                }
                case 70: {
                    this.mCursorDrawableRes = a.getResourceId(attr3, 0);
                    continue block114;
                }
                case 62: {
                    this.mTextSelectHandleLeftRes = a.getResourceId(attr3, 0);
                    continue block114;
                }
                case 63: {
                    this.mTextSelectHandleRightRes = a.getResourceId(attr3, 0);
                    continue block114;
                }
                case 64: {
                    this.mTextSelectHandleRes = a.getResourceId(attr3, 0);
                    continue block114;
                }
                case 71: {
                    this.mTextEditSuggestionItemLayout = a.getResourceId(attr3, 0);
                    continue block114;
                }
                case 67: {
                    this.mTextIsSelectable = a.getBoolean(attr3, false);
                    continue block114;
                }
                case 72: {
                    allCaps = a.getBoolean(attr3, false);
                }
            }
        }
        a.recycle();
        BufferType bufferType = BufferType.EDITABLE;
        int variation = inputType & 0xFFF;
        boolean passwordInputType = variation == 129;
        boolean webPasswordInputType = variation == 225;
        boolean bl = numberPasswordInputType = variation == 18;
        if (inputMethod != null) {
            Class<?> c;
            try {
                c = Class.forName(((Object)inputMethod).toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mInput = (KeyListener)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mInputType = inputType != 0 ? inputType : this.mInput.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mInputType = 1;
            }
        } else if (digits != null) {
            this.mInput = DigitsKeyListener.getInstance(((Object)digits).toString());
            this.mInputType = inputType != 0 ? inputType : 1;
        } else if (inputType != 0) {
            this.setInputType(inputType, true);
            singleLine = !TextView.isMultilineInputType(inputType);
        } else if (phone) {
            this.mInput = DialerKeyListener.getInstance();
            inputType = 3;
            this.mInputType = 3;
        } else if (numeric != 0) {
            this.mInput = DigitsKeyListener.getInstance((numeric & 2) != 0, (numeric & 4) != 0);
            inputType = 2;
            if ((numeric & 2) != 0) {
                inputType |= 0x1000;
            }
            if ((numeric & 4) != 0) {
                inputType |= 0x2000;
            }
            this.mInputType = inputType;
        } else if (autotext || autocap != -1) {
            TextKeyListener.Capitalize cap;
            inputType = 1;
            switch (autocap) {
                case 1: {
                    cap = TextKeyListener.Capitalize.SENTENCES;
                    inputType |= 0x4000;
                    break;
                }
                case 2: {
                    cap = TextKeyListener.Capitalize.WORDS;
                    inputType |= 0x2000;
                    break;
                }
                case 3: {
                    cap = TextKeyListener.Capitalize.CHARACTERS;
                    inputType |= 0x1000;
                    break;
                }
                default: {
                    cap = TextKeyListener.Capitalize.NONE;
                }
            }
            this.mInput = TextKeyListener.getInstance(autotext, cap);
            this.mInputType = inputType;
        } else if (this.mTextIsSelectable) {
            this.mInputType = 0;
            this.mInput = null;
            bufferType = BufferType.SPANNABLE;
            this.setFocusableInTouchMode(true);
            this.setMovementMethod(ArrowKeyMovementMethod.getInstance());
        } else if (editable) {
            this.mInput = TextKeyListener.getInstance();
            this.mInputType = 1;
        } else {
            this.mInput = null;
            switch (buffertype) {
                case 0: {
                    bufferType = BufferType.NORMAL;
                    break;
                }
                case 1: {
                    bufferType = BufferType.SPANNABLE;
                    break;
                }
                case 2: {
                    bufferType = BufferType.EDITABLE;
                }
            }
        }
        if ((this.mInputType & 0xF) == 1) {
            if (password || passwordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0x80;
            }
            if (webPasswordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0xE0;
            }
        } else if ((this.mInputType & 0xF) == 2 && numberPasswordInputType) {
            this.mInputType = this.mInputType & 0xFFFFF00F | 0x10;
        }
        if (selectallonfocus) {
            this.mSelectAllOnFocus = true;
            if (bufferType == BufferType.NORMAL) {
                bufferType = BufferType.SPANNABLE;
            }
        }
        this.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        this.setRelativeDrawablesIfNeeded(drawableStart, drawableEnd);
        this.setCompoundDrawablePadding(drawablePadding);
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, singleLine, singleLine);
        if (singleLine && this.mInput == null && ellipsize < 0) {
            ellipsize = 3;
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                if (ViewConfiguration.get(context).isFadingMarqueeEnabled()) {
                    this.setHorizontalFadingEdgeEnabled(true);
                    this.mMarqueeFadeMode = 0;
                } else {
                    this.setHorizontalFadingEdgeEnabled(false);
                    this.mMarqueeFadeMode = 1;
                }
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        this.setTextColor(textColor != null ? textColor : ColorStateList.valueOf(-16777216));
        this.setHintTextColor(textColorHint);
        this.setLinkTextColor(textColorLink);
        if (textColorHighlight != 0) {
            this.setHighlightColor(textColorHighlight);
        }
        this.setRawTextSize(textSize);
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        if (password || passwordInputType || webPasswordInputType || numberPasswordInputType) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            typefaceIndex = 3;
        } else if ((this.mInputType & 0xFFF) == 129) {
            typefaceIndex = 3;
        }
        this.setTypefaceByIndex(typefaceIndex, styleIndex);
        if (shadowcolor != 0) {
            this.setShadowLayer(r, dx, dy, shadowcolor);
        }
        if (maxlength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxlength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
        this.setText(text, bufferType);
        if (hint != null) {
            this.setHint(hint);
        }
        a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        boolean clickable = focusable = this.mMovement != null || this.mInput != null;
        boolean longClickable = focusable;
        n = a.getIndexCount();
        block115: for (int i = 0; i < n; ++i) {
            int attr4 = a.getIndex(i);
            switch (attr4) {
                case 18: {
                    focusable = a.getBoolean(attr4, focusable);
                    continue block115;
                }
                case 29: {
                    clickable = a.getBoolean(attr4, clickable);
                    continue block115;
                }
                case 30: {
                    longClickable = a.getBoolean(attr4, longClickable);
                }
            }
        }
        a.recycle();
        this.setFocusable(focusable);
        this.setClickable(clickable);
        this.setLongClickable(longClickable);
        this.prepareCursorControllers();
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        int touchSlop = viewConfiguration.getScaledTouchSlop();
        this.mSquaredTouchSlopDistance = touchSlop * touchSlop;
    }

    private void setTypefaceByIndex(int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    private void setRelativeDrawablesIfNeeded(Drawable start, Drawable end) {
        boolean hasRelativeDrawables;
        boolean bl = hasRelativeDrawables = start != null || end != null;
        if (hasRelativeDrawables) {
            Drawables dr = this.mDrawables;
            if (dr == null) {
                this.mDrawables = dr = new Drawables();
            }
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableStart = start;
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableEnd = end;
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        InputMethodManager imm;
        if (enabled == this.isEnabled()) {
            return;
        }
        if (!enabled && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this)) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        super.setEnabled(enabled);
        this.prepareCursorControllers();
        if (enabled && (imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
        this.makeBlink();
    }

    public void setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    protected boolean getDefaultEditable() {
        return false;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getText() {
        return this.mText;
    }

    public int length() {
        return this.mText.length();
    }

    public Editable getEditableText() {
        return this.mText instanceof Editable ? (Editable)this.mText : null;
    }

    public int getLineHeight() {
        return FastMath.round((float)this.mTextPaint.getFontMetricsInt(null) * this.mSpacingMult + this.mSpacingAdd);
    }

    public final Layout getLayout() {
        return this.mLayout;
    }

    public final KeyListener getKeyListener() {
        return this.mInput;
    }

    public void setKeyListener(KeyListener input) {
        this.setKeyListenerOnly(input);
        this.fixFocusableAndClickableSettings();
        if (input != null) {
            try {
                this.mInputType = this.mInput.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mInputType = 1;
            }
            this.setInputTypeSingleLine(this.mSingleLine);
        } else {
            this.mInputType = 0;
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null) {
            imm.restartInput(this);
        }
    }

    private void setKeyListenerOnly(KeyListener input) {
        this.mInput = input;
        if (this.mInput != null && !(this.mText instanceof Editable)) {
            this.setText(this.mText);
        }
        this.setFilters((Editable)this.mText, this.mFilters);
    }

    public final MovementMethod getMovementMethod() {
        return this.mMovement;
    }

    public final void setMovementMethod(MovementMethod movement) {
        this.mMovement = movement;
        if (this.mMovement != null && !(this.mText instanceof Spannable)) {
            this.setText(this.mText);
        }
        this.fixFocusableAndClickableSettings();
        this.prepareCursorControllers();
    }

    private void fixFocusableAndClickableSettings() {
        if (this.mMovement != null || this.mInput != null) {
            this.setFocusable(true);
            this.setClickable(true);
            this.setLongClickable(true);
        } else {
            this.setFocusable(false);
            this.setClickable(false);
            this.setLongClickable(false);
        }
    }

    public final TransformationMethod getTransformationMethod() {
        return this.mTransformation;
    }

    public final void setTransformationMethod(TransformationMethod method) {
        if (method == this.mTransformation) {
            return;
        }
        if (this.mTransformation != null && this.mText instanceof Spannable) {
            ((Spannable)this.mText).removeSpan(this.mTransformation);
        }
        this.mTransformation = method;
        if (method instanceof TransformationMethod2) {
            TransformationMethod2 method2 = (TransformationMethod2)method;
            this.mAllowTransformationLengthChange = !this.mTextIsSelectable && !(this.mText instanceof Editable);
            method2.setLengthChangesAllowed(this.mAllowTransformationLengthChange);
        } else {
            this.mAllowTransformationLengthChange = false;
        }
        this.setText(this.mText);
    }

    public int getCompoundPaddingTop() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableTop == null) {
            return this.mPaddingTop;
        }
        return this.mPaddingTop + dr.mDrawablePadding + dr.mDrawableSizeTop;
    }

    public int getCompoundPaddingBottom() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableBottom == null) {
            return this.mPaddingBottom;
        }
        return this.mPaddingBottom + dr.mDrawablePadding + dr.mDrawableSizeBottom;
    }

    public int getCompoundPaddingLeft() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableLeft == null) {
            return this.mPaddingLeft;
        }
        return this.mPaddingLeft + dr.mDrawablePadding + dr.mDrawableSizeLeft;
    }

    public int getCompoundPaddingRight() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableRight == null) {
            return this.mPaddingRight;
        }
        return this.mPaddingRight + dr.mDrawablePadding + dr.mDrawableSizeRight;
    }

    public int getCompoundPaddingStart() {
        this.resolveDrawables();
        switch (this.getResolvedLayoutDirection()) {
            default: {
                return this.getCompoundPaddingLeft();
            }
            case 0x40000000: 
        }
        return this.getCompoundPaddingRight();
    }

    public int getCompoundPaddingEnd() {
        this.resolveDrawables();
        switch (this.getResolvedLayoutDirection()) {
            default: {
                return this.getCompoundPaddingRight();
            }
            case 0x40000000: 
        }
        return this.getCompoundPaddingLeft();
    }

    public int getExtendedPaddingTop() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingTop();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingTop();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return top;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return top;
        }
        if (gravity == 80) {
            return top + viewht - layoutht;
        }
        return top + (viewht - layoutht) / 2;
    }

    public int getExtendedPaddingBottom() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingBottom();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingBottom();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return bottom;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return bottom + viewht - layoutht;
        }
        if (gravity == 80) {
            return bottom;
        }
        return bottom + (viewht - layoutht) / 2;
    }

    public int getTotalPaddingLeft() {
        return this.getCompoundPaddingLeft();
    }

    public int getTotalPaddingRight() {
        return this.getCompoundPaddingRight();
    }

    public int getTotalPaddingStart() {
        return this.getCompoundPaddingStart();
    }

    public int getTotalPaddingEnd() {
        return this.getCompoundPaddingEnd();
    }

    public int getTotalPaddingTop() {
        return this.getExtendedPaddingTop() + this.getVerticalOffset(true);
    }

    public int getTotalPaddingBottom() {
        return this.getExtendedPaddingBottom() + this.getBottomVerticalOffset(true);
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        boolean bl = drawables = left != null || top != null || right != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (dr.mDrawablePadding == 0) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableLeft != null) {
                        dr.mDrawableLeft.setCallback(null);
                    }
                    dr.mDrawableLeft = null;
                    if (dr.mDrawableTop != null) {
                        dr.mDrawableTop.setCallback(null);
                    }
                    dr.mDrawableTop = null;
                    if (dr.mDrawableRight != null) {
                        dr.mDrawableRight.setCallback(null);
                    }
                    dr.mDrawableRight = null;
                    if (dr.mDrawableBottom != null) {
                        dr.mDrawableBottom.setCallback(null);
                    }
                    dr.mDrawableBottom = null;
                    dr.mDrawableHeightLeft = 0;
                    dr.mDrawableSizeLeft = 0;
                    dr.mDrawableHeightRight = 0;
                    dr.mDrawableSizeRight = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables();
            }
            if (dr.mDrawableLeft != left && dr.mDrawableLeft != null) {
                dr.mDrawableLeft.setCallback(null);
            }
            dr.mDrawableLeft = left;
            if (dr.mDrawableTop != top && dr.mDrawableTop != null) {
                dr.mDrawableTop.setCallback(null);
            }
            dr.mDrawableTop = top;
            if (dr.mDrawableRight != right && dr.mDrawableRight != null) {
                dr.mDrawableRight.setCallback(null);
            }
            dr.mDrawableRight = right;
            if (dr.mDrawableBottom != bottom && dr.mDrawableBottom != null) {
                dr.mDrawableBottom.setCallback(null);
            }
            dr.mDrawableBottom = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (left != null) {
                left.setState(state);
                left.copyBounds(compoundRect);
                left.setCallback(this);
                dr.mDrawableSizeLeft = compoundRect.width();
                dr.mDrawableHeightLeft = compoundRect.height();
            } else {
                dr.mDrawableHeightLeft = 0;
                dr.mDrawableSizeLeft = 0;
            }
            if (right != null) {
                right.setState(state);
                right.copyBounds(compoundRect);
                right.setCallback(this);
                dr.mDrawableSizeRight = compoundRect.width();
                dr.mDrawableHeightRight = compoundRect.height();
            } else {
                dr.mDrawableHeightRight = 0;
                dr.mDrawableSizeRight = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        Resources resources = this.getContext().getResources();
        this.setCompoundDrawablesWithIntrinsicBounds(left != 0 ? resources.getDrawable(left) : null, top != 0 ? resources.getDrawable(top) : null, right != 0 ? resources.getDrawable(right) : null, bottom != 0 ? resources.getDrawable(bottom) : null);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left.setBounds(0, 0, left.getIntrinsicWidth(), left.getIntrinsicHeight());
        }
        if (right != null) {
            right.setBounds(0, 0, right.getIntrinsicWidth(), right.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawables(left, top, right, bottom);
    }

    public void setCompoundDrawablesRelative(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        boolean bl = drawables = start != null || top != null || end != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (dr.mDrawablePadding == 0) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableStart != null) {
                        dr.mDrawableStart.setCallback(null);
                    }
                    dr.mDrawableStart = null;
                    if (dr.mDrawableTop != null) {
                        dr.mDrawableTop.setCallback(null);
                    }
                    dr.mDrawableTop = null;
                    if (dr.mDrawableEnd != null) {
                        dr.mDrawableEnd.setCallback(null);
                    }
                    dr.mDrawableEnd = null;
                    if (dr.mDrawableBottom != null) {
                        dr.mDrawableBottom.setCallback(null);
                    }
                    dr.mDrawableBottom = null;
                    dr.mDrawableHeightStart = 0;
                    dr.mDrawableSizeStart = 0;
                    dr.mDrawableHeightEnd = 0;
                    dr.mDrawableSizeEnd = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables();
            }
            if (dr.mDrawableStart != start && dr.mDrawableStart != null) {
                dr.mDrawableStart.setCallback(null);
            }
            dr.mDrawableStart = start;
            if (dr.mDrawableTop != top && dr.mDrawableTop != null) {
                dr.mDrawableTop.setCallback(null);
            }
            dr.mDrawableTop = top;
            if (dr.mDrawableEnd != end && dr.mDrawableEnd != null) {
                dr.mDrawableEnd.setCallback(null);
            }
            dr.mDrawableEnd = end;
            if (dr.mDrawableBottom != bottom && dr.mDrawableBottom != null) {
                dr.mDrawableBottom.setCallback(null);
            }
            dr.mDrawableBottom = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        this.resolveDrawables();
        this.invalidate();
        this.requestLayout();
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        this.resetResolvedDrawables();
        Resources resources = this.getContext().getResources();
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(start != 0 ? resources.getDrawable(start) : null, top != 0 ? resources.getDrawable(top) : null, end != 0 ? resources.getDrawable(end) : null, bottom != 0 ? resources.getDrawable(bottom) : null);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        this.resetResolvedDrawables();
        if (start != null) {
            start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
        }
        if (end != null) {
            end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawablesRelative(start, top, end, bottom);
    }

    public Drawable[] getCompoundDrawables() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableLeft, dr.mDrawableTop, dr.mDrawableRight, dr.mDrawableBottom};
        }
        return new Drawable[]{null, null, null, null};
    }

    public Drawable[] getCompoundDrawablesRelative() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableStart, dr.mDrawableTop, dr.mDrawableEnd, dr.mDrawableBottom};
        }
        return new Drawable[]{null, null, null, null};
    }

    public void setCompoundDrawablePadding(int pad) {
        Drawables dr = this.mDrawables;
        if (pad == 0) {
            if (dr != null) {
                dr.mDrawablePadding = pad;
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables();
            }
            dr.mDrawablePadding = pad;
        }
        this.invalidate();
        this.requestLayout();
    }

    public int getCompoundDrawablePadding() {
        Drawables dr = this.mDrawables;
        return dr != null ? dr.mDrawablePadding : 0;
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        if (left != this.mPaddingLeft || right != this.mPaddingRight || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPadding(left, top, right, bottom);
        this.invalidate();
    }

    public final int getAutoLinkMask() {
        return this.mAutoLinkMask;
    }

    public void setTextAppearance(Context context, int resid) {
        int ts;
        ColorStateList colors;
        TypedArray appearance = context.obtainStyledAttributes(resid, R.styleable.TextAppearance);
        int color2 = appearance.getColor(4, 0);
        if (color2 != 0) {
            this.setHighlightColor(color2);
        }
        if ((colors = appearance.getColorStateList(3)) != null) {
            this.setTextColor(colors);
        }
        if ((ts = appearance.getDimensionPixelSize(0, 0)) != 0) {
            this.setRawTextSize(ts);
        }
        if ((colors = appearance.getColorStateList(5)) != null) {
            this.setHintTextColor(colors);
        }
        if ((colors = appearance.getColorStateList(6)) != null) {
            this.setLinkTextColor(colors);
        }
        int typefaceIndex = appearance.getInt(1, -1);
        int styleIndex = appearance.getInt(2, -1);
        this.setTypefaceByIndex(typefaceIndex, styleIndex);
        if (appearance.getBoolean(7, false)) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        appearance.recycle();
    }

    public float getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    @RemotableViewMethod
    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        this.setRawTextSize(TypedValue.applyDimension(unit, size, r.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (size != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public float getTextScaleX() {
        return this.mTextPaint.getTextScaleX();
    }

    @RemotableViewMethod
    public void setTextScaleX(float size) {
        if (size != this.mTextPaint.getTextScaleX()) {
            this.mUserSetTextScaleX = true;
            this.mTextPaint.setTextScaleX(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public Typeface getTypeface() {
        return this.mTextPaint.getTypeface();
    }

    @RemotableViewMethod
    public void setTextColor(int color2) {
        this.mTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getTextColors() {
        return this.mTextColor;
    }

    public final int getCurrentTextColor() {
        return this.mCurTextColor;
    }

    @RemotableViewMethod
    public void setHighlightColor(int color2) {
        if (this.mHighlightColor != color2) {
            this.mHighlightColor = color2;
            this.invalidate();
        }
    }

    public void setShadowLayer(float radius, float dx, float dy, int color2) {
        this.mTextPaint.setShadowLayer(radius, dx, dy, color2);
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.invalidate();
    }

    public TextPaint getPaint() {
        return this.mTextPaint;
    }

    @RemotableViewMethod
    public final void setAutoLinkMask(int mask) {
        this.mAutoLinkMask = mask;
    }

    @RemotableViewMethod
    public final void setLinksClickable(boolean whether) {
        this.mLinksClickable = whether;
    }

    public final boolean getLinksClickable() {
        return this.mLinksClickable;
    }

    @RemotableViewMethod
    public final void setSoftInputShownOnFocus(boolean show) {
        this.mSoftInputShownOnFocus = show;
    }

    public final boolean getSoftInputShownOnFocus() {
        return this.mSoftInputShownOnFocus;
    }

    public URLSpan[] getUrls() {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpans(0, this.mText.length(), URLSpan.class);
        }
        return new URLSpan[0];
    }

    @RemotableViewMethod
    public final void setHintTextColor(int color2) {
        this.mHintTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public final void setHintTextColor(ColorStateList colors) {
        this.mHintTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getHintTextColors() {
        return this.mHintTextColor;
    }

    public final int getCurrentHintTextColor() {
        return this.mHintTextColor != null ? this.mCurHintTextColor : this.mCurTextColor;
    }

    @RemotableViewMethod
    public final void setLinkTextColor(int color2) {
        this.mLinkTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public final void setLinkTextColor(ColorStateList colors) {
        this.mLinkTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getLinkTextColors() {
        return this.mLinkTextColor;
    }

    public void setGravity(int gravity) {
        if ((gravity & 0x800007) == 0) {
            gravity |= 0x800003;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        boolean newLayout = false;
        if ((gravity & 0x800007) != (this.mGravity & 0x800007)) {
            newLayout = true;
        }
        if (gravity != this.mGravity) {
            this.invalidate();
            this.mLayoutAlignment = null;
        }
        this.mGravity = gravity;
        if (this.mLayout != null && newLayout) {
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), true);
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getPaintFlags() {
        return this.mTextPaint.getFlags();
    }

    @RemotableViewMethod
    public void setPaintFlags(int flags) {
        if (this.mTextPaint.getFlags() != flags) {
            this.mTextPaint.setFlags(flags);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setHorizontallyScrolling(boolean whether) {
        if (this.mHorizontallyScrolling != whether) {
            this.mHorizontallyScrolling = whether;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean getHorizontallyScrolling() {
        return this.mHorizontallyScrolling;
    }

    @RemotableViewMethod
    public void setMinLines(int minlines) {
        this.mMinimum = minlines;
        this.mMinMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinHeight(int minHeight) {
        this.mMinimum = minHeight;
        this.mMinMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxLines(int maxlines) {
        this.mMaximum = maxlines;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxHeight(int maxHeight) {
        this.mMaximum = maxHeight;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setLines(int lines) {
        this.mMaximum = this.mMinimum = lines;
        this.mMinMode = 1;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setHeight(int pixels) {
        this.mMaximum = this.mMinimum = pixels;
        this.mMinMode = 2;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinEms(int minems) {
        this.mMinWidth = minems;
        this.mMinWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinWidth(int minpixels) {
        this.mMinWidth = minpixels;
        this.mMinWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxEms(int maxems) {
        this.mMaxWidth = maxems;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxWidth(int maxpixels) {
        this.mMaxWidth = maxpixels;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setEms(int ems) {
        this.mMaxWidth = this.mMinWidth = ems;
        this.mMinWidthMode = 1;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setWidth(int pixels) {
        this.mMaxWidth = this.mMinWidth = pixels;
        this.mMinWidthMode = 2;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public void setLineSpacing(float add, float mult) {
        if (this.mSpacingAdd != add || this.mSpacingMult != mult) {
            this.mSpacingAdd = add;
            this.mSpacingMult = mult;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public final void append(CharSequence text) {
        this.append(text, 0, text.length());
    }

    public void append(CharSequence text, int start, int end) {
        if (!(this.mText instanceof Editable)) {
            this.setText(this.mText, BufferType.EDITABLE);
        }
        ((Editable)this.mText).append(text, start, end);
    }

    private void updateTextColors() {
        boolean inval = false;
        int color2 = this.mTextColor.getColorForState(this.getDrawableState(), 0);
        if (color2 != this.mCurTextColor) {
            this.mCurTextColor = color2;
            inval = true;
        }
        if (this.mLinkTextColor != null && (color2 = this.mLinkTextColor.getColorForState(this.getDrawableState(), 0)) != this.mTextPaint.linkColor) {
            this.mTextPaint.linkColor = color2;
            inval = true;
        }
        if (this.mHintTextColor != null && (color2 = this.mHintTextColor.getColorForState(this.getDrawableState(), 0)) != this.mCurHintTextColor && this.mText.length() == 0) {
            this.mCurHintTextColor = color2;
            inval = true;
        }
        if (inval) {
            this.invalidate();
        }
    }

    @Override
    protected void drawableStateChanged() {
        Drawables dr;
        super.drawableStateChanged();
        if (this.mTextColor != null && this.mTextColor.isStateful() || this.mHintTextColor != null && this.mHintTextColor.isStateful() || this.mLinkTextColor != null && this.mLinkTextColor.isStateful()) {
            this.updateTextColors();
        }
        if ((dr = this.mDrawables) != null) {
            int[] state = this.getDrawableState();
            if (dr.mDrawableTop != null && dr.mDrawableTop.isStateful()) {
                dr.mDrawableTop.setState(state);
            }
            if (dr.mDrawableBottom != null && dr.mDrawableBottom.isStateful()) {
                dr.mDrawableBottom.setState(state);
            }
            if (dr.mDrawableLeft != null && dr.mDrawableLeft.isStateful()) {
                dr.mDrawableLeft.setState(state);
            }
            if (dr.mDrawableRight != null && dr.mDrawableRight.isStateful()) {
                dr.mDrawableRight.setState(state);
            }
            if (dr.mDrawableStart != null && dr.mDrawableStart.isStateful()) {
                dr.mDrawableStart.setState(state);
            }
            if (dr.mDrawableEnd != null && dr.mDrawableEnd.isStateful()) {
                dr.mDrawableEnd.setState(state);
            }
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        boolean save = this.mFreezesText;
        int start = 0;
        int end = 0;
        if (this.mText != null) {
            start = this.getSelectionStart();
            end = this.getSelectionEnd();
            if (start >= 0 || end >= 0) {
                save = true;
            }
        }
        if (save) {
            SavedState ss = new SavedState(superState);
            ss.selStart = start;
            ss.selEnd = end;
            if (this.mText instanceof Spanned) {
                SpannableString sp = new SpannableString(this.mText);
                for (ChangeWatcher cw : sp.getSpans(0, sp.length(), ChangeWatcher.class)) {
                    sp.removeSpan(cw);
                }
                this.removeMisspelledSpans(sp);
                sp.removeSpan(this.mSuggestionRangeSpan);
                ss.text = sp;
            } else {
                ss.text = ((Object)this.mText).toString();
            }
            if (this.isFocused() && start >= 0 && end >= 0) {
                ss.frozenWithFocus = true;
            }
            ss.error = this.mError;
            return ss;
        }
        return superState;
    }

    void removeMisspelledSpans(Spannable spannable) {
        SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            int flags = suggestionSpans[i].getFlags();
            if ((flags & 1) == 0 || (flags & 2) == 0) continue;
            spannable.removeSpan(suggestionSpans[i]);
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.text != null) {
            this.setText(ss.text);
        }
        if (ss.selStart >= 0 && ss.selEnd >= 0 && this.mText instanceof Spannable) {
            int len = this.mText.length();
            if (ss.selStart > len || ss.selEnd > len) {
                String restored = "";
                if (ss.text != null) {
                    restored = "(restored) ";
                }
                Log.e(LOG_TAG, "Saved cursor position " + ss.selStart + "/" + ss.selEnd + " out of range for " + restored + "text " + this.mText);
            } else {
                Selection.setSelection((Spannable)this.mText, ss.selStart, ss.selEnd);
                if (ss.frozenWithFocus) {
                    this.mFrozenWithFocus = true;
                }
            }
        }
        if (ss.error != null) {
            final CharSequence error = ss.error;
            this.post(new Runnable(){

                public void run() {
                    TextView.this.setError(error);
                }
            });
        }
    }

    @RemotableViewMethod
    public void setFreezesText(boolean freezesText) {
        this.mFreezesText = freezesText;
    }

    public boolean getFreezesText() {
        return this.mFreezesText;
    }

    public final void setEditableFactory(Editable.Factory factory) {
        this.mEditableFactory = factory;
        this.setText(this.mText);
    }

    public final void setSpannableFactory(Spannable.Factory factory) {
        this.mSpannableFactory = factory;
        this.setText(this.mText);
    }

    @RemotableViewMethod
    public final void setText(CharSequence text) {
        this.setText(text, this.mBufferType);
    }

    @RemotableViewMethod
    public final void setTextKeepState(CharSequence text) {
        this.setTextKeepState(text, this.mBufferType);
    }

    public void setText(CharSequence text, BufferType type) {
        this.setText(text, type, true, 0);
        if (this.mCharWrapper != null) {
            CharWrapper.access$102(this.mCharWrapper, null);
        }
    }

    private void setText(CharSequence text, BufferType type, boolean notifyBefore, int oldlen) {
        Spannable s2;
        if (text == null) {
            text = "";
        }
        if (!this.isSuggestionsEnabled()) {
            text = this.removeSuggestionSpans(text);
        }
        if (!this.mUserSetTextScaleX) {
            this.mTextPaint.setTextScaleX(1.0f);
        }
        if (text instanceof Spanned && ((Spanned)text).getSpanStart((Object)TextUtils.TruncateAt.MARQUEE) >= 0) {
            if (ViewConfiguration.get(this.mContext).isFadingMarqueeEnabled()) {
                this.setHorizontalFadingEdgeEnabled(true);
                this.mMarqueeFadeMode = 0;
            } else {
                this.setHorizontalFadingEdgeEnabled(false);
                this.mMarqueeFadeMode = 1;
            }
            this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        }
        int n = this.mFilters.length;
        for (int i = 0; i < n; ++i) {
            CharSequence out = this.mFilters[i].filter(text, 0, text.length(), EMPTY_SPANNED, 0, 0);
            if (out == null) continue;
            text = out;
        }
        if (notifyBefore) {
            if (this.mText != null) {
                oldlen = this.mText.length();
                this.sendBeforeTextChanged(this.mText, 0, oldlen, text.length());
            } else {
                this.sendBeforeTextChanged("", 0, 0, text.length());
            }
        }
        boolean needEditableForNotification = false;
        if (this.mListeners != null && this.mListeners.size() != 0) {
            needEditableForNotification = true;
        }
        if (type == BufferType.EDITABLE || this.mInput != null || needEditableForNotification) {
            Editable t = this.mEditableFactory.newEditable(text);
            text = t;
            this.setFilters(t, this.mFilters);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.restartInput(this);
            }
        } else if (type == BufferType.SPANNABLE || this.mMovement != null) {
            text = this.mSpannableFactory.newSpannable(text);
        } else if (!(text instanceof CharWrapper)) {
            text = TextUtils.stringOrSpannedString(text);
        }
        if (this.mAutoLinkMask != 0 && Linkify.addLinks(s2 = type == BufferType.EDITABLE || text instanceof Spannable ? (Spannable)text : this.mSpannableFactory.newSpannable(text), this.mAutoLinkMask)) {
            text = s2;
            type = type == BufferType.EDITABLE ? BufferType.EDITABLE : BufferType.SPANNABLE;
            this.mText = text;
            if (this.mLinksClickable && !this.textCanBeSelected()) {
                this.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
        this.mBufferType = type;
        this.mText = text;
        this.mTransformed = this.mTransformation == null ? text : this.mTransformation.getTransformation(text, this);
        int textLength = text.length();
        if (text instanceof Spannable && !this.mAllowTransformationLengthChange) {
            Spannable sp = (Spannable)text;
            ChangeWatcher[] watchers = sp.getSpans(0, sp.length(), ChangeWatcher.class);
            int count = watchers.length;
            for (int i = 0; i < count; ++i) {
                sp.removeSpan(watchers[i]);
            }
            if (this.mChangeWatcher == null) {
                this.mChangeWatcher = new ChangeWatcher();
            }
            sp.setSpan(this.mChangeWatcher, 0, textLength, 6553618);
            if (this.mInput != null) {
                sp.setSpan(this.mInput, 0, textLength, 18);
            }
            if (this.mTransformation != null) {
                sp.setSpan(this.mTransformation, 0, textLength, 18);
            }
            if (this.mMovement != null) {
                this.mMovement.initialize(this, (Spannable)text);
                this.mSelectionMoved = false;
            }
        }
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        this.sendOnTextChanged(text, 0, oldlen, textLength);
        this.onTextChanged(text, 0, oldlen, textLength);
        if (needEditableForNotification) {
            this.sendAfterTextChanged((Editable)text);
        }
        this.prepareCursorControllers();
    }

    public final void setText(char[] text, int start, int len) {
        int oldlen = 0;
        if (start < 0 || len < 0 || start + len > text.length) {
            throw new IndexOutOfBoundsException(start + ", " + len);
        }
        if (this.mText != null) {
            oldlen = this.mText.length();
            this.sendBeforeTextChanged(this.mText, 0, oldlen, len);
        } else {
            this.sendBeforeTextChanged("", 0, 0, len);
        }
        if (this.mCharWrapper == null) {
            this.mCharWrapper = new CharWrapper(text, start, len);
        } else {
            this.mCharWrapper.set(text, start, len);
        }
        this.setText(this.mCharWrapper, this.mBufferType, false, oldlen);
    }

    public final void setTextKeepState(CharSequence text, BufferType type) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int len = text.length();
        this.setText(text, type);
        if ((start >= 0 || end >= 0) && this.mText instanceof Spannable) {
            Selection.setSelection((Spannable)this.mText, Math.max(0, Math.min(start, len)), Math.max(0, Math.min(end, len)));
        }
    }

    @RemotableViewMethod
    public final void setText(int resid) {
        this.setText(this.getContext().getResources().getText(resid));
    }

    public final void setText(int resid, BufferType type) {
        this.setText(this.getContext().getResources().getText(resid), type);
    }

    @RemotableViewMethod
    public final void setHint(CharSequence hint) {
        this.mHint = TextUtils.stringOrSpannedString(hint);
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        if (this.mText.length() == 0) {
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public final void setHint(int resid) {
        this.setHint(this.getContext().getResources().getText(resid));
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getHint() {
        return this.mHint;
    }

    private static boolean isMultilineInputType(int type) {
        return (type & 0x2000F) == 131073;
    }

    public void setInputType(int type) {
        InputMethodManager imm;
        boolean singleLine;
        boolean wasPassword = TextView.isPasswordInputType(this.mInputType);
        boolean wasVisiblePassword = TextView.isVisiblePasswordInputType(this.mInputType);
        this.setInputType(type, false);
        boolean isPassword = TextView.isPasswordInputType(type);
        boolean isVisiblePassword = TextView.isVisiblePasswordInputType(type);
        boolean forceUpdate = false;
        if (isPassword) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            this.setTypefaceByIndex(3, 0);
        } else if (isVisiblePassword) {
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
            this.setTypefaceByIndex(3, 0);
        } else if (wasPassword || wasVisiblePassword) {
            this.setTypefaceByIndex(-1, -1);
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
        }
        boolean bl = singleLine = !TextView.isMultilineInputType(type);
        if (this.mSingleLine != singleLine || forceUpdate) {
            this.applySingleLine(singleLine, !isPassword, true);
        }
        if (!this.isSuggestionsEnabled()) {
            this.mText = this.removeSuggestionSpans(this.mText);
        }
        if ((imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
    }

    private boolean hasPasswordTransformationMethod() {
        return this.mTransformation instanceof PasswordTransformationMethod;
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static boolean isVisiblePasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 145;
    }

    public void setRawInputType(int type) {
        this.mInputType = type;
    }

    private void setInputType(int type, boolean direct) {
        BaseKeyListener input;
        int cls = type & 0xF;
        if (cls == 1) {
            boolean autotext;
            boolean bl = autotext = (type & 0x8000) != 0;
            TextKeyListener.Capitalize cap = (type & 0x1000) != 0 ? TextKeyListener.Capitalize.CHARACTERS : ((type & 0x2000) != 0 ? TextKeyListener.Capitalize.WORDS : ((type & 0x4000) != 0 ? TextKeyListener.Capitalize.SENTENCES : TextKeyListener.Capitalize.NONE));
            input = TextKeyListener.getInstance(autotext, cap);
        } else if (cls == 2) {
            input = DigitsKeyListener.getInstance((type & 0x1000) != 0, (type & 0x2000) != 0);
        } else if (cls == 4) {
            switch (type & 0xFF0) {
                case 16: {
                    input = DateKeyListener.getInstance();
                    break;
                }
                case 32: {
                    input = TimeKeyListener.getInstance();
                    break;
                }
                default: {
                    input = DateTimeKeyListener.getInstance();
                    break;
                }
            }
        } else {
            input = cls == 3 ? DialerKeyListener.getInstance() : TextKeyListener.getInstance();
        }
        this.setRawInputType(type);
        if (direct) {
            this.mInput = input;
        } else {
            this.setKeyListenerOnly(input);
        }
    }

    public int getInputType() {
        return this.mInputType;
    }

    public void setImeOptions(int imeOptions) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.imeOptions = imeOptions;
    }

    public int getImeOptions() {
        return this.mInputContentType != null ? this.mInputContentType.imeOptions : 0;
    }

    public void setImeActionLabel(CharSequence label, int actionId) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.imeActionLabel = label;
        this.mInputContentType.imeActionId = actionId;
    }

    public CharSequence getImeActionLabel() {
        return this.mInputContentType != null ? this.mInputContentType.imeActionLabel : null;
    }

    public int getImeActionId() {
        return this.mInputContentType != null ? this.mInputContentType.imeActionId : 0;
    }

    public void setOnEditorActionListener(OnEditorActionListener l) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.onEditorActionListener = l;
    }

    public void onEditorAction(int actionCode) {
        Handler h;
        InputContentType ict = this.mInputContentType;
        if (ict != null) {
            if (ict.onEditorActionListener != null && ict.onEditorActionListener.onEditorAction(this, actionCode, null)) {
                return;
            }
            if (actionCode == 5) {
                View v = this.focusSearch(2);
                if (v != null && !v.requestFocus(2)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 7) {
                View v = this.focusSearch(1);
                if (v != null && !v.requestFocus(1)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 6) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm != null && imm.isActive(this)) {
                    imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                }
                return;
            }
        }
        if ((h = this.getHandler()) != null) {
            long eventTime = SystemClock.uptimeMillis();
            h.sendMessage(h.obtainMessage(1011, new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22)));
            h.sendMessage(h.obtainMessage(1011, new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22)));
        }
    }

    public void setPrivateImeOptions(String type) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.privateImeOptions = type;
    }

    public String getPrivateImeOptions() {
        return this.mInputContentType != null ? this.mInputContentType.privateImeOptions : null;
    }

    public void setInputExtras(int xmlResId) throws XmlPullParserException, IOException {
        XmlResourceParser parser = this.getResources().getXml(xmlResId);
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.extras = new Bundle();
        this.getResources().parseBundleExtras(parser, this.mInputContentType.extras);
    }

    public Bundle getInputExtras(boolean create) {
        if (this.mInputContentType == null) {
            if (!create) {
                return null;
            }
            this.mInputContentType = new InputContentType();
        }
        if (this.mInputContentType.extras == null) {
            if (!create) {
                return null;
            }
            this.mInputContentType.extras = new Bundle();
        }
        return this.mInputContentType.extras;
    }

    public CharSequence getError() {
        return this.mError;
    }

    @RemotableViewMethod
    public void setError(CharSequence error) {
        if (error == null) {
            this.setError(null, null);
        } else {
            Drawable dr = this.getContext().getResources().getDrawable(17302368);
            dr.setBounds(0, 0, dr.getIntrinsicWidth(), dr.getIntrinsicHeight());
            this.setError(error, dr);
        }
    }

    public void setError(CharSequence error, Drawable icon) {
        this.mError = error = TextUtils.stringOrSpannedString(error);
        this.mErrorWasChanged = true;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            switch (this.getResolvedLayoutDirection()) {
                default: {
                    this.setCompoundDrawables(dr.mDrawableLeft, dr.mDrawableTop, icon, dr.mDrawableBottom);
                    break;
                }
                case 0x40000000: {
                    this.setCompoundDrawables(icon, dr.mDrawableTop, dr.mDrawableRight, dr.mDrawableBottom);
                    break;
                }
            }
        } else {
            this.setCompoundDrawables(null, null, icon, null);
        }
        if (error == null) {
            if (this.mPopup != null) {
                if (this.mPopup.isShowing()) {
                    this.mPopup.dismiss();
                }
                this.mPopup = null;
            }
        } else if (this.isFocused()) {
            this.showError();
        }
    }

    private void showError() {
        if (this.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mPopup == null) {
            LayoutInflater inflater = LayoutInflater.from(this.getContext());
            TextView err = (TextView)inflater.inflate(17367207, null);
            float scale = this.getResources().getDisplayMetrics().density;
            this.mPopup = new ErrorPopup(err, (int)(200.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f));
            this.mPopup.setFocusable(false);
            this.mPopup.setInputMethodMode(1);
        }
        TextView tv = (TextView)this.mPopup.getContentView();
        this.chooseSize(this.mPopup, this.mError, tv);
        tv.setText(this.mError);
        this.mPopup.showAsDropDown(this, this.getErrorX(), this.getErrorY());
        this.mPopup.fixDirection(this.mPopup.isAboveAnchor());
    }

    private int getErrorX() {
        float scale = this.getResources().getDisplayMetrics().density;
        Drawables dr = this.mDrawables;
        return this.getWidth() - this.mPopup.getWidth() - this.getPaddingRight() - (dr != null ? dr.mDrawableSizeRight : 0) / 2 + (int)(25.0f * scale + 0.5f);
    }

    private int getErrorY() {
        int compoundPaddingTop = this.getCompoundPaddingTop();
        int vspace = this.mBottom - this.mTop - this.getCompoundPaddingBottom() - compoundPaddingTop;
        Drawables dr = this.mDrawables;
        int icontop = compoundPaddingTop + (vspace - (dr != null ? dr.mDrawableHeightRight : 0)) / 2;
        float scale = this.getResources().getDisplayMetrics().density;
        return icontop + (dr != null ? dr.mDrawableHeightRight : 0) - this.getHeight() - (int)(2.0f * scale + 0.5f);
    }

    private void hideError() {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    private void chooseSize(PopupWindow pop, CharSequence text, TextView tv) {
        int wid = tv.getPaddingLeft() + tv.getPaddingRight();
        int ht = tv.getPaddingTop() + tv.getPaddingBottom();
        int defaultWidthInPixels = this.getResources().getDimensionPixelSize(17104963);
        StaticLayout l = new StaticLayout(text, tv.getPaint(), defaultWidthInPixels, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        float max = 0.0f;
        for (int i = 0; i < ((Layout)l).getLineCount(); ++i) {
            max = Math.max(max, l.getLineWidth(i));
        }
        pop.setWidth(wid + (int)Math.ceil(max));
        pop.setHeight(ht + l.getHeight());
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.mPopup != null) {
            TextView tv = (TextView)this.mPopup.getContentView();
            this.chooseSize(this.mPopup, this.mError, tv);
            this.mPopup.update(this, this.getErrorX(), this.getErrorY(), this.mPopup.getWidth(), this.mPopup.getHeight());
        }
        this.restartMarqueeIfNeeded();
        return result;
    }

    private void restartMarqueeIfNeeded() {
        if (this.mRestartMarquee && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mRestartMarquee = false;
            this.startMarquee();
        }
    }

    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
        if (this.mText instanceof Editable) {
            this.setFilters((Editable)this.mText, filters);
        }
    }

    private void setFilters(Editable e, InputFilter[] filters) {
        if (this.mInput instanceof InputFilter) {
            InputFilter[] nf = new InputFilter[filters.length + 1];
            System.arraycopy(filters, 0, nf, 0, filters.length);
            nf[filters.length] = (InputFilter)((Object)this.mInput);
            e.setFilters(nf);
        } else {
            e.setFilters(filters);
        }
    }

    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    private int getVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 48) {
            int boxht = l == this.mHintLayout ? this.getMeasuredHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom() : this.getMeasuredHeight() - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 80 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    private int getBottomVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 80) {
            int boxht = l == this.mHintLayout ? this.getMeasuredHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom() : this.getMeasuredHeight() - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 48 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCursorPath() {
        if (this.mHighlightPathBogus) {
            this.invalidateCursor();
        } else {
            int horizontalPadding = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (this.mCursorCount == 0) {
                RectF rectF = sTempRect;
                synchronized (rectF) {
                    float thick = FloatMath.ceil(this.mTextPaint.getStrokeWidth());
                    if (thick < 1.0f) {
                        thick = 1.0f;
                    }
                    this.mHighlightPath.computeBounds(sTempRect, false);
                    this.invalidate((int)FloatMath.floor((float)horizontalPadding + TextView.sTempRect.left - (thick /= 2.0f)), (int)FloatMath.floor((float)verticalPadding + TextView.sTempRect.top - thick), (int)FloatMath.ceil((float)horizontalPadding + TextView.sTempRect.right + thick), (int)FloatMath.ceil((float)verticalPadding + TextView.sTempRect.bottom + thick));
                }
            } else {
                for (int i = 0; i < this.mCursorCount; ++i) {
                    Rect bounds = this.mCursorDrawable[i].getBounds();
                    this.invalidate(bounds.left + horizontalPadding, bounds.top + verticalPadding, bounds.right + horizontalPadding, bounds.bottom + verticalPadding);
                }
            }
        }
    }

    private void invalidateCursor() {
        int where = this.getSelectionEnd();
        this.invalidateCursor(where, where, where);
    }

    private void invalidateCursor(int a, int b, int c) {
        if (a >= 0 || b >= 0 || c >= 0) {
            int start = Math.min(Math.min(a, b), c);
            int end = Math.max(Math.max(a, b), c);
            this.invalidateRegion(start, end, true);
        }
    }

    void invalidateRegion(int start, int end, boolean invalidateCursor) {
        if (this.mLayout == null) {
            this.invalidate();
        } else {
            int right;
            int left;
            int lineStart = this.mLayout.getLineForOffset(start);
            int top = this.mLayout.getLineTop(lineStart);
            if (lineStart > 0) {
                top -= this.mLayout.getLineDescent(lineStart - 1);
            }
            int lineEnd = start == end ? lineStart : this.mLayout.getLineForOffset(end);
            int bottom = this.mLayout.getLineBottom(lineEnd);
            if (invalidateCursor) {
                for (int i = 0; i < this.mCursorCount; ++i) {
                    Rect bounds = this.mCursorDrawable[i].getBounds();
                    top = Math.min(top, bounds.top);
                    bottom = Math.max(bottom, bounds.bottom);
                }
            }
            int compoundPaddingLeft = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (lineStart == lineEnd && !invalidateCursor) {
                left = (int)this.mLayout.getPrimaryHorizontal(start);
                right = (int)((double)this.mLayout.getPrimaryHorizontal(end) + 1.0);
                left += compoundPaddingLeft;
                right += compoundPaddingLeft;
            } else {
                left = compoundPaddingLeft;
                right = this.getWidth() - this.getCompoundPaddingRight();
            }
            this.invalidate(this.mScrollX + left, verticalPadding + top, this.mScrollX + right, verticalPadding + bottom);
        }
    }

    private void registerForPreDraw() {
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (this.mPreDrawState == 0) {
            observer.addOnPreDrawListener(this);
            this.mPreDrawState = 1;
        } else if (this.mPreDrawState == 2) {
            this.mPreDrawState = 1;
        }
    }

    @Override
    public boolean onPreDraw() {
        if (this.mPreDrawState != 1) {
            return true;
        }
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        boolean changed = false;
        if (this.mMovement != null) {
            int curs = this.getSelectionEnd();
            if (this.mSelectionModifierCursorController != null && this.mSelectionModifierCursorController.isSelectionStartDragged()) {
                curs = this.getSelectionStart();
            }
            if (curs < 0 && (this.mGravity & 0x70) == 80) {
                curs = this.mText.length();
            }
            if (curs >= 0) {
                changed = this.bringPointIntoView(curs);
            }
        } else {
            changed = this.bringTextIntoView();
        }
        if (this.mCreatedWithASelection) {
            this.startSelectionActionMode();
            this.mCreatedWithASelection = false;
        }
        if (this instanceof ExtractEditText && this.hasSelection()) {
            this.startSelectionActionMode();
        }
        this.mPreDrawState = 2;
        return !changed;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTemporaryDetach = false;
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (this.mInsertionPointCursorController != null) {
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        if (this.mSelectionModifierCursorController != null) {
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        this.resolveDrawables();
        this.updateSpellCheckSpans(0, this.mText.length(), true);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (this.mPreDrawState != 0) {
            observer.removeOnPreDrawListener(this);
            this.mPreDrawState = 0;
        }
        if (this.mError != null) {
            this.hideError();
        }
        if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        this.hideControllers();
        this.resetResolvedDrawables();
        if (this.mSpellChecker != null) {
            this.mSpellChecker.closeSession();
            this.mSpellChecker = null;
        }
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return this.mShadowRadius != 0.0f || this.mDrawables != null;
    }

    @Override
    protected int getLeftPaddingOffset() {
        return this.getCompoundPaddingLeft() - this.mPaddingLeft + (int)Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
    }

    @Override
    protected int getTopPaddingOffset() {
        return (int)Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
    }

    @Override
    protected int getBottomPaddingOffset() {
        return (int)Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
    }

    @Override
    protected int getRightPaddingOffset() {
        return -(this.getCompoundPaddingRight() - this.mPaddingRight) + (int)Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        boolean verified = super.verifyDrawable(who);
        if (!verified && this.mDrawables != null) {
            return who == this.mDrawables.mDrawableLeft || who == this.mDrawables.mDrawableTop || who == this.mDrawables.mDrawableRight || who == this.mDrawables.mDrawableBottom || who == this.mDrawables.mDrawableStart || who == this.mDrawables.mDrawableEnd;
        }
        return verified;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawables != null) {
            if (this.mDrawables.mDrawableLeft != null) {
                this.mDrawables.mDrawableLeft.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableTop != null) {
                this.mDrawables.mDrawableTop.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableRight != null) {
                this.mDrawables.mDrawableRight.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableBottom != null) {
                this.mDrawables.mDrawableBottom.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableStart != null) {
                this.mDrawables.mDrawableStart.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableEnd != null) {
                this.mDrawables.mDrawableEnd.jumpToCurrentState();
            }
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            Drawables drawables = this.mDrawables;
            if (drawables != null) {
                if (drawable2 == drawables.mDrawableLeft) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mPaddingLeft;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightLeft) / 2;
                } else if (drawable2 == drawables.mDrawableRight) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mRight - this.mLeft - this.mPaddingRight - drawables.mDrawableSizeRight;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightRight) / 2;
                } else if (drawable2 == drawables.mDrawableTop) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthTop) / 2;
                    scrollY += this.mPaddingTop;
                } else if (drawable2 == drawables.mDrawableBottom) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthBottom) / 2;
                    scrollY += this.mBottom - this.mTop - this.mPaddingBottom - drawables.mDrawableSizeBottom;
                }
            }
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        }
    }

    @Override
    public int getResolvedLayoutDirection(Drawable who) {
        if (who == null) {
            return 0;
        }
        if (this.mDrawables != null) {
            Drawables drawables = this.mDrawables;
            if (who == drawables.mDrawableLeft || who == drawables.mDrawableRight || who == drawables.mDrawableTop || who == drawables.mDrawableBottom || who == drawables.mDrawableStart || who == drawables.mDrawableEnd) {
                return this.getResolvedLayoutDirection();
            }
        }
        return super.getResolvedLayoutDirection(who);
    }

    @Override
    protected boolean onSetAlpha(int alpha) {
        if (this.getBackground() == null) {
            this.mCurrentAlpha = alpha;
            Drawables dr = this.mDrawables;
            if (dr != null) {
                if (dr.mDrawableLeft != null) {
                    dr.mDrawableLeft.mutate().setAlpha(alpha);
                }
                if (dr.mDrawableTop != null) {
                    dr.mDrawableTop.mutate().setAlpha(alpha);
                }
                if (dr.mDrawableRight != null) {
                    dr.mDrawableRight.mutate().setAlpha(alpha);
                }
                if (dr.mDrawableBottom != null) {
                    dr.mDrawableBottom.mutate().setAlpha(alpha);
                }
                if (dr.mDrawableStart != null) {
                    dr.mDrawableStart.mutate().setAlpha(alpha);
                }
                if (dr.mDrawableEnd != null) {
                    dr.mDrawableEnd.mutate().setAlpha(alpha);
                }
            }
            return true;
        }
        this.mCurrentAlpha = 255;
        return false;
    }

    public boolean isTextSelectable() {
        return this.mTextIsSelectable;
    }

    public void setTextIsSelectable(boolean selectable) {
        if (this.mTextIsSelectable == selectable) {
            return;
        }
        this.mTextIsSelectable = selectable;
        this.setFocusableInTouchMode(selectable);
        this.setFocusable(selectable);
        this.setClickable(selectable);
        this.setLongClickable(selectable);
        this.setMovementMethod(selectable ? ArrowKeyMovementMethod.getInstance() : null);
        this.setText(this.getText(), selectable ? BufferType.SPANNABLE : BufferType.NORMAL);
        this.prepareCursorControllers();
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState;
        if (this.mSingleLine) {
            drawableState = super.onCreateDrawableState(extraSpace);
        } else {
            drawableState = super.onCreateDrawableState(extraSpace + 1);
            TextView.mergeDrawableStates(drawableState, MULTILINE_STATE_SET);
        }
        if (this.mTextIsSelectable) {
            int length = drawableState.length;
            for (int i = 0; i < length; ++i) {
                if (drawableState[i] != 16842919) continue;
                int[] nonPressedState = new int[length - 1];
                System.arraycopy(drawableState, 0, nonPressedState, 0, i);
                System.arraycopy(drawableState, i + 1, nonPressedState, i, length - i - 1);
                return nonPressedState;
            }
        }
        return drawableState;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InputMethodManager imm;
        if (this.mPreDrawState == 2) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnPreDrawListener(this);
            this.mPreDrawState = 0;
        }
        if ((float)this.mCurrentAlpha <= 5.2916665f) {
            return;
        }
        this.restartMarqueeIfNeeded();
        super.onDraw(canvas);
        int compoundPaddingLeft = this.getCompoundPaddingLeft();
        int compoundPaddingTop = this.getCompoundPaddingTop();
        int compoundPaddingRight = this.getCompoundPaddingRight();
        int compoundPaddingBottom = this.getCompoundPaddingBottom();
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int right = this.mRight;
        int left = this.mLeft;
        int bottom = this.mBottom;
        int top = this.mTop;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            int vspace = bottom - top - compoundPaddingBottom - compoundPaddingTop;
            int hspace = right - left - compoundPaddingRight - compoundPaddingLeft;
            if (dr.mDrawableLeft != null) {
                canvas.save();
                canvas.translate(scrollX + this.mPaddingLeft, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightLeft) / 2);
                dr.mDrawableLeft.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableRight != null) {
                canvas.save();
                canvas.translate(scrollX + right - left - this.mPaddingRight - dr.mDrawableSizeRight, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightRight) / 2);
                dr.mDrawableRight.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableTop != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthTop) / 2, scrollY + this.mPaddingTop);
                dr.mDrawableTop.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableBottom != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthBottom) / 2, scrollY + bottom - top - this.mPaddingBottom - dr.mDrawableSizeBottom);
                dr.mDrawableBottom.draw(canvas);
                canvas.restore();
            }
        }
        int color2 = this.mCurTextColor;
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        Layout layout2 = this.mLayout;
        int cursorcolor = color2;
        if (this.mHint != null && this.mText.length() == 0) {
            if (this.mHintTextColor != null) {
                color2 = this.mCurHintTextColor;
            }
            layout2 = this.mHintLayout;
        }
        this.mTextPaint.setColor(color2);
        if (this.mCurrentAlpha != 255) {
            this.mTextPaint.setAlpha(this.mCurrentAlpha * Color.alpha(color2) / 255);
        }
        this.mTextPaint.drawableState = this.getDrawableState();
        canvas.save();
        int extendedPaddingTop = this.getExtendedPaddingTop();
        int extendedPaddingBottom = this.getExtendedPaddingBottom();
        float clipLeft = compoundPaddingLeft + scrollX;
        float clipTop = extendedPaddingTop + scrollY;
        float clipRight = right - left - compoundPaddingRight + scrollX;
        float clipBottom = bottom - top - extendedPaddingBottom + scrollY;
        if (this.mShadowRadius != 0.0f) {
            clipLeft += Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
            clipRight += Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
            clipTop += Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
            clipBottom += Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
        }
        canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
        int voffsetText = 0;
        int voffsetCursor = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffsetText = this.getVerticalOffset(false);
            voffsetCursor = this.getVerticalOffset(true);
        }
        canvas.translate(compoundPaddingLeft, extendedPaddingTop + voffsetText);
        int layoutDirection = this.getResolvedLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1) {
            if (!this.mSingleLine && this.getLineCount() == 1 && this.canMarquee() && (absoluteGravity & 7) != 3) {
                canvas.translate(this.mLayout.getLineRight(0) - (float)(this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight()), 0.0f);
            }
            if (this.mMarquee != null && this.mMarquee.isRunning()) {
                canvas.translate(-this.mMarquee.mScroll, 0.0f);
            }
        }
        Path highlight = null;
        int selStart = -1;
        int selEnd = -1;
        boolean drawCursor = false;
        if (this.mMovement != null && (this.isFocused() || this.isPressed())) {
            selStart = this.getSelectionStart();
            selEnd = this.getSelectionEnd();
            if (selStart >= 0) {
                if (this.mHighlightPath == null) {
                    this.mHighlightPath = new Path();
                }
                if (selStart == selEnd) {
                    if (this.isCursorVisible() && (SystemClock.uptimeMillis() - this.mShowCursor) % 1000L < 500L) {
                        if (this.mHighlightPathBogus) {
                            this.mHighlightPath.reset();
                            this.mLayout.getCursorPath(selStart, this.mHighlightPath, this.mText);
                            this.updateCursorsPositions();
                            this.mHighlightPathBogus = false;
                        }
                        this.mHighlightPaint.setColor(cursorcolor);
                        if (this.mCurrentAlpha != 255) {
                            this.mHighlightPaint.setAlpha(this.mCurrentAlpha * Color.alpha(cursorcolor) / 255);
                        }
                        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
                        highlight = this.mHighlightPath;
                        drawCursor = this.mCursorCount > 0;
                    }
                } else if (this.textCanBeSelected()) {
                    if (this.mHighlightPathBogus) {
                        this.mHighlightPath.reset();
                        this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                        this.mHighlightPathBogus = false;
                    }
                    this.mHighlightPaint.setColor(this.mHighlightColor);
                    if (this.mCurrentAlpha != 255) {
                        this.mHighlightPaint.setAlpha(this.mCurrentAlpha * Color.alpha(this.mHighlightColor) / 255);
                    }
                    this.mHighlightPaint.setStyle(Paint.Style.FILL);
                    highlight = this.mHighlightPath;
                }
            }
        }
        InputMethodState ims = this.mInputMethodState;
        int cursorOffsetVertical = voffsetCursor - voffsetText;
        if (ims != null && ims.mBatchEditNesting == 0 && (imm = InputMethodManager.peekInstance()) != null) {
            if (imm.isActive(this)) {
                boolean reported = false;
                if (ims.mContentChanged || ims.mSelectionModeChanged) {
                    reported = this.reportExtractedText();
                }
                if (!reported && highlight != null) {
                    int candStart = -1;
                    int candEnd = -1;
                    if (this.mText instanceof Spannable) {
                        Spannable sp = (Spannable)this.mText;
                        candStart = EditableInputConnection.getComposingSpanStart(sp);
                        candEnd = EditableInputConnection.getComposingSpanEnd(sp);
                    }
                    imm.updateSelection(this, selStart, selEnd, candStart, candEnd);
                }
            }
            if (imm.isWatchingCursor(this) && highlight != null) {
                highlight.computeBounds(ims.mTmpRectF, true);
                ims.mTmpOffset[1] = 0.0f;
                ims.mTmpOffset[0] = 0.0f;
                canvas.getMatrix().mapPoints(ims.mTmpOffset);
                ims.mTmpRectF.offset(ims.mTmpOffset[0], ims.mTmpOffset[1]);
                ims.mTmpRectF.offset(0.0f, cursorOffsetVertical);
                ims.mCursorRectInWindow.set((int)((double)ims.mTmpRectF.left + 0.5), (int)((double)ims.mTmpRectF.top + 0.5), (int)((double)ims.mTmpRectF.right + 0.5), (int)((double)ims.mTmpRectF.bottom + 0.5));
                imm.updateCursor(this, ims.mCursorRectInWindow.left, ims.mCursorRectInWindow.top, ims.mCursorRectInWindow.right, ims.mCursorRectInWindow.bottom);
            }
        }
        if (this.mCorrectionHighlighter != null) {
            this.mCorrectionHighlighter.draw(canvas, cursorOffsetVertical);
        }
        if (drawCursor) {
            this.drawCursor(canvas, cursorOffsetVertical);
            highlight = null;
        }
        layout2.draw(canvas, highlight, this.mHighlightPaint, cursorOffsetVertical);
        if (this.mMarquee != null && this.mMarquee.shouldDrawGhost()) {
            canvas.translate((int)this.mMarquee.getGhostOffset(), 0.0f);
            layout2.draw(canvas, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        canvas.restore();
    }

    private void updateCursorsPositions() {
        if (this.mCursorDrawableRes == 0) {
            this.mCursorCount = 0;
            return;
        }
        int offset = this.getSelectionStart();
        int line = this.mLayout.getLineForOffset(offset);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        this.mCursorCount = this.mLayout.isLevelBoundary(offset) ? 2 : 1;
        int middle = bottom;
        if (this.mCursorCount == 2) {
            middle = top + bottom >> 1;
        }
        this.updateCursorPosition(0, top, middle, this.mLayout.getPrimaryHorizontal(offset));
        if (this.mCursorCount == 2) {
            this.updateCursorPosition(1, middle, bottom, this.mLayout.getSecondaryHorizontal(offset));
        }
    }

    private void updateCursorPosition(int cursorIndex, int top, int bottom, float horizontal) {
        if (this.mCursorDrawable[cursorIndex] == null) {
            this.mCursorDrawable[cursorIndex] = this.mContext.getResources().getDrawable(this.mCursorDrawableRes);
        }
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        this.mCursorDrawable[cursorIndex].getPadding(this.mTempRect);
        int width = this.mCursorDrawable[cursorIndex].getIntrinsicWidth();
        horizontal = Math.max(0.5f, horizontal - 0.5f);
        int left = (int)horizontal - this.mTempRect.left;
        this.mCursorDrawable[cursorIndex].setBounds(left, top - this.mTempRect.top, left + width, bottom + this.mTempRect.bottom);
    }

    private void drawCursor(Canvas canvas, int cursorOffsetVertical) {
        boolean translate;
        boolean bl = translate = cursorOffsetVertical != 0;
        if (translate) {
            canvas.translate(0.0f, cursorOffsetVertical);
        }
        for (int i = 0; i < this.mCursorCount; ++i) {
            this.mCursorDrawable[i].draw(canvas);
        }
        if (translate) {
            canvas.translate(0.0f, -cursorOffsetVertical);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFocusedRect(Rect r) {
        if (this.mLayout == null) {
            super.getFocusedRect(r);
            return;
        }
        int selEnd = this.getSelectionEnd();
        if (selEnd < 0) {
            super.getFocusedRect(r);
            return;
        }
        int selStart = this.getSelectionStart();
        if (selStart < 0 || selStart >= selEnd) {
            int line = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(line);
            r.bottom = this.mLayout.getLineBottom(line);
            r.left = (int)this.mLayout.getPrimaryHorizontal(selEnd) - 2;
            r.right = r.left + 4;
        } else {
            int lineStart = this.mLayout.getLineForOffset(selStart);
            int lineEnd = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(lineStart);
            r.bottom = this.mLayout.getLineBottom(lineEnd);
            if (lineStart == lineEnd) {
                r.left = (int)this.mLayout.getPrimaryHorizontal(selStart);
                r.right = (int)this.mLayout.getPrimaryHorizontal(selEnd);
            } else {
                if (this.mHighlightPath == null) {
                    this.mHighlightPath = new Path();
                }
                if (this.mHighlightPathBogus) {
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                RectF rectF = sTempRect;
                synchronized (rectF) {
                    this.mHighlightPath.computeBounds(sTempRect, true);
                    r.left = (int)TextView.sTempRect.left - 1;
                    r.right = (int)TextView.sTempRect.right + 1;
                }
            }
        }
        int paddingLeft = this.getCompoundPaddingLeft();
        int paddingTop = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            paddingTop += this.getVerticalOffset(false);
        }
        r.offset(paddingLeft, paddingTop);
    }

    public int getLineCount() {
        return this.mLayout != null ? this.mLayout.getLineCount() : 0;
    }

    public int getLineBounds(int line, Rect bounds) {
        if (this.mLayout == null) {
            if (bounds != null) {
                bounds.set(0, 0, 0, 0);
            }
            return 0;
        }
        int baseline = this.mLayout.getLineBounds(line, bounds);
        int voffset = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            voffset += this.getVerticalOffset(true);
        }
        if (bounds != null) {
            bounds.offset(this.getCompoundPaddingLeft(), voffset);
        }
        return baseline + voffset;
    }

    @Override
    public int getBaseline() {
        if (this.mLayout == null) {
            return super.getBaseline();
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        return this.getExtendedPaddingTop() + voffset + this.mLayout.getLineBaseline(0);
    }

    @Override
    protected int getFadeTop(boolean offsetRequired) {
        if (this.mLayout == null) {
            return 0;
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (offsetRequired) {
            voffset += this.getTopPaddingOffset();
        }
        return this.getExtendedPaddingTop() + voffset;
    }

    @Override
    protected int getFadeHeight(boolean offsetRequired) {
        return this.mLayout != null ? this.mLayout.getHeight() : 0;
    }

    @Override
    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            boolean isInSelectionMode;
            boolean bl = isInSelectionMode = this.mSelectionActionMode != null;
            if (isInSelectionMode) {
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                    if (state != null) {
                        state.startTracking(event, this);
                    }
                    return true;
                }
                if (event.getAction() == 1) {
                    KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                    if (state != null) {
                        state.handleUpEvent(event);
                    }
                    if (event.isTracking() && !event.isCanceled() && isInSelectionMode) {
                        this.stopSelectionActionMode();
                        return true;
                    }
                }
            }
        }
        return super.onKeyPreIme(keyCode, event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        int which = this.doKeyDown(keyCode, event, null);
        if (which == 0) {
            return super.onKeyDown(keyCode, event);
        }
        return true;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        KeyEvent down = KeyEvent.changeAction(event, 0);
        int which = this.doKeyDown(keyCode, down, event);
        if (which == 0) {
            return super.onKeyMultiple(keyCode, repeatCount, event);
        }
        if (which == -1) {
            return true;
        }
        --repeatCount;
        KeyEvent up = KeyEvent.changeAction(event, 1);
        if (which == 1) {
            this.mInput.onKeyUp(this, (Editable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mInput.onKeyDown(this, (Editable)this.mText, keyCode, down);
                this.mInput.onKeyUp(this, (Editable)this.mText, keyCode, up);
            }
            this.hideErrorIfUnchanged();
        } else if (which == 2) {
            this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, down);
                this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            }
        }
        return true;
    }

    private boolean shouldAdvanceFocusOnEnter() {
        int variation;
        if (this.mInput == null) {
            return false;
        }
        if (this.mSingleLine) {
            return true;
        }
        return (this.mInputType & 0xF) == 1 && ((variation = this.mInputType & 0xFF0) == 32 || variation == 48);
    }

    private boolean shouldAdvanceFocusOnTab() {
        int variation;
        return this.mInput == null || this.mSingleLine || (this.mInputType & 0xF) != 1 || (variation = this.mInputType & 0xFF0) != 262144 && variation != 131072;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doKeyDown(int keyCode, KeyEvent event, KeyEvent otherEvent) {
        boolean handled;
        boolean doDown;
        if (!this.isEnabled()) {
            return 0;
        }
        switch (keyCode) {
            case 66: {
                if (!event.hasNoModifiers()) break;
                if (this.mInputContentType != null && this.mInputContentType.onEditorActionListener != null && this.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                    this.mInputContentType.enterDown = true;
                    return -1;
                }
                if ((event.getFlags() & 0x10) == 0 && !this.shouldAdvanceFocusOnEnter()) break;
                if (this.hasOnClickListeners()) {
                    return 0;
                }
                return -1;
            }
            case 23: {
                if (!event.hasNoModifiers() || !this.shouldAdvanceFocusOnEnter()) break;
                return 0;
            }
            case 61: {
                if (!event.hasNoModifiers() && !event.hasModifiers(1) || !this.shouldAdvanceFocusOnTab()) break;
                return 0;
            }
            case 4: {
                if (this.mSelectionActionMode == null) break;
                this.stopSelectionActionMode();
                return -1;
            }
        }
        if (this.mInput != null) {
            this.resetErrorChangedFlag();
            doDown = true;
            if (otherEvent != null) {
                try {
                    this.beginBatchEdit();
                    handled = this.mInput.onKeyOther(this, (Editable)this.mText, otherEvent);
                    this.hideErrorIfUnchanged();
                    doDown = false;
                    if (handled) {
                        int n = -1;
                        return n;
                    }
                }
                catch (AbstractMethodError e) {
                }
                finally {
                    this.endBatchEdit();
                }
            }
            if (doDown) {
                this.beginBatchEdit();
                handled = this.mInput.onKeyDown(this, (Editable)this.mText, keyCode, event);
                this.endBatchEdit();
                this.hideErrorIfUnchanged();
                if (handled) {
                    return 1;
                }
            }
        }
        if (this.mMovement != null && this.mLayout != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    handled = this.mMovement.onKeyOther(this, (Spannable)this.mText, otherEvent);
                    doDown = false;
                    if (handled) {
                        return -1;
                    }
                }
                catch (AbstractMethodError e) {
                    // empty catch block
                }
            }
            if (doDown && this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, event)) {
                return 2;
            }
        }
        return 0;
    }

    public void resetErrorChangedFlag() {
        this.mErrorWasChanged = false;
    }

    public void hideErrorIfUnchanged() {
        if (this.mError != null && !this.mErrorWasChanged) {
            this.setError(null, null);
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyUp(keyCode, event);
        }
        switch (keyCode) {
            case 23: {
                if (event.hasNoModifiers() && !this.hasOnClickListeners() && this.mMovement != null && this.mText instanceof Editable && this.mLayout != null && this.onCheckIsTextEditor()) {
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    this.viewClicked(imm);
                    if (imm != null && this.mSoftInputShownOnFocus) {
                        imm.showSoftInput(this, 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
            case 66: {
                if (!event.hasNoModifiers()) break;
                if (this.mInputContentType != null && this.mInputContentType.onEditorActionListener != null && this.mInputContentType.enterDown) {
                    this.mInputContentType.enterDown = false;
                    if (this.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                        return true;
                    }
                }
                if (((event.getFlags() & 0x10) != 0 || this.shouldAdvanceFocusOnEnter()) && !this.hasOnClickListeners()) {
                    InputMethodManager imm;
                    View v = this.focusSearch(130);
                    if (v != null) {
                        if (!v.requestFocus(130)) {
                            throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                        }
                        super.onKeyUp(keyCode, event);
                        return true;
                    }
                    if ((event.getFlags() & 0x10) != 0 && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this)) {
                        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
        }
        if (this.mInput != null && this.mInput.onKeyUp(this, (Editable)this.mText, keyCode, event)) {
            return true;
        }
        if (this.mMovement != null && this.mLayout != null && this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onCheckIsTextEditor() {
        return this.mInputType != 0;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.onCheckIsTextEditor() && this.isEnabled()) {
            if (this.mInputMethodState == null) {
                this.mInputMethodState = new InputMethodState();
            }
            outAttrs.inputType = this.mInputType;
            if (this.mInputContentType != null) {
                outAttrs.imeOptions = this.mInputContentType.imeOptions;
                outAttrs.privateImeOptions = this.mInputContentType.privateImeOptions;
                outAttrs.actionLabel = this.mInputContentType.imeActionLabel;
                outAttrs.actionId = this.mInputContentType.imeActionId;
                outAttrs.extras = this.mInputContentType.extras;
            } else {
                outAttrs.imeOptions = 0;
            }
            if (this.focusSearch(130) != null) {
                outAttrs.imeOptions |= 0x8000000;
            }
            if (this.focusSearch(33) != null) {
                outAttrs.imeOptions |= 0x4000000;
            }
            if ((outAttrs.imeOptions & 0xFF) == 0) {
                outAttrs.imeOptions = (outAttrs.imeOptions & 0x8000000) != 0 ? (outAttrs.imeOptions |= 5) : (outAttrs.imeOptions |= 6);
                if (!this.shouldAdvanceFocusOnEnter()) {
                    outAttrs.imeOptions |= 0x40000000;
                }
            }
            if (TextView.isMultilineInputType(outAttrs.inputType)) {
                outAttrs.imeOptions |= 0x40000000;
            }
            outAttrs.hintText = this.mHint;
            if (this.mText instanceof Editable) {
                EditableInputConnection ic = new EditableInputConnection(this);
                outAttrs.initialSelStart = this.getSelectionStart();
                outAttrs.initialSelEnd = this.getSelectionEnd();
                outAttrs.initialCapsMode = ic.getCursorCapsMode(this.mInputType);
                return ic;
            }
        }
        return null;
    }

    public boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        return this.extractTextInternal(request, -1, -1, -1, outText);
    }

    boolean extractTextInternal(ExtractedTextRequest request, int partialStartOffset, int partialEndOffset, int delta, ExtractedText outText) {
        CharSequence content = this.mText;
        if (content != null) {
            if (partialStartOffset != -2) {
                int N = content.length();
                if (partialStartOffset < 0) {
                    outText.partialEndOffset = -1;
                    outText.partialStartOffset = -1;
                    partialStartOffset = 0;
                    partialEndOffset = N;
                } else {
                    partialEndOffset += delta;
                    if (content instanceof Spanned) {
                        Spanned spanned = (Spanned)content;
                        ParcelableSpan[] spans = spanned.getSpans(partialStartOffset, partialEndOffset, ParcelableSpan.class);
                        int i = spans.length;
                        while (i > 0) {
                            int j;
                            if ((j = spanned.getSpanStart(spans[--i])) < partialStartOffset) {
                                partialStartOffset = j;
                            }
                            if ((j = spanned.getSpanEnd(spans[i])) <= partialEndOffset) continue;
                            partialEndOffset = j;
                        }
                    }
                    outText.partialStartOffset = partialStartOffset;
                    outText.partialEndOffset = partialEndOffset - delta;
                    if (partialStartOffset > N) {
                        partialStartOffset = N;
                    } else if (partialStartOffset < 0) {
                        partialStartOffset = 0;
                    }
                    if (partialEndOffset > N) {
                        partialEndOffset = N;
                    } else if (partialEndOffset < 0) {
                        partialEndOffset = 0;
                    }
                }
                outText.text = (request.flags & 1) != 0 ? content.subSequence(partialStartOffset, partialEndOffset) : TextUtils.substring(content, partialStartOffset, partialEndOffset);
            } else {
                outText.partialStartOffset = 0;
                outText.partialEndOffset = 0;
                outText.text = "";
            }
            outText.flags = 0;
            if (MetaKeyKeyListener.getMetaState(this.mText, 2048) != 0) {
                outText.flags |= 2;
            }
            if (this.mSingleLine) {
                outText.flags |= 1;
            }
            outText.startOffset = 0;
            outText.selectionStart = this.getSelectionStart();
            outText.selectionEnd = this.getSelectionEnd();
            return true;
        }
        return false;
    }

    boolean reportExtractedText() {
        boolean contentChanged;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ((contentChanged = ims.mContentChanged) || ims.mSelectionModeChanged)) {
            InputMethodManager imm;
            ims.mContentChanged = false;
            ims.mSelectionModeChanged = false;
            ExtractedTextRequest req = this.mInputMethodState.mExtracting;
            if (req != null && (imm = InputMethodManager.peekInstance()) != null) {
                if (ims.mChangedStart < 0 && !contentChanged) {
                    ims.mChangedStart = -2;
                }
                if (this.extractTextInternal(req, ims.mChangedStart, ims.mChangedEnd, ims.mChangedDelta, ims.mTmpExtracted)) {
                    imm.updateExtractedText(this, req.token, this.mInputMethodState.mTmpExtracted);
                    ims.mChangedStart = -1;
                    ims.mChangedEnd = -1;
                    ims.mChangedDelta = 0;
                    ims.mContentChanged = false;
                    return true;
                }
            }
        }
        return false;
    }

    static void removeParcelableSpans(Spannable spannable, int start, int end) {
        ParcelableSpan[] spans = spannable.getSpans(start, end, ParcelableSpan.class);
        int i = spans.length;
        while (i > 0) {
            spannable.removeSpan(spans[--i]);
        }
    }

    public void setExtractedText(ExtractedText text) {
        Editable content = this.getEditableText();
        if (text.text != null) {
            if (content == null) {
                this.setText(text.text, BufferType.EDITABLE);
            } else if (text.partialStartOffset < 0) {
                TextView.removeParcelableSpans(content, 0, content.length());
                content.replace(0, content.length(), text.text);
            } else {
                int end;
                int start = text.partialStartOffset;
                int N = content.length();
                if (start > N) {
                    start = N;
                }
                if ((end = text.partialEndOffset) > N) {
                    end = N;
                }
                TextView.removeParcelableSpans(content, start, end);
                content.replace(start, end, text.text);
            }
        }
        Spannable sp = (Spannable)this.getText();
        int N = sp.length();
        int start = text.selectionStart;
        if (start < 0) {
            start = 0;
        } else if (start > N) {
            start = N;
        }
        int end = text.selectionEnd;
        if (end < 0) {
            end = 0;
        } else if (end > N) {
            end = N;
        }
        Selection.setSelection(sp, start, end);
        if ((text.flags & 2) != 0) {
            MetaKeyKeyListener.startSelecting(this, sp);
        } else {
            MetaKeyKeyListener.stopSelecting(this, sp);
        }
    }

    public void setExtracting(ExtractedTextRequest req) {
        if (this.mInputMethodState != null) {
            this.mInputMethodState.mExtracting = req;
        }
        this.hideControllers();
    }

    public void onCommitCompletion(CompletionInfo text) {
    }

    public void onCommitCorrection(CorrectionInfo info) {
        if (this.mCorrectionHighlighter == null) {
            this.mCorrectionHighlighter = new CorrectionHighlighter();
        } else {
            this.mCorrectionHighlighter.invalidate(false);
        }
        this.mCorrectionHighlighter.highlight(info);
    }

    public void beginBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = true;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = ++ims.mBatchEditNesting) == 1) {
            ims.mCursorChanged = false;
            ims.mChangedDelta = 0;
            if (ims.mContentChanged) {
                ims.mChangedStart = 0;
                ims.mChangedEnd = this.mText.length();
            } else {
                ims.mChangedStart = -1;
                ims.mChangedEnd = -1;
                ims.mContentChanged = false;
            }
            this.onBeginBatchEdit();
        }
    }

    public void endBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = false;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = --ims.mBatchEditNesting) == 0) {
            this.finishBatchEdit(ims);
        }
    }

    void ensureEndedBatchEdit() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting != 0) {
            ims.mBatchEditNesting = 0;
            this.finishBatchEdit(ims);
        }
    }

    void finishBatchEdit(InputMethodState ims) {
        this.onEndBatchEdit();
        if (ims.mContentChanged || ims.mSelectionModeChanged) {
            this.updateAfterEdit();
            this.reportExtractedText();
        } else if (ims.mCursorChanged) {
            this.invalidateCursor();
        }
    }

    void updateAfterEdit() {
        this.invalidate();
        int curs = this.getSelectionStart();
        if (curs >= 0 || (this.mGravity & 0x70) == 80) {
            this.registerForPreDraw();
        }
        if (curs >= 0) {
            this.mHighlightPathBogus = true;
            this.makeBlink();
            this.bringPointIntoView(curs);
        }
        this.checkForResize();
    }

    public void onBeginBatchEdit() {
    }

    public void onEndBatchEdit() {
    }

    public boolean onPrivateIMECommand(String action, Bundle data) {
        return false;
    }

    private void nullLayouts() {
        if (this.mLayout instanceof BoringLayout && this.mSavedLayout == null) {
            this.mSavedLayout = (BoringLayout)this.mLayout;
        }
        if (this.mHintLayout instanceof BoringLayout && this.mSavedHintLayout == null) {
            this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
        }
        this.mHintLayout = null;
        this.mLayout = null;
        this.mSavedMarqueeModeLayout = null;
        this.prepareCursorControllers();
    }

    private void assumeLayout() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (width < 1) {
            width = 0;
        }
        int physicalWidth = width;
        if (this.mHorizontallyScrolling) {
            width = 0x100000;
        }
        this.makeNewLayout(width, physicalWidth, UNKNOWN_BORING, UNKNOWN_BORING, physicalWidth, false);
    }

    @Override
    protected void resetResolvedLayoutDirection() {
        super.resetResolvedLayoutDirection();
        if (this.mLayoutAlignment != null && (this.mTextAlign == TextAlign.VIEW_START || this.mTextAlign == TextAlign.VIEW_END)) {
            this.mLayoutAlignment = null;
        }
    }

    private Layout.Alignment getLayoutAlignment() {
        if (this.mLayoutAlignment == null) {
            Layout.Alignment alignment;
            TextAlign textAlign = this.mTextAlign;
            block0 : switch (textAlign) {
                case INHERIT: 
                case GRAVITY: {
                    switch (this.mGravity & 0x800007) {
                        case 0x800003: {
                            alignment = Layout.Alignment.ALIGN_NORMAL;
                            break block0;
                        }
                        case 0x800005: {
                            alignment = Layout.Alignment.ALIGN_OPPOSITE;
                            break block0;
                        }
                        case 3: {
                            alignment = Layout.Alignment.ALIGN_LEFT;
                            break block0;
                        }
                        case 5: {
                            alignment = Layout.Alignment.ALIGN_RIGHT;
                            break block0;
                        }
                        case 1: {
                            alignment = Layout.Alignment.ALIGN_CENTER;
                            break block0;
                        }
                    }
                    alignment = Layout.Alignment.ALIGN_NORMAL;
                    break;
                }
                case TEXT_START: {
                    alignment = Layout.Alignment.ALIGN_NORMAL;
                    break;
                }
                case TEXT_END: {
                    alignment = Layout.Alignment.ALIGN_OPPOSITE;
                    break;
                }
                case CENTER: {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                    break;
                }
                case VIEW_START: {
                    alignment = this.getResolvedLayoutDirection() == 0x40000000 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
                    break;
                }
                case VIEW_END: {
                    alignment = this.getResolvedLayoutDirection() == 0x40000000 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
                    break;
                }
                default: {
                    alignment = Layout.Alignment.ALIGN_NORMAL;
                }
            }
            this.mLayoutAlignment = alignment;
        }
        return this.mLayoutAlignment;
    }

    protected void makeNewLayout(int wantWidth, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        this.stopMarquee();
        this.mOldMaximum = this.mMaximum;
        this.mOldMaxMode = this.mMaxMode;
        this.mHighlightPathBogus = true;
        if (wantWidth < 0) {
            wantWidth = 0;
        }
        if (hintWidth < 0) {
            hintWidth = 0;
        }
        Layout.Alignment alignment = this.getLayoutAlignment();
        boolean shouldEllipsize = this.mEllipsize != null && this.mInput == null;
        boolean switchEllipsize = this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 0;
        TextUtils.TruncateAt effectiveEllipsize = this.mEllipsize;
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode == 1) {
            effectiveEllipsize = TextUtils.TruncateAt.END_SMALL;
        }
        if (this.mTextDir == null) {
            this.resolveTextDirection();
        }
        this.mLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, effectiveEllipsize, effectiveEllipsize == this.mEllipsize);
        if (switchEllipsize) {
            TextUtils.TruncateAt oppositeEllipsize = effectiveEllipsize == TextUtils.TruncateAt.MARQUEE ? TextUtils.TruncateAt.END : TextUtils.TruncateAt.MARQUEE;
            this.mSavedMarqueeModeLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, oppositeEllipsize, effectiveEllipsize != this.mEllipsize);
        }
        shouldEllipsize = this.mEllipsize != null;
        this.mHintLayout = null;
        if (this.mHint != null) {
            if (shouldEllipsize) {
                hintWidth = wantWidth;
            }
            if (hintBoring == UNKNOWN_BORING && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.mHintBoring)) != null) {
                this.mHintBoring = hintBoring;
            }
            if (hintBoring != null) {
                if (!(hintBoring.width > hintWidth || shouldEllipsize && hintBoring.width > ellipsisWidth)) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad);
                    this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
                } else {
                    this.mHintLayout = shouldEllipsize && hintBoring.width <= hintWidth ? (this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth)) : (shouldEllipsize ? new StaticLayout(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mHint, this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad));
                }
            } else {
                this.mHintLayout = shouldEllipsize ? new StaticLayout(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mHint, this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
            }
        }
        if (bringIntoView) {
            this.registerForPreDraw();
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && !this.compressText(ellipsisWidth)) {
            int height = this.mLayoutParams.height;
            if (height != -2 && height != -1) {
                this.startMarquee();
            } else {
                this.mRestartMarquee = true;
            }
        }
        this.prepareCursorControllers();
    }

    private Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        Layout result = null;
        if (this.mText instanceof Spannable) {
            result = new DynamicLayout(this.mText, this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mInput == null ? effectiveEllipsize : null, ellipsisWidth);
        } else {
            if (boring == UNKNOWN_BORING && (boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.mBoring)) != null) {
                this.mBoring = boring;
            }
            if (boring != null) {
                if (boring.width <= wantWidth && (effectiveEllipsize == null || boring.width <= ellipsisWidth)) {
                    result = useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad);
                    if (useSaved) {
                        this.mSavedLayout = (BoringLayout)result;
                    }
                } else {
                    result = shouldEllipsize && boring.width <= wantWidth ? (useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth)) : (shouldEllipsize ? new StaticLayout(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, effectiveEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad));
                }
            } else {
                result = shouldEllipsize ? new StaticLayout(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, effectiveEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
            }
        }
        return result;
    }

    private boolean compressText(float width) {
        float textWidth;
        float overflow;
        if (this.isHardwareAccelerated()) {
            return false;
        }
        if (width > 0.0f && this.mLayout != null && this.getLineCount() == 1 && !this.mUserSetTextScaleX && this.mTextPaint.getTextScaleX() == 1.0f && (overflow = ((textWidth = this.mLayout.getLineWidth(0)) + 1.0f - width) / width) > 0.0f && overflow <= 0.07f) {
            this.mTextPaint.setTextScaleX(1.0f - overflow - 0.005f);
            this.post(new Runnable(){

                public void run() {
                    TextView.this.requestLayout();
                }
            });
            return true;
        }
        return false;
    }

    private static int desired(Layout layout2) {
        int i;
        int n = layout2.getLineCount();
        CharSequence text = layout2.getText();
        float max = 0.0f;
        for (i = 0; i < n - 1; ++i) {
            if (text.charAt(layout2.getLineEnd(i) - 1) == '\n') continue;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            max = Math.max(max, layout2.getLineWidth(i));
        }
        return (int)FloatMath.ceil(max);
    }

    public void setIncludeFontPadding(boolean includepad) {
        if (this.mIncludePad != includepad) {
            this.mIncludePad = includepad;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int hintWidth;
        int want;
        int width;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING;
        BoringLayout.Metrics hintBoring = UNKNOWN_BORING;
        if (this.mTextDir == null) {
            this.resolveTextDirection();
        }
        int des = -1;
        boolean fromexisting = false;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (this.mLayout != null && this.mEllipsize == null) {
                des = TextView.desired(this.mLayout);
            }
            if (des < 0) {
                boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.mBoring);
                if (boring != null) {
                    this.mBoring = boring;
                }
            } else {
                fromexisting = true;
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    des = (int)FloatMath.ceil(Layout.getDesiredWidth(this.mTransformed, this.mTextPaint));
                }
                width = des;
            } else {
                width = boring.width;
            }
            Drawables dr = this.mDrawables;
            if (dr != null) {
                width = Math.max(width, dr.mDrawableWidthTop);
                width = Math.max(width, dr.mDrawableWidthBottom);
            }
            if (this.mHint != null) {
                int hintWidth2;
                int hintDes = -1;
                if (this.mHintLayout != null && this.mEllipsize == null) {
                    hintDes = TextView.desired(this.mHintLayout);
                }
                if (hintDes < 0 && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mHintBoring)) != null) {
                    this.mHintBoring = hintBoring;
                }
                if (hintBoring == null || hintBoring == UNKNOWN_BORING) {
                    if (hintDes < 0) {
                        hintDes = (int)FloatMath.ceil(Layout.getDesiredWidth(this.mHint, this.mTextPaint));
                    }
                    hintWidth2 = hintDes;
                } else {
                    hintWidth2 = hintBoring.width;
                }
                if (hintWidth2 > width) {
                    width = hintWidth2;
                }
            }
            width += this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
            width = this.mMaxWidthMode == 1 ? Math.min(width, this.mMaxWidth * this.getLineHeight()) : Math.min(width, this.mMaxWidth);
            width = this.mMinWidthMode == 1 ? Math.max(width, this.mMinWidth * this.getLineHeight()) : Math.max(width, this.mMinWidth);
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        int unpaddedWidth = want = width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (this.mHorizontallyScrolling) {
            want = 0x100000;
        }
        int hintWant = want;
        int n = hintWidth = this.mHintLayout == null ? hintWant : this.mHintLayout.getWidth();
        if (this.mLayout == null) {
            this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
        } else {
            boolean maximumChanged;
            boolean layoutChanged = this.mLayout.getWidth() != want || hintWidth != hintWant || this.mLayout.getEllipsizedWidth() != width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            boolean widthChanged = this.mHint == null && this.mEllipsize == null && want > this.mLayout.getWidth() && (this.mLayout instanceof BoringLayout || fromexisting && des >= 0 && des <= want);
            boolean bl = maximumChanged = this.mMaxMode != this.mOldMaxMode || this.mMaximum != this.mOldMaximum;
            if (layoutChanged || maximumChanged) {
                if (!maximumChanged && widthChanged) {
                    this.mLayout.increaseWidthTo(want);
                } else {
                    this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
                }
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
            this.mDesiredHeightAtMeasure = -1;
        } else {
            int desired;
            height = desired = this.getDesiredHeight();
            this.mDesiredHeightAtMeasure = desired;
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(desired, heightSize);
            }
        }
        int unpaddedHeight = height - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
        if (this.mMaxMode == 1 && this.mLayout.getLineCount() > this.mMaximum) {
            unpaddedHeight = Math.min(unpaddedHeight, this.mLayout.getLineTop(this.mMaximum));
        }
        if (this.mMovement != null || this.mLayout.getWidth() > unpaddedWidth || this.mLayout.getHeight() > unpaddedHeight) {
            this.registerForPreDraw();
        } else {
            this.scrollTo(0, 0);
        }
        this.setMeasuredDimension(width, height);
    }

    private int getDesiredHeight() {
        return Math.max(this.getDesiredHeight(this.mLayout, true), this.getDesiredHeight(this.mHintLayout, this.mEllipsize != null));
    }

    private int getDesiredHeight(Layout layout2, boolean cap) {
        if (layout2 == null) {
            return 0;
        }
        int linecount = layout2.getLineCount();
        int pad = this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
        int desired = layout2.getLineTop(linecount);
        Drawables dr = this.mDrawables;
        if (dr != null) {
            desired = Math.max(desired, dr.mDrawableHeightLeft);
            desired = Math.max(desired, dr.mDrawableHeightRight);
        }
        desired += pad;
        if (this.mMaxMode == 1) {
            if (cap && linecount > this.mMaximum) {
                desired = layout2.getLineTop(this.mMaximum);
                if (dr != null) {
                    desired = Math.max(desired, dr.mDrawableHeightLeft);
                    desired = Math.max(desired, dr.mDrawableHeightRight);
                }
                desired += pad;
                linecount = this.mMaximum;
            }
        } else {
            desired = Math.min(desired, this.mMaximum);
        }
        if (this.mMinMode == 1) {
            if (linecount < this.mMinimum) {
                desired += this.getLineHeight() * (this.mMinimum - linecount);
            }
        } else {
            desired = Math.max(desired, this.mMinimum);
        }
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    private void checkForResize() {
        boolean sizeChanged = false;
        if (this.mLayout != null) {
            int desiredHeight;
            if (this.mLayoutParams.width == -2) {
                sizeChanged = true;
                this.invalidate();
            }
            if (this.mLayoutParams.height == -2) {
                int desiredHeight2 = this.getDesiredHeight();
                if (desiredHeight2 != this.getHeight()) {
                    sizeChanged = true;
                }
            } else if (this.mLayoutParams.height == -1 && this.mDesiredHeightAtMeasure >= 0 && (desiredHeight = this.getDesiredHeight()) != this.mDesiredHeightAtMeasure) {
                sizeChanged = true;
            }
        }
        if (sizeChanged) {
            this.requestLayout();
        }
    }

    private void checkForRelayout() {
        if ((this.mLayoutParams.width != -2 || this.mMaxWidthMode == this.mMinWidthMode && this.mMaxWidth == this.mMinWidth) && (this.mHint == null || this.mHintLayout != null) && this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight() > 0) {
            int oldht = this.mLayout.getHeight();
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
            if (this.mEllipsize != TextUtils.TruncateAt.MARQUEE) {
                if (this.mLayoutParams.height != -2 && this.mLayoutParams.height != -1) {
                    this.invalidate();
                    return;
                }
                if (this.mLayout.getHeight() == oldht && (this.mHintLayout == null || this.mHintLayout.getHeight() == oldht)) {
                    this.invalidate();
                    return;
                }
            }
            this.requestLayout();
            this.invalidate();
        } else {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    private boolean bringTextIntoView() {
        int scrollx;
        int line = 0;
        if ((this.mGravity & 0x70) == 80) {
            line = this.mLayout.getLineCount() - 1;
        }
        Layout.Alignment a = this.mLayout.getParagraphAlignment(line);
        int dir = this.mLayout.getParagraphDirection(line);
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int ht = this.mLayout.getHeight();
        if (a == Layout.Alignment.ALIGN_NORMAL) {
            a = dir == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
        } else if (a == Layout.Alignment.ALIGN_OPPOSITE) {
            Layout.Alignment alignment = a = dir == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
        }
        if (a == Layout.Alignment.ALIGN_CENTER) {
            int left = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
            int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
            scrollx = right - left < hspace ? (right + left) / 2 - hspace / 2 : (dir < 0 ? right - hspace : left);
        } else if (a == Layout.Alignment.ALIGN_RIGHT) {
            int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
            scrollx = right - hspace;
        } else {
            scrollx = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
        }
        int scrolly = ht < vspace ? 0 : ((this.mGravity & 0x70) == 80 ? ht - vspace : 0);
        if (scrollx != this.mScrollX || scrolly != this.mScrollY) {
            this.scrollTo(scrollx, scrolly);
            return true;
        }
        return false;
    }

    public boolean bringPointIntoView(int offset) {
        int hslack;
        int grav;
        boolean changed = false;
        if (this.mLayout == null) {
            return changed;
        }
        int line = this.mLayout.getLineForOffset(offset);
        int x = (int)this.mLayout.getPrimaryHorizontal(offset);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int left = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
        int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
        int ht = this.mLayout.getHeight();
        switch (this.mLayout.getParagraphAlignment(line)) {
            case ALIGN_LEFT: {
                grav = 1;
                break;
            }
            case ALIGN_RIGHT: {
                grav = -1;
                break;
            }
            case ALIGN_NORMAL: {
                grav = this.mLayout.getParagraphDirection(line);
                break;
            }
            case ALIGN_OPPOSITE: {
                grav = -this.mLayout.getParagraphDirection(line);
                break;
            }
            default: {
                grav = 0;
            }
        }
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int vslack = hslack = (bottom - top) / 2;
        if (vslack > vspace / 4) {
            vslack = vspace / 4;
        }
        if (hslack > hspace / 4) {
            hslack = hspace / 4;
        }
        int hs = this.mScrollX;
        int vs = this.mScrollY;
        if (top - vs < vslack) {
            vs = top - vslack;
        }
        if (bottom - vs > vspace - vslack) {
            vs = bottom - (vspace - vslack);
        }
        if (ht - vs < vspace) {
            vs = ht - vspace;
        }
        if (0 - vs > 0) {
            vs = 0;
        }
        if (grav != 0) {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (grav < 0) {
            if (left - hs > 0) {
                hs = left;
            }
            if (right - hs < hspace) {
                hs = right - hspace;
            }
        } else if (grav > 0) {
            if (right - hs < hspace) {
                hs = right - hspace;
            }
            if (left - hs > 0) {
                hs = left;
            }
        } else if (right - left <= hspace) {
            hs = left - (hspace - (right - left)) / 2;
        } else if (x > right - hslack) {
            hs = right - hspace;
        } else if (x < left + hslack) {
            hs = left;
        } else if (left > hs) {
            hs = left;
        } else if (right < hs + hspace) {
            hs = right - hspace;
        } else {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (hs != this.mScrollX || vs != this.mScrollY) {
            if (this.mScroller == null) {
                this.scrollTo(hs, vs);
            } else {
                long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
                int dx = hs - this.mScrollX;
                int dy = vs - this.mScrollY;
                if (duration > 250L) {
                    this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy);
                    this.awakenScrollBars(this.mScroller.getDuration());
                    this.invalidate();
                } else {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    this.scrollBy(dx, dy);
                }
                this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
            }
            changed = true;
        }
        if (this.isFocused()) {
            if (this.mTempRect == null) {
                this.mTempRect = new Rect();
            }
            this.mTempRect.set(x - 2, top, x + 2, bottom);
            this.getInterestingRect(this.mTempRect, line);
            this.mTempRect.offset(this.mScrollX, this.mScrollY);
            if (this.requestRectangleOnScreen(this.mTempRect)) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean moveCursorToVisibleOffset() {
        int vs;
        int vspace;
        int end;
        if (!(this.mText instanceof Spannable)) {
            return false;
        }
        int start = this.getSelectionStart();
        if (start != (end = this.getSelectionEnd())) {
            return false;
        }
        int line = this.mLayout.getLineForOffset(start);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int vslack = (bottom - top) / 2;
        if (vslack > (vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom()) / 4) {
            vslack = vspace / 4;
        }
        if (top < (vs = this.mScrollY) + vslack) {
            line = this.mLayout.getLineForVertical(vs + vslack + (bottom - top));
        } else if (bottom > vspace + vs - vslack) {
            line = this.mLayout.getLineForVertical(vspace + vs - vslack - (bottom - top));
        }
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int hs = this.mScrollX;
        int leftChar = this.mLayout.getOffsetForHorizontal(line, hs);
        int rightChar = this.mLayout.getOffsetForHorizontal(line, hspace + hs);
        int lowChar = leftChar < rightChar ? leftChar : rightChar;
        int highChar = leftChar > rightChar ? leftChar : rightChar;
        int newStart = start;
        if (newStart < lowChar) {
            newStart = lowChar;
        } else if (newStart > highChar) {
            newStart = highChar;
        }
        if (newStart != start) {
            Selection.setSelection((Spannable)this.mText, newStart);
            return true;
        }
        return false;
    }

    @Override
    public void computeScroll() {
        if (this.mScroller != null && this.mScroller.computeScrollOffset()) {
            this.mScrollX = this.mScroller.getCurrX();
            this.mScrollY = this.mScroller.getCurrY();
            this.invalidateParentCaches();
            this.postInvalidate();
        }
    }

    private void getInterestingRect(Rect r, int line) {
        this.convertFromViewportToContentCoordinates(r);
        if (line == 0) {
            r.top -= this.getExtendedPaddingTop();
        }
        if (line == this.mLayout.getLineCount() - 1) {
            r.bottom += this.getExtendedPaddingBottom();
        }
    }

    private void convertFromViewportToContentCoordinates(Rect r) {
        int horizontalOffset = this.viewportToContentHorizontalOffset();
        r.left += horizontalOffset;
        r.right += horizontalOffset;
        int verticalOffset = this.viewportToContentVerticalOffset();
        r.top += verticalOffset;
        r.bottom += verticalOffset;
    }

    private int viewportToContentHorizontalOffset() {
        return this.getCompoundPaddingLeft() - this.mScrollX;
    }

    private int viewportToContentVerticalOffset() {
        int offset = this.getExtendedPaddingTop() - this.mScrollY;
        if ((this.mGravity & 0x70) != 48) {
            offset += this.getVerticalOffset(false);
        }
        return offset;
    }

    @Override
    public void debug(int depth) {
        super.debug(depth);
        String output = TextView.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        if (this.mText != null) {
            output = output + "mText=\"" + this.mText + "\" ";
            if (this.mLayout != null) {
                output = output + "mLayout width=" + this.mLayout.getWidth() + " height=" + this.mLayout.getHeight();
            }
        } else {
            output = output + "mText=NULL";
        }
        Log.d("View", output);
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionStart() {
        return Selection.getSelectionStart(this.getText());
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionEnd() {
        return Selection.getSelectionEnd(this.getText());
    }

    public boolean hasSelection() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        return selectionStart >= 0 && selectionStart != selectionEnd;
    }

    public void setSingleLine() {
        this.setSingleLine(true);
    }

    public void setAllCaps(boolean allCaps) {
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }

    @RemotableViewMethod
    public void setSingleLine(boolean singleLine) {
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, true, true);
    }

    private void setInputTypeSingleLine(boolean singleLine) {
        if ((this.mInputType & 0xF) == 1) {
            this.mInputType = singleLine ? (this.mInputType &= 0xFFFDFFFF) : (this.mInputType |= 0x20000);
        }
    }

    private void applySingleLine(boolean singleLine, boolean applyTransformation, boolean changeMaxLines) {
        this.mSingleLine = singleLine;
        if (singleLine) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
            if (applyTransformation) {
                this.setTransformationMethod(SingleLineTransformationMethod.getInstance());
            }
        } else {
            if (changeMaxLines) {
                this.setMaxLines(Integer.MAX_VALUE);
            }
            this.setHorizontallyScrolling(false);
            if (applyTransformation) {
                this.setTransformationMethod(null);
            }
        }
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (this.mEllipsize != where) {
            this.mEllipsize = where;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setMarqueeRepeatLimit(int marqueeLimit) {
        this.mMarqueeRepeatLimit = marqueeLimit;
    }

    @ViewDebug.ExportedProperty
    public TextUtils.TruncateAt getEllipsize() {
        return this.mEllipsize;
    }

    @RemotableViewMethod
    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.mSelectAllOnFocus = selectAllOnFocus;
        if (selectAllOnFocus && !(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    @RemotableViewMethod
    public void setCursorVisible(boolean visible) {
        if (this.mCursorVisible != visible) {
            this.mCursorVisible = visible;
            this.invalidate();
            this.makeBlink();
            this.prepareCursorControllers();
        }
    }

    private boolean isCursorVisible() {
        return this.mCursorVisible && this.isTextEditable();
    }

    private boolean canMarquee() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        return width > 0 && (this.mLayout.getLineWidth(0) > (float)width || this.mMarqueeFadeMode != 0 && this.mSavedMarqueeModeLayout != null && this.mSavedMarqueeModeLayout.getLineWidth(0) > (float)width);
    }

    private void startMarquee() {
        if (this.mInput != null) {
            return;
        }
        if (this.compressText(this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) {
            return;
        }
        if ((this.mMarquee == null || this.mMarquee.isStopped()) && (this.isFocused() || this.isSelected()) && this.getLineCount() == 1 && this.canMarquee()) {
            if (this.mMarqueeFadeMode == 1) {
                this.mMarqueeFadeMode = 2;
                Layout tmp = this.mLayout;
                this.mLayout = this.mSavedMarqueeModeLayout;
                this.mSavedMarqueeModeLayout = tmp;
                this.setHorizontalFadingEdgeEnabled(true);
                this.requestLayout();
                this.invalidate();
            }
            if (this.mMarquee == null) {
                this.mMarquee = new Marquee(this);
            }
            this.mMarquee.start(this.mMarqueeRepeatLimit);
        }
    }

    private void stopMarquee() {
        if (this.mMarquee != null && !this.mMarquee.isStopped()) {
            this.mMarquee.stop();
        }
        if (this.mMarqueeFadeMode == 2) {
            this.mMarqueeFadeMode = 1;
            Layout tmp = this.mSavedMarqueeModeLayout;
            this.mSavedMarqueeModeLayout = this.mLayout;
            this.mLayout = tmp;
            this.setHorizontalFadingEdgeEnabled(false);
            this.requestLayout();
            this.invalidate();
        }
    }

    private void startStopMarquee(boolean start) {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (start) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        this.sendAccessibilityEvent(8192);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mListeners != null && (i = this.mListeners.indexOf(watcher)) >= 0) {
            this.mListeners.remove(i);
        }
    }

    private void sendBeforeTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).beforeTextChanged(text, start, before, after);
            }
        }
        this.removeIntersectingSpans(start, start + before, SpellCheckSpan.class);
        this.removeIntersectingSpans(start, start + before, SuggestionSpan.class);
    }

    private <T> void removeIntersectingSpans(int start, int end, Class<T> type) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        T[] spans = text.getSpans(start, end, type);
        int length = spans.length;
        for (int i = 0; i < length; ++i) {
            int s = text.getSpanStart(spans[i]);
            int e = text.getSpanEnd(spans[i]);
            if (e == start || s == end) break;
            text.removeSpan(spans[i]);
        }
    }

    void sendOnTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).onTextChanged(text, start, before, after);
            }
        }
        this.updateSpellCheckSpans(start, start + after, false);
        this.hideCursorControllers();
    }

    void sendAfterTextChanged(Editable text) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).afterTextChanged(text);
            }
        }
    }

    void handleTextChanged(CharSequence buffer, int start, int before, int after) {
        InputMethodState ims = this.mInputMethodState;
        if (ims == null || ims.mBatchEditNesting == 0) {
            this.updateAfterEdit();
        }
        if (ims != null) {
            ims.mContentChanged = true;
            if (ims.mChangedStart < 0) {
                ims.mChangedStart = start;
                ims.mChangedEnd = start + before;
            } else {
                ims.mChangedStart = Math.min(ims.mChangedStart, start);
                ims.mChangedEnd = Math.max(ims.mChangedEnd, start + before - ims.mChangedDelta);
            }
            ims.mChangedDelta += after - before;
        }
        this.sendOnTextChanged(buffer, start, before, after);
        this.onTextChanged(buffer, start, before, after);
    }

    void spanChange(Spanned buf, Object what, int oldStart, int newStart, int oldEnd, int newEnd) {
        boolean selChanged = false;
        int newSelStart = -1;
        int newSelEnd = -1;
        InputMethodState ims = this.mInputMethodState;
        if (what == Selection.SELECTION_END) {
            this.mHighlightPathBogus = true;
            selChanged = true;
            newSelEnd = newStart;
            if (!this.isFocused()) {
                this.mSelectionMoved = true;
            }
            if (oldStart >= 0 || newStart >= 0) {
                this.invalidateCursor(Selection.getSelectionStart(buf), oldStart, newStart);
                this.registerForPreDraw();
                this.makeBlink();
            }
        }
        if (what == Selection.SELECTION_START) {
            this.mHighlightPathBogus = true;
            selChanged = true;
            newSelStart = newStart;
            if (!this.isFocused()) {
                this.mSelectionMoved = true;
            }
            if (oldStart >= 0 || newStart >= 0) {
                int end = Selection.getSelectionEnd(buf);
                this.invalidateCursor(end, oldStart, newStart);
            }
        }
        if (selChanged && (buf.getSpanFlags(what) & 0x200) == 0) {
            if (newSelStart < 0) {
                newSelStart = Selection.getSelectionStart(buf);
            }
            if (newSelEnd < 0) {
                newSelEnd = Selection.getSelectionEnd(buf);
            }
            this.onSelectionChanged(newSelStart, newSelEnd);
        }
        if (what instanceof UpdateAppearance || what instanceof ParagraphStyle) {
            if (ims == null || ims.mBatchEditNesting == 0) {
                this.invalidate();
                this.mHighlightPathBogus = true;
                this.checkForResize();
            } else {
                ims.mContentChanged = true;
            }
        }
        if (MetaKeyKeyListener.isMetaTracker(buf, what)) {
            this.mHighlightPathBogus = true;
            if (ims != null && MetaKeyKeyListener.isSelectingMetaTracker(buf, what)) {
                ims.mSelectionModeChanged = true;
            }
            if (Selection.getSelectionStart(buf) >= 0) {
                if (ims == null || ims.mBatchEditNesting == 0) {
                    this.invalidateCursor();
                } else {
                    ims.mCursorChanged = true;
                }
            }
        }
        if (what instanceof ParcelableSpan && ims != null && ims.mExtracting != null) {
            if (ims.mBatchEditNesting != 0) {
                if (oldStart >= 0) {
                    if (ims.mChangedStart > oldStart) {
                        ims.mChangedStart = oldStart;
                    }
                    if (ims.mChangedStart > oldEnd) {
                        ims.mChangedStart = oldEnd;
                    }
                }
                if (newStart >= 0) {
                    if (ims.mChangedStart > newStart) {
                        ims.mChangedStart = newStart;
                    }
                    if (ims.mChangedStart > newEnd) {
                        ims.mChangedStart = newEnd;
                    }
                }
            } else {
                ims.mContentChanged = true;
            }
        }
        if (this.mSpellChecker != null && newStart < 0 && what instanceof SpellCheckSpan) {
            this.mSpellChecker.removeSpellCheckSpan((SpellCheckSpan)what);
        }
    }

    private void updateSpellCheckSpans(int start, int end, boolean createSpellChecker) {
        if (this.isTextEditable() && this.isSuggestionsEnabled() && !(this instanceof ExtractEditText)) {
            if (this.mSpellChecker == null && createSpellChecker) {
                this.mSpellChecker = new SpellChecker(this);
            }
            if (this.mSpellChecker != null) {
                this.mSpellChecker.spellCheck(start, end);
            }
        }
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        this.mDispatchTemporaryDetach = true;
        super.dispatchFinishTemporaryDetach();
        this.mDispatchTemporaryDetach = false;
    }

    @Override
    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (!this.mDispatchTemporaryDetach) {
            this.mTemporaryDetach = true;
        }
        this.hideControllers();
    }

    @Override
    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (!this.mDispatchTemporaryDetach) {
            this.mTemporaryDetach = false;
        }
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.mTemporaryDetach) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            return;
        }
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (focused) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            boolean isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mText.length();
            boolean bl = this.mCreatedWithASelection = this.mFrozenWithFocus && this.hasSelection() && !isFocusHighlighted;
            if (!this.mFrozenWithFocus || selStart < 0 || selEnd < 0) {
                int lastTapPosition = this.getLastTapPosition();
                if (lastTapPosition >= 0) {
                    Selection.setSelection((Spannable)this.mText, lastTapPosition);
                }
                if (this.mMovement != null) {
                    this.mMovement.onTakeFocus(this, (Spannable)this.mText, direction);
                }
                if ((this instanceof ExtractEditText || this.mSelectionMoved) && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mText, selStart, selEnd);
                }
                if (this.mSelectAllOnFocus) {
                    this.selectAll();
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mText instanceof Spannable) {
                Spannable sp = (Spannable)this.mText;
                MetaKeyKeyListener.resetMetaState(sp);
            }
            this.makeBlink();
            if (this.mError != null) {
                this.showError();
            }
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.onEndBatchEdit();
            if (this instanceof ExtractEditText) {
                int selStart = this.getSelectionStart();
                int selEnd = this.getSelectionEnd();
                this.hideControllers();
                Selection.setSelection((Spannable)this.mText, selStart, selEnd);
            } else {
                this.hideControllers();
                this.downgradeEasyCorrectionSpans();
            }
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.resetTouchOffsets();
            }
        }
        this.startStopMarquee(focused);
        if (this.mTransformation != null) {
            this.mTransformation.onFocusChanged(this, this.mText, focused, direction, previouslyFocusedRect);
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    private int getLastTapPosition() {
        int lastTapPosition;
        if (this.mSelectionModifierCursorController != null && (lastTapPosition = this.mSelectionModifierCursorController.getMinTouchOffset()) >= 0) {
            if (lastTapPosition > this.mText.length()) {
                Log.e(LOG_TAG, "Invalid tap focus position (" + lastTapPosition + " vs " + this.mText.length() + ")");
                lastTapPosition = this.mText.length();
            }
            return lastTapPosition;
        }
        return -1;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                this.makeBlink();
            }
        } else {
            if (this.mBlink != null) {
                this.mBlink.cancel();
            }
            this.onEndBatchEdit();
            if (this.mInputContentType != null) {
                this.mInputContentType.enterDown = false;
            }
            this.hideControllers();
            if (this.mSuggestionsPopupWindow != null) {
                this.mSuggestionsPopupWindow.onParentLostFocus();
            }
        }
        this.startStopMarquee(hasWindowFocus);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.hideControllers();
        }
    }

    public void clearComposingText() {
        if (this.mText instanceof Spannable) {
            BaseInputConnection.removeComposingSpans((Spannable)this.mText);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        boolean wasSelected = this.isSelected();
        super.setSelected(selected);
        if (selected != wasSelected && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (selected) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        boolean touchIsFinished;
        int action = event.getActionMasked();
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(event);
        }
        if (action == 0) {
            this.mLastDownPositionX = event.getX();
            this.mLastDownPositionY = event.getY();
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
        boolean superResult = super.onTouchEvent(event);
        if (this.mDiscardNextActionUp && action == 1) {
            this.mDiscardNextActionUp = false;
            return superResult;
        }
        boolean bl = touchIsFinished = action == 1 && !this.shouldIgnoreActionUpEvent() && this.isFocused();
        if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.isEnabled() && this.mText instanceof Spannable && this.mLayout != null) {
            ClickableSpan[] links;
            boolean handled = false;
            if (this.mMovement != null) {
                handled |= this.mMovement.onTouchEvent(this, (Spannable)this.mText, event);
            }
            if (touchIsFinished && this.mLinksClickable && this.mAutoLinkMask != 0 && this.mTextIsSelectable && (links = ((Spannable)this.mText).getSpans(this.getSelectionStart(), this.getSelectionEnd(), ClickableSpan.class)).length != 0) {
                links[0].onClick(this);
                handled = true;
            }
            if (touchIsFinished && (this.isTextEditable() || this.mTextIsSelectable)) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                this.viewClicked(imm);
                if (!this.mTextIsSelectable && this.mSoftInputShownOnFocus) {
                    handled |= imm != null && imm.showSoftInput(this, 0);
                }
                boolean selectAllGotFocus = this.mSelectAllOnFocus && this.didTouchFocusSelect();
                this.hideControllers();
                if (!selectAllGotFocus && this.mText.length() > 0) {
                    if (this.mSpellChecker != null) {
                        this.mSpellChecker.onSelectionChanged();
                    }
                    if (!this.extractedTextModeWillBeStarted()) {
                        if (this.isCursorInsideEasyCorrectionSpan()) {
                            this.showSuggestions();
                        } else if (this.hasInsertionController()) {
                            this.getInsertionController().show();
                        }
                    }
                }
                handled = true;
            }
            if (handled) {
                return true;
            }
        }
        return superResult;
    }

    private boolean isCursorInsideSuggestionSpan() {
        if (!(this.mText instanceof Spannable)) {
            return false;
        }
        SuggestionSpan[] suggestionSpans = ((Spannable)this.mText).getSpans(this.getSelectionStart(), this.getSelectionEnd(), SuggestionSpan.class);
        return suggestionSpans.length > 0;
    }

    private boolean isCursorInsideEasyCorrectionSpan() {
        Spannable spannable = (Spannable)this.mText;
        SuggestionSpan[] suggestionSpans = spannable.getSpans(this.getSelectionStart(), this.getSelectionEnd(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            if ((suggestionSpans[i].getFlags() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    private void downgradeEasyCorrectionSpans() {
        if (this.mText instanceof Spannable) {
            Spannable spannable = (Spannable)this.mText;
            SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
            for (int i = 0; i < suggestionSpans.length; ++i) {
                int flags = suggestionSpans[i].getFlags();
                if ((flags & 1) == 0 || (flags & 2) != 0) continue;
                suggestionSpans[i].setFlags(flags &= 0xFFFFFFFE);
            }
        }
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null) {
            try {
                if (this.mMovement.onGenericMotionEvent(this, (Spannable)this.mText, event)) {
                    return true;
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private void prepareCursorControllers() {
        boolean windowSupportsHandles = false;
        ViewGroup.LayoutParams params = this.getRootView().getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            windowSupportsHandles = windowParams.type < 1000 || windowParams.type > 1999;
        }
        this.mInsertionControllerEnabled = windowSupportsHandles && this.isCursorVisible() && this.mLayout != null;
        boolean bl = this.mSelectionControllerEnabled = windowSupportsHandles && this.textCanBeSelected() && this.mLayout != null;
        if (!this.mInsertionControllerEnabled) {
            this.hideInsertionPointCursorController();
            if (this.mInsertionPointCursorController != null) {
                this.mInsertionPointCursorController.onDetached();
                this.mInsertionPointCursorController = null;
            }
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopSelectionActionMode();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.onDetached();
                this.mSelectionModifierCursorController = null;
            }
        }
    }

    private boolean isTextEditable() {
        return this.mText instanceof Editable && this.onCheckIsTextEditor() && this.isEnabled();
    }

    public boolean didTouchFocusSelect() {
        return this.mTouchFocusSelected;
    }

    @Override
    public void cancelLongPress() {
        super.cancelLongPress();
        this.mIgnoreActionUpEvent = true;
    }

    public boolean shouldIgnoreActionUpEvent() {
        return this.mIgnoreActionUpEvent;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null && this.mMovement.onTrackballEvent(this, (Spannable)this.mText, event)) {
            return true;
        }
        return super.onTrackballEvent(event);
    }

    public void setScroller(Scroller s) {
        this.mScroller = s;
    }

    private boolean shouldBlink() {
        if (!this.isFocused()) {
            return false;
        }
        int start = this.getSelectionStart();
        if (start < 0) {
            return false;
        }
        int end = this.getSelectionEnd();
        if (end < 0) {
            return false;
        }
        return start == end;
    }

    private void makeBlink() {
        if (this.isCursorVisible()) {
            if (this.shouldBlink()) {
                this.mShowCursor = SystemClock.uptimeMillis();
                if (this.mBlink == null) {
                    this.mBlink = new Blink(this);
                }
                this.mBlink.removeCallbacks(this.mBlink);
                this.mBlink.postAtTime(this.mBlink, this.mShowCursor + 500L);
            }
        } else if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
    }

    @Override
    protected float getLeftFadingEdgeStrength() {
        if ((float)this.mCurrentAlpha <= 5.2916665f) {
            return 0.0f;
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1) {
            if (this.mMarquee != null && !this.mMarquee.isStopped()) {
                Marquee marquee = this.mMarquee;
                if (marquee.shouldDrawLeftFade()) {
                    return marquee.mScroll / (float)this.getHorizontalFadingEdgeLength();
                }
                return 0.0f;
            }
            if (this.getLineCount() == 1) {
                int layoutDirection = this.getResolvedLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
                switch (absoluteGravity & 7) {
                    case 3: {
                        return 0.0f;
                    }
                    case 5: {
                        return (this.mLayout.getLineRight(0) - (float)(this.mRight - this.mLeft) - (float)this.getCompoundPaddingLeft() - (float)this.getCompoundPaddingRight() - this.mLayout.getLineLeft(0)) / (float)this.getHorizontalFadingEdgeLength();
                    }
                    case 1: {
                        return 0.0f;
                    }
                }
            }
        }
        return super.getLeftFadingEdgeStrength();
    }

    @Override
    protected float getRightFadingEdgeStrength() {
        if ((float)this.mCurrentAlpha <= 5.2916665f) {
            return 0.0f;
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1) {
            if (this.mMarquee != null && !this.mMarquee.isStopped()) {
                Marquee marquee = this.mMarquee;
                return (marquee.mMaxFadeScroll - marquee.mScroll) / (float)this.getHorizontalFadingEdgeLength();
            }
            if (this.getLineCount() == 1) {
                int layoutDirection = this.getResolvedLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
                switch (absoluteGravity & 7) {
                    case 3: {
                        int textWidth = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
                        float lineWidth = this.mLayout.getLineWidth(0);
                        return (lineWidth - (float)textWidth) / (float)this.getHorizontalFadingEdgeLength();
                    }
                    case 5: {
                        return 0.0f;
                    }
                    case 1: 
                    case 7: {
                        return (this.mLayout.getLineWidth(0) - (float)(this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) / (float)this.getHorizontalFadingEdgeLength();
                    }
                }
            }
        }
        return super.getRightFadingEdgeStrength();
    }

    @Override
    protected int computeHorizontalScrollRange() {
        if (this.mLayout != null) {
            return this.mSingleLine && (this.mGravity & 7) == 3 ? (int)this.mLayout.getLineWidth(0) : this.mLayout.getWidth();
        }
        return super.computeHorizontalScrollRange();
    }

    @Override
    protected int computeVerticalScrollRange() {
        if (this.mLayout != null) {
            return this.mLayout.getHeight();
        }
        return super.computeVerticalScrollRange();
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return this.getHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
    }

    @Override
    public void findViewsWithText(ArrayList<View> outViews, CharSequence searched, int flags) {
        super.findViewsWithText(outViews, searched, flags);
        if (!(outViews.contains(this) || (flags & 1) == 0 || TextUtils.isEmpty(searched) || TextUtils.isEmpty(this.mText))) {
            String searchedLowerCase = ((Object)searched).toString().toLowerCase();
            String textLowerCase = ((Object)this.mText).toString().toLowerCase();
            if (textLowerCase.contains(searchedLowerCase)) {
                outViews.add(this);
            }
        }
    }

    public static ColorStateList getTextColors(Context context, TypedArray attrs) {
        int ap;
        ColorStateList colors = attrs.getColorStateList(5);
        if (colors == null && (ap = attrs.getResourceId(1, -1)) != -1) {
            TypedArray appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
            colors = appearance.getColorStateList(3);
            appearance.recycle();
        }
        return colors;
    }

    public static int getTextColor(Context context, TypedArray attrs, int def) {
        ColorStateList colors = TextView.getTextColors(context, attrs);
        if (colors == null) {
            return def;
        }
        return colors.getDefaultColor();
    }

    @Override
    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        int filteredMetaState = event.getMetaState() & 0xFFFF8FFF;
        if (KeyEvent.metaStateHasNoModifiers(filteredMetaState)) {
            switch (keyCode) {
                case 29: {
                    if (!this.canSelectText()) break;
                    return this.onTextContextMenuItem(16908319);
                }
                case 52: {
                    if (!this.canCut()) break;
                    return this.onTextContextMenuItem(0x1020020);
                }
                case 31: {
                    if (!this.canCopy()) break;
                    return this.onTextContextMenuItem(0x1020021);
                }
                case 50: {
                    if (!this.canPaste()) break;
                    return this.onTextContextMenuItem(0x1020022);
                }
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    private boolean canSelectText() {
        return this.hasSelectionController() && this.mText.length() != 0;
    }

    private boolean textCanBeSelected() {
        if (this.mMovement == null || !this.mMovement.canSelectArbitrarily()) {
            return false;
        }
        return this.isTextEditable() || this.mTextIsSelectable && this.mText instanceof Spannable && this.isEnabled();
    }

    private boolean canCut() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mText instanceof Editable && this.mInput != null;
    }

    private boolean canCopy() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection();
    }

    private boolean canPaste() {
        return this.mText instanceof Editable && this.mInput != null && this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0 && ((ClipboardManager)this.getContext().getSystemService("clipboard")).hasPrimaryClip();
    }

    private static long packRangeInLong(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    private static int extractRangeStartFromLong(long range) {
        return (int)(range >>> 32);
    }

    private static int extractRangeEndFromLong(long range) {
        return (int)(range & 0xFFFFFFFFL);
    }

    private boolean selectAll() {
        int length = this.mText.length();
        Selection.setSelection((Spannable)this.mText, 0, length);
        return length > 0;
    }

    private boolean selectCurrentWord() {
        int selectionEnd;
        int selectionStart;
        if (!this.canSelectText()) {
            return false;
        }
        if (this.hasPasswordTransformationMethod()) {
            return this.selectAll();
        }
        int klass = this.mInputType & 0xF;
        int variation = this.mInputType & 0xFF0;
        if (klass == 2 || klass == 3 || klass == 4 || variation == 16 || variation == 32 || variation == 208 || variation == 176) {
            return this.selectAll();
        }
        long lastTouchOffsets = this.getLastTouchOffsets();
        int minOffset = TextView.extractRangeStartFromLong(lastTouchOffsets);
        int maxOffset = TextView.extractRangeEndFromLong(lastTouchOffsets);
        if (minOffset < 0 || minOffset >= this.mText.length()) {
            return false;
        }
        if (maxOffset < 0 || maxOffset >= this.mText.length()) {
            return false;
        }
        URLSpan[] urlSpans = ((Spanned)this.mText).getSpans(minOffset, maxOffset, URLSpan.class);
        if (urlSpans.length >= 1) {
            URLSpan urlSpan = urlSpans[0];
            selectionStart = ((Spanned)this.mText).getSpanStart(urlSpan);
            selectionEnd = ((Spanned)this.mText).getSpanEnd(urlSpan);
        } else {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mText, minOffset, maxOffset);
            selectionStart = wordIterator.getBeginning(minOffset);
            if (selectionStart == -1) {
                return false;
            }
            selectionEnd = wordIterator.getEnd(maxOffset);
            if (selectionEnd == -1) {
                return false;
            }
            if (selectionStart == selectionEnd) {
                long range = this.getCharRange(selectionStart);
                selectionStart = TextView.extractRangeStartFromLong(range);
                selectionEnd = TextView.extractRangeEndFromLong(range);
            }
        }
        Selection.setSelection((Spannable)this.mText, selectionStart, selectionEnd);
        return selectionEnd > selectionStart;
    }

    public Locale getTextServicesLocale() {
        Locale locale = Locale.getDefault();
        TextServicesManager textServicesManager = (TextServicesManager)this.mContext.getSystemService("textservices");
        SpellCheckerSubtype subtype = textServicesManager.getCurrentSpellCheckerSubtype(true);
        if (subtype != null) {
            locale = new Locale(subtype.getLocale());
        }
        return locale;
    }

    void onLocaleChanged() {
        this.mWordIterator = null;
    }

    public WordIterator getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.getTextServicesLocale());
        }
        return this.mWordIterator;
    }

    private long getCharRange(int offset) {
        char nextChar;
        char currentChar;
        int textLength = this.mText.length();
        if (offset + 1 < textLength && Character.isSurrogatePair(currentChar = this.mText.charAt(offset), nextChar = this.mText.charAt(offset + 1))) {
            return TextView.packRangeInLong(offset, offset + 2);
        }
        if (offset < textLength) {
            return TextView.packRangeInLong(offset, offset + 1);
        }
        if (offset - 2 >= 0) {
            char previousChar = this.mText.charAt(offset - 1);
            char previousPreviousChar = this.mText.charAt(offset - 2);
            if (Character.isSurrogatePair(previousPreviousChar, previousChar)) {
                return TextView.packRangeInLong(offset - 2, offset);
            }
        }
        if (offset - 1 >= 0) {
            return TextView.packRangeInLong(offset - 1, offset);
        }
        return TextView.packRangeInLong(offset, offset);
    }

    private long getLastTouchOffsets() {
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return TextView.packRangeInLong(minOffset, maxOffset);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        CharSequence text;
        super.onPopulateAccessibilityEvent(event);
        boolean isPassword = this.hasPasswordTransformationMethod();
        if (!isPassword && !TextUtils.isEmpty(text = this.getTextForAccessibility())) {
            event.getText().add(text);
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        boolean isPassword = this.hasPasswordTransformationMethod();
        event.setPassword(isPassword);
        if (event.getEventType() == 8192) {
            event.setFromIndex(Selection.getSelectionStart(this.mText));
            event.setToIndex(Selection.getSelectionEnd(this.mText));
            event.setItemCount(this.mText.length());
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        boolean isPassword = this.hasPasswordTransformationMethod();
        if (!isPassword) {
            info.setText(this.getTextForAccessibility());
        }
        info.setPassword(isPassword);
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (eventType == 4096) {
            return;
        }
        super.sendAccessibilityEvent(eventType);
    }

    private CharSequence getTextForAccessibility() {
        CharSequence text = this.getText();
        if (TextUtils.isEmpty(text)) {
            text = this.getHint();
        }
        return text;
    }

    void sendAccessibilityEventTypeViewTextChanged(CharSequence beforeText, int fromIndex, int removedCount, int addedCount) {
        AccessibilityEvent event = AccessibilityEvent.obtain(16);
        event.setFromIndex(fromIndex);
        event.setRemovedCount(removedCount);
        event.setAddedCount(addedCount);
        event.setBeforeText(beforeText);
        this.sendAccessibilityEventUnchecked(event);
    }

    public boolean isInputMethodTarget() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        return imm != null && imm.isActive(this);
    }

    public boolean onTextContextMenuItem(int id2) {
        int min = 0;
        int max = this.mText.length();
        if (this.isFocused()) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            min = Math.max(0, Math.min(selStart, selEnd));
            max = Math.max(0, Math.max(selStart, selEnd));
        }
        switch (id2) {
            case 16908319: {
                this.selectAll();
                return true;
            }
            case 0x1020022: {
                this.paste(min, max);
                return true;
            }
            case 0x1020020: {
                this.setPrimaryClip(ClipData.newPlainText(null, this.getTransformedText(min, max)));
                this.deleteText_internal(min, max);
                this.stopSelectionActionMode();
                return true;
            }
            case 0x1020021: {
                this.setPrimaryClip(ClipData.newPlainText(null, this.getTransformedText(min, max)));
                this.stopSelectionActionMode();
                return true;
            }
        }
        return false;
    }

    private CharSequence getTransformedText(int start, int end) {
        return this.removeSuggestionSpans(this.mTransformed.subSequence(start, end));
    }

    private long prepareSpacesAroundPaste(int min, int max, CharSequence paste) {
        if (paste.length() > 0) {
            char charAfter;
            char charBefore;
            if (min > 0) {
                charBefore = this.mTransformed.charAt(min - 1);
                charAfter = paste.charAt(0);
                if (Character.isSpaceChar(charBefore) && Character.isSpaceChar(charAfter)) {
                    int originalLength = this.mText.length();
                    this.deleteText_internal(min - 1, min);
                    int delta = this.mText.length() - originalLength;
                    min += delta;
                    max += delta;
                } else if (!Character.isSpaceChar(charBefore) && charBefore != '\n' && !Character.isSpaceChar(charAfter) && charAfter != '\n') {
                    int originalLength = this.mText.length();
                    this.replaceText_internal(min, min, " ");
                    int delta = this.mText.length() - originalLength;
                    min += delta;
                    max += delta;
                }
            }
            if (max < this.mText.length()) {
                charBefore = paste.charAt(paste.length() - 1);
                charAfter = this.mTransformed.charAt(max);
                if (Character.isSpaceChar(charBefore) && Character.isSpaceChar(charAfter)) {
                    this.deleteText_internal(max, max + 1);
                } else if (!Character.isSpaceChar(charBefore) && charBefore != '\n' && !Character.isSpaceChar(charAfter) && charAfter != '\n') {
                    this.replaceText_internal(max, max, " ");
                }
            }
        }
        return TextView.packRangeInLong(min, max);
    }

    private View.DragShadowBuilder getTextThumbnailBuilder(CharSequence text) {
        TextView shadowView = (TextView)TextView.inflate(this.mContext, 17367199, null);
        if (shadowView == null) {
            throw new IllegalArgumentException("Unable to inflate text drag thumbnail");
        }
        if (text.length() > DRAG_SHADOW_MAX_TEXT_LENGTH) {
            text = text.subSequence(0, DRAG_SHADOW_MAX_TEXT_LENGTH);
        }
        shadowView.setText(text);
        shadowView.setTextColor(this.getTextColors());
        shadowView.setTextAppearance(this.mContext, 16);
        shadowView.setGravity(17);
        shadowView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int size = View.MeasureSpec.makeMeasureSpec(0, 0);
        shadowView.measure(size, size);
        shadowView.layout(0, 0, shadowView.getMeasuredWidth(), shadowView.getMeasuredHeight());
        shadowView.invalidate();
        return new View.DragShadowBuilder(shadowView);
    }

    @Override
    public boolean performLongClick() {
        boolean handled = false;
        boolean vibrate = true;
        if (super.performLongClick()) {
            this.mDiscardNextActionUp = true;
            handled = true;
        }
        if (!handled && !this.isPositionOnText(this.mLastDownPositionX, this.mLastDownPositionY) && this.mInsertionControllerEnabled) {
            int offset = this.getOffsetForPosition(this.mLastDownPositionX, this.mLastDownPositionY);
            this.stopSelectionActionMode();
            Selection.setSelection((Spannable)this.mText, offset);
            this.getInsertionController().showWithActionPopup();
            handled = true;
            vibrate = false;
        }
        if (!handled && this.mSelectionActionMode != null) {
            if (this.touchPositionIsInSelection()) {
                int start = this.getSelectionStart();
                int end = this.getSelectionEnd();
                CharSequence selectedText = this.getTransformedText(start, end);
                ClipData data = ClipData.newPlainText(null, selectedText);
                DragLocalState localState = new DragLocalState(this, start, end);
                this.startDrag(data, this.getTextThumbnailBuilder(selectedText), localState, 0);
                this.stopSelectionActionMode();
            } else {
                this.getSelectionController().hide();
                this.selectCurrentWord();
                this.getSelectionController().show();
            }
            handled = true;
        }
        if (!handled) {
            vibrate = handled = this.startSelectionActionMode();
        }
        if (vibrate) {
            this.performHapticFeedback(0);
        }
        if (handled) {
            this.mDiscardNextActionUp = true;
        }
        return handled;
    }

    private boolean touchPositionIsInSelection() {
        int selectionEnd;
        int selectionStart = this.getSelectionStart();
        if (selectionStart == (selectionEnd = this.getSelectionEnd())) {
            return false;
        }
        if (selectionStart > selectionEnd) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
            Selection.setSelection((Spannable)this.mText, selectionStart, selectionEnd);
        }
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return minOffset >= selectionStart && maxOffset < selectionEnd;
    }

    private PositionListener getPositionListener() {
        if (this.mPositionListener == null) {
            this.mPositionListener = new PositionListener();
        }
        return this.mPositionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPositionVisible(int positionX, int positionY) {
        float[] fArray = sTmpPosition;
        synchronized (sTmpPosition) {
            float[] position = sTmpPosition;
            position[0] = positionX;
            position[1] = positionY;
            View view = this;
            while (view != null) {
                if (view != this) {
                    position[0] = position[0] - (float)view.getScrollX();
                    position[1] = position[1] - (float)view.getScrollY();
                }
                if (position[0] < 0.0f || position[1] < 0.0f || position[0] > (float)view.getWidth() || position[1] > (float)view.getHeight()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (!view.getMatrix().isIdentity()) {
                    view.getMatrix().mapPoints(position);
                }
                position[0] = position[0] + (float)view.getLeft();
                position[1] = position[1] + (float)view.getTop();
                ViewParent parent = view.getParent();
                if (parent instanceof View) {
                    view = (View)((Object)parent);
                    continue;
                }
                view = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private boolean isOffsetVisible(int offset) {
        int line = this.mLayout.getLineForOffset(offset);
        int lineBottom = this.mLayout.getLineBottom(line);
        int primaryHorizontal = (int)this.mLayout.getPrimaryHorizontal(offset);
        return this.isPositionVisible(primaryHorizontal + this.viewportToContentHorizontalOffset(), lineBottom + this.viewportToContentVerticalOffset());
    }

    @Override
    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        if (this.mPositionListener != null) {
            this.mPositionListener.onScrollChanged();
        }
    }

    CharSequence removeSuggestionSpans(CharSequence text) {
        if (text instanceof Spanned) {
            Spannable spannable;
            if (text instanceof Spannable) {
                spannable = (Spannable)text;
            } else {
                spannable = new SpannableString(text);
                text = spannable;
            }
            SuggestionSpan[] spans = spannable.getSpans(0, text.length(), SuggestionSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                spannable.removeSpan(spans[i]);
            }
        }
        return text;
    }

    void showSuggestions() {
        if (this.mSuggestionsPopupWindow == null) {
            this.mSuggestionsPopupWindow = new SuggestionsPopupWindow();
        }
        this.hideControllers();
        this.mSuggestionsPopupWindow.show();
    }

    boolean areSuggestionsShown() {
        return this.mSuggestionsPopupWindow != null && this.mSuggestionsPopupWindow.isShowing();
    }

    public boolean isSuggestionsEnabled() {
        if ((this.mInputType & 0xF) != 1) {
            return false;
        }
        if ((this.mInputType & 0x80000) > 0) {
            return false;
        }
        int variation = this.mInputType & 0xFF0;
        return variation == 0 || variation == 48 || variation == 80 || variation == 64 || variation == 160;
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback actionModeCallback) {
        this.mCustomSelectionActionModeCallback = actionModeCallback;
    }

    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return this.mCustomSelectionActionModeCallback;
    }

    private boolean startSelectionActionMode() {
        InputMethodManager imm;
        boolean selectionStarted;
        if (this.mSelectionActionMode != null) {
            return false;
        }
        if (!this.canSelectText() || !this.requestFocus()) {
            Log.w(LOG_TAG, "TextView does not support text selection. Action mode cancelled.");
            return false;
        }
        if (!this.hasSelection() && !this.selectCurrentWord()) {
            return false;
        }
        boolean willExtract = this.extractedTextModeWillBeStarted();
        if (!willExtract) {
            SelectionActionModeCallback actionModeCallback = new SelectionActionModeCallback();
            this.mSelectionActionMode = this.startActionMode(actionModeCallback);
        }
        boolean bl = selectionStarted = this.mSelectionActionMode != null || willExtract;
        if (selectionStarted && !this.mTextIsSelectable && this.mSoftInputShownOnFocus && (imm = InputMethodManager.peekInstance()) != null) {
            imm.showSoftInput(this, 0, null);
        }
        return selectionStarted;
    }

    private boolean extractedTextModeWillBeStarted() {
        if (!(this instanceof ExtractEditText)) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            return imm != null && imm.isFullscreenMode();
        }
        return false;
    }

    private void stopSelectionActionMode() {
        if (this.mSelectionActionMode != null) {
            this.mSelectionActionMode.finish();
        }
    }

    private void paste(int min, int max) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null) {
            boolean didFirst = false;
            for (int i = 0; i < clip.getItemCount(); ++i) {
                CharSequence paste = clip.getItemAt(i).coerceToText(this.getContext());
                if (paste == null) continue;
                if (!didFirst) {
                    long minMax = this.prepareSpacesAroundPaste(min, max, paste);
                    min = TextView.extractRangeStartFromLong(minMax);
                    max = TextView.extractRangeEndFromLong(minMax);
                    Selection.setSelection((Spannable)this.mText, max);
                    ((Editable)this.mText).replace(min, max, paste);
                    didFirst = true;
                    continue;
                }
                ((Editable)this.mText).insert(this.getSelectionEnd(), "\n");
                ((Editable)this.mText).insert(this.getSelectionEnd(), paste);
            }
            this.stopSelectionActionMode();
            sLastCutOrCopyTime = 0L;
        }
    }

    private void setPrimaryClip(ClipData clip) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(clip);
        sLastCutOrCopyTime = SystemClock.uptimeMillis();
    }

    private void hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    private void hideControllers() {
        this.hideCursorControllers();
        this.hideSpanControllers();
    }

    private void hideSpanControllers() {
        if (this.mChangeWatcher != null) {
            this.mChangeWatcher.hideControllers();
        }
    }

    private void hideCursorControllers() {
        if (this.mSuggestionsPopupWindow != null && !this.mSuggestionsPopupWindow.isShowingUp()) {
            this.mSuggestionsPopupWindow.hide();
        }
        this.hideInsertionPointCursorController();
        this.stopSelectionActionMode();
    }

    public int getOffsetForPosition(float x, float y) {
        if (this.getLayout() == null) {
            return -1;
        }
        int line = this.getLineAtCoordinate(y);
        int offset = this.getOffsetAtCoordinate(line, x);
        return offset;
    }

    private float convertToLocalHorizontalCoordinate(float x) {
        x -= (float)this.getTotalPaddingLeft();
        x = Math.max(0.0f, x);
        x = Math.min((float)(this.getWidth() - this.getTotalPaddingRight() - 1), x);
        return x += (float)this.getScrollX();
    }

    private int getLineAtCoordinate(float y) {
        y -= (float)this.getTotalPaddingTop();
        y = Math.max(0.0f, y);
        y = Math.min((float)(this.getHeight() - this.getTotalPaddingBottom() - 1), y);
        return this.getLayout().getLineForVertical((int)(y += (float)this.getScrollY()));
    }

    private int getOffsetAtCoordinate(int line, float x) {
        x = this.convertToLocalHorizontalCoordinate(x);
        return this.getLayout().getOffsetForHorizontal(line, x);
    }

    private boolean isPositionOnText(float x, float y) {
        if (this.getLayout() == null) {
            return false;
        }
        int line = this.getLineAtCoordinate(y);
        if ((x = this.convertToLocalHorizontalCoordinate(x)) < this.getLayout().getLineLeft(line)) {
            return false;
        }
        return !(x > this.getLayout().getLineRight(line));
    }

    @Override
    public boolean onDragEvent(DragEvent event) {
        switch (event.getAction()) {
            case 1: {
                return this.hasInsertionController();
            }
            case 5: {
                this.requestFocus();
                return true;
            }
            case 2: {
                int offset = this.getOffsetForPosition(event.getX(), event.getY());
                Selection.setSelection((Spannable)this.mText, offset);
                return true;
            }
            case 3: {
                this.onDrop(event);
                return true;
            }
        }
        return true;
    }

    private void onDrop(DragEvent event) {
        boolean dragDropIntoItself;
        StringBuilder content = new StringBuilder("");
        ClipData clipData = event.getClipData();
        int itemCount = clipData.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            ClipData.Item item = clipData.getItemAt(i);
            content.append(item.coerceToText(this.mContext));
        }
        int offset = this.getOffsetForPosition(event.getX(), event.getY());
        Object localState = event.getLocalState();
        DragLocalState dragLocalState = null;
        if (localState instanceof DragLocalState) {
            dragLocalState = (DragLocalState)localState;
        }
        boolean bl = dragDropIntoItself = dragLocalState != null && dragLocalState.sourceTextView == this;
        if (dragDropIntoItself && offset >= dragLocalState.start && offset < dragLocalState.end) {
            return;
        }
        int originalLength = this.mText.length();
        long minMax = this.prepareSpacesAroundPaste(offset, offset, content);
        int min = TextView.extractRangeStartFromLong(minMax);
        int max = TextView.extractRangeEndFromLong(minMax);
        Selection.setSelection((Spannable)this.mText, max);
        this.replaceText_internal(min, max, content);
        if (dragDropIntoItself) {
            int dragSourceStart = dragLocalState.start;
            int dragSourceEnd = dragLocalState.end;
            if (max <= dragSourceStart) {
                int shift = this.mText.length() - originalLength;
                dragSourceStart += shift;
                dragSourceEnd += shift;
            }
            this.deleteText_internal(dragSourceStart, dragSourceEnd);
            if ((dragSourceStart == 0 || Character.isSpaceChar(this.mTransformed.charAt(dragSourceStart - 1))) && (dragSourceStart == this.mText.length() || Character.isSpaceChar(this.mTransformed.charAt(dragSourceStart)))) {
                int pos = dragSourceStart == this.mText.length() ? dragSourceStart - 1 : dragSourceStart;
                this.deleteText_internal(pos, pos + 1);
            }
        }
    }

    boolean hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    boolean hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    InsertionPointCursorController getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController();
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        return this.mInsertionPointCursorController;
    }

    SelectionModifierCursorController getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController();
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        return this.mSelectionModifierCursorController;
    }

    boolean isInBatchEditMode() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null) {
            return ims.mBatchEditNesting > 0;
        }
        return this.mInBatchEditControllers;
    }

    @Override
    protected void resolveTextDirection() {
        if (this.hasPasswordTransformationMethod()) {
            this.mTextDir = TextDirectionHeuristics.LOCALE;
            return;
        }
        boolean defaultIsRtl = this.getResolvedLayoutDirection() == 0x40000000;
        super.resolveTextDirection();
        int textDir = this.getResolvedTextDirection();
        switch (textDir) {
            default: {
                this.mTextDir = defaultIsRtl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
                break;
            }
            case 2: {
                this.mTextDir = TextDirectionHeuristics.ANYRTL_LTR;
                break;
            }
            case 3: {
                this.mTextDir = TextDirectionHeuristics.LTR;
                break;
            }
            case 4: {
                this.mTextDir = TextDirectionHeuristics.RTL;
            }
        }
    }

    protected void resolveDrawables() {
        if (this.mResolvedDrawables) {
            return;
        }
        if (this.mDrawables == null) {
            return;
        }
        if (this.mDrawables.mDrawableStart == null && this.mDrawables.mDrawableEnd == null) {
            this.mResolvedDrawables = true;
            return;
        }
        Drawables dr = this.mDrawables;
        switch (this.getResolvedLayoutDirection()) {
            case 0x40000000: {
                if (dr.mDrawableStart != null) {
                    dr.mDrawableRight = dr.mDrawableStart;
                    dr.mDrawableSizeRight = dr.mDrawableSizeStart;
                    dr.mDrawableHeightRight = dr.mDrawableHeightStart;
                }
                if (dr.mDrawableEnd == null) break;
                dr.mDrawableLeft = dr.mDrawableEnd;
                dr.mDrawableSizeLeft = dr.mDrawableSizeEnd;
                dr.mDrawableHeightLeft = dr.mDrawableHeightEnd;
                break;
            }
            default: {
                if (dr.mDrawableStart != null) {
                    dr.mDrawableLeft = dr.mDrawableStart;
                    dr.mDrawableSizeLeft = dr.mDrawableSizeStart;
                    dr.mDrawableHeightLeft = dr.mDrawableHeightStart;
                }
                if (dr.mDrawableEnd == null) break;
                dr.mDrawableRight = dr.mDrawableEnd;
                dr.mDrawableSizeRight = dr.mDrawableSizeEnd;
                dr.mDrawableHeightRight = dr.mDrawableHeightEnd;
            }
        }
        this.mResolvedDrawables = true;
    }

    protected void resetResolvedDrawables() {
        this.mResolvedDrawables = false;
    }

    protected void viewClicked(InputMethodManager imm) {
        if (imm != null) {
            imm.viewClicked(this);
        }
    }

    protected void deleteText_internal(int start, int end) {
        ((Editable)this.mText).delete(start, end);
    }

    protected void replaceText_internal(int start, int end, CharSequence text) {
        ((Editable)this.mText).replace(start, end, text);
    }

    protected void setSpan_internal(Object span, int start, int end, int flags) {
        ((Editable)this.mText).setSpan(span, start, end, flags);
    }

    protected void setCursorPosition_internal(int start, int end) {
        Selection.setSelection((Editable)this.mText, start, end);
    }

    static {
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.measureText("H");
        UNKNOWN_BORING = new BoringLayout.Metrics();
        sTempRect = new RectF();
        sTmpPosition = new float[2];
        NO_FILTERS = new InputFilter[0];
        EMPTY_SPANNED = new SpannedString("");
        DRAG_SHADOW_MAX_TEXT_LENGTH = 20;
        MULTILINE_STATE_SET = new int[]{16843597};
    }

    private class SelectionModifierCursorController
    implements CursorController {
        private static final int DELAY_BEFORE_REPLACE_ACTION = 200;
        private SelectionStartHandleView mStartHandle;
        private SelectionEndHandleView mEndHandle;
        private int mMinTouchOffset;
        private int mMaxTouchOffset;
        private long mPreviousTapUpTime = 0L;
        private float mPreviousTapPositionX;
        private float mPreviousTapPositionY;

        SelectionModifierCursorController() {
            this.resetTouchOffsets();
        }

        public void show() {
            if (TextView.this.isInBatchEditMode()) {
                return;
            }
            this.initDrawables();
            this.initHandles();
            TextView.this.hideInsertionPointCursorController();
        }

        private void initDrawables() {
            if (TextView.this.mSelectHandleLeft == null) {
                TextView.this.mSelectHandleLeft = TextView.this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleLeftRes);
            }
            if (TextView.this.mSelectHandleRight == null) {
                TextView.this.mSelectHandleRight = TextView.this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleRightRes);
            }
        }

        private void initHandles() {
            if (this.mStartHandle == null) {
                this.mStartHandle = new SelectionStartHandleView(TextView.this.mSelectHandleLeft, TextView.this.mSelectHandleRight);
            }
            if (this.mEndHandle == null) {
                this.mEndHandle = new SelectionEndHandleView(TextView.this.mSelectHandleRight, TextView.this.mSelectHandleLeft);
            }
            this.mStartHandle.show();
            this.mEndHandle.show();
            this.mStartHandle.showActionPopupWindow(200);
            this.mEndHandle.setActionPopupWindow(this.mStartHandle.getActionPopupWindow());
            TextView.this.hideInsertionPointCursorController();
        }

        public void hide() {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
        }

        public void onTouchEvent(MotionEvent event) {
            switch (event.getActionMasked()) {
                case 0: {
                    float deltaY;
                    float deltaX;
                    float distanceSquared;
                    float x = event.getX();
                    float y = event.getY();
                    this.mMinTouchOffset = this.mMaxTouchOffset = TextView.this.getOffsetForPosition(x, y);
                    long duration = SystemClock.uptimeMillis() - this.mPreviousTapUpTime;
                    if (duration <= (long)ViewConfiguration.getDoubleTapTimeout() && TextView.this.isPositionOnText(x, y) && (distanceSquared = (deltaX = x - this.mPreviousTapPositionX) * deltaX + (deltaY = y - this.mPreviousTapPositionY) * deltaY) < (float)TextView.this.mSquaredTouchSlopDistance) {
                        TextView.this.startSelectionActionMode();
                        TextView.this.mDiscardNextActionUp = true;
                    }
                    this.mPreviousTapPositionX = x;
                    this.mPreviousTapPositionY = y;
                    break;
                }
                case 5: 
                case 6: {
                    if (!TextView.this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) break;
                    this.updateMinAndMaxOffsets(event);
                    break;
                }
                case 1: {
                    this.mPreviousTapUpTime = SystemClock.uptimeMillis();
                }
            }
        }

        private void updateMinAndMaxOffsets(MotionEvent event) {
            int pointerCount = event.getPointerCount();
            for (int index = 0; index < pointerCount; ++index) {
                int offset = TextView.this.getOffsetForPosition(event.getX(index), event.getY(index));
                if (offset < this.mMinTouchOffset) {
                    this.mMinTouchOffset = offset;
                }
                if (offset <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = offset;
            }
        }

        public int getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        public int getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        public void resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
        }

        public boolean isSelectionStartDragged() {
            return this.mStartHandle != null && this.mStartHandle.isDragging();
        }

        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        public void onDetached() {
            ViewTreeObserver observer = TextView.this.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mStartHandle != null) {
                this.mStartHandle.onDetached();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.onDetached();
            }
        }
    }

    private class InsertionPointCursorController
    implements CursorController {
        private InsertionHandleView mHandle;

        private InsertionPointCursorController() {
        }

        public void show() {
            this.getHandle().show();
        }

        public void showWithActionPopup() {
            this.getHandle().showWithActionPopup();
        }

        public void hide() {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
        }

        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        private InsertionHandleView getHandle() {
            if (TextView.this.mSelectHandleCenter == null) {
                TextView.this.mSelectHandleCenter = TextView.this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleRes);
            }
            if (this.mHandle == null) {
                this.mHandle = new InsertionHandleView(TextView.this.mSelectHandleCenter);
            }
            return this.mHandle;
        }

        public void onDetached() {
            ViewTreeObserver observer = TextView.this.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mHandle != null) {
                this.mHandle.onDetached();
            }
        }
    }

    private static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener {
        public void show();

        public void hide();

        public void onDetached();
    }

    private class SelectionEndHandleView
    extends HandleView {
        public SelectionEndHandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(drawableLtr, drawableRtl);
        }

        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() * 3 / 4;
            }
            return drawable2.getIntrinsicWidth() / 4;
        }

        public int getCurrentCursorOffset() {
            return TextView.this.getSelectionEnd();
        }

        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)TextView.this.mText, TextView.this.getSelectionStart(), offset);
            this.updateDrawable();
        }

        public void updatePosition(float x, float y) {
            int selectionStart;
            int offset = TextView.this.getOffsetForPosition(x, y);
            if (offset <= (selectionStart = TextView.this.getSelectionStart())) {
                offset = Math.min(selectionStart + 1, TextView.this.mText.length());
            }
            this.positionAtCursorOffset(offset, false);
        }

        public void setActionPopupWindow(ActionPopupWindow actionPopupWindow) {
            this.mActionPopupWindow = actionPopupWindow;
        }
    }

    private class SelectionStartHandleView
    extends HandleView {
        public SelectionStartHandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(drawableLtr, drawableRtl);
        }

        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() / 4;
            }
            return drawable2.getIntrinsicWidth() * 3 / 4;
        }

        public int getCurrentCursorOffset() {
            return TextView.this.getSelectionStart();
        }

        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)TextView.this.mText, offset, TextView.this.getSelectionEnd());
            this.updateDrawable();
        }

        public void updatePosition(float x, float y) {
            int selectionEnd;
            int offset = TextView.this.getOffsetForPosition(x, y);
            if (offset >= (selectionEnd = TextView.this.getSelectionEnd())) {
                offset = Math.max(0, selectionEnd - 1);
            }
            this.positionAtCursorOffset(offset, false);
        }

        public ActionPopupWindow getActionPopupWindow() {
            return this.mActionPopupWindow;
        }
    }

    private class InsertionHandleView
    extends HandleView {
        private static final int DELAY_BEFORE_HANDLE_FADES_OUT = 4000;
        private static final int RECENT_CUT_COPY_DURATION = 15000;
        private float mDownPositionX;
        private float mDownPositionY;
        private Runnable mHider;

        public InsertionHandleView(Drawable drawable2) {
            super(drawable2, drawable2);
        }

        public void show() {
            super.show();
            long durationSinceCutOrCopy = SystemClock.uptimeMillis() - sLastCutOrCopyTime;
            if (durationSinceCutOrCopy < 15000L) {
                this.showActionPopupWindow(0);
            }
            this.hideAfterDelay();
        }

        public void showWithActionPopup() {
            this.show();
            this.showActionPopupWindow(0);
        }

        private void hideAfterDelay() {
            this.removeHiderCallback();
            if (this.mHider == null) {
                this.mHider = new Runnable(){

                    public void run() {
                        InsertionHandleView.this.hide();
                    }
                };
            }
            TextView.this.postDelayed(this.mHider, 4000L);
        }

        private void removeHiderCallback() {
            if (this.mHider != null) {
                TextView.this.removeCallbacks(this.mHider);
            }
        }

        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            return drawable2.getIntrinsicWidth() / 2;
        }

        public boolean onTouchEvent(MotionEvent ev) {
            boolean result = super.onTouchEvent(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDownPositionX = ev.getRawX();
                    this.mDownPositionY = ev.getRawY();
                    break;
                }
                case 1: {
                    float deltaY;
                    float deltaX;
                    float distanceSquared;
                    if (!this.offsetHasBeenChanged() && (distanceSquared = (deltaX = this.mDownPositionX - ev.getRawX()) * deltaX + (deltaY = this.mDownPositionY - ev.getRawY()) * deltaY) < (float)TextView.this.mSquaredTouchSlopDistance) {
                        if (this.mActionPopupWindow != null && this.mActionPopupWindow.isShowing()) {
                            this.mActionPopupWindow.hide();
                        } else {
                            this.showWithActionPopup();
                        }
                    }
                    this.hideAfterDelay();
                    break;
                }
                case 3: {
                    this.hideAfterDelay();
                    break;
                }
            }
            return result;
        }

        public int getCurrentCursorOffset() {
            return TextView.this.getSelectionStart();
        }

        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)TextView.this.mText, offset);
        }

        public void updatePosition(float x, float y) {
            this.positionAtCursorOffset(TextView.this.getOffsetForPosition(x, y), false);
        }

        void onHandleMoved() {
            super.onHandleMoved();
            this.removeHiderCallback();
        }

        public void onDetached() {
            super.onDetached();
            this.removeHiderCallback();
        }
    }

    private abstract class HandleView
    extends View
    implements TextViewPositionListener {
        protected Drawable mDrawable;
        protected Drawable mDrawableLtr;
        protected Drawable mDrawableRtl;
        private final PopupWindow mContainer;
        private int mPositionX;
        private int mPositionY;
        private boolean mIsDragging;
        private float mTouchToWindowOffsetX;
        private float mTouchToWindowOffsetY;
        protected int mHotspotX;
        private float mTouchOffsetY;
        private float mIdealVerticalOffset;
        private int mLastParentX;
        private int mLastParentY;
        protected ActionPopupWindow mActionPopupWindow;
        private int mPreviousOffset;
        private boolean mPositionHasChanged;
        private Runnable mActionPopupShower;
        private static final int HISTORY_SIZE = 5;
        private static final int TOUCH_UP_FILTER_DELAY_AFTER = 150;
        private static final int TOUCH_UP_FILTER_DELAY_BEFORE = 350;
        private final long[] mPreviousOffsetsTimes;
        private final int[] mPreviousOffsets;
        private int mPreviousOffsetIndex;
        private int mNumberPreviousOffsets;

        public HandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(TextView.this.mContext);
            this.mPreviousOffset = -1;
            this.mPositionHasChanged = true;
            this.mPreviousOffsetsTimes = new long[5];
            this.mPreviousOffsets = new int[5];
            this.mPreviousOffsetIndex = 0;
            this.mNumberPreviousOffsets = 0;
            this.mContainer = new PopupWindow(TextView.this.mContext, null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.mContainer.setContentView(this);
            this.mDrawableLtr = drawableLtr;
            this.mDrawableRtl = drawableRtl;
            this.updateDrawable();
            int handleHeight = this.mDrawable.getIntrinsicHeight();
            this.mTouchOffsetY = -0.3f * (float)handleHeight;
            this.mIdealVerticalOffset = 0.7f * (float)handleHeight;
        }

        protected void updateDrawable() {
            int offset = this.getCurrentCursorOffset();
            boolean isRtlCharAtOffset = TextView.this.mLayout.isRtlCharAt(offset);
            this.mDrawable = isRtlCharAtOffset ? this.mDrawableRtl : this.mDrawableLtr;
            this.mHotspotX = this.getHotspotX(this.mDrawable, isRtlCharAtOffset);
        }

        protected abstract int getHotspotX(Drawable var1, boolean var2);

        private void startTouchUpFilter(int offset) {
            this.mNumberPreviousOffsets = 0;
            this.addPositionToTouchUpFilter(offset);
        }

        private void addPositionToTouchUpFilter(int offset) {
            this.mPreviousOffsetIndex = (this.mPreviousOffsetIndex + 1) % 5;
            this.mPreviousOffsets[this.mPreviousOffsetIndex] = offset;
            this.mPreviousOffsetsTimes[this.mPreviousOffsetIndex] = SystemClock.uptimeMillis();
            ++this.mNumberPreviousOffsets;
        }

        private void filterOnTouchUp() {
            long now = SystemClock.uptimeMillis();
            int i = 0;
            int index = this.mPreviousOffsetIndex;
            int iMax = Math.min(this.mNumberPreviousOffsets, 5);
            while (i < iMax && now - this.mPreviousOffsetsTimes[index] < 150L) {
                index = (this.mPreviousOffsetIndex - ++i + 5) % 5;
            }
            if (i > 0 && i < iMax && now - this.mPreviousOffsetsTimes[index] > 350L) {
                this.positionAtCursorOffset(this.mPreviousOffsets[index], false);
            }
        }

        public boolean offsetHasBeenChanged() {
            return this.mNumberPreviousOffsets > 1;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        public void show() {
            if (this.isShowing()) {
                return;
            }
            TextView.this.getPositionListener().addSubscriber(this, true);
            this.mPreviousOffset = -1;
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), false);
            this.hideActionPopupWindow();
        }

        protected void dismiss() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
            this.onDetached();
        }

        public void hide() {
            this.dismiss();
            TextView.this.getPositionListener().removeSubscriber(this);
        }

        void showActionPopupWindow(int delay) {
            if (this.mActionPopupWindow == null) {
                this.mActionPopupWindow = new ActionPopupWindow();
            }
            if (this.mActionPopupShower == null) {
                this.mActionPopupShower = new Runnable(){

                    public void run() {
                        HandleView.this.mActionPopupWindow.show();
                    }
                };
            } else {
                TextView.this.removeCallbacks(this.mActionPopupShower);
            }
            TextView.this.postDelayed(this.mActionPopupShower, delay);
        }

        protected void hideActionPopupWindow() {
            if (this.mActionPopupShower != null) {
                TextView.this.removeCallbacks(this.mActionPopupShower);
            }
            if (this.mActionPopupWindow != null) {
                this.mActionPopupWindow.hide();
            }
        }

        public boolean isShowing() {
            return this.mContainer.isShowing();
        }

        private boolean isVisible() {
            if (this.mIsDragging) {
                return true;
            }
            if (TextView.this.isInBatchEditMode()) {
                return false;
            }
            return TextView.this.isPositionVisible(this.mPositionX + this.mHotspotX, this.mPositionY);
        }

        public abstract int getCurrentCursorOffset();

        protected abstract void updateSelection(int var1);

        public abstract void updatePosition(float var1, float var2);

        protected void positionAtCursorOffset(int offset, boolean parentScrolled) {
            if (TextView.this.mLayout == null) {
                TextView.this.prepareCursorControllers();
                return;
            }
            if (offset != this.mPreviousOffset || parentScrolled) {
                this.updateSelection(offset);
                this.addPositionToTouchUpFilter(offset);
                int line = TextView.this.mLayout.getLineForOffset(offset);
                this.mPositionX = (int)(TextView.this.mLayout.getPrimaryHorizontal(offset) - 0.5f - (float)this.mHotspotX);
                this.mPositionY = TextView.this.mLayout.getLineBottom(line);
                this.mPositionX += TextView.this.viewportToContentHorizontalOffset();
                this.mPositionY += TextView.this.viewportToContentVerticalOffset();
                this.mPreviousOffset = offset;
                this.mPositionHasChanged = true;
            }
        }

        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), parentScrolled);
            if (parentPositionChanged || this.mPositionHasChanged) {
                if (this.mIsDragging) {
                    if (parentPositionX != this.mLastParentX || parentPositionY != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(parentPositionX - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(parentPositionY - this.mLastParentY);
                        this.mLastParentX = parentPositionX;
                        this.mLastParentY = parentPositionY;
                    }
                    this.onHandleMoved();
                }
                if (this.isVisible()) {
                    int positionX = parentPositionX + this.mPositionX;
                    int positionY = parentPositionY + this.mPositionY;
                    if (this.isShowing()) {
                        this.mContainer.update(positionX, positionY, -1, -1);
                    } else {
                        this.mContainer.showAtLocation(TextView.this, 0, positionX, positionY);
                    }
                } else if (this.isShowing()) {
                    this.dismiss();
                }
                this.mPositionHasChanged = false;
            }
        }

        protected void onDraw(Canvas c) {
            this.mDrawable.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            this.mDrawable.draw(c);
        }

        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.startTouchUpFilter(this.getCurrentCursorOffset());
                    this.mTouchToWindowOffsetX = ev.getRawX() - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = ev.getRawY() - (float)this.mPositionY;
                    PositionListener positionListener = TextView.this.getPositionListener();
                    this.mLastParentX = positionListener.getPositionX();
                    this.mLastParentY = positionListener.getPositionY();
                    this.mIsDragging = true;
                    break;
                }
                case 2: {
                    float newVerticalOffset;
                    float rawX = ev.getRawX();
                    float rawY = ev.getRawY();
                    float previousVerticalOffset = this.mTouchToWindowOffsetY - (float)this.mLastParentY;
                    float currentVerticalOffset = rawY - (float)this.mPositionY - (float)this.mLastParentY;
                    if (previousVerticalOffset < this.mIdealVerticalOffset) {
                        newVerticalOffset = Math.min(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.max(newVerticalOffset, previousVerticalOffset);
                    } else {
                        newVerticalOffset = Math.max(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.min(newVerticalOffset, previousVerticalOffset);
                    }
                    this.mTouchToWindowOffsetY = newVerticalOffset + (float)this.mLastParentY;
                    float newPosX = rawX - this.mTouchToWindowOffsetX + (float)this.mHotspotX;
                    float newPosY = rawY - this.mTouchToWindowOffsetY + this.mTouchOffsetY;
                    this.updatePosition(newPosX, newPosY);
                    break;
                }
                case 1: {
                    this.filterOnTouchUp();
                    this.mIsDragging = false;
                    break;
                }
                case 3: {
                    this.mIsDragging = false;
                }
            }
            return true;
        }

        public boolean isDragging() {
            return this.mIsDragging;
        }

        void onHandleMoved() {
            this.hideActionPopupWindow();
        }

        public void onDetached() {
            this.hideActionPopupWindow();
        }
    }

    private class ActionPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367200;
        private TextView mPasteTextView;
        private TextView mReplaceTextView;

        private ActionPopupWindow() {
        }

        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(TextView.this.mContext, null, 16843464);
            this.mPopupWindow.setClippingEnabled(true);
        }

        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(TextView.this.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17302932);
            LayoutInflater inflater = (LayoutInflater)TextView.this.mContext.getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mPasteTextView = (TextView)inflater.inflate(17367200, null);
            this.mPasteTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mPasteTextView);
            this.mPasteTextView.setText(17039371);
            this.mPasteTextView.setOnClickListener(this);
            this.mReplaceTextView = (TextView)inflater.inflate(17367200, null);
            this.mReplaceTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mReplaceTextView);
            this.mReplaceTextView.setText(17040275);
            this.mReplaceTextView.setOnClickListener(this);
        }

        public void show() {
            boolean canPaste = TextView.this.canPaste();
            boolean canSuggest = TextView.this.isSuggestionsEnabled() && TextView.this.isCursorInsideSuggestionSpan();
            this.mPasteTextView.setVisibility(canPaste ? 0 : 8);
            this.mReplaceTextView.setVisibility(canSuggest ? 0 : 8);
            if (!canPaste && !canSuggest) {
                return;
            }
            super.show();
        }

        public void onClick(View view) {
            if (view == this.mPasteTextView && TextView.this.canPaste()) {
                TextView.this.onTextContextMenuItem(0x1020022);
                this.hide();
            } else if (view == this.mReplaceTextView) {
                int middle = (TextView.this.getSelectionStart() + TextView.this.getSelectionEnd()) / 2;
                TextView.this.stopSelectionActionMode();
                Selection.setSelection((Spannable)TextView.this.mText, middle);
                TextView.this.showSuggestions();
            }
        }

        protected int getTextOffset() {
            return (TextView.this.getSelectionStart() + TextView.this.getSelectionEnd()) / 2;
        }

        protected int getVerticalLocalPosition(int line) {
            return TextView.this.mLayout.getLineTop(line) - this.mContentView.getMeasuredHeight();
        }

        protected int clipVertically(int positionY) {
            if (positionY < 0) {
                int offset = this.getTextOffset();
                int line = TextView.this.mLayout.getLineForOffset(offset);
                positionY += TextView.this.mLayout.getLineBottom(line) - TextView.this.mLayout.getLineTop(line);
                positionY += this.mContentView.getMeasuredHeight();
                Drawable handle = TextView.this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleRes);
                positionY += handle.getIntrinsicHeight();
            }
            return positionY;
        }
    }

    private class SelectionActionModeCallback
    implements ActionMode.Callback {
        private SelectionActionModeCallback() {
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            TypedArray styledAttributes = TextView.this.mContext.obtainStyledAttributes(R.styleable.SelectionModeDrawables);
            boolean allowText = TextView.this.getContext().getResources().getBoolean(0x1110030);
            mode.setTitle(allowText ? TextView.this.mContext.getString(17040277) : null);
            mode.setSubtitle(null);
            int selectAllIconId = 0;
            if (!allowText) {
                selectAllIconId = styledAttributes.getResourceId(3, 0);
            }
            menu2.add(0, 16908319, 0, 17039373).setIcon(selectAllIconId).setAlphabeticShortcut('a').setShowAsAction(6);
            if (TextView.this.canCut()) {
                menu2.add(0, 0x1020020, 0, 17039363).setIcon(styledAttributes.getResourceId(0, 0)).setAlphabeticShortcut('x').setShowAsAction(6);
            }
            if (TextView.this.canCopy()) {
                menu2.add(0, 0x1020021, 0, 0x1040001).setIcon(styledAttributes.getResourceId(1, 0)).setAlphabeticShortcut('c').setShowAsAction(6);
            }
            if (TextView.this.canPaste()) {
                menu2.add(0, 0x1020022, 0, 17039371).setIcon(styledAttributes.getResourceId(2, 0)).setAlphabeticShortcut('v').setShowAsAction(6);
            }
            styledAttributes.recycle();
            if (TextView.this.mCustomSelectionActionModeCallback != null && !TextView.this.mCustomSelectionActionModeCallback.onCreateActionMode(mode, menu2)) {
                return false;
            }
            if (menu2.hasVisibleItems() || mode.getCustomView() != null) {
                TextView.this.getSelectionController().show();
                return true;
            }
            return false;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            if (TextView.this.mCustomSelectionActionModeCallback != null) {
                return TextView.this.mCustomSelectionActionModeCallback.onPrepareActionMode(mode, menu2);
            }
            return true;
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            if (TextView.this.mCustomSelectionActionModeCallback != null && TextView.this.mCustomSelectionActionModeCallback.onActionItemClicked(mode, item)) {
                return true;
            }
            return TextView.this.onTextContextMenuItem(item.getItemId());
        }

        public void onDestroyActionMode(ActionMode mode) {
            if (TextView.this.mCustomSelectionActionModeCallback != null) {
                TextView.this.mCustomSelectionActionModeCallback.onDestroyActionMode(mode);
            }
            Selection.setSelection((Spannable)TextView.this.mText, TextView.this.getSelectionEnd());
            if (TextView.this.mSelectionModifierCursorController != null) {
                TextView.this.mSelectionModifierCursorController.hide();
            }
            TextView.this.mSelectionActionMode = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuggestionsPopupWindow
    extends PinnedPopupWindow
    implements AdapterView.OnItemClickListener {
        private static final int MAX_NUMBER_SUGGESTIONS = 5;
        private static final int ADD_TO_DICTIONARY = -1;
        private static final int DELETE_TEXT = -2;
        private SuggestionInfo[] mSuggestionInfos;
        private int mNumberOfSuggestions;
        private boolean mCursorWasVisibleBeforeSuggestions;
        private boolean mIsShowingUp;
        private SuggestionAdapter mSuggestionsAdapter;
        private final Comparator<SuggestionSpan> mSuggestionSpanComparator;
        private final HashMap<SuggestionSpan, Integer> mSpansLengths;

        public SuggestionsPopupWindow() {
            this.mIsShowingUp = false;
            this.mCursorWasVisibleBeforeSuggestions = TextView.this.mCursorVisible;
            this.mSuggestionSpanComparator = new SuggestionSpanComparator();
            this.mSpansLengths = new HashMap();
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new CustomPopupWindow(TextView.this.mContext, 16843635);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setClippingEnabled(false);
        }

        @Override
        protected void initContentView() {
            ListView listView = new ListView(TextView.this.getContext());
            this.mSuggestionsAdapter = new SuggestionAdapter();
            listView.setAdapter(this.mSuggestionsAdapter);
            listView.setOnItemClickListener(this);
            this.mContentView = listView;
            this.mSuggestionInfos = new SuggestionInfo[7];
            for (int i = 0; i < this.mSuggestionInfos.length; ++i) {
                this.mSuggestionInfos[i] = new SuggestionInfo();
            }
        }

        public boolean isShowingUp() {
            return this.mIsShowingUp;
        }

        public void onParentLostFocus() {
            this.mIsShowingUp = false;
        }

        private SuggestionSpan[] getSuggestionSpans() {
            int pos = TextView.this.getSelectionStart();
            Spannable spannable = (Spannable)TextView.this.mText;
            SuggestionSpan[] suggestionSpans = spannable.getSpans(pos, pos, SuggestionSpan.class);
            this.mSpansLengths.clear();
            for (SuggestionSpan suggestionSpan : suggestionSpans) {
                int start = spannable.getSpanStart(suggestionSpan);
                int end = spannable.getSpanEnd(suggestionSpan);
                this.mSpansLengths.put(suggestionSpan, end - start);
            }
            Arrays.sort(suggestionSpans, this.mSuggestionSpanComparator);
            return suggestionSpans;
        }

        @Override
        public void show() {
            if (!(TextView.this.mText instanceof Editable)) {
                return;
            }
            this.updateSuggestions();
            this.mCursorWasVisibleBeforeSuggestions = TextView.this.mCursorVisible;
            TextView.this.setCursorVisible(false);
            this.mIsShowingUp = true;
            super.show();
        }

        @Override
        protected void measureContent() {
            DisplayMetrics displayMetrics = TextView.this.mContext.getResources().getDisplayMetrics();
            int horizontalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE);
            int verticalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE);
            int width = 0;
            View view = null;
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                view = this.mSuggestionsAdapter.getView(i, view, this.mContentView);
                view.getLayoutParams().width = -2;
                view.measure(horizontalMeasure, verticalMeasure);
                width = Math.max(width, view.getMeasuredWidth());
            }
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), verticalMeasure);
            Drawable popupBackground = this.mPopupWindow.getBackground();
            if (popupBackground != null) {
                if (TextView.this.mTempRect == null) {
                    TextView.this.mTempRect = new Rect();
                }
                popupBackground.getPadding(TextView.this.mTempRect);
                width += TextView.this.mTempRect.left + TextView.this.mTempRect.right;
            }
            this.mPopupWindow.setWidth(width);
        }

        @Override
        protected int getTextOffset() {
            return TextView.this.getSelectionStart();
        }

        @Override
        protected int getVerticalLocalPosition(int line) {
            return TextView.this.mLayout.getLineBottom(line);
        }

        @Override
        protected int clipVertically(int positionY) {
            int height = this.mContentView.getMeasuredHeight();
            DisplayMetrics displayMetrics = TextView.this.mContext.getResources().getDisplayMetrics();
            return Math.min(positionY, displayMetrics.heightPixels - height);
        }

        @Override
        public void hide() {
            super.hide();
        }

        private void updateSuggestions() {
            Spannable spannable = (Spannable)TextView.this.mText;
            SuggestionSpan[] suggestionSpans = this.getSuggestionSpans();
            int nbSpans = suggestionSpans.length;
            this.mNumberOfSuggestions = 0;
            int spanUnionStart = TextView.this.mText.length();
            int spanUnionEnd = 0;
            SuggestionSpan misspelledSpan = null;
            int underlineColor = 0;
            block0: for (int spanIndex = 0; spanIndex < nbSpans; ++spanIndex) {
                SuggestionSpan suggestionSpan = suggestionSpans[spanIndex];
                int spanStart = spannable.getSpanStart(suggestionSpan);
                int spanEnd = spannable.getSpanEnd(suggestionSpan);
                spanUnionStart = Math.min(spanStart, spanUnionStart);
                spanUnionEnd = Math.max(spanEnd, spanUnionEnd);
                if ((suggestionSpan.getFlags() & 2) != 0) {
                    misspelledSpan = suggestionSpan;
                }
                if (spanIndex == 0) {
                    underlineColor = suggestionSpan.getUnderlineColor();
                }
                String[] suggestions = suggestionSpan.getSuggestions();
                int nbSuggestions = suggestions.length;
                for (int suggestionIndex = 0; suggestionIndex < nbSuggestions; ++suggestionIndex) {
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = suggestionSpan;
                    suggestionInfo.suggestionIndex = suggestionIndex;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), suggestions[suggestionIndex]);
                    ++this.mNumberOfSuggestions;
                    if (this.mNumberOfSuggestions != 5) continue;
                    spanIndex = nbSpans;
                    continue block0;
                }
            }
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                this.highlightTextDifferences(this.mSuggestionInfos[i], spanUnionStart, spanUnionEnd);
            }
            if (misspelledSpan != null) {
                int misspelledStart = spannable.getSpanStart(misspelledSpan);
                int misspelledEnd = spannable.getSpanEnd(misspelledSpan);
                if (misspelledStart >= 0 && misspelledEnd > misspelledStart) {
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = misspelledSpan;
                    suggestionInfo.suggestionIndex = -1;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), TextView.this.getContext().getString(17040278));
                    suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
                    ++this.mNumberOfSuggestions;
                }
            }
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
            suggestionInfo.suggestionSpan = null;
            suggestionInfo.suggestionIndex = -2;
            suggestionInfo.text.replace(0, suggestionInfo.text.length(), TextView.this.getContext().getString(17040279));
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
            ++this.mNumberOfSuggestions;
            if (TextView.this.mSuggestionRangeSpan == null) {
                TextView.this.mSuggestionRangeSpan = new SuggestionRangeSpan();
            }
            if (underlineColor == 0) {
                TextView.this.mSuggestionRangeSpan.setBackgroundColor(TextView.this.mHighlightColor);
            } else {
                float BACKGROUND_TRANSPARENCY = 0.4f;
                int newAlpha = (int)((float)Color.alpha(underlineColor) * 0.4f);
                TextView.this.mSuggestionRangeSpan.setBackgroundColor((underlineColor & 0xFFFFFF) + (newAlpha << 24));
            }
            spannable.setSpan(TextView.this.mSuggestionRangeSpan, spanUnionStart, spanUnionEnd, 33);
            this.mSuggestionsAdapter.notifyDataSetChanged();
        }

        private void highlightTextDifferences(SuggestionInfo suggestionInfo, int unionStart, int unionEnd) {
            Spannable text = (Spannable)TextView.this.mText;
            int spanStart = text.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = text.getSpanEnd(suggestionInfo.suggestionSpan);
            suggestionInfo.suggestionStart = spanStart - unionStart;
            suggestionInfo.suggestionEnd = suggestionInfo.suggestionStart + suggestionInfo.text.length();
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, suggestionInfo.text.length(), 33);
            suggestionInfo.text.insert(0, ((Object)TextView.this.mText).toString().substring(unionStart, spanStart));
            suggestionInfo.text.append(((Object)TextView.this.mText).toString().substring(spanEnd, unionEnd));
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            Editable editable = (Editable)TextView.this.mText;
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[position];
            if (suggestionInfo.suggestionIndex == -2) {
                int spanUnionStart = editable.getSpanStart(TextView.this.mSuggestionRangeSpan);
                int spanUnionEnd = editable.getSpanEnd(TextView.this.mSuggestionRangeSpan);
                if (spanUnionStart >= 0 && spanUnionEnd > spanUnionStart) {
                    if (spanUnionEnd < editable.length() && Character.isSpaceChar(editable.charAt(spanUnionEnd)) && (spanUnionStart == 0 || Character.isSpaceChar(editable.charAt(spanUnionStart - 1)))) {
                        ++spanUnionEnd;
                    }
                    TextView.this.deleteText_internal(spanUnionStart, spanUnionEnd);
                }
                this.hide();
                return;
            }
            int spanStart = editable.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = editable.getSpanEnd(suggestionInfo.suggestionSpan);
            if (spanStart < 0 || spanEnd <= spanStart) {
                this.hide();
                return;
            }
            String originalText = ((Object)TextView.this.mText).toString().substring(spanStart, spanEnd);
            if (suggestionInfo.suggestionIndex == -1) {
                Intent intent = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                intent.putExtra("word", originalText);
                intent.putExtra("locale", TextView.this.getTextServicesLocale().toString());
                intent.setFlags(intent.getFlags() | 0x10000000);
                TextView.this.getContext().startActivity(intent);
                editable.removeSpan(suggestionInfo.suggestionSpan);
                TextView.this.updateSpellCheckSpans(spanStart, spanEnd, false);
            } else {
                InputMethodManager imm;
                SuggestionSpan[] suggestionSpans = editable.getSpans(spanStart, spanEnd, SuggestionSpan.class);
                int length = suggestionSpans.length;
                int[] suggestionSpansStarts = new int[length];
                int[] suggestionSpansEnds = new int[length];
                int[] suggestionSpansFlags = new int[length];
                for (int i = 0; i < length; ++i) {
                    SuggestionSpan suggestionSpan = suggestionSpans[i];
                    suggestionSpansStarts[i] = editable.getSpanStart(suggestionSpan);
                    suggestionSpansEnds[i] = editable.getSpanEnd(suggestionSpan);
                    suggestionSpansFlags[i] = editable.getSpanFlags(suggestionSpan);
                    int suggestionSpanFlags = suggestionSpan.getFlags();
                    if ((suggestionSpanFlags & 2) <= 0) continue;
                    suggestionSpanFlags &= 0xFFFFFFFD;
                    suggestionSpan.setFlags(suggestionSpanFlags &= 0xFFFFFFFE);
                }
                int suggestionStart = suggestionInfo.suggestionStart;
                int suggestionEnd = suggestionInfo.suggestionEnd;
                String suggestion = ((Object)suggestionInfo.text.subSequence(suggestionStart, suggestionEnd)).toString();
                TextView.this.replaceText_internal(spanStart, spanEnd, suggestion);
                if (!TextUtils.isEmpty(suggestionInfo.suggestionSpan.getNotificationTargetClassName()) && (imm = InputMethodManager.peekInstance()) != null) {
                    imm.notifySuggestionPicked(suggestionInfo.suggestionSpan, originalText, suggestionInfo.suggestionIndex);
                }
                String[] suggestions = suggestionInfo.suggestionSpan.getSuggestions();
                suggestions[suggestionInfo.suggestionIndex] = originalText;
                int lengthDifference = suggestion.length() - (spanEnd - spanStart);
                for (int i = 0; i < length; ++i) {
                    if (suggestionSpansStarts[i] > spanStart || suggestionSpansEnds[i] < spanEnd) continue;
                    TextView.this.setSpan_internal(suggestionSpans[i], suggestionSpansStarts[i], suggestionSpansEnds[i] + lengthDifference, suggestionSpansFlags[i]);
                }
                int newCursorPosition = spanEnd + lengthDifference;
                TextView.this.setCursorPosition_internal(newCursorPosition, newCursorPosition);
            }
            this.hide();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SuggestionSpanComparator
        implements Comparator<SuggestionSpan> {
            private SuggestionSpanComparator() {
            }

            @Override
            public int compare(SuggestionSpan span1, SuggestionSpan span2) {
                int flag2;
                int flag1 = span1.getFlags();
                if (flag1 != (flag2 = span2.getFlags())) {
                    boolean misspelled2;
                    boolean easy1 = (flag1 & 1) != 0;
                    boolean easy2 = (flag2 & 1) != 0;
                    boolean misspelled1 = (flag1 & 2) != 0;
                    boolean bl = misspelled2 = (flag2 & 2) != 0;
                    if (easy1 && !misspelled1) {
                        return -1;
                    }
                    if (easy2 && !misspelled2) {
                        return 1;
                    }
                    if (misspelled1) {
                        return -1;
                    }
                    if (misspelled2) {
                        return 1;
                    }
                }
                return (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(span1) - (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(span2);
            }
        }

        private class SuggestionAdapter
        extends BaseAdapter {
            private LayoutInflater mInflater;

            private SuggestionAdapter() {
                this.mInflater = (LayoutInflater)TextView.this.mContext.getSystemService("layout_inflater");
            }

            public int getCount() {
                return SuggestionsPopupWindow.this.mNumberOfSuggestions;
            }

            public Object getItem(int position) {
                return SuggestionsPopupWindow.this.mSuggestionInfos[position];
            }

            public long getItemId(int position) {
                return position;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                TextView textView = (TextView)convertView;
                if (textView == null) {
                    textView = (TextView)this.mInflater.inflate(TextView.this.mTextEditSuggestionItemLayout, parent, false);
                }
                SuggestionInfo suggestionInfo = SuggestionsPopupWindow.this.mSuggestionInfos[position];
                textView.setText(suggestionInfo.text);
                if (suggestionInfo.suggestionIndex == -1) {
                    textView.setCompoundDrawablesWithIntrinsicBounds(17302341, 0, 0, 0);
                } else if (suggestionInfo.suggestionIndex == -2) {
                    textView.setCompoundDrawablesWithIntrinsicBounds(17302342, 0, 0, 0);
                } else {
                    textView.setCompoundDrawables(null, null, null, null);
                }
                return textView;
            }
        }

        private class SuggestionInfo {
            int suggestionStart;
            int suggestionEnd;
            SuggestionSpan suggestionSpan;
            int suggestionIndex;
            SpannableStringBuilder text = new SpannableStringBuilder();
            TextAppearanceSpan highlightSpan;

            private SuggestionInfo() {
                this.highlightSpan = new TextAppearanceSpan(TextView.this.mContext, 16974104);
            }
        }

        private class CustomPopupWindow
        extends PopupWindow {
            public CustomPopupWindow(Context context, int defStyle) {
                super(context, null, defStyle);
            }

            public void dismiss() {
                super.dismiss();
                TextView.this.getPositionListener().removeSubscriber(SuggestionsPopupWindow.this);
                ((Spannable)TextView.this.mText).removeSpan(TextView.this.mSuggestionRangeSpan);
                TextView.this.setCursorVisible(SuggestionsPopupWindow.this.mCursorWasVisibleBeforeSuggestions);
                if (TextView.this.hasInsertionController()) {
                    TextView.this.getInsertionController().show();
                }
            }
        }
    }

    private abstract class PinnedPopupWindow
    implements TextViewPositionListener {
        protected PopupWindow mPopupWindow;
        protected ViewGroup mContentView;
        int mPositionX;
        int mPositionY;

        protected abstract void createPopupWindow();

        protected abstract void initContentView();

        protected abstract int getTextOffset();

        protected abstract int getVerticalLocalPosition(int var1);

        protected abstract int clipVertically(int var1);

        public PinnedPopupWindow() {
            this.createPopupWindow();
            this.mPopupWindow.setWindowLayoutType(1002);
            this.mPopupWindow.setWidth(-2);
            this.mPopupWindow.setHeight(-2);
            this.initContentView();
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mContentView.setLayoutParams(wrapContent);
            this.mPopupWindow.setContentView(this.mContentView);
        }

        public void show() {
            TextView.this.getPositionListener().addSubscriber(this, false);
            this.computeLocalPosition();
            PositionListener positionListener = TextView.this.getPositionListener();
            this.updatePosition(positionListener.getPositionX(), positionListener.getPositionY());
        }

        protected void measureContent() {
            DisplayMetrics displayMetrics = TextView.this.mContext.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }

        private void computeLocalPosition() {
            this.measureContent();
            int width = this.mContentView.getMeasuredWidth();
            int offset = this.getTextOffset();
            this.mPositionX = (int)(TextView.this.mLayout.getPrimaryHorizontal(offset) - (float)width / 2.0f);
            this.mPositionX += TextView.this.viewportToContentHorizontalOffset();
            int line = TextView.this.mLayout.getLineForOffset(offset);
            this.mPositionY = this.getVerticalLocalPosition(line);
            this.mPositionY += TextView.this.viewportToContentVerticalOffset();
        }

        private void updatePosition(int parentPositionX, int parentPositionY) {
            int positionX = parentPositionX + this.mPositionX;
            int positionY = parentPositionY + this.mPositionY;
            positionY = this.clipVertically(positionY);
            DisplayMetrics displayMetrics = TextView.this.mContext.getResources().getDisplayMetrics();
            int width = this.mContentView.getMeasuredWidth();
            positionX = Math.min(displayMetrics.widthPixels - width, positionX);
            positionX = Math.max(0, positionX);
            if (this.isShowing()) {
                this.mPopupWindow.update(positionX, positionY, -1, -1);
            } else {
                this.mPopupWindow.showAtLocation(TextView.this, 0, positionX, positionY);
            }
        }

        public void hide() {
            this.mPopupWindow.dismiss();
            TextView.this.getPositionListener().removeSubscriber(this);
        }

        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            if (this.isShowing() && TextView.this.isOffsetVisible(this.getTextOffset())) {
                if (parentScrolled) {
                    this.computeLocalPosition();
                }
                this.updatePosition(parentPositionX, parentPositionY);
            } else {
                this.hide();
            }
        }

        public boolean isShowing() {
            return this.mPopupWindow.isShowing();
        }
    }

    private class PositionListener
    implements ViewTreeObserver.OnPreDrawListener {
        private final int MAXIMUM_NUMBER_OF_LISTENERS = 6;
        private TextViewPositionListener[] mPositionListeners = new TextViewPositionListener[6];
        private boolean[] mCanMove = new boolean[6];
        private boolean mPositionHasChanged = true;
        private int mPositionX;
        private int mPositionY;
        private int mNumberOfListeners;
        private boolean mScrollHasChanged;

        private PositionListener() {
        }

        public void addSubscriber(TextViewPositionListener positionListener, boolean canMove) {
            if (this.mNumberOfListeners == 0) {
                this.updatePosition();
                ViewTreeObserver vto = TextView.this.getViewTreeObserver();
                vto.addOnPreDrawListener(this);
            }
            int emptySlotIndex = -1;
            for (int i = 0; i < 6; ++i) {
                TextViewPositionListener listener = this.mPositionListeners[i];
                if (listener == positionListener) {
                    return;
                }
                if (emptySlotIndex >= 0 || listener != null) continue;
                emptySlotIndex = i;
            }
            this.mPositionListeners[emptySlotIndex] = positionListener;
            this.mCanMove[emptySlotIndex] = canMove;
            ++this.mNumberOfListeners;
        }

        public void removeSubscriber(TextViewPositionListener positionListener) {
            for (int i = 0; i < 6; ++i) {
                if (this.mPositionListeners[i] != positionListener) continue;
                this.mPositionListeners[i] = null;
                --this.mNumberOfListeners;
                break;
            }
            if (this.mNumberOfListeners == 0) {
                ViewTreeObserver vto = TextView.this.getViewTreeObserver();
                vto.removeOnPreDrawListener(this);
            }
        }

        public int getPositionX() {
            return this.mPositionX;
        }

        public int getPositionY() {
            return this.mPositionY;
        }

        public boolean onPreDraw() {
            this.updatePosition();
            for (int i = 0; i < 6; ++i) {
                TextViewPositionListener positionListener;
                if (!this.mPositionHasChanged && !this.mScrollHasChanged && !this.mCanMove[i] || (positionListener = this.mPositionListeners[i]) == null) continue;
                positionListener.updatePosition(this.mPositionX, this.mPositionY, this.mPositionHasChanged, this.mScrollHasChanged);
            }
            this.mScrollHasChanged = false;
            return true;
        }

        private void updatePosition() {
            TextView.this.getLocationInWindow(TextView.this.mTempCoords);
            this.mPositionHasChanged = TextView.this.mTempCoords[0] != this.mPositionX || TextView.this.mTempCoords[1] != this.mPositionY;
            this.mPositionX = TextView.this.mTempCoords[0];
            this.mPositionY = TextView.this.mTempCoords[1];
        }

        public void onScrollChanged() {
            this.mScrollHasChanged = true;
        }
    }

    private static interface TextViewPositionListener {
        public void updatePosition(int var1, int var2, boolean var3, boolean var4);
    }

    private static class DragLocalState {
        public TextView sourceTextView;
        public int start;
        public int end;

        public DragLocalState(TextView sourceTextView, int start, int end) {
            this.sourceTextView = sourceTextView;
            this.start = start;
            this.end = end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferType {
        NORMAL,
        SPANNABLE,
        EDITABLE;

    }

    private static class Blink
    extends Handler
    implements Runnable {
        private final WeakReference<TextView> mView;
        private boolean mCancelled;

        public Blink(TextView v) {
            this.mView = new WeakReference<TextView>(v);
        }

        public void run() {
            if (this.mCancelled) {
                return;
            }
            this.removeCallbacks(this);
            TextView tv = (TextView)this.mView.get();
            if (tv != null && tv.shouldBlink()) {
                if (tv.mLayout != null) {
                    tv.invalidateCursorPath();
                }
                this.postAtTime(this, SystemClock.uptimeMillis() + 500L);
            }
        }

        void cancel() {
            if (!this.mCancelled) {
                this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        void uncancel() {
            this.mCancelled = false;
        }
    }

    private class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private CharSequence mBeforeText;
        private EasyEditSpanController mEasyEditSpanController;

        private ChangeWatcher() {
            this.mEasyEditSpanController = new EasyEditSpanController();
        }

        public void beforeTextChanged(CharSequence buffer, int start, int before, int after) {
            if (AccessibilityManager.getInstance(TextView.this.mContext).isEnabled() && !TextView.isPasswordInputType(TextView.this.mInputType) && !TextView.this.hasPasswordTransformationMethod()) {
                this.mBeforeText = ((Object)buffer).toString();
            }
            TextView.this.sendBeforeTextChanged(buffer, start, before, after);
        }

        public void onTextChanged(CharSequence buffer, int start, int before, int after) {
            TextView.this.handleTextChanged(buffer, start, before, after);
            this.mEasyEditSpanController.onTextChange(buffer);
            if (AccessibilityManager.getInstance(TextView.this.mContext).isEnabled() && (TextView.this.isFocused() || TextView.this.isSelected() && TextView.this.isShown())) {
                TextView.this.sendAccessibilityEventTypeViewTextChanged(this.mBeforeText, start, before, after);
                this.mBeforeText = null;
            }
        }

        public void afterTextChanged(Editable buffer) {
            TextView.this.sendAfterTextChanged(buffer);
            if (MetaKeyKeyListener.getMetaState(buffer, 2048) != 0) {
                MetaKeyKeyListener.stopSelecting(TextView.this, buffer);
            }
        }

        public void onSpanChanged(Spannable buf, Object what, int s, int e, int st, int en) {
            TextView.this.spanChange(buf, what, s, st, e, en);
        }

        public void onSpanAdded(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, -1, s, -1, e);
        }

        public void onSpanRemoved(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, s, -1, e, -1);
        }

        private void hideControllers() {
            this.mEasyEditSpanController.hide();
        }
    }

    private class EasyEditPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367200;
        private TextView mDeleteTextView;
        private EasyEditSpan mEasyEditSpan;

        private EasyEditPopupWindow() {
        }

        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(TextView.this.mContext, null, 16843464);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setClippingEnabled(true);
        }

        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(TextView.this.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17302933);
            LayoutInflater inflater = (LayoutInflater)TextView.this.mContext.getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mDeleteTextView = (TextView)inflater.inflate(17367200, null);
            this.mDeleteTextView.setLayoutParams(wrapContent);
            this.mDeleteTextView.setText(17040276);
            this.mDeleteTextView.setOnClickListener(this);
            this.mContentView.addView(this.mDeleteTextView);
        }

        public void show(EasyEditSpan easyEditSpan) {
            this.mEasyEditSpan = easyEditSpan;
            super.show();
        }

        public void onClick(View view) {
            if (view == this.mDeleteTextView) {
                Editable editable = (Editable)TextView.this.mText;
                int start = editable.getSpanStart(this.mEasyEditSpan);
                int end = editable.getSpanEnd(this.mEasyEditSpan);
                if (start >= 0 && end >= 0) {
                    TextView.this.deleteText_internal(start, end);
                }
            }
        }

        protected int getTextOffset() {
            Editable editable = (Editable)TextView.this.mText;
            return editable.getSpanEnd(this.mEasyEditSpan);
        }

        protected int getVerticalLocalPosition(int line) {
            return TextView.this.mLayout.getLineBottom(line);
        }

        protected int clipVertically(int positionY) {
            return positionY;
        }
    }

    private class EasyEditSpanController {
        private static final int DISPLAY_TIMEOUT_MS = 3000;
        private EasyEditPopupWindow mPopupWindow;
        private EasyEditSpan mEasyEditSpan;
        private Runnable mHidePopup;

        private EasyEditSpanController() {
        }

        private void hide() {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.hide();
                TextView.this.removeCallbacks(this.mHidePopup);
            }
            this.removeSpans(TextView.this.mText);
            this.mEasyEditSpan = null;
        }

        public void onTextChange(CharSequence buffer) {
            this.adjustSpans(TextView.this.mText);
            if (TextView.this.getWindowVisibility() != 0) {
                return;
            }
            if (TextView.this.mLayout == null) {
                return;
            }
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (!(TextView.this instanceof ExtractEditText) && imm != null && imm.isFullscreenMode()) {
                return;
            }
            if (this.mEasyEditSpan != null) {
                if (TextView.this.mText instanceof Spannable) {
                    ((Spannable)TextView.this.mText).removeSpan(this.mEasyEditSpan);
                }
                this.mEasyEditSpan = null;
            }
            if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
                this.mPopupWindow.hide();
            }
            if (buffer instanceof Spanned) {
                this.mEasyEditSpan = this.getSpan((Spanned)buffer);
                if (this.mEasyEditSpan != null) {
                    if (this.mPopupWindow == null) {
                        this.mPopupWindow = new EasyEditPopupWindow();
                        this.mHidePopup = new Runnable(){

                            public void run() {
                                EasyEditSpanController.this.hide();
                            }
                        };
                    }
                    this.mPopupWindow.show(this.mEasyEditSpan);
                    TextView.this.removeCallbacks(this.mHidePopup);
                    TextView.this.postDelayed(this.mHidePopup, 3000L);
                }
            }
        }

        private void adjustSpans(CharSequence buffer) {
            if (buffer instanceof Spannable) {
                Spannable spannable = (Spannable)buffer;
                EasyEditSpan[] spans = spannable.getSpans(0, spannable.length(), EasyEditSpan.class);
                for (int i = 0; i < spans.length - 1; ++i) {
                    spannable.removeSpan(spans[i]);
                }
            }
        }

        private void removeSpans(CharSequence buffer) {
            if (buffer instanceof Spannable) {
                Spannable spannable = (Spannable)buffer;
                EasyEditSpan[] spans = spannable.getSpans(0, spannable.length(), EasyEditSpan.class);
                for (int i = 0; i < spans.length; ++i) {
                    spannable.removeSpan(spans[i]);
                }
            }
        }

        private EasyEditSpan getSpan(Spanned spanned) {
            EasyEditSpan[] easyEditSpans = spanned.getSpans(0, spanned.length(), EasyEditSpan.class);
            if (easyEditSpans.length == 0) {
                return null;
            }
            return easyEditSpans[0];
        }
    }

    private static final class Marquee
    extends Handler {
        private static final float MARQUEE_DELTA_MAX = 0.07f;
        private static final int MARQUEE_DELAY = 1200;
        private static final int MARQUEE_RESTART_DELAY = 1200;
        private static final int MARQUEE_RESOLUTION = 33;
        private static final int MARQUEE_PIXELS_PER_SECOND = 30;
        private static final byte MARQUEE_STOPPED = 0;
        private static final byte MARQUEE_STARTING = 1;
        private static final byte MARQUEE_RUNNING = 2;
        private static final int MESSAGE_START = 1;
        private static final int MESSAGE_TICK = 2;
        private static final int MESSAGE_RESTART = 3;
        private final WeakReference<TextView> mView;
        private byte mStatus = 0;
        private final float mScrollUnit;
        private float mMaxScroll;
        float mMaxFadeScroll;
        private float mGhostStart;
        private float mGhostOffset;
        private float mFadeStop;
        private int mRepeatLimit;
        float mScroll;

        Marquee(TextView v) {
            float density = v.getContext().getResources().getDisplayMetrics().density;
            this.mScrollUnit = 30.0f * density / 33.0f;
            this.mView = new WeakReference<TextView>(v);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mStatus = (byte)2;
                    this.tick();
                    break;
                }
                case 2: {
                    this.tick();
                    break;
                }
                case 3: {
                    if (this.mStatus != 2) break;
                    if (this.mRepeatLimit >= 0) {
                        --this.mRepeatLimit;
                    }
                    this.start(this.mRepeatLimit);
                }
            }
        }

        void tick() {
            if (this.mStatus != 2) {
                return;
            }
            this.removeMessages(2);
            TextView textView = (TextView)this.mView.get();
            if (textView != null && (textView.isFocused() || textView.isSelected())) {
                this.mScroll += this.mScrollUnit;
                if (this.mScroll > this.mMaxScroll) {
                    this.mScroll = this.mMaxScroll;
                    this.sendEmptyMessageDelayed(3, 1200L);
                } else {
                    this.sendEmptyMessageDelayed(2, 33L);
                }
                textView.invalidate();
            }
        }

        void stop() {
            this.mStatus = 0;
            this.removeMessages(1);
            this.removeMessages(3);
            this.removeMessages(2);
            this.resetScroll();
        }

        private void resetScroll() {
            this.mScroll = 0.0f;
            TextView textView = (TextView)this.mView.get();
            if (textView != null) {
                textView.invalidate();
            }
        }

        void start(int repeatLimit) {
            if (repeatLimit == 0) {
                this.stop();
                return;
            }
            this.mRepeatLimit = repeatLimit;
            TextView textView = (TextView)this.mView.get();
            if (textView != null && textView.mLayout != null) {
                this.mStatus = 1;
                this.mScroll = 0.0f;
                int textWidth = textView.getWidth() - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight();
                float lineWidth = textView.mLayout.getLineWidth(0);
                float gap = (float)textWidth / 3.0f;
                this.mGhostStart = lineWidth - (float)textWidth + gap;
                this.mMaxScroll = this.mGhostStart + (float)textWidth;
                this.mGhostOffset = lineWidth + gap;
                this.mFadeStop = lineWidth + (float)textWidth / 6.0f;
                this.mMaxFadeScroll = this.mGhostStart + lineWidth + lineWidth;
                textView.invalidate();
                this.sendEmptyMessageDelayed(1, 1200L);
            }
        }

        float getGhostOffset() {
            return this.mGhostOffset;
        }

        boolean shouldDrawLeftFade() {
            return this.mScroll <= this.mFadeStop;
        }

        boolean shouldDrawGhost() {
            return this.mStatus == 2 && this.mScroll > this.mGhostStart;
        }

        boolean isRunning() {
            return this.mStatus == 2;
        }

        boolean isStopped() {
            return this.mStatus == 0;
        }
    }

    private class CorrectionHighlighter {
        private final Path mPath = new Path();
        private final Paint mPaint = new Paint(1);
        private int mStart;
        private int mEnd;
        private long mFadingStartTime;
        private static final int FADE_OUT_DURATION = 400;

        public CorrectionHighlighter() {
            this.mPaint.setCompatibilityScaling(TextView.this.getResources().getCompatibilityInfo().applicationScale);
            this.mPaint.setStyle(Paint.Style.FILL);
        }

        public void highlight(CorrectionInfo info) {
            this.mStart = info.getOffset();
            this.mEnd = this.mStart + info.getNewText().length();
            this.mFadingStartTime = SystemClock.uptimeMillis();
            if (this.mStart < 0 || this.mEnd < 0) {
                this.stopAnimation();
            }
        }

        public void draw(Canvas canvas, int cursorOffsetVertical) {
            if (this.updatePath() && this.updatePaint()) {
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, cursorOffsetVertical);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, -cursorOffsetVertical);
                }
                this.invalidate(true);
            } else {
                this.stopAnimation();
                this.invalidate(false);
            }
        }

        private boolean updatePaint() {
            long duration = SystemClock.uptimeMillis() - this.mFadingStartTime;
            if (duration > 400L) {
                return false;
            }
            float coef = 1.0f - (float)duration / 400.0f;
            int highlightColorAlpha = Color.alpha(TextView.this.mHighlightColor);
            int color2 = (TextView.this.mHighlightColor & 0xFFFFFF) + ((int)((float)highlightColorAlpha * coef) << 24);
            this.mPaint.setColor(color2);
            return true;
        }

        private boolean updatePath() {
            Layout layout2 = TextView.this.mLayout;
            if (layout2 == null) {
                return false;
            }
            int length = TextView.this.mText.length();
            int start = Math.min(length, this.mStart);
            int end = Math.min(length, this.mEnd);
            this.mPath.reset();
            TextView.this.mLayout.getSelectionPath(start, end, this.mPath);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidate(boolean delayed) {
            if (TextView.this.mLayout == null) {
                return;
            }
            RectF rectF = sTempRect;
            synchronized (rectF) {
                this.mPath.computeBounds(sTempRect, false);
                int left = TextView.this.getCompoundPaddingLeft();
                int top = TextView.this.getExtendedPaddingTop() + TextView.this.getVerticalOffset(true);
                if (delayed) {
                    TextView.this.postInvalidateDelayed(16L, left + (int)sTempRect.left, top + (int)sTempRect.top, left + (int)sTempRect.right, top + (int)sTempRect.bottom);
                } else {
                    TextView.this.postInvalidate((int)sTempRect.left, (int)sTempRect.top, (int)sTempRect.right, (int)sTempRect.bottom);
                }
            }
        }

        private void stopAnimation() {
            TextView.this.mCorrectionHighlighter = null;
        }
    }

    private static class ErrorPopup
    extends PopupWindow {
        private boolean mAbove = false;
        private final TextView mView;
        private int mPopupInlineErrorBackgroundId = 0;
        private int mPopupInlineErrorAboveBackgroundId = 0;

        ErrorPopup(TextView v, int width, int height) {
            super(v, width, height);
            this.mView = v;
            this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 217);
            this.mView.setBackgroundResource(this.mPopupInlineErrorBackgroundId);
        }

        void fixDirection(boolean above) {
            this.mAbove = above;
            if (above) {
                this.mPopupInlineErrorAboveBackgroundId = this.getResourceId(this.mPopupInlineErrorAboveBackgroundId, 218);
            } else {
                this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 217);
            }
            this.mView.setBackgroundResource(above ? this.mPopupInlineErrorAboveBackgroundId : this.mPopupInlineErrorBackgroundId);
        }

        private int getResourceId(int currentId, int index) {
            if (currentId == 0) {
                TypedArray styledAttributes = this.mView.getContext().obtainStyledAttributes(R.styleable.Theme);
                currentId = styledAttributes.getResourceId(index, 0);
                styledAttributes.recycle();
            }
            return currentId;
        }

        public void update(int x, int y, int w, int h, boolean force) {
            super.update(x, y, w, h, force);
            boolean above = this.isAboveAnchor();
            if (above != this.mAbove) {
                this.fixDirection(above);
            }
        }
    }

    private static class CharWrapper
    implements CharSequence,
    GetChars,
    GraphicsOperations {
        private char[] mChars;
        private int mStart;
        private int mLength;

        public CharWrapper(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        void set(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        public int length() {
            return this.mLength;
        }

        public char charAt(int off) {
            return this.mChars[off + this.mStart];
        }

        public String toString() {
            return new String(this.mChars, this.mStart, this.mLength);
        }

        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            return new String(this.mChars, start + this.mStart, end - start);
        }

        public void getChars(int start, int end, char[] buf, int off) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            System.arraycopy(this.mChars, start + this.mStart, buf, off, end - start);
        }

        public void drawText(Canvas c, int start, int end, float x, float y, Paint p) {
            c.drawText(this.mChars, start + this.mStart, end - start, x, y, p);
        }

        public void drawTextRun(Canvas c, int start, int end, int contextStart, int contextEnd, float x, float y, int flags, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, x, y, flags, p);
        }

        public float measureText(int start, int end, Paint p) {
            return p.measureText(this.mChars, start + this.mStart, end - start);
        }

        public int getTextWidths(int start, int end, float[] widths, Paint p) {
            return p.getTextWidths(this.mChars, start + this.mStart, end - start, widths);
        }

        public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesIndex, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            return p.getTextRunAdvances(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, flags, advances, advancesIndex);
        }

        public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesIndex, Paint p, int reserved) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            return p.getTextRunAdvances(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, flags, advances, advancesIndex, reserved);
        }

        public int getTextRunCursor(int contextStart, int contextEnd, int flags, int offset, int cursorOpt, Paint p) {
            int contextCount = contextEnd - contextStart;
            return p.getTextRunCursor(this.mChars, contextStart + this.mStart, contextCount, flags, offset + this.mStart, cursorOpt);
        }

        static /* synthetic */ char[] access$102(CharWrapper x0, char[] x1) {
            x0.mChars = x1;
            return x1;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int selStart;
        int selEnd;
        CharSequence text;
        boolean frozenWithFocus;
        CharSequence error;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.selStart);
            out.writeInt(this.selEnd);
            out.writeInt(this.frozenWithFocus ? 1 : 0);
            TextUtils.writeToParcel(this.text, out, flags);
            if (this.error == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                TextUtils.writeToParcel(this.error, out, flags);
            }
        }

        public String toString() {
            String str = "TextView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " start=" + this.selStart + " end=" + this.selEnd;
            if (this.text != null) {
                str = str + " text=" + this.text;
            }
            return str + "}";
        }

        private SavedState(Parcel in) {
            super(in);
            this.selStart = in.readInt();
            this.selEnd = in.readInt();
            this.frozenWithFocus = in.readInt() != 0;
            this.text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() != 0) {
                this.error = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
        }
    }

    public static interface OnEditorActionListener {
        public boolean onEditorAction(TextView var1, int var2, KeyEvent var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TextAlign {
        INHERIT,
        GRAVITY,
        TEXT_START,
        TEXT_END,
        CENTER,
        VIEW_START,
        VIEW_END;

    }

    static class InputMethodState {
        Rect mCursorRectInWindow = new Rect();
        RectF mTmpRectF = new RectF();
        float[] mTmpOffset = new float[2];
        ExtractedTextRequest mExtracting;
        final ExtractedText mTmpExtracted = new ExtractedText();
        int mBatchEditNesting;
        boolean mCursorChanged;
        boolean mSelectionModeChanged;
        boolean mContentChanged;
        int mChangedStart;
        int mChangedEnd;
        int mChangedDelta;

        InputMethodState() {
        }
    }

    static class InputContentType {
        int imeOptions = 0;
        String privateImeOptions;
        CharSequence imeActionLabel;
        int imeActionId;
        Bundle extras;
        OnEditorActionListener onEditorActionListener;
        boolean enterDown;

        InputContentType() {
        }
    }

    static class Drawables {
        final Rect mCompoundRect = new Rect();
        Drawable mDrawableTop;
        Drawable mDrawableBottom;
        Drawable mDrawableLeft;
        Drawable mDrawableRight;
        Drawable mDrawableStart;
        Drawable mDrawableEnd;
        int mDrawableSizeTop;
        int mDrawableSizeBottom;
        int mDrawableSizeLeft;
        int mDrawableSizeRight;
        int mDrawableSizeStart;
        int mDrawableSizeEnd;
        int mDrawableWidthTop;
        int mDrawableWidthBottom;
        int mDrawableHeightLeft;
        int mDrawableHeightRight;
        int mDrawableHeightStart;
        int mDrawableHeightEnd;
        int mDrawablePadding;

        Drawables() {
        }
    }
}

