/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import com.android.internal.os.storage.ExternalStorageFormatter;

public class ExternalMediaFormatActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final int POSITIVE_BUTTON = -1;
    private BroadcastReceiver mStorageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.d("ExternalMediaFormatActivity", "got action " + action);
            if (action == "android.intent.action.MEDIA_REMOVED" || action == "android.intent.action.MEDIA_CHECKING" || action == "android.intent.action.MEDIA_MOUNTED" || action == "android.intent.action.MEDIA_SHARED") {
                ExternalMediaFormatActivity.this.finish();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d("ExternalMediaFormatActivity", "onCreate!");
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301642;
        p.mTitle = this.getString(17040399);
        p.mMessage = this.getString(0x1040410);
        p.mPositiveButtonText = this.getString(0x1040411);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(0x1040000);
        p.mNegativeButtonListener = this;
        this.setupAlert();
    }

    protected void onResume() {
        super.onResume();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_REMOVED");
        filter.addAction("android.intent.action.MEDIA_CHECKING");
        filter.addAction("android.intent.action.MEDIA_MOUNTED");
        filter.addAction("android.intent.action.MEDIA_SHARED");
        this.registerReceiver(this.mStorageReceiver, filter);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mStorageReceiver);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            Intent intent = new Intent("com.android.internal.os.storage.FORMAT_ONLY");
            intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
            this.startService(intent);
        }
        this.finish();
    }
}

