/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

public class HeavyWeightSwitcherActivity
extends Activity {
    public static final String KEY_INTENT = "intent";
    public static final String KEY_HAS_RESULT = "has_result";
    public static final String KEY_CUR_APP = "cur_app";
    public static final String KEY_CUR_TASK = "cur_task";
    public static final String KEY_NEW_APP = "new_app";
    IntentSender mStartIntent;
    boolean mHasResult;
    String mCurApp;
    int mCurTask;
    String mNewApp;
    private View.OnClickListener mSwitchOldListener = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                ActivityManagerNative.getDefault().moveTaskToFront(HeavyWeightSwitcherActivity.this.mCurTask, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            HeavyWeightSwitcherActivity.this.finish();
        }
    };
    private View.OnClickListener mSwitchNewListener = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                ActivityManagerNative.getDefault().finishHeavyWeightApp();
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                if (HeavyWeightSwitcherActivity.this.mHasResult) {
                    HeavyWeightSwitcherActivity.this.startIntentSenderForResult(HeavyWeightSwitcherActivity.this.mStartIntent, -1, null, 0x2000000, 0x2000000, 0);
                } else {
                    HeavyWeightSwitcherActivity.this.startIntentSenderForResult(HeavyWeightSwitcherActivity.this.mStartIntent, -1, null, 0, 0, 0);
                }
            }
            catch (IntentSender.SendIntentException ex) {
                Log.w("HeavyWeightSwitcherActivity", "Failure starting", ex);
            }
            HeavyWeightSwitcherActivity.this.finish();
        }
    };
    private View.OnClickListener mCancelListener = new View.OnClickListener(){

        public void onClick(View v) {
            HeavyWeightSwitcherActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(3);
        this.mStartIntent = (IntentSender)this.getIntent().getParcelableExtra(KEY_INTENT);
        this.mHasResult = this.getIntent().getBooleanExtra(KEY_HAS_RESULT, false);
        this.mCurApp = this.getIntent().getStringExtra(KEY_CUR_APP);
        this.mCurTask = this.getIntent().getIntExtra(KEY_CUR_TASK, 0);
        this.mNewApp = this.getIntent().getStringExtra(KEY_NEW_APP);
        this.setContentView(17367107);
        this.setIconAndText(16908914, 16908915, 16908916, this.mCurApp, 17040320, 17040321);
        this.setIconAndText(16908918, 16908919, 16908920, this.mNewApp, 17040322, 17040323);
        View button = this.findViewById(16908913);
        button.setOnClickListener(this.mSwitchOldListener);
        button = this.findViewById(16908917);
        button.setOnClickListener(this.mSwitchNewListener);
        button = this.findViewById(16908886);
        button.setOnClickListener(this.mCancelListener);
        TypedValue out = new TypedValue();
        this.getTheme().resolveAttribute(16843605, out, true);
        this.getWindow().setFeatureDrawableResource(3, out.resourceId);
    }

    void setText(int id2, CharSequence text) {
        ((TextView)this.findViewById(id2)).setText(text);
    }

    void setDrawable(int id2, Drawable dr) {
        if (dr != null) {
            ((ImageView)this.findViewById(id2)).setImageDrawable(dr);
        }
    }

    void setIconAndText(int iconId, int actionId, int descriptionId, String packageName, int actionStr, int descriptionStr) {
        CharSequence appName = "";
        Drawable appIcon = null;
        if (this.mCurApp != null) {
            try {
                ApplicationInfo info = this.getPackageManager().getApplicationInfo(packageName, 0);
                appName = info.loadLabel(this.getPackageManager());
                appIcon = info.loadIcon(this.getPackageManager());
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        this.setDrawable(iconId, appIcon);
        this.setText(actionId, this.getString(actionStr, appName));
        this.setText(descriptionId, this.getText(descriptionStr));
    }
}

