/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverActivity
extends AlertActivity
implements DialogInterface.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private ResolveListAdapter mAdapter;
    private CheckBox mAlwaysCheck;
    private TextView mClearDefaultHint;
    private PackageManager mPm;

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.onCreate(savedInstanceState, this.makeMyIntent(), this.getResources().getText(17040287), null, null, true);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        super.onCreate(savedInstanceState);
        this.mPm = this.getPackageManager();
        intent.setComponent(null);
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mTitle = title;
        ap.mOnClickListener = this;
        if (alwaysUseOption) {
            LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
            ap.mView = inflater.inflate(17367078, null);
            this.mAlwaysCheck = (CheckBox)ap.mView.findViewById(16908869);
            this.mAlwaysCheck.setText(17040288);
            this.mAlwaysCheck.setOnCheckedChangeListener(this);
            this.mClearDefaultHint = (TextView)ap.mView.findViewById(16908870);
            this.mClearDefaultHint.setVisibility(8);
        }
        this.mAdapter = new ResolveListAdapter(this, intent, initialIntents, rList);
        int count = this.mAdapter.getCount();
        if (count > 1) {
            ap.mAdapter = this.mAdapter;
        } else {
            if (count == 1) {
                this.startActivity(this.mAdapter.intentForPosition(0));
                this.finish();
                return;
            }
            ap.mMessage = this.getResources().getText(17040292);
        }
        this.setupAlert();
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which);
        Intent intent = this.mAdapter.intentForPosition(which);
        boolean alwaysCheck = this.mAlwaysCheck != null && this.mAlwaysCheck.isChecked();
        this.onIntentSelected(ri, intent, alwaysCheck);
        this.finish();
    }

    protected void onIntentSelected(ResolveInfo ri, Intent intent, boolean alwaysCheck) {
        if (alwaysCheck) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter = new IntentFilter();
            if (intent.getAction() != null) {
                filter.addAction(intent.getAction());
            }
            if ((categories = intent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = intent.getData();
            if (cat == 0x600000 && (mimeType = intent.resolveType(this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w("ResolverActivity", e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<PatternMatcher> pIt;
                filter.addDataScheme(data.getScheme());
                Iterator<IntentFilter.AuthorityEntry> aIt = ri.filter.authoritiesIterator();
                if (aIt != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mList.size();
                ComponentName[] set = new ComponentName[N];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = ((DisplayResolveInfo)((ResolveListAdapter)this.mAdapter).mList.get((int)i)).ri;
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                this.getPackageManager().addPreferredActivity(filter, bestMatch, set, intent.getComponent());
            }
        }
        if (intent != null) {
            this.startActivity(intent);
        }
    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (this.mClearDefaultHint == null) {
            return;
        }
        if (isChecked) {
            this.mClearDefaultHint.setVisibility(0);
        } else {
            this.mClearDefaultHint.setVisibility(8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResolveListAdapter
    extends BaseAdapter {
        private final Intent mIntent;
        private final LayoutInflater mInflater;
        private List<DisplayResolveInfo> mList;

        public ResolveListAdapter(Context context, Intent intent, Intent[] initialIntents, List<ResolveInfo> rList) {
            int N;
            this.mIntent = new Intent(intent);
            this.mIntent.setComponent(null);
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            if (rList == null) {
                rList = ResolverActivity.this.mPm.queryIntentActivities(intent, 0x10000 | (ResolverActivity.this.mAlwaysCheck != null ? 64 : 0));
            }
            if (rList != null && (N = rList.size()) > 0) {
                ResolveInfo ri;
                int i;
                ResolveInfo r0 = rList.get(0);
                for (i = 1; i < N; ++i) {
                    ResolveInfo ri2 = rList.get(i);
                    if (r0.priority == ri2.priority && r0.isDefault == ri2.isDefault) continue;
                    while (i < N) {
                        rList.remove(i);
                        --N;
                    }
                }
                if (N > 1) {
                    ResolveInfo.DisplayNameComparator rComparator = new ResolveInfo.DisplayNameComparator(ResolverActivity.this.mPm);
                    Collections.sort(rList, rComparator);
                }
                this.mList = new ArrayList<DisplayResolveInfo>();
                if (initialIntents != null) {
                    for (i = 0; i < initialIntents.length; ++i) {
                        Intent ii = initialIntents[i];
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w("ResolverActivity", "No activity found for " + ii);
                            continue;
                        }
                        ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.icon = li.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(ri, ri.loadLabel(ResolverActivity.this.getPackageManager()), null, ii));
                    }
                }
                r0 = rList.get(0);
                int start = 0;
                CharSequence r0Label = r0.loadLabel(ResolverActivity.this.mPm);
                for (int i2 = 1; i2 < N; ++i2) {
                    CharSequence riLabel;
                    if (r0Label == null) {
                        r0Label = r0.activityInfo.packageName;
                    }
                    if ((riLabel = (ri = rList.get(i2)).loadLabel(ResolverActivity.this.mPm)) == null) {
                        riLabel = ri.activityInfo.packageName;
                    }
                    if (riLabel.equals(r0Label)) continue;
                    this.processGroup(rList, start, i2 - 1, r0, r0Label);
                    r0 = ri;
                    r0Label = riLabel;
                    start = i2;
                }
                this.processGroup(rList, start, N - 1, r0, r0Label);
            }
        }

        private void processGroup(List<ResolveInfo> rList, int start, int end, ResolveInfo ro, CharSequence roLabel) {
            int num = end - start + 1;
            if (num == 1) {
                this.mList.add(new DisplayResolveInfo(ro, roLabel, null, null));
            } else {
                boolean usePkg = false;
                CharSequence startApp = ro.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                if (startApp == null) {
                    usePkg = true;
                }
                if (!usePkg) {
                    HashSet<CharSequence> duplicates = new HashSet<CharSequence>();
                    duplicates.add(startApp);
                    for (int j = start + 1; j <= end; ++j) {
                        ResolveInfo jRi = rList.get(j);
                        CharSequence jApp = jRi.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                        if (jApp == null || duplicates.contains(jApp)) {
                            usePkg = true;
                            break;
                        }
                        duplicates.add(jApp);
                    }
                    duplicates.clear();
                }
                for (int k = start; k <= end; ++k) {
                    ResolveInfo add = rList.get(k);
                    if (usePkg) {
                        this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.packageName, null));
                        continue;
                    }
                    this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm), null));
                }
            }
        }

        public ResolveInfo resolveInfoForPosition(int position) {
            if (this.mList == null) {
                return null;
            }
            return this.mList.get((int)position).ri;
        }

        public Intent intentForPosition(int position) {
            if (this.mList == null) {
                return null;
            }
            DisplayResolveInfo dri = this.mList.get(position);
            Intent intent = new Intent(dri.origIntent != null ? dri.origIntent : this.mIntent);
            intent.addFlags(0x3000000);
            ActivityInfo ai = dri.ri.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            return intent;
        }

        @Override
        public int getCount() {
            return this.mList != null ? this.mList.size() : 0;
        }

        @Override
        public Object getItem(int position) {
            return position;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView == null ? this.mInflater.inflate(17367167, parent, false) : convertView;
            this.bindView(view, this.mList.get(position));
            return view;
        }

        private final void bindView(View view, DisplayResolveInfo info) {
            TextView text = (TextView)view.findViewById(16908308);
            TextView text2 = (TextView)view.findViewById(16908309);
            ImageView icon = (ImageView)view.findViewById(16908294);
            text.setText(info.displayLabel);
            if (info.extendedInfo != null) {
                text2.setVisibility(0);
                text2.setText(info.extendedInfo);
            } else {
                text2.setVisibility(8);
            }
            if (info.displayIcon == null) {
                info.displayIcon = info.ri.loadIcon(ResolverActivity.this.mPm);
            }
            icon.setImageDrawable(info.displayIcon);
        }
    }

    private final class DisplayResolveInfo {
        ResolveInfo ri;
        CharSequence displayLabel;
        Drawable displayIcon;
        CharSequence extendedInfo;
        Intent origIntent;

        DisplayResolveInfo(ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.ri = pri;
            this.displayLabel = pLabel;
            this.extendedInfo = pInfo;
            this.origIntent = pOrigIntent;
        }
    }
}

