/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.IActivityManager;
import android.app.ProgressDialog;
import android.bluetooth.IBluetooth;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Power;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Vibrator;
import android.os.storage.IMountService;
import android.os.storage.IMountShutdownObserver;
import android.util.Log;
import com.android.internal.telephony.ITelephony;

public final class ShutdownThread
extends Thread {
    private static final String TAG = "ShutdownThread";
    private static final int MAX_NUM_PHONE_STATE_READS = 16;
    private static final int PHONE_STATE_POLL_SLEEP_MSEC = 500;
    private static final int MAX_BROADCAST_TIME = 10000;
    private static final int MAX_SHUTDOWN_WAIT_TIME = 20000;
    private static final int SHUTDOWN_VIBRATE_MS = 500;
    private static Object sIsStartedGuard = new Object();
    private static boolean sIsStarted = false;
    private static boolean mReboot;
    private static String mRebootReason;
    public static final String SHUTDOWN_ACTION_PROPERTY = "sys.shutdown.requested";
    private static final ShutdownThread sInstance;
    private final Object mActionDoneSync = new Object();
    private boolean mActionDone;
    private Context mContext;
    private PowerManager mPowerManager;
    private PowerManager.WakeLock mCpuWakeLock;
    private PowerManager.WakeLock mScreenWakeLock;
    private Handler mHandler;

    private ShutdownThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(final Context context, boolean confirm) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Request to shutdown already running, returning.");
                return;
            }
        }
        int longPressBehavior = context.getResources().getInteger(17694738);
        int resourceId = longPressBehavior == 2 ? 17039658 : 17039657;
        Log.d(TAG, "Notifying thread to start shutdown longPressBehavior=" + longPressBehavior);
        if (confirm) {
            CloseDialogReceiver closer = new CloseDialogReceiver(context);
            AlertDialog dialog = new AlertDialog.Builder(context).setTitle(17039652).setMessage(resourceId).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ShutdownThread.beginShutdownSequence(context);
                }
            }).setNegativeButton(17039369, null).create();
            closer.dialog = dialog;
            dialog.setOnDismissListener(closer);
            dialog.getWindow().setType(2009);
            dialog.show();
        } else {
            ShutdownThread.beginShutdownSequence(context);
        }
    }

    public static void reboot(Context context, String reason, boolean confirm) {
        mReboot = true;
        mRebootReason = reason;
        ShutdownThread.shutdown(context, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void beginShutdownSequence(Context context) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Shutdown sequence already running, returning.");
                return;
            }
            sIsStarted = true;
        }
        ProgressDialog pd = new ProgressDialog(context);
        pd.setTitle(context.getText(17039652));
        pd.setMessage(context.getText(17039656));
        pd.setIndeterminate(true);
        pd.setCancelable(false);
        pd.getWindow().setType(2009);
        pd.show();
        ShutdownThread.sInstance.mContext = context;
        ShutdownThread.sInstance.mPowerManager = (PowerManager)context.getSystemService("power");
        ShutdownThread.sInstance.mCpuWakeLock = null;
        try {
            ShutdownThread.sInstance.mCpuWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(1, "ShutdownThread-cpu");
            ShutdownThread.sInstance.mCpuWakeLock.setReferenceCounted(false);
            ShutdownThread.sInstance.mCpuWakeLock.acquire();
        }
        catch (SecurityException e) {
            Log.w(TAG, "No permission to acquire wake lock", e);
            ShutdownThread.sInstance.mCpuWakeLock = null;
        }
        ShutdownThread.sInstance.mScreenWakeLock = null;
        if (ShutdownThread.sInstance.mPowerManager.isScreenOn()) {
            try {
                ShutdownThread.sInstance.mScreenWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(26, "ShutdownThread-screen");
                ShutdownThread.sInstance.mScreenWakeLock.setReferenceCounted(false);
                ShutdownThread.sInstance.mScreenWakeLock.acquire();
            }
            catch (SecurityException e) {
                Log.w(TAG, "No permission to acquire wake lock", e);
                ShutdownThread.sInstance.mScreenWakeLock = null;
            }
        }
        ShutdownThread.sInstance.mHandler = new Handler(){};
        sInstance.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionDone() {
        Object object = this.mActionDoneSync;
        synchronized (object) {
            this.mActionDone = true;
            this.mActionDoneSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean radioOff;
        boolean bluetoothOff;
        BroadcastReceiver br = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ShutdownThread.this.actionDone();
            }
        };
        String reason = (mReboot ? "1" : "0") + (mRebootReason != null ? mRebootReason : "");
        SystemProperties.set(SHUTDOWN_ACTION_PROPERTY, reason);
        Log.i(TAG, "Sending shutdown broadcast...");
        this.mActionDone = false;
        this.mContext.sendOrderedBroadcast(new Intent("android.intent.action.ACTION_SHUTDOWN"), null, br, this.mHandler, 0, null, null);
        long endTime = SystemClock.elapsedRealtime() + 10000L;
        Object object = this.mActionDoneSync;
        synchronized (object) {
            while (!this.mActionDone) {
                long delay = endTime - SystemClock.elapsedRealtime();
                if (delay <= 0L) {
                    Log.w(TAG, "Shutdown broadcast timed out");
                    break;
                }
                try {
                    this.mActionDoneSync.wait(delay);
                }
                catch (InterruptedException e) {}
            }
        }
        Log.i(TAG, "Shutting down activity manager...");
        IActivityManager am = ActivityManagerNative.asInterface(ServiceManager.checkService("activity"));
        if (am != null) {
            try {
                am.shutdown(10000);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        IBluetooth bluetooth = IBluetooth.Stub.asInterface(ServiceManager.checkService("bluetooth"));
        IMountService mount = IMountService.Stub.asInterface(ServiceManager.checkService("mount"));
        try {
            boolean bl = bluetoothOff = bluetooth == null || bluetooth.getBluetoothState() == 10;
            if (!bluetoothOff) {
                Log.w(TAG, "Disabling Bluetooth...");
                bluetooth.disable(false);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "RemoteException during bluetooth shutdown", ex);
            bluetoothOff = true;
        }
        try {
            boolean bl = radioOff = phone == null || !phone.isRadioOn();
            if (!radioOff) {
                Log.w(TAG, "Turning off radio...");
                phone.setRadio(false);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "RemoteException during radio shutdown", ex);
            radioOff = true;
        }
        Log.i(TAG, "Waiting for Bluetooth and Radio...");
        for (int i = 0; i < 16; ++i) {
            if (!bluetoothOff) {
                try {
                    bluetoothOff = bluetooth.getBluetoothState() == 10;
                }
                catch (RemoteException ex) {
                    Log.e(TAG, "RemoteException during bluetooth shutdown", ex);
                    bluetoothOff = true;
                }
            }
            if (!radioOff) {
                try {
                    radioOff = !phone.isRadioOn();
                }
                catch (RemoteException ex) {
                    Log.e(TAG, "RemoteException during radio shutdown", ex);
                    radioOff = true;
                }
            }
            if (radioOff && bluetoothOff) {
                Log.i(TAG, "Radio and Bluetooth shutdown complete.");
                break;
            }
            SystemClock.sleep(500L);
        }
        IMountShutdownObserver.Stub observer = new IMountShutdownObserver.Stub(){

            public void onShutDownComplete(int statusCode) throws RemoteException {
                Log.w(ShutdownThread.TAG, "Result code " + statusCode + " from MountService.shutdown");
                ShutdownThread.this.actionDone();
            }
        };
        Log.i(TAG, "Shutting down MountService");
        this.mActionDone = false;
        long endShutTime = SystemClock.elapsedRealtime() + 20000L;
        Object object2 = this.mActionDoneSync;
        synchronized (object2) {
            try {
                if (mount != null) {
                    mount.shutdown(observer);
                } else {
                    Log.w(TAG, "MountService unavailable for shutdown");
                }
            }
            catch (Exception e) {
                Log.e(TAG, "Exception during MountService shutdown", e);
            }
            while (!this.mActionDone) {
                long delay = endShutTime - SystemClock.elapsedRealtime();
                if (delay <= 0L) {
                    Log.w(TAG, "Shutdown wait timed out");
                    break;
                }
                try {
                    this.mActionDoneSync.wait(delay);
                }
                catch (InterruptedException e) {}
            }
        }
        ShutdownThread.rebootOrShutdown(mReboot, mRebootReason);
    }

    public static void rebootOrShutdown(boolean reboot, String reason) {
        if (reboot) {
            Log.i(TAG, "Rebooting, reason: " + reason);
            try {
                Power.reboot(reason);
            }
            catch (Exception e) {
                Log.e(TAG, "Reboot failed, will attempt shutdown instead", e);
            }
        } else {
            Vibrator vibrator = new Vibrator();
            try {
                vibrator.vibrate(500L);
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to vibrate during shutdown.", e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.i(TAG, "Performing low-level shutdown...");
        Power.shutdown();
    }

    static {
        sInstance = new ShutdownThread();
    }

    private static class CloseDialogReceiver
    extends BroadcastReceiver
    implements DialogInterface.OnDismissListener {
        private Context mContext;
        public Dialog dialog;

        CloseDialogReceiver(Context context) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            context.registerReceiver(this, filter);
        }

        public void onReceive(Context context, Intent intent) {
            this.dialog.cancel();
        }

        public void onDismiss(DialogInterface unused) {
            this.mContext.unregisterReceiver(this);
        }
    }
}

