/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.net.NetworkStats;
import android.os.SystemClock;
import android.util.Slog;
import com.android.internal.util.ProcFileReader;
import com.android.server.NetworkManagementSocketTagger;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkStatsFactory {
    private static final String TAG = "NetworkStatsFactory";
    @Deprecated
    private final File mStatsIface;
    @Deprecated
    private final File mStatsXtIface;
    private final File mStatsXtIfaceAll;
    private final File mStatsXtUid;
    private static final String KEY_IDX = "idx";
    private static final String KEY_IFACE = "iface";
    private static final String KEY_ACTIVE = "active";
    private static final String KEY_UID = "uid_tag_int";
    private static final String KEY_COUNTER_SET = "cnt_set";
    private static final String KEY_TAG_HEX = "acct_tag_hex";
    private static final String KEY_SNAP_RX_BYTES = "snap_rx_bytes";
    private static final String KEY_SNAP_RX_PACKETS = "snap_rx_packets";
    private static final String KEY_SNAP_TX_BYTES = "snap_tx_bytes";
    private static final String KEY_SNAP_TX_PACKETS = "snap_tx_packets";
    private static final String KEY_RX_BYTES = "rx_bytes";
    private static final String KEY_RX_PACKETS = "rx_packets";
    private static final String KEY_TX_BYTES = "tx_bytes";
    private static final String KEY_TX_PACKETS = "tx_packets";

    public NetworkStatsFactory() {
        this(new File("/proc/"));
    }

    public NetworkStatsFactory(File procRoot) {
        this.mStatsIface = new File(procRoot, "net/dev");
        this.mStatsXtUid = new File(procRoot, "net/xt_qtaguid/stats");
        this.mStatsXtIface = new File(procRoot, "net/xt_qtaguid/iface_stat");
        this.mStatsXtIfaceAll = new File(procRoot, "net/xt_qtaguid/iface_stat_all");
    }

    public NetworkStats readNetworkStatsSummary() throws IllegalStateException {
        if (this.mStatsXtIfaceAll.exists()) {
            return this.readNetworkStatsSummarySingleFile();
        }
        return this.readNetworkStatsSummaryMultipleFiles();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetworkStats readNetworkStatsSummarySingleFile() {
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ArrayList<String> keys = Lists.newArrayList(KEY_IFACE, KEY_ACTIVE, KEY_SNAP_RX_BYTES, KEY_SNAP_RX_PACKETS, KEY_SNAP_TX_BYTES, KEY_SNAP_TX_PACKETS, KEY_RX_BYTES, KEY_RX_PACKETS, KEY_TX_BYTES, KEY_TX_PACKETS);
        ArrayList<String> values = Lists.newArrayList();
        HashMap<String, String> parsed = Maps.newHashMap();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.mStatsXtIfaceAll));
            while ((line = reader.readLine()) != null) {
                boolean active;
                NetworkStatsFactory.splitLine(line, values);
                NetworkStatsFactory.parseLine(keys, values, parsed);
                entry.iface = parsed.get(KEY_IFACE);
                entry.uid = -1;
                entry.set = 0;
                entry.tag = 0;
                entry.rxBytes = NetworkStatsFactory.getParsedLong(parsed, KEY_SNAP_RX_BYTES);
                entry.rxPackets = NetworkStatsFactory.getParsedLong(parsed, KEY_SNAP_RX_PACKETS);
                entry.txBytes = NetworkStatsFactory.getParsedLong(parsed, KEY_SNAP_TX_BYTES);
                entry.txPackets = NetworkStatsFactory.getParsedLong(parsed, KEY_SNAP_TX_PACKETS);
                boolean bl = active = NetworkStatsFactory.getParsedInt(parsed, KEY_ACTIVE) != 0;
                if (active) {
                    entry.rxBytes += NetworkStatsFactory.getParsedLong(parsed, KEY_RX_BYTES);
                    entry.rxPackets += NetworkStatsFactory.getParsedLong(parsed, KEY_RX_PACKETS);
                    entry.txBytes += NetworkStatsFactory.getParsedLong(parsed, KEY_TX_BYTES);
                    entry.txPackets += NetworkStatsFactory.getParsedLong(parsed, KEY_TX_PACKETS);
                }
                stats.addValues(entry);
            }
        }
        catch (NullPointerException e) {
            try {
                throw new IllegalStateException("problem parsing stats: " + e);
                catch (NumberFormatException e2) {
                    throw new IllegalStateException("problem parsing stats: " + e2);
                }
                catch (IOException e3) {
                    throw new IllegalStateException("problem parsing stats: " + e3);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)reader);
        return stats;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    private NetworkStats readNetworkStatsSummaryMultipleFiles() {
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        HashSet knownIfaces = Sets.newHashSet();
        HashSet activeIfaces = Sets.newHashSet();
        for (String iface : NetworkStatsFactory.fileListWithoutNull(this.mStatsXtIface)) {
            File ifacePath = new File(this.mStatsXtIface, iface);
            long active = NetworkStatsFactory.readSingleLongFromFile(new File(ifacePath, KEY_ACTIVE));
            if (active == 1L) {
                knownIfaces.add(iface);
                activeIfaces.add(iface);
            } else {
                if (active != 0L) continue;
                knownIfaces.add(iface);
            }
            entry.iface = iface;
            entry.uid = -1;
            entry.set = 0;
            entry.tag = 0;
            entry.rxBytes = NetworkStatsFactory.readSingleLongFromFile(new File(ifacePath, KEY_RX_BYTES));
            entry.rxPackets = NetworkStatsFactory.readSingleLongFromFile(new File(ifacePath, KEY_RX_PACKETS));
            entry.txBytes = NetworkStatsFactory.readSingleLongFromFile(new File(ifacePath, KEY_TX_BYTES));
            entry.txPackets = NetworkStatsFactory.readSingleLongFromFile(new File(ifacePath, KEY_TX_PACKETS));
            stats.addValues(entry);
        }
        ArrayList<String> values = Lists.newArrayList();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.mStatsIface));
            reader.readLine();
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                NetworkStatsFactory.splitLine(line, values);
                try {
                    entry.iface = values.get(0);
                    entry.uid = -1;
                    entry.set = 0;
                    entry.tag = 0;
                    entry.rxBytes = Long.parseLong(values.get(1));
                    entry.rxPackets = Long.parseLong(values.get(2));
                    entry.txBytes = Long.parseLong(values.get(9));
                    entry.txPackets = Long.parseLong(values.get(10));
                    if (activeIfaces.contains(entry.iface)) {
                        stats.combineValues(entry);
                        continue;
                    }
                    if (knownIfaces.contains(entry.iface)) continue;
                    stats.addValues(entry);
                }
                catch (NumberFormatException e) {
                    Slog.w(TAG, "problem parsing stats row '" + line + "': " + e);
                }
            }
        }
        catch (NullPointerException e) {
            try {
                throw new IllegalStateException("problem parsing stats: " + e);
                catch (NumberFormatException e2) {
                    throw new IllegalStateException("problem parsing stats: " + e2);
                }
                catch (IOException e3) {
                    throw new IllegalStateException("problem parsing stats: " + e3);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)reader);
        return stats;
    }

    public NetworkStats readNetworkStatsDetail() {
        return this.readNetworkStatsDetail(-1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkStats readNetworkStatsDetail(int limitUid) throws IllegalStateException {
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 24);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        int idx = 1;
        int lastIdx = 1;
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtUid));
            reader.finishLine();
            while (reader.hasMoreData()) {
                idx = reader.nextInt();
                if (idx != lastIdx + 1) {
                    throw new IllegalStateException("inconsistent idx=" + idx + " after lastIdx=" + lastIdx);
                }
                lastIdx = idx;
                entry.iface = reader.nextString();
                entry.tag = NetworkManagementSocketTagger.kernelToTag(reader.nextString());
                entry.uid = reader.nextInt();
                entry.set = reader.nextInt();
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (limitUid == -1 || limitUid == entry.uid) {
                    stats.addValues(entry);
                }
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new IllegalStateException("problem parsing idx " + idx, e);
                catch (NumberFormatException e2) {
                    throw new IllegalStateException("problem parsing idx " + idx, e2);
                }
                catch (IOException e3) {
                    throw new IllegalStateException("problem parsing idx " + idx, e3);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)reader);
        return stats;
    }

    @Deprecated
    private static int getParsedInt(HashMap<String, String> parsed, String key) {
        String value = parsed.get(key);
        return value != null ? Integer.parseInt(value) : 0;
    }

    @Deprecated
    private static long getParsedLong(HashMap<String, String> parsed, String key) {
        String value = parsed.get(key);
        return value != null ? Long.parseLong(value) : 0L;
    }

    @Deprecated
    private static void splitLine(String line, ArrayList<String> outSplit) {
        outSplit.clear();
        StringTokenizer t = new StringTokenizer(line, " \t\n\r\f:");
        while (t.hasMoreTokens()) {
            outSplit.add(t.nextToken());
        }
    }

    @Deprecated
    private static void parseLine(ArrayList<String> keys, ArrayList<String> values, HashMap<String, String> outParsed) {
        outParsed.clear();
        int size = Math.min(keys.size(), values.size());
        for (int i = 0; i < size; ++i) {
            outParsed.put(keys.get(i), values.get(i));
        }
    }

    private static long readSingleLongFromFile(File file) {
        try {
            byte[] buffer = IoUtils.readFileAsByteArray((String)file.toString());
            return Long.parseLong(new String(buffer).trim());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private static String[] fileListWithoutNull(File file) {
        String[] list = file.list();
        return list != null ? list : new String[]{};
    }
}

