/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.Process;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import dalvik.system.PathClassLoader;
import dalvik.system.Zygote;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;

class ZygoteConnection {
    private static final String TAG = "Zygote";
    private static final int[][] intArray2d = new int[0][0];
    private static final int CONNECTION_TIMEOUT_MILLIS = 1000;
    private static final int MAX_ZYGOTE_ARGC = 1024;
    private final LocalSocket mSocket;
    private final DataOutputStream mSocketOutStream;
    private final BufferedReader mSocketReader;
    private final Credentials peer;
    private static LocalSocket sPeerWaitSocket = null;

    ZygoteConnection(LocalSocket socket) throws IOException {
        this.mSocket = socket;
        this.mSocketOutStream = new DataOutputStream(socket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException ex) {
            Log.e(TAG, "Cannot read peer credentials", ex);
            throw ex;
        }
    }

    FileDescriptor getFileDesciptor() {
        return this.mSocket.getFileDescriptor();
    }

    void run() throws ZygoteInit.MethodAndArgsCaller {
        int loopCount = 10;
        do {
            if (loopCount <= 0) {
                ZygoteInit.gc();
                loopCount = 10;
                continue;
            }
            --loopCount;
        } while (!this.runOnce());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runOnce() throws ZygoteInit.MethodAndArgsCaller {
        FileDescriptor[] descriptors;
        String[] args;
        Arguments parsedArgs = null;
        try {
            args = this.readArgumentList();
            descriptors = this.mSocket.getAncillaryFileDescriptors();
        }
        catch (IOException ex) {
            Log.w(TAG, "IOException on command socket " + ex.getMessage());
            this.closeSocket();
            return true;
        }
        if (args == null) {
            this.closeSocket();
            return true;
        }
        PrintStream newStderr = null;
        if (descriptors != null && descriptors.length >= 3) {
            newStderr = new PrintStream(new FileOutputStream(descriptors[2]));
        }
        int pid = -1;
        FileDescriptor childPipeFd = null;
        FileDescriptor serverPipeFd = null;
        try {
            parsedArgs = new Arguments(args);
            ZygoteConnection.applyUidSecurityPolicy(parsedArgs, this.peer);
            ZygoteConnection.applyRlimitSecurityPolicy(parsedArgs, this.peer);
            ZygoteConnection.applyCapabilitiesSecurityPolicy(parsedArgs, this.peer);
            ZygoteConnection.applyInvokeWithSecurityPolicy(parsedArgs, this.peer);
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            int[][] rlimits = null;
            if (parsedArgs.rlimits != null) {
                rlimits = (int[][])parsedArgs.rlimits.toArray((T[])intArray2d);
            }
            if (parsedArgs.runtimeInit && parsedArgs.invokeWith != null) {
                FileDescriptor[] pipeFds = Libcore.os.pipe();
                childPipeFd = pipeFds[1];
                serverPipeFd = pipeFds[0];
                ZygoteInit.setCloseOnExec(serverPipeFd, true);
            }
            pid = Zygote.forkAndSpecialize((int)parsedArgs.uid, (int)parsedArgs.gid, (int[])parsedArgs.gids, (int)parsedArgs.debugFlags, (int[][])rlimits);
        }
        catch (IOException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Exception creating pipe", ex);
        }
        catch (ErrnoException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Exception creating pipe", ex);
        }
        catch (IllegalArgumentException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Invalid zygote arguments", ex);
        }
        catch (ZygoteSecurityException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Zygote security policy prevents request: ", ex);
        }
        try {
            if (pid == 0) {
                IoUtils.closeQuietly(serverPipeFd);
                serverPipeFd = null;
                this.handleChildProc(parsedArgs, descriptors, childPipeFd, newStderr);
                boolean bl = true;
                return bl;
            }
            IoUtils.closeQuietly(childPipeFd);
            childPipeFd = null;
            boolean bl = this.handleParentProc(pid, descriptors, serverPipeFd, parsedArgs);
            return bl;
        }
        finally {
            IoUtils.closeQuietly(childPipeFd);
            IoUtils.closeQuietly(serverPipeFd);
        }
    }

    void closeSocket() {
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Log.e(TAG, "Exception while closing command socket in parent", ex);
        }
    }

    private String[] readArgumentList() throws IOException {
        int argc;
        try {
            String s = this.mSocketReader.readLine();
            if (s == null) {
                return null;
            }
            argc = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            Log.e(TAG, "invalid Zygote wire format: non-int at argc");
            throw new IOException("invalid wire format");
        }
        if (argc > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] result = new String[argc];
        for (int i = 0; i < argc; ++i) {
            result[i] = this.mSocketReader.readLine();
            if (result[i] != null) continue;
            throw new IOException("truncated request");
        }
        return result;
    }

    private static void applyUidSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (peerUid != 0) {
            if (peerUid == 1000) {
                boolean uidRestricted;
                String factoryTest = SystemProperties.get("ro.factorytest");
                boolean bl = uidRestricted = !factoryTest.equals("1") && !factoryTest.equals("2");
                if (uidRestricted && args.uidSpecified && args.uid < 1000) {
                    throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
                }
            } else if (args.uidSpecified || args.gidSpecified || args.gids != null) {
                throw new ZygoteSecurityException("App UIDs may not specify uid's or gid's");
            }
        }
        if (!args.uidSpecified) {
            args.uid = peer.getUid();
            args.uidSpecified = true;
        }
        if (!args.gidSpecified) {
            args.gid = peer.getGid();
            args.gidSpecified = true;
        }
    }

    public static void applyDebuggerSystemProperty(Arguments args) {
        if ("1".equals(SystemProperties.get("ro.debuggable"))) {
            args.debugFlags |= 1;
        }
    }

    private static void applyRlimitSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (peerUid != 0 && peerUid != 1000 && args.rlimits != null) {
            throw new ZygoteSecurityException("This UID may not specify rlimits.");
        }
    }

    private static void applyCapabilitiesSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        long permittedCaps;
        if (args.permittedCapabilities == 0L && args.effectiveCapabilities == 0L) {
            return;
        }
        if (peer.getUid() == 0) {
            return;
        }
        try {
            permittedCaps = ZygoteInit.capgetPermitted(peer.getPid());
        }
        catch (IOException ex) {
            throw new ZygoteSecurityException("Error retrieving peer's capabilities.");
        }
        if (((args.permittedCapabilities ^ 0xFFFFFFFFFFFFFFFFL) & args.effectiveCapabilities) != 0L) {
            throw new ZygoteSecurityException("Effective capabilities cannot be superset of  permitted capabilities");
        }
        if (((permittedCaps ^ 0xFFFFFFFFFFFFFFFFL) & args.permittedCapabilities) != 0L) {
            throw new ZygoteSecurityException("Peer specified unpermitted capabilities");
        }
    }

    private static void applyInvokeWithSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (args.invokeWith != null && peerUid != 0) {
            throw new ZygoteSecurityException("Peer is not permitted to specify an explicit invoke-with wrapper command");
        }
    }

    public static void applyInvokeWithSystemProperty(Arguments args) {
        if (args.invokeWith == null && args.niceName != null && args.niceName != null) {
            String property = "wrap." + args.niceName;
            if (property.length() > 31) {
                property = property.substring(0, 31);
            }
            args.invokeWith = SystemProperties.get(property);
            if (args.invokeWith != null && args.invokeWith.length() == 0) {
                args.invokeWith = null;
            }
        }
    }

    private void handleChildProc(Arguments parsedArgs, FileDescriptor[] descriptors, FileDescriptor pipeFd, PrintStream newStderr) throws ZygoteInit.MethodAndArgsCaller {
        if (parsedArgs.peerWait) {
            try {
                ZygoteInit.setCloseOnExec(this.mSocket.getFileDescriptor(), true);
                sPeerWaitSocket = this.mSocket;
            }
            catch (IOException ex) {
                Log.e(TAG, "Zygote Child: error setting peer wait socket to be close-on-exec", ex);
            }
        } else {
            this.closeSocket();
            ZygoteInit.closeServerSocket();
        }
        if (descriptors != null) {
            try {
                ZygoteInit.reopenStdio(descriptors[0], descriptors[1], descriptors[2]);
                for (FileDescriptor fd : descriptors) {
                    IoUtils.closeQuietly((FileDescriptor)fd);
                }
                newStderr = System.err;
            }
            catch (IOException ex) {
                Log.e(TAG, "Error reopening stdio", ex);
            }
        }
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if (parsedArgs.runtimeInit) {
            if (parsedArgs.invokeWith != null) {
                WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, pipeFd, parsedArgs.remainingArgs);
            } else {
                RuntimeInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs);
            }
        } else {
            String className;
            try {
                className = parsedArgs.remainingArgs[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ZygoteConnection.logAndPrintError(newStderr, "Missing required class name argument", null);
                return;
            }
            String[] mainArgs = new String[parsedArgs.remainingArgs.length - 1];
            System.arraycopy(parsedArgs.remainingArgs, 1, mainArgs, 0, mainArgs.length);
            if (parsedArgs.invokeWith != null) {
                WrapperInit.execStandalone(parsedArgs.invokeWith, parsedArgs.classpath, className, mainArgs);
            } else {
                ClassLoader cloader = parsedArgs.classpath != null ? new PathClassLoader(parsedArgs.classpath, ClassLoader.getSystemClassLoader()) : ClassLoader.getSystemClassLoader();
                try {
                    ZygoteInit.invokeStaticMain(cloader, className, mainArgs);
                }
                catch (RuntimeException ex) {
                    ZygoteConnection.logAndPrintError(newStderr, "Error starting.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleParentProc(int pid, FileDescriptor[] descriptors, FileDescriptor pipeFd, Arguments parsedArgs) {
        if (pid > 0) {
            this.setChildPgid(pid);
        }
        if (descriptors != null) {
            for (FileDescriptor fd : descriptors) {
                IoUtils.closeQuietly((FileDescriptor)fd);
            }
        }
        boolean usingWrapper = false;
        if (pipeFd != null && pid > 0) {
            DataInputStream is = new DataInputStream(new FileInputStream(pipeFd));
            int innerPid = -1;
            try {
                innerPid = is.readInt();
            }
            catch (IOException ex) {
                Log.w(TAG, "Error reading pid from wrapped process, child may have died", ex);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
            if (innerPid > 0) {
                int parentPid = innerPid;
                while (parentPid > 0 && parentPid != pid) {
                    parentPid = Process.getParentPid(parentPid);
                }
                if (parentPid > 0) {
                    Log.i(TAG, "Wrapped process has pid " + innerPid);
                    pid = innerPid;
                    usingWrapper = true;
                } else {
                    Log.w(TAG, "Wrapped process reported a pid that is not a child of the process that we forked: childPid=" + pid + " innerPid=" + innerPid);
                }
            }
        }
        try {
            this.mSocketOutStream.writeInt(pid);
            this.mSocketOutStream.writeBoolean(usingWrapper);
        }
        catch (IOException ex) {
            Log.e(TAG, "Error reading from command socket", ex);
            return true;
        }
        if (parsedArgs.peerWait) {
            try {
                this.mSocket.close();
            }
            catch (IOException ex) {
                Log.e(TAG, "Zygote: error closing sockets", ex);
            }
            return true;
        }
        return false;
    }

    private void setChildPgid(int pid) {
        try {
            ZygoteInit.setpgid(pid, ZygoteInit.getpgid(this.peer.getPid()));
        }
        catch (IOException ex) {
            Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
        }
    }

    private static void logAndPrintError(PrintStream newStderr, String message, Throwable ex) {
        Log.e(TAG, message, ex);
        if (newStderr != null) {
            newStderr.println(message + (ex == null ? "" : ex));
        }
    }

    static class Arguments {
        int uid = 0;
        boolean uidSpecified;
        int gid = 0;
        boolean gidSpecified;
        int[] gids;
        boolean peerWait;
        int debugFlags;
        int targetSdkVersion;
        boolean targetSdkVersionSpecified;
        String classpath;
        boolean runtimeInit;
        String niceName;
        boolean capabilitiesSpecified;
        long permittedCapabilities;
        long effectiveCapabilities;
        ArrayList<int[]> rlimits;
        String invokeWith;
        String[] remainingArgs;

        Arguments(String[] args) throws IllegalArgumentException {
            this.parseArgs(args);
        }

        private void parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (arg.startsWith("--setuid=")) {
                    if (this.uidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.uidSpecified = true;
                    this.uid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--setgid=")) {
                    if (this.gidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.gidSpecified = true;
                    this.gid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--target-sdk-version=")) {
                    if (this.targetSdkVersionSpecified) {
                        throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                    }
                    this.targetSdkVersionSpecified = true;
                    this.targetSdkVersion = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.equals("--enable-debugger")) {
                    this.debugFlags |= 1;
                    continue;
                }
                if (arg.equals("--enable-safemode")) {
                    this.debugFlags |= 8;
                    continue;
                }
                if (arg.equals("--enable-checkjni")) {
                    this.debugFlags |= 2;
                    continue;
                }
                if (arg.equals("--enable-jni-logging")) {
                    this.debugFlags |= 0x10;
                    continue;
                }
                if (arg.equals("--enable-assert")) {
                    this.debugFlags |= 4;
                    continue;
                }
                if (arg.equals("--peer-wait")) {
                    this.peerWait = true;
                    continue;
                }
                if (arg.equals("--runtime-init")) {
                    this.runtimeInit = true;
                    continue;
                }
                if (arg.startsWith("--capabilities=")) {
                    if (this.capabilitiesSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.capabilitiesSpecified = true;
                    String capString = arg.substring(arg.indexOf(61) + 1);
                    String[] capStrings = capString.split(",", 2);
                    if (capStrings.length == 1) {
                        this.permittedCapabilities = this.effectiveCapabilities = Long.decode(capStrings[0]).longValue();
                        continue;
                    }
                    this.permittedCapabilities = Long.decode(capStrings[0]);
                    this.effectiveCapabilities = Long.decode(capStrings[1]);
                    continue;
                }
                if (arg.startsWith("--rlimit=")) {
                    String[] limitStrings = arg.substring(arg.indexOf(61) + 1).split(",");
                    if (limitStrings.length != 3) {
                        throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                    }
                    int[] rlimitTuple = new int[limitStrings.length];
                    for (int i = 0; i < limitStrings.length; ++i) {
                        rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                    }
                    if (this.rlimits == null) {
                        this.rlimits = new ArrayList();
                    }
                    this.rlimits.add(rlimitTuple);
                    continue;
                }
                if (arg.equals("-classpath")) {
                    if (this.classpath != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.classpath = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("-classpath requires argument");
                    }
                }
                if (arg.startsWith("--setgroups=")) {
                    if (this.gids != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    String[] params = arg.substring(arg.indexOf(61) + 1).split(",");
                    this.gids = new int[params.length];
                    for (int i = params.length - 1; i >= 0; --i) {
                        this.gids[i] = Integer.parseInt(params[i]);
                    }
                    continue;
                }
                if (arg.equals("--invoke-with")) {
                    if (this.invokeWith != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.invokeWith = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("--invoke-with requires argument");
                    }
                }
                if (!arg.startsWith("--nice-name=")) break;
                if (this.niceName != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                this.niceName = arg.substring(arg.indexOf(61) + 1);
            }
            if (this.runtimeInit && this.classpath != null) {
                throw new IllegalArgumentException("--runtime-init and -classpath are incompatible");
            }
            this.remainingArgs = new String[args.length - curArg];
            System.arraycopy(args, curArg, this.remainingArgs, 0, this.remainingArgs.length);
        }
    }
}

