/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.LocalServerSocket;
import android.os.Debug;
import android.os.FileUtils;
import android.os.Process;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.ZygoteConnection;
import dalvik.system.VMRuntime;
import dalvik.system.Zygote;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import libcore.io.IoUtils;

public class ZygoteInit {
    private static final String TAG = "Zygote";
    private static final String ANDROID_SOCKET_ENV = "ANDROID_SOCKET_zygote";
    private static final int LOG_BOOT_PROGRESS_PRELOAD_START = 3020;
    private static final int LOG_BOOT_PROGRESS_PRELOAD_END = 3030;
    private static final int PRELOAD_GC_THRESHOLD = 50000;
    public static final String USAGE_STRING = " <\"start-system-server\"|\"\" for startSystemServer>";
    private static LocalServerSocket sServerSocket;
    private static Resources mResources;
    static final int GC_LOOP_COUNT = 10;
    private static final boolean ZYGOTE_FORK_MODE = false;
    private static final String PRELOADED_CLASSES = "preloaded-classes";
    private static final boolean PRELOAD_RESOURCES = true;
    private static final int UNPRIVILEGED_UID = 9999;
    private static final int UNPRIVILEGED_GID = 9999;
    private static final int ROOT_UID = 0;
    private static final int ROOT_GID = 0;

    static void invokeStaticMain(ClassLoader loader, String className, String[] argv) throws MethodAndArgsCaller {
        Method m;
        Class<?> cl;
        try {
            cl = loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Missing class when invoking static main " + className, ex);
        }
        try {
            m = cl.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing static main on " + className, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Problem getting static main on " + className, ex);
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Main method is not public and static on " + className);
        }
        throw new MethodAndArgsCaller(m, argv);
    }

    private static void registerZygoteSocket() {
        if (sServerSocket == null) {
            int fileDesc;
            try {
                String env = System.getenv(ANDROID_SOCKET_ENV);
                fileDesc = Integer.parseInt(env);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("ANDROID_SOCKET_zygote unset or invalid", ex);
            }
            try {
                sServerSocket = new LocalServerSocket(ZygoteInit.createFileDescriptor(fileDesc));
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to local socket '" + fileDesc + "'", ex);
            }
        }
    }

    private static ZygoteConnection acceptCommandPeer() {
        try {
            return new ZygoteConnection(sServerSocket.accept());
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException during accept()", ex);
        }
    }

    static void closeServerSocket() {
        try {
            if (sServerSocket != null) {
                sServerSocket.close();
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Zygote:  error closing sockets", ex);
        }
        sServerSocket = null;
    }

    private static void setEffectiveUser(int uid) {
        int errno = ZygoteInit.setreuid(0, uid);
        if (errno != 0) {
            Log.e(TAG, "setreuid() failed. errno: " + errno);
        }
    }

    private static void setEffectiveGroup(int gid) {
        int errno = ZygoteInit.setregid(0, gid);
        if (errno != 0) {
            Log.e(TAG, "setregid() failed. errno: " + errno);
        }
    }

    static void preload() {
        ZygoteInit.preloadClasses();
        ZygoteInit.preloadResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preloadClasses() {
        VMRuntime runtime = VMRuntime.getRuntime();
        InputStream is = ZygoteInit.class.getClassLoader().getResourceAsStream(PRELOADED_CLASSES);
        if (is == null) {
            Log.e(TAG, "Couldn't find preloaded-classes.");
        } else {
            Log.i(TAG, "Preloading classes...");
            long startTime = SystemClock.uptimeMillis();
            ZygoteInit.setEffectiveGroup(9999);
            ZygoteInit.setEffectiveUser(9999);
            float defaultUtilization = runtime.getTargetHeapUtilization();
            runtime.setTargetHeapUtilization(0.8f);
            System.gc();
            runtime.runFinalizationSync();
            Debug.startAllocCounting();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is), 256);
                int count = 0;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                    try {
                        Class.forName(line);
                        if (Debug.getGlobalAllocSize() > 50000) {
                            System.gc();
                            runtime.runFinalizationSync();
                            Debug.resetGlobalAllocSize();
                        }
                        ++count;
                    }
                    catch (ClassNotFoundException e) {
                        Log.w(TAG, "Class not found for preloading: " + line);
                    }
                    catch (Throwable t) {
                        Log.e(TAG, "Error preloading " + line + ".", t);
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new RuntimeException(t);
                    }
                }
                Log.i(TAG, "...preloaded " + count + " classes in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            }
            catch (IOException e) {
                Log.e(TAG, "Error reading preloaded-classes.", e);
            }
            finally {
                IoUtils.closeQuietly((AutoCloseable)is);
                runtime.setTargetHeapUtilization(defaultUtilization);
                Debug.stopAllocCounting();
                ZygoteInit.setEffectiveUser(0);
                ZygoteInit.setEffectiveGroup(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preloadResources() {
        VMRuntime runtime = VMRuntime.getRuntime();
        Debug.startAllocCounting();
        try {
            System.gc();
            runtime.runFinalizationSync();
            mResources = Resources.getSystem();
            mResources.startPreloading();
            Log.i(TAG, "Preloading resources...");
            long startTime = SystemClock.uptimeMillis();
            TypedArray ar = mResources.obtainTypedArray(17235973);
            int N = ZygoteInit.preloadDrawables(runtime, ar);
            Log.i(TAG, "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            startTime = SystemClock.uptimeMillis();
            ar = mResources.obtainTypedArray(17235974);
            N = ZygoteInit.preloadColorStateLists(runtime, ar);
            Log.i(TAG, "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            mResources.finishPreloading();
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Failure preloading resources", e);
        }
        finally {
            Debug.stopAllocCounting();
        }
    }

    private static int preloadColorStateLists(VMRuntime runtime, TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2;
            if (Debug.getGlobalAllocSize() > 50000) {
                System.gc();
                runtime.runFinalizationSync();
                Debug.resetGlobalAllocSize();
            }
            if ((id2 = ar.getResourceId(i, 0)) == 0) continue;
            mResources.getColorStateList(id2);
        }
        return N;
    }

    private static int preloadDrawables(VMRuntime runtime, TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            Drawable dr;
            int id2;
            if (Debug.getGlobalAllocSize() > 50000) {
                System.gc();
                runtime.runFinalizationSync();
                Debug.resetGlobalAllocSize();
            }
            if ((id2 = ar.getResourceId(i, 0)) == 0 || ((dr = mResources.getDrawable(id2)).getChangingConfigurations() & 0xBFFFFFFF) == 0) continue;
            Log.w(TAG, "Preloaded drawable resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ") that varies with configuration!!");
        }
        return N;
    }

    static void gc() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
        runtime.runFinalizationSync();
    }

    private static void handleSystemServerProcess(ZygoteConnection.Arguments parsedArgs) throws MethodAndArgsCaller {
        ZygoteInit.closeServerSocket();
        FileUtils.setUMask(63);
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if (parsedArgs.invokeWith != null) {
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, null, parsedArgs.remainingArgs);
        } else {
            RuntimeInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs);
        }
    }

    private static boolean startSystemServer() throws MethodAndArgsCaller, RuntimeException {
        int pid;
        String[] args = new String[]{"--setuid=1000", "--setgid=1000", "--setgroups=1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1018,3001,3002,3003,3006,3007", "--capabilities=130104352,130104352", "--runtime-init", "--nice-name=system_server", "com.android.server.SystemServer"};
        ZygoteConnection.Arguments parsedArgs = null;
        try {
            parsedArgs = new ZygoteConnection.Arguments(args);
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            pid = Zygote.forkSystemServer((int)parsedArgs.uid, (int)parsedArgs.gid, (int[])parsedArgs.gids, (int)parsedArgs.debugFlags, (int[][])null, (long)parsedArgs.permittedCapabilities, (long)parsedArgs.effectiveCapabilities);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        if (pid == 0) {
            ZygoteInit.handleSystemServerProcess(parsedArgs);
        }
        return true;
    }

    public static void main(String[] argv) {
        try {
            SamplingProfilerIntegration.start();
            ZygoteInit.registerZygoteSocket();
            EventLog.writeEvent(3020, SystemClock.uptimeMillis());
            ZygoteInit.preload();
            EventLog.writeEvent(3030, SystemClock.uptimeMillis());
            SamplingProfilerIntegration.writeZygoteSnapshot();
            ZygoteInit.gc();
            if (argv.length != 2) {
                throw new RuntimeException(argv[0] + USAGE_STRING);
            }
            if (argv[1].equals("start-system-server")) {
                ZygoteInit.startSystemServer();
            } else if (!argv[1].equals("")) {
                throw new RuntimeException(argv[0] + USAGE_STRING);
            }
            Log.i(TAG, "Accepting command socket connections");
            ZygoteInit.runSelectLoopMode();
            ZygoteInit.closeServerSocket();
        }
        catch (MethodAndArgsCaller caller) {
            caller.run();
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "Zygote died with exception", ex);
            ZygoteInit.closeServerSocket();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runForkMode() throws MethodAndArgsCaller {
        ZygoteConnection peer;
        block7: {
            while (true) {
                peer = ZygoteInit.acceptCommandPeer();
                int pid = Zygote.fork();
                if (pid == 0) {
                    try {
                        sServerSocket.close();
                        break block7;
                    }
                    catch (IOException ex) {
                        Log.e(TAG, "Zygote Child: error closing sockets", ex);
                        break block7;
                    }
                    finally {
                        sServerSocket = null;
                    }
                }
                if (pid <= 0) break;
                peer.closeSocket();
            }
            throw new RuntimeException("Error invoking fork()");
        }
        peer.run();
    }

    private static void runSelectLoopMode() throws MethodAndArgsCaller {
        ArrayList<FileDescriptor> fds = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> peers = new ArrayList<ZygoteConnection>();
        FileDescriptor[] fdArray = new FileDescriptor[4];
        fds.add(sServerSocket.getFileDescriptor());
        peers.add(null);
        int loopCount = 10;
        while (true) {
            int index;
            if (loopCount <= 0) {
                ZygoteInit.gc();
                loopCount = 10;
            } else {
                --loopCount;
            }
            try {
                fdArray = fds.toArray(fdArray);
                index = ZygoteInit.selectReadable(fdArray);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error in select()", ex);
            }
            if (index < 0) {
                throw new RuntimeException("Error in select()");
            }
            if (index == 0) {
                ZygoteConnection newPeer = ZygoteInit.acceptCommandPeer();
                peers.add(newPeer);
                fds.add(newPeer.getFileDesciptor());
                continue;
            }
            boolean done = ((ZygoteConnection)peers.get(index)).runOnce();
            if (!done) continue;
            peers.remove(index);
            fds.remove(index);
        }
    }

    static native int setreuid(int var0, int var1);

    static native int setregid(int var0, int var1);

    static native int setpgid(int var0, int var1);

    static native int getpgid(int var0) throws IOException;

    static native void reopenStdio(FileDescriptor var0, FileDescriptor var1, FileDescriptor var2) throws IOException;

    static native void setCloseOnExec(FileDescriptor var0, boolean var1) throws IOException;

    static native long capgetPermitted(int var0) throws IOException;

    static native void setCapabilities(long var0, long var2) throws IOException;

    static native int selectReadable(FileDescriptor[] var0) throws IOException;

    static native FileDescriptor createFileDescriptor(int var0) throws IOException;

    private ZygoteInit() {
    }

    public static class MethodAndArgsCaller
    extends Exception
    implements Runnable {
        private final Method mMethod;
        private final String[] mArgs;

        public MethodAndArgsCaller(Method method, String[] args) {
            this.mMethod = method;
            this.mArgs = args;
        }

        public void run() {
            try {
                this.mMethod.invoke(null, new Object[]{this.mArgs});
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(ex);
            }
        }
    }
}

