/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.storage;

import android.app.ProgressDialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Environment;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.util.Log;
import android.widget.Toast;

public class ExternalStorageFormatter
extends Service
implements DialogInterface.OnCancelListener {
    static final String TAG = "ExternalStorageFormatter";
    public static final String FORMAT_ONLY = "com.android.internal.os.storage.FORMAT_ONLY";
    public static final String FORMAT_AND_FACTORY_RESET = "com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET";
    public static final String EXTRA_ALWAYS_RESET = "always_reset";
    private StorageVolume mStorageVolume;
    public static final ComponentName COMPONENT_NAME = new ComponentName("android", ExternalStorageFormatter.class.getName());
    private IMountService mMountService = null;
    private StorageManager mStorageManager = null;
    private PowerManager.WakeLock mWakeLock;
    private ProgressDialog mProgressDialog = null;
    private boolean mFactoryReset = false;
    private boolean mAlwaysReset = false;
    StorageEventListener mStorageListener = new StorageEventListener(){

        public void onStorageStateChanged(String path, String oldState, String newState) {
            Log.i(ExternalStorageFormatter.TAG, "Received storage state changed notification that " + path + " changed state from " + oldState + " to " + newState);
            ExternalStorageFormatter.this.updateProgressState();
        }
    };

    public void onCreate() {
        super.onCreate();
        if (this.mStorageManager == null) {
            this.mStorageManager = (StorageManager)this.getSystemService("storage");
            this.mStorageManager.registerListener(this.mStorageListener);
        }
        this.mWakeLock = ((PowerManager)this.getSystemService("power")).newWakeLock(1, TAG);
        this.mWakeLock.acquire();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (FORMAT_AND_FACTORY_RESET.equals(intent.getAction())) {
            this.mFactoryReset = true;
        }
        if (intent.getBooleanExtra(EXTRA_ALWAYS_RESET, false)) {
            this.mAlwaysReset = true;
        }
        this.mStorageVolume = (StorageVolume)intent.getParcelableExtra("storage_volume");
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.getWindow().setType(2003);
            if (!this.mAlwaysReset) {
                this.mProgressDialog.setOnCancelListener(this);
            }
            this.updateProgressState();
            this.mProgressDialog.show();
        }
        return 3;
    }

    public void onDestroy() {
        if (this.mStorageManager != null) {
            this.mStorageManager.unregisterListener(this.mStorageListener);
        }
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
        this.mWakeLock.release();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCancel(DialogInterface dialog) {
        IMountService mountService = this.getMountService();
        String extStoragePath = this.mStorageVolume == null ? Environment.getExternalStorageDirectory().toString() : this.mStorageVolume.getPath();
        try {
            mountService.mountVolume(extStoragePath);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed talking with mount service", e);
        }
        this.stopSelf();
    }

    void fail(int msg) {
        Toast.makeText((Context)this, msg, 1).show();
        if (this.mAlwaysReset) {
            this.sendBroadcast(new Intent("android.intent.action.MASTER_CLEAR"));
        }
        this.stopSelf();
    }

    void updateProgressState() {
        String status;
        String string2 = status = this.mStorageVolume == null ? Environment.getExternalStorageState() : this.mStorageManager.getVolumeState(this.mStorageVolume.getPath());
        if ("mounted".equals(status) || "mounted_ro".equals(status)) {
            this.updateProgressDialog(17040473);
            IMountService mountService = this.getMountService();
            String extStoragePath = this.mStorageVolume == null ? Environment.getExternalStorageDirectory().toString() : this.mStorageVolume.getPath();
            try {
                mountService.unmountVolume(extStoragePath, true, this.mFactoryReset);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed talking with mount service", e);
            }
        } else if ("nofs".equals(status) || "unmounted".equals(status) || "unmountable".equals(status)) {
            String extStoragePath;
            this.updateProgressDialog(17040474);
            final IMountService mountService = this.getMountService();
            String string3 = extStoragePath = this.mStorageVolume == null ? Environment.getExternalStorageDirectory().toString() : this.mStorageVolume.getPath();
            if (mountService != null) {
                new Thread(){

                    public void run() {
                        boolean success = false;
                        try {
                            mountService.formatVolume(extStoragePath);
                            success = true;
                        }
                        catch (Exception e) {
                            Toast.makeText((Context)ExternalStorageFormatter.this, 17040475, 1).show();
                        }
                        if (success && ExternalStorageFormatter.this.mFactoryReset) {
                            ExternalStorageFormatter.this.sendBroadcast(new Intent("android.intent.action.MASTER_CLEAR"));
                            ExternalStorageFormatter.this.stopSelf();
                            return;
                        }
                        if (!success && ExternalStorageFormatter.this.mAlwaysReset) {
                            ExternalStorageFormatter.this.sendBroadcast(new Intent("android.intent.action.MASTER_CLEAR"));
                        } else {
                            try {
                                mountService.mountVolume(extStoragePath);
                            }
                            catch (RemoteException e) {
                                Log.w(ExternalStorageFormatter.TAG, "Failed talking with mount service", e);
                            }
                        }
                        ExternalStorageFormatter.this.stopSelf();
                    }
                }.start();
            } else {
                Log.w(TAG, "Unable to locate IMountService");
            }
        } else if ("bad_removal".equals(status)) {
            this.fail(17040476);
        } else if ("checking".equals(status)) {
            this.fail(17040477);
        } else if ("removed".equals(status)) {
            this.fail(17040478);
        } else if ("shared".equals(status)) {
            this.fail(17040479);
        } else {
            this.fail(17040480);
            Log.w(TAG, "Unknown storage state: " + status);
            this.stopSelf();
        }
    }

    public void updateProgressDialog(int msg) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.getWindow().setType(2003);
            this.mProgressDialog.show();
        }
        this.mProgressDialog.setMessage(this.getText(msg));
    }

    IMountService getMountService() {
        if (this.mMountService == null) {
            IBinder service = ServiceManager.getService("mount");
            if (service != null) {
                this.mMountService = IMountService.Stub.asInterface(service);
            } else {
                Log.e(TAG, "Can't get mount service");
            }
        }
        return this.mMountService;
    }
}

