/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.UsimPhoneBookManager;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdnRecordCache
extends Handler
implements IccConstants {
    PhoneBase phone;
    private UsimPhoneBookManager mUsimPhoneBookManager;
    SparseArray<ArrayList<AdnRecord>> adnLikeFiles = new SparseArray();
    SparseArray<ArrayList<Message>> adnLikeWaiters = new SparseArray();
    SparseArray<Message> userWriteResponse = new SparseArray();
    static final int EVENT_LOAD_ALL_ADN_LIKE_DONE = 1;
    static final int EVENT_UPDATE_ADN_DONE = 2;

    public AdnRecordCache(PhoneBase phone) {
        this.phone = phone;
        this.mUsimPhoneBookManager = new UsimPhoneBookManager(phone, this);
    }

    public void reset() {
        this.adnLikeFiles.clear();
        this.mUsimPhoneBookManager.reset();
        this.clearWaiters();
        this.clearUserWriters();
    }

    private void clearWaiters() {
        int size = this.adnLikeWaiters.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<Message> waiters = this.adnLikeWaiters.valueAt(i);
            AsyncResult ar = new AsyncResult(null, null, new RuntimeException("AdnCache reset"));
            this.notifyWaiters(waiters, ar);
        }
        this.adnLikeWaiters.clear();
    }

    private void clearUserWriters() {
        int size = this.userWriteResponse.size();
        for (int i = 0; i < size; ++i) {
            this.sendErrorResponse(this.userWriteResponse.valueAt(i), "AdnCace reset");
        }
        this.userWriteResponse.clear();
    }

    public ArrayList<AdnRecord> getRecordsIfLoaded(int efid) {
        return this.adnLikeFiles.get(efid);
    }

    int extensionEfForEf(int efid) {
        switch (efid) {
            case 28615: {
                return 28616;
            }
            case 28474: {
                return 28490;
            }
            case 28489: {
                return 28492;
            }
            case 28475: {
                return 28491;
            }
            case 28480: {
                return 28490;
            }
            case 20272: {
                return 0;
            }
        }
        return -1;
    }

    private void sendErrorResponse(Message response, String errString) {
        if (response != null) {
            RuntimeException e = new RuntimeException(errString);
            AsyncResult.forMessage((Message)response).exception = e;
            response.sendToTarget();
        }
    }

    public void updateAdnByIndex(int efid, AdnRecord adn, int recordIndex, String pin2, Message response) {
        int extensionEF = this.extensionEfForEf(efid);
        if (extensionEF < 0) {
            this.sendErrorResponse(response, "EF is not known ADN-like EF:" + efid);
            return;
        }
        Message pendingResponse = this.userWriteResponse.get(efid);
        if (pendingResponse != null) {
            this.sendErrorResponse(response, "Have pending update for EF:" + efid);
            return;
        }
        this.userWriteResponse.put(efid, response);
        new AdnRecordLoader(this.phone).updateEF(adn, efid, extensionEF, recordIndex, pin2, this.obtainMessage(2, efid, recordIndex, adn));
    }

    public void updateAdnBySearch(int efid, AdnRecord oldAdn, AdnRecord newAdn, String pin2, Message response) {
        Message pendingResponse;
        int extensionEF = this.extensionEfForEf(efid);
        if (extensionEF < 0) {
            this.sendErrorResponse(response, "EF is not known ADN-like EF:" + efid);
            return;
        }
        ArrayList<AdnRecord> oldAdnList = efid == 20272 ? this.mUsimPhoneBookManager.loadEfFilesFromUsim() : this.getRecordsIfLoaded(efid);
        if (oldAdnList == null) {
            this.sendErrorResponse(response, "Adn list not exist for EF:" + efid);
            return;
        }
        int index = -1;
        int count = 1;
        Iterator<AdnRecord> it = oldAdnList.iterator();
        while (it.hasNext()) {
            if (oldAdn.isEqual(it.next())) {
                index = count;
                break;
            }
            ++count;
        }
        if (index == -1) {
            this.sendErrorResponse(response, "Adn record don't exist for " + oldAdn);
            return;
        }
        if (efid == 20272) {
            AdnRecord foundAdn = oldAdnList.get(index - 1);
            efid = foundAdn.efid;
            extensionEF = foundAdn.extRecord;
            index = foundAdn.recordNumber;
            newAdn.efid = efid;
            newAdn.extRecord = extensionEF;
            newAdn.recordNumber = index;
        }
        if ((pendingResponse = this.userWriteResponse.get(efid)) != null) {
            this.sendErrorResponse(response, "Have pending update for EF:" + efid);
            return;
        }
        this.userWriteResponse.put(efid, response);
        new AdnRecordLoader(this.phone).updateEF(newAdn, efid, extensionEF, index, pin2, this.obtainMessage(2, efid, index, newAdn));
    }

    public void requestLoadAllAdnLike(int efid, int extensionEf, Message response) {
        ArrayList<AdnRecord> result = efid == 20272 ? this.mUsimPhoneBookManager.loadEfFilesFromUsim() : this.getRecordsIfLoaded(efid);
        if (result != null) {
            if (response != null) {
                AsyncResult.forMessage((Message)response).result = result;
                response.sendToTarget();
            }
            return;
        }
        ArrayList<Message> waiters = this.adnLikeWaiters.get(efid);
        if (waiters != null) {
            waiters.add(response);
            return;
        }
        waiters = new ArrayList();
        waiters.add(response);
        this.adnLikeWaiters.put(efid, waiters);
        if (extensionEf < 0) {
            if (response != null) {
                AsyncResult.forMessage((Message)response).exception = new RuntimeException("EF is not known ADN-like EF:" + efid);
                response.sendToTarget();
            }
            return;
        }
        new AdnRecordLoader(this.phone).loadAllFromEF(efid, extensionEf, this.obtainMessage(1, efid, 0));
    }

    private void notifyWaiters(ArrayList<Message> waiters, AsyncResult ar) {
        if (waiters == null) {
            return;
        }
        int s = waiters.size();
        for (int i = 0; i < s; ++i) {
            Message waiter = waiters.get(i);
            AsyncResult.forMessage(waiter, ar.result, ar.exception);
            waiter.sendToTarget();
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                int efid = msg.arg1;
                ArrayList<Message> waiters = this.adnLikeWaiters.get(efid);
                this.adnLikeWaiters.delete(efid);
                if (ar.exception == null) {
                    this.adnLikeFiles.put(efid, (ArrayList)ar.result);
                }
                this.notifyWaiters(waiters, ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                int efid = msg.arg1;
                int index = msg.arg2;
                AdnRecord adn = (AdnRecord)ar.userObj;
                if (ar.exception == null) {
                    this.adnLikeFiles.get(efid).set(index - 1, adn);
                    this.mUsimPhoneBookManager.invalidateCache();
                }
                Message response = this.userWriteResponse.get(efid);
                this.userWriteResponse.delete(efid);
                AsyncResult.forMessage(response, null, ar.exception);
                response.sendToTarget();
            }
        }
    }
}

