/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.media.AudioManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipPhone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallManager {
    private static final String LOG_TAG = "CallManager";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int EVENT_DISCONNECT = 100;
    private static final int EVENT_PRECISE_CALL_STATE_CHANGED = 101;
    private static final int EVENT_NEW_RINGING_CONNECTION = 102;
    private static final int EVENT_UNKNOWN_CONNECTION = 103;
    private static final int EVENT_INCOMING_RING = 104;
    private static final int EVENT_RINGBACK_TONE = 105;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_ON = 106;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_OFF = 107;
    private static final int EVENT_CALL_WAITING = 108;
    private static final int EVENT_DISPLAY_INFO = 109;
    private static final int EVENT_SIGNAL_INFO = 110;
    private static final int EVENT_CDMA_OTA_STATUS_CHANGE = 111;
    private static final int EVENT_RESEND_INCALL_MUTE = 112;
    private static final int EVENT_MMI_INITIATE = 113;
    private static final int EVENT_MMI_COMPLETE = 114;
    private static final int EVENT_ECM_TIMER_RESET = 115;
    private static final int EVENT_SUBSCRIPTION_INFO_READY = 116;
    private static final int EVENT_SUPP_SERVICE_FAILED = 117;
    private static final int EVENT_SERVICE_STATE_CHANGED = 118;
    private static final int EVENT_POST_DIAL_CHARACTER = 119;
    private static final CallManager INSTANCE = new CallManager();
    private final ArrayList<Phone> mPhones;
    private final ArrayList<Call> mRingingCalls;
    private final ArrayList<Call> mBackgroundCalls;
    private final ArrayList<Call> mForegroundCalls;
    private final ArrayList<Connection> emptyConnections = new ArrayList();
    private Phone mDefaultPhone = null;
    protected final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    protected final RegistrantList mNewRingingConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mIncomingRingRegistrants = new RegistrantList();
    protected final RegistrantList mDisconnectRegistrants = new RegistrantList();
    protected final RegistrantList mMmiRegistrants = new RegistrantList();
    protected final RegistrantList mUnknownConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mRingbackToneRegistrants = new RegistrantList();
    protected final RegistrantList mInCallVoicePrivacyOnRegistrants = new RegistrantList();
    protected final RegistrantList mInCallVoicePrivacyOffRegistrants = new RegistrantList();
    protected final RegistrantList mCallWaitingRegistrants = new RegistrantList();
    protected final RegistrantList mDisplayInfoRegistrants = new RegistrantList();
    protected final RegistrantList mSignalInfoRegistrants = new RegistrantList();
    protected final RegistrantList mCdmaOtaStatusChangeRegistrants = new RegistrantList();
    protected final RegistrantList mResendIncallMuteRegistrants = new RegistrantList();
    protected final RegistrantList mMmiInitiateRegistrants = new RegistrantList();
    protected final RegistrantList mMmiCompleteRegistrants = new RegistrantList();
    protected final RegistrantList mEcmTimerResetRegistrants = new RegistrantList();
    protected final RegistrantList mSubscriptionInfoReadyRegistrants = new RegistrantList();
    protected final RegistrantList mSuppServiceFailedRegistrants = new RegistrantList();
    protected final RegistrantList mServiceStateChangedRegistrants = new RegistrantList();
    protected final RegistrantList mPostDialCharacterRegistrants = new RegistrantList();
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    CallManager.this.mDisconnectRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 101: {
                    CallManager.this.mPreciseCallStateRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 102: {
                    if (CallManager.this.getActiveFgCallState().isDialing() || CallManager.this.hasMoreThanOneRingingCall()) {
                        Connection c = (Connection)((AsyncResult)msg.obj).result;
                        try {
                            Log.d(CallManager.LOG_TAG, "silently drop incoming call: " + c.getCall());
                            c.getCall().hangup();
                        }
                        catch (CallStateException e) {
                            Log.w(CallManager.LOG_TAG, "new ringing connection", e);
                        }
                        break;
                    }
                    CallManager.this.mNewRingingConnectionRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 103: {
                    CallManager.this.mUnknownConnectionRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 104: {
                    if (CallManager.this.hasActiveFgCall()) break;
                    CallManager.this.mIncomingRingRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 105: {
                    CallManager.this.mRingbackToneRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 106: {
                    CallManager.this.mInCallVoicePrivacyOnRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 107: {
                    CallManager.this.mInCallVoicePrivacyOffRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 108: {
                    CallManager.this.mCallWaitingRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 109: {
                    CallManager.this.mDisplayInfoRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 110: {
                    CallManager.this.mSignalInfoRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 111: {
                    CallManager.this.mCdmaOtaStatusChangeRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 112: {
                    CallManager.this.mResendIncallMuteRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 113: {
                    CallManager.this.mMmiInitiateRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 114: {
                    CallManager.this.mMmiCompleteRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 115: {
                    CallManager.this.mEcmTimerResetRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 116: {
                    CallManager.this.mSubscriptionInfoReadyRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 117: {
                    CallManager.this.mSuppServiceFailedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 118: {
                    CallManager.this.mServiceStateChangedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 119: {
                    for (int i = 0; i < CallManager.this.mPostDialCharacterRegistrants.size(); ++i) {
                        Message notifyMsg = ((Registrant)CallManager.this.mPostDialCharacterRegistrants.get(i)).messageForRegistrant();
                        notifyMsg.obj = msg.obj;
                        notifyMsg.arg1 = msg.arg1;
                        notifyMsg.sendToTarget();
                    }
                    break;
                }
            }
        }
    };

    private CallManager() {
        this.mPhones = new ArrayList();
        this.mRingingCalls = new ArrayList();
        this.mBackgroundCalls = new ArrayList();
        this.mForegroundCalls = new ArrayList();
    }

    public static CallManager getInstance() {
        return INSTANCE;
    }

    private static Phone getPhoneBase(Phone phone) {
        if (phone instanceof PhoneProxy) {
            return phone.getForegroundCall().getPhone();
        }
        return phone;
    }

    public static boolean isSamePhone(Phone p1, Phone p2) {
        return CallManager.getPhoneBase(p1) == CallManager.getPhoneBase(p2);
    }

    public List<Phone> getAllPhones() {
        return Collections.unmodifiableList(this.mPhones);
    }

    public Phone.State getState() {
        Phone.State s = Phone.State.IDLE;
        for (Phone phone : this.mPhones) {
            if (phone.getState() == Phone.State.RINGING) {
                s = Phone.State.RINGING;
                continue;
            }
            if (phone.getState() != Phone.State.OFFHOOK || s != Phone.State.IDLE) continue;
            s = Phone.State.OFFHOOK;
        }
        return s;
    }

    public int getServiceState() {
        int resultState = 1;
        for (Phone phone : this.mPhones) {
            int serviceState = phone.getServiceState().getState();
            if (serviceState == 0) {
                resultState = serviceState;
                break;
            }
            if (serviceState == 1) {
                if (resultState != 2 && resultState != 3) continue;
                resultState = serviceState;
                continue;
            }
            if (serviceState != 2 || resultState != 3) continue;
            resultState = serviceState;
        }
        return resultState;
    }

    public boolean registerPhone(Phone phone) {
        Phone basePhone = CallManager.getPhoneBase(phone);
        if (basePhone != null && !this.mPhones.contains(basePhone)) {
            Log.d(LOG_TAG, "registerPhone(" + phone.getPhoneName() + " " + phone + ")");
            if (this.mPhones.isEmpty()) {
                this.mDefaultPhone = basePhone;
            }
            this.mPhones.add(basePhone);
            this.mRingingCalls.add(basePhone.getRingingCall());
            this.mBackgroundCalls.add(basePhone.getBackgroundCall());
            this.mForegroundCalls.add(basePhone.getForegroundCall());
            this.registerForPhoneStates(basePhone);
            return true;
        }
        return false;
    }

    public void unregisterPhone(Phone phone) {
        Phone basePhone = CallManager.getPhoneBase(phone);
        if (basePhone != null && this.mPhones.contains(basePhone)) {
            Log.d(LOG_TAG, "unregisterPhone(" + phone.getPhoneName() + " " + phone + ")");
            this.mPhones.remove(basePhone);
            this.mRingingCalls.remove(basePhone.getRingingCall());
            this.mBackgroundCalls.remove(basePhone.getBackgroundCall());
            this.mForegroundCalls.remove(basePhone.getForegroundCall());
            this.unregisterForPhoneStates(basePhone);
            if (basePhone == this.mDefaultPhone) {
                this.mDefaultPhone = this.mPhones.isEmpty() ? null : this.mPhones.get(0);
            }
        }
    }

    public Phone getDefaultPhone() {
        return this.mDefaultPhone;
    }

    public Phone getFgPhone() {
        return this.getActiveFgCall().getPhone();
    }

    public Phone getBgPhone() {
        return this.getFirstActiveBgCall().getPhone();
    }

    public Phone getRingingPhone() {
        return this.getFirstActiveRingingCall().getPhone();
    }

    public void setAudioMode() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        int mode = 0;
        switch (this.getState()) {
            case RINGING: {
                mode = 1;
                break;
            }
            case OFFHOOK: {
                Phone offhookPhone = this.getFgPhone();
                if (this.getActiveFgCallState() == Call.State.IDLE) {
                    offhookPhone = this.getBgPhone();
                }
                mode = offhookPhone instanceof SipPhone ? 3 : 2;
            }
        }
        if (audioManager.getMode() != mode) {
            audioManager.setMode(mode);
        }
    }

    private Context getContext() {
        Phone defaultPhone = this.getDefaultPhone();
        return defaultPhone == null ? null : defaultPhone.getContext();
    }

    private void registerForPhoneStates(Phone phone) {
        phone.registerForPreciseCallStateChanged(this.mHandler, 101, null);
        phone.registerForDisconnect(this.mHandler, 100, null);
        phone.registerForNewRingingConnection(this.mHandler, 102, null);
        phone.registerForUnknownConnection(this.mHandler, 103, null);
        phone.registerForIncomingRing(this.mHandler, 104, null);
        phone.registerForRingbackTone(this.mHandler, 105, null);
        phone.registerForInCallVoicePrivacyOn(this.mHandler, 106, null);
        phone.registerForInCallVoicePrivacyOff(this.mHandler, 107, null);
        phone.registerForDisplayInfo(this.mHandler, 109, null);
        phone.registerForSignalInfo(this.mHandler, 110, null);
        phone.registerForResendIncallMute(this.mHandler, 112, null);
        phone.registerForMmiInitiate(this.mHandler, 113, null);
        phone.registerForMmiComplete(this.mHandler, 114, null);
        phone.registerForSuppServiceFailed(this.mHandler, 117, null);
        phone.registerForServiceStateChanged(this.mHandler, 118, null);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2) {
            phone.setOnPostDialCharacter(this.mHandler, 119, null);
        }
        if (phone.getPhoneType() == 2) {
            phone.registerForCdmaOtaStatusChange(this.mHandler, 111, null);
            phone.registerForSubscriptionInfoReady(this.mHandler, 116, null);
            phone.registerForCallWaiting(this.mHandler, 108, null);
            phone.registerForEcmTimerReset(this.mHandler, 115, null);
        }
    }

    private void unregisterForPhoneStates(Phone phone) {
        phone.unregisterForPreciseCallStateChanged(this.mHandler);
        phone.unregisterForDisconnect(this.mHandler);
        phone.unregisterForNewRingingConnection(this.mHandler);
        phone.unregisterForUnknownConnection(this.mHandler);
        phone.unregisterForIncomingRing(this.mHandler);
        phone.unregisterForRingbackTone(this.mHandler);
        phone.unregisterForInCallVoicePrivacyOn(this.mHandler);
        phone.unregisterForInCallVoicePrivacyOff(this.mHandler);
        phone.unregisterForDisplayInfo(this.mHandler);
        phone.unregisterForSignalInfo(this.mHandler);
        phone.unregisterForResendIncallMute(this.mHandler);
        phone.unregisterForMmiInitiate(this.mHandler);
        phone.unregisterForMmiComplete(this.mHandler);
        phone.unregisterForSuppServiceFailed(this.mHandler);
        phone.unregisterForServiceStateChanged(this.mHandler);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2) {
            phone.setOnPostDialCharacter(null, 119, null);
        }
        if (phone.getPhoneType() == 2) {
            phone.unregisterForCdmaOtaStatusChange(this.mHandler);
            phone.unregisterForSubscriptionInfoReady(this.mHandler);
            phone.unregisterForCallWaiting(this.mHandler);
            phone.unregisterForEcmTimerReset(this.mHandler);
        }
    }

    public void acceptCall(Call ringingCall) throws CallStateException {
        Phone ringingPhone = ringingCall.getPhone();
        if (this.hasActiveFgCall()) {
            boolean sameChannel;
            Phone activePhone = this.getActiveFgCall().getPhone();
            boolean hasBgCall = !activePhone.getBackgroundCall().isIdle();
            boolean bl = sameChannel = activePhone == ringingPhone;
            if (sameChannel && hasBgCall) {
                this.getActiveFgCall().hangup();
            } else if (!sameChannel && !hasBgCall) {
                activePhone.switchHoldingAndActive();
            } else if (!sameChannel && hasBgCall) {
                this.getActiveFgCall().hangup();
            }
        }
        ringingPhone.acceptCall();
    }

    public void rejectCall(Call ringingCall) throws CallStateException {
        Phone ringingPhone = ringingCall.getPhone();
        ringingPhone.rejectCall();
    }

    public void switchHoldingAndActive(Call heldCall) throws CallStateException {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        if (activePhone != null) {
            activePhone.switchHoldingAndActive();
        }
        if (heldPhone != null && heldPhone != activePhone) {
            heldPhone.switchHoldingAndActive();
        }
    }

    public void hangupForegroundResumeBackground(Call heldCall) throws CallStateException {
        Phone foregroundPhone = null;
        Phone backgroundPhone = null;
        if (this.hasActiveFgCall()) {
            foregroundPhone = this.getFgPhone();
            if (heldCall != null) {
                backgroundPhone = heldCall.getPhone();
                if (foregroundPhone == backgroundPhone) {
                    this.getActiveFgCall().hangup();
                } else {
                    this.getActiveFgCall().hangup();
                    this.switchHoldingAndActive(heldCall);
                }
            }
        }
    }

    public boolean canConference(Call heldCall) {
        Phone activePhone = null;
        Object heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone.getClass().equals(activePhone.getClass());
    }

    public void conference(Call heldCall) throws CallStateException {
        Phone fgPhone = this.getFgPhone();
        if (fgPhone instanceof SipPhone) {
            ((SipPhone)fgPhone).conference(heldCall);
        } else if (this.canConference(heldCall)) {
            fgPhone.conference();
        } else {
            throw new CallStateException("Can't conference foreground and selected background call");
        }
    }

    public Connection dial(Phone phone, String dialString) throws CallStateException {
        Phone basePhone = CallManager.getPhoneBase(phone);
        if (!this.canDial(phone)) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.hasActiveFgCall()) {
            Phone activePhone = this.getActiveFgCall().getPhone();
            boolean hasBgCall = !activePhone.getBackgroundCall().isIdle();
            Log.d(LOG_TAG, "hasBgCall: " + hasBgCall + " sameChannel:" + (activePhone == basePhone));
            if (activePhone != basePhone) {
                if (hasBgCall) {
                    Log.d(LOG_TAG, "Hangup");
                    this.getActiveFgCall().hangup();
                } else {
                    Log.d(LOG_TAG, "Switch");
                    activePhone.switchHoldingAndActive();
                }
            }
        }
        Connection result = basePhone.dial(dialString);
        return result;
    }

    public Connection dial(Phone phone, String dialString, UUSInfo uusInfo) throws CallStateException {
        return phone.dial(dialString, uusInfo);
    }

    public void clearDisconnected() {
        for (Phone phone : this.mPhones) {
            phone.clearDisconnected();
        }
    }

    private boolean canDial(Phone phone) {
        boolean result;
        int serviceState = phone.getServiceState().getState();
        boolean hasRingingCall = this.hasActiveRingingCall();
        boolean hasActiveCall = this.hasActiveFgCall();
        boolean hasHoldingCall = this.hasActiveBgCall();
        boolean allLinesTaken = hasActiveCall && hasHoldingCall;
        Call.State fgCallState = this.getActiveFgCallState();
        boolean bl = result = serviceState != 3 && !hasRingingCall && !allLinesTaken && (fgCallState == Call.State.ACTIVE || fgCallState == Call.State.IDLE || fgCallState == Call.State.DISCONNECTED);
        if (!result) {
            Log.d(LOG_TAG, "canDial serviceState=" + serviceState + " hasRingingCall=" + hasRingingCall + " hasActiveCall=" + hasActiveCall + " hasHoldingCall=" + hasHoldingCall + " allLinesTaken=" + allLinesTaken + " fgCallState=" + (Object)((Object)fgCallState));
        }
        return result;
    }

    public boolean canTransfer(Call heldCall) {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone == activePhone && activePhone.canTransfer();
    }

    public void explicitCallTransfer(Call heldCall) throws CallStateException {
        if (this.canTransfer(heldCall)) {
            heldCall.getPhone().explicitCallTransfer();
        }
    }

    public List<? extends MmiCode> getPendingMmiCodes(Phone phone) {
        Log.e(LOG_TAG, "getPendingMmiCodes not implemented");
        return null;
    }

    public boolean sendUssdResponse(Phone phone, String ussdMessge) {
        Log.e(LOG_TAG, "sendUssdResponse not implemented");
        return false;
    }

    public void setMute(boolean muted) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setMute(muted);
        }
    }

    public boolean getMute() {
        if (this.hasActiveFgCall()) {
            return this.getActiveFgCall().getPhone().getMute();
        }
        if (this.hasActiveBgCall()) {
            return this.getFirstActiveBgCall().getPhone().getMute();
        }
        return false;
    }

    public void setEchoSuppressionEnabled(boolean enabled) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setEchoSuppressionEnabled(enabled);
        }
    }

    public boolean sendDtmf(char c) {
        boolean result = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendDtmf(c);
            result = true;
        }
        return result;
    }

    public boolean startDtmf(char c) {
        boolean result = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().startDtmf(c);
            result = true;
        }
        return result;
    }

    public void stopDtmf() {
        if (this.hasActiveFgCall()) {
            this.getFgPhone().stopDtmf();
        }
    }

    public boolean sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendBurstDtmf(dtmfString, on, off, onComplete);
            return true;
        }
        return false;
    }

    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    public void registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    public void registerForRingbackTone(Handler h, int what, Object obj) {
        this.mRingbackToneRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForRingbackTone(Handler h) {
        this.mRingbackToneRegistrants.remove(h);
    }

    public void registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mResendIncallMuteRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForResendIncallMute(Handler h) {
        this.mResendIncallMuteRegistrants.remove(h);
    }

    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.mMmiInitiateRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForMmiInitiate(Handler h) {
        this.mMmiInitiateRegistrants.remove(h);
    }

    public void registerForMmiComplete(Handler h, int what, Object obj) {
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForMmiComplete(Handler h) {
        this.mMmiCompleteRegistrants.remove(h);
    }

    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.mServiceStateChangedRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateChangedRegistrants.remove(h);
    }

    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mInCallVoicePrivacyOnRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mInCallVoicePrivacyOnRegistrants.remove(h);
    }

    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mInCallVoicePrivacyOffRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mInCallVoicePrivacyOffRegistrants.remove(h);
    }

    public void registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCallWaitingRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mSignalInfoRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSignalInfo(Handler h) {
        this.mSignalInfoRegistrants.remove(h);
    }

    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mDisplayInfoRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForDisplayInfo(Handler h) {
        this.mDisplayInfoRegistrants.remove(h);
    }

    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCdmaOtaStatusChangeRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCdmaOtaStatusChangeRegistrants.remove(h);
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSubscriptionInfoReadyRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mSubscriptionInfoReadyRegistrants.remove(h);
    }

    public void registerForPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialCharacterRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForPostDialCharacter(Handler h) {
        this.mPostDialCharacterRegistrants.remove(h);
    }

    public List<Call> getRingingCalls() {
        return Collections.unmodifiableList(this.mRingingCalls);
    }

    public List<Call> getForegroundCalls() {
        return Collections.unmodifiableList(this.mForegroundCalls);
    }

    public List<Call> getBackgroundCalls() {
        return Collections.unmodifiableList(this.mBackgroundCalls);
    }

    public boolean hasActiveFgCall() {
        return this.getFirstActiveCall(this.mForegroundCalls) != null;
    }

    public boolean hasActiveBgCall() {
        return this.getFirstActiveCall(this.mBackgroundCalls) != null;
    }

    public boolean hasActiveRingingCall() {
        return this.getFirstActiveCall(this.mRingingCalls) != null;
    }

    public Call getActiveFgCall() {
        Call call = this.getFirstNonIdleCall(this.mForegroundCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getForegroundCall();
        }
        return call;
    }

    private Call getFirstNonIdleCall(List<Call> calls) {
        Call result = null;
        for (Call call : calls) {
            if (!call.isIdle()) {
                return call;
            }
            if (call.getState() == Call.State.IDLE || result != null) continue;
            result = call;
        }
        return result;
    }

    public Call getFirstActiveBgCall() {
        Call call = this.getFirstNonIdleCall(this.mBackgroundCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getBackgroundCall();
        }
        return call;
    }

    public Call getFirstActiveRingingCall() {
        Call call = this.getFirstNonIdleCall(this.mRingingCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getRingingCall();
        }
        return call;
    }

    public Call.State getActiveFgCallState() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getState();
        }
        return Call.State.IDLE;
    }

    public List<Connection> getFgCallConnections() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getConnections();
        }
        return this.emptyConnections;
    }

    public List<Connection> getBgCallConnections() {
        Call bgCall = this.getFirstActiveBgCall();
        if (bgCall != null) {
            return bgCall.getConnections();
        }
        return this.emptyConnections;
    }

    public Connection getFgCallLatestConnection() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getLatestConnection();
        }
        return null;
    }

    public boolean hasDisconnectedFgCall() {
        return this.getFirstCallOfState(this.mForegroundCalls, Call.State.DISCONNECTED) != null;
    }

    public boolean hasDisconnectedBgCall() {
        return this.getFirstCallOfState(this.mBackgroundCalls, Call.State.DISCONNECTED) != null;
    }

    private Call getFirstActiveCall(ArrayList<Call> calls) {
        for (Call call : calls) {
            if (call.isIdle()) continue;
            return call;
        }
        return null;
    }

    private Call getFirstCallOfState(ArrayList<Call> calls, Call.State state) {
        for (Call call : calls) {
            if (call.getState() != state) continue;
            return call;
        }
        return null;
    }

    private boolean hasMoreThanOneRingingCall() {
        int count = 0;
        for (Call call : this.mRingingCalls) {
            if (!call.getState().isRinging() || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallManager {");
        b.append("\nstate = " + (Object)((Object)this.getState()));
        Call call = this.getActiveFgCall();
        b.append("\n- Foreground: " + (Object)((Object)this.getActiveFgCallState()));
        b.append(" from " + call.getPhone());
        b.append("\n  Conn: ").append(this.getFgCallConnections());
        call = this.getFirstActiveBgCall();
        b.append("\n- Background: " + (Object)((Object)call.getState()));
        b.append(" from " + call.getPhone());
        b.append("\n  Conn: ").append(this.getBgCallConnections());
        call = this.getFirstActiveRingingCall();
        b.append("\n- Ringing: " + (Object)((Object)call.getState()));
        b.append(" from " + call.getPhone());
        for (Phone phone : this.getAllPhones()) {
            if (phone == null) continue;
            b.append("\nPhone: " + phone + ", name = " + phone.getPhoneName() + ", state = " + (Object)((Object)phone.getState()));
            call = phone.getForegroundCall();
            b.append("\n- Foreground: ").append(call);
            call = phone.getBackgroundCall();
            b.append(" Background: ").append(call);
            call = phone.getRingingCall();
            b.append(" Ringing: ").append(call);
        }
        b.append("\n}");
        return b.toString();
    }
}

