/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.ApnContext;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionAc;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DataConnectionTracker
extends Handler {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    public static String ACTION_DATA_CONNECTION_TRACKER_MESSENGER = "com.android.internal.telephony";
    public static String EXTRA_MESSENGER = "EXTRA_MESSENGER";
    protected static final int BASE = 270336;
    protected static final int EVENT_DATA_SETUP_COMPLETE = 270336;
    protected static final int EVENT_RADIO_AVAILABLE = 270337;
    protected static final int EVENT_RECORDS_LOADED = 270338;
    protected static final int EVENT_TRY_SETUP_DATA = 270339;
    protected static final int EVENT_DATA_STATE_CHANGED = 270340;
    protected static final int EVENT_POLL_PDP = 270341;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 270342;
    protected static final int EVENT_VOICE_CALL_STARTED = 270343;
    protected static final int EVENT_VOICE_CALL_ENDED = 270344;
    protected static final int EVENT_DATA_CONNECTION_DETACHED = 270345;
    protected static final int EVENT_LINK_STATE_CHANGED = 270346;
    protected static final int EVENT_ROAMING_ON = 270347;
    protected static final int EVENT_ROAMING_OFF = 270348;
    protected static final int EVENT_ENABLE_NEW_APN = 270349;
    protected static final int EVENT_RESTORE_DEFAULT_APN = 270350;
    protected static final int EVENT_DISCONNECT_DONE = 270351;
    protected static final int EVENT_DATA_CONNECTION_ATTACHED = 270352;
    protected static final int EVENT_DATA_STALL_ALARM = 270353;
    protected static final int EVENT_DO_RECOVERY = 270354;
    protected static final int EVENT_APN_CHANGED = 270355;
    protected static final int EVENT_CDMA_DATA_DETACHED = 270356;
    protected static final int EVENT_NV_READY = 270357;
    protected static final int EVENT_PS_RESTRICT_ENABLED = 270358;
    protected static final int EVENT_PS_RESTRICT_DISABLED = 270359;
    public static final int EVENT_CLEAN_UP_CONNECTION = 270360;
    protected static final int EVENT_CDMA_OTA_PROVISION = 270361;
    protected static final int EVENT_RESTART_RADIO = 270362;
    protected static final int EVENT_SET_INTERNAL_DATA_ENABLE = 270363;
    protected static final int EVENT_RESET_DONE = 270364;
    public static final int CMD_SET_USER_DATA_ENABLE = 270365;
    public static final int EVENT_CLEAN_UP_ALL_CONNECTIONS = 270366;
    public static final int CMD_SET_DEPENDENCY_MET = 270367;
    public static final int CMD_SET_POLICY_DATA_ENABLE = 270368;
    protected static final int APN_INVALID_ID = -1;
    protected static final int APN_DEFAULT_ID = 0;
    protected static final int APN_MMS_ID = 1;
    protected static final int APN_SUPL_ID = 2;
    protected static final int APN_DUN_ID = 3;
    protected static final int APN_HIPRI_ID = 4;
    protected static final int APN_IMS_ID = 5;
    protected static final int APN_FOTA_ID = 6;
    protected static final int APN_CBS_ID = 7;
    protected static final int APN_NUM_TYPES = 8;
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final String APN_TYPE_KEY = "apnType";
    protected static final int APN_DELAY_MILLIS = SystemProperties.getInt("persist.radio.apn_delay", 5000);
    protected Object mDataEnabledLock = new Object();
    protected boolean mInternalDataEnabled = true;
    protected boolean mUserDataEnabled = true;
    protected static boolean sPolicyDataEnabled = true;
    private boolean[] dataEnabled = new boolean[8];
    private int enabledCount = 0;
    protected String mRequestedApnType = "default";
    protected static final String DEFAULT_DATA_RETRY_CONFIG = "default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000";
    protected static final String SECONDARY_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    protected static final int POLL_NETSTAT_SLOW_MILLIS = 5000;
    protected static final int DEFAULT_MAX_PDP_RESET_FAIL = 3;
    protected static final int NO_RECV_POLL_LIMIT = 24;
    protected static final int POLL_NETSTAT_MILLIS = 1000;
    protected static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    protected static final int POLL_LONGEST_RTT = 120000;
    protected static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    protected static final int RESTORE_DEFAULT_APN_DELAY = 60000;
    protected static final String APN_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    protected static final String NULL_IP = "0.0.0.0";
    protected static final int DATA_STALL_ALARM_DELAY_IN_MS_DEFAULT = 360000;
    protected static final int DATA_STALL_NO_RECV_POLL_LIMIT = 1;
    protected static final String DATA_STALL_ALARM_TAG_EXTRA = "data.stall.alram.tag";
    protected static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    protected static final String INTENT_SET_FAIL_DATA_SETUP_COUNTER = "com.android.internal.telephony.dataconnectiontracker.intent_set_fail_data_setup_counter";
    protected static final String FAIL_DATA_SETUP_COUNTER = "fail_data_setup_counter";
    protected int mFailDataSetupCounter = 0;
    protected static final String FAIL_DATA_SETUP_FAIL_CAUSE = "fail_data_setup_fail_cause";
    protected DataConnection.FailCause mFailDataSetupFailCause = DataConnection.FailCause.ERROR_UNSPECIFIED;
    protected static final String DEFALUT_DATA_ON_BOOT_PROP = "net.def_data_on_boot";
    protected PhoneBase mPhone;
    protected Activity mActivity = Activity.NONE;
    protected State mState = State.IDLE;
    protected Handler mDataConnectionTracker = null;
    protected long mTxPkts;
    protected long mRxPkts;
    protected int mNetStatPollPeriod;
    protected boolean mNetStatPollEnabled = false;
    protected TxRxSum mDataStallTxRxSum = new TxRxSum(0L, 0L);
    protected int mDataStallAlarmTag = (int)SystemClock.elapsedRealtime();
    protected PendingIntent mDataStallAlarmIntent = null;
    protected long mSentSinceLastRecv;
    protected int mNoRecvPollCount = 0;
    protected boolean mIsWifiConnected = false;
    protected PendingIntent mReconnectIntent = null;
    protected int mCidActive;
    protected boolean mAutoAttachOnCreation = false;
    protected boolean mIsScreenOn = true;
    protected AtomicInteger mUniqueIdGenerator = new AtomicInteger(0);
    protected HashMap<Integer, DataConnection> mDataConnections = new HashMap();
    protected HashMap<Integer, DataConnectionAc> mDataConnectionAsyncChannels = new HashMap();
    protected HashMap<String, Integer> mApnToDataConnectionId = new HashMap();
    protected ConcurrentHashMap<String, ApnContext> mApnContexts;
    protected ApnSetting mActiveApn;
    protected ArrayList<ApnSetting> mAllApns = null;
    protected ApnSetting mPreferredApn = null;
    protected boolean mIsPsRestricted = false;
    protected boolean mIsDisposed = false;
    protected BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            DataConnectionTracker.this.log("onReceive: action=" + action);
            if (action.equals("android.intent.action.SCREEN_ON")) {
                DataConnectionTracker.this.mIsScreenOn = true;
                DataConnectionTracker.this.stopNetStatPoll();
                DataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                DataConnectionTracker.this.mIsScreenOn = false;
                DataConnectionTracker.this.stopNetStatPoll();
                DataConnectionTracker.this.startNetStatPoll();
            } else if (action.startsWith(DataConnectionTracker.this.getActionIntentReconnectAlarm())) {
                DataConnectionTracker.this.log("Reconnect alarm. Previous state was " + (Object)((Object)DataConnectionTracker.this.mState));
                DataConnectionTracker.this.onActionIntentReconnectAlarm(intent);
            } else if (action.equals(DataConnectionTracker.this.getActionIntentDataStallAlarm())) {
                DataConnectionTracker.this.onActionIntentDataStallAlarm(intent);
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                DataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    DataConnectionTracker.this.mIsWifiConnected = false;
                }
            } else if (action.equals(DataConnectionTracker.INTENT_SET_FAIL_DATA_SETUP_COUNTER)) {
                DataConnectionTracker.this.mFailDataSetupCounter = intent.getIntExtra(DataConnectionTracker.FAIL_DATA_SETUP_COUNTER, 1);
                DataConnectionTracker.this.mFailDataSetupFailCause = DataConnection.FailCause.fromInt(intent.getIntExtra(DataConnectionTracker.FAIL_DATA_SETUP_FAIL_CAUSE, DataConnection.FailCause.ERROR_UNSPECIFIED.getErrorCode()));
                DataConnectionTracker.this.log("set mFailDataSetupCounter=" + DataConnectionTracker.this.mFailDataSetupCounter + " mFailDataSetupFailCause=" + (Object)((Object)DataConnectionTracker.this.mFailDataSetupFailCause));
            }
        }
    };
    private final DataRoamingSettingObserver mDataRoamingSettingObserver;

    protected boolean isDataSetupCompleteOk(AsyncResult ar) {
        if (ar.exception != null) {
            this.log("isDataSetupCompleteOk return false, ar.result=" + ar.result);
            return false;
        }
        if (this.mFailDataSetupCounter <= 0) {
            this.log("isDataSetupCompleteOk return true");
            return true;
        }
        ar.result = this.mFailDataSetupFailCause;
        this.log("isDataSetupCompleteOk return false mFailDataSetupCounter=" + this.mFailDataSetupCounter + " mFailDataSetupFailCause=" + (Object)((Object)this.mFailDataSetupFailCause));
        --this.mFailDataSetupCounter;
        return false;
    }

    protected void onActionIntentReconnectAlarm(Intent intent) {
        String reason = intent.getStringExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON);
        if (this.mState == State.FAILED) {
            Message msg = this.obtainMessage(270360);
            msg.arg1 = 0;
            msg.arg2 = 0;
            msg.obj = reason;
            this.sendMessage(msg);
        }
        this.sendMessage(this.obtainMessage(270339));
    }

    protected void onActionIntentDataStallAlarm(Intent intent) {
        Message msg = this.obtainMessage(270353, intent.getAction());
        msg.arg1 = intent.getIntExtra(DATA_STALL_ALARM_TAG_EXTRA, 0);
        this.sendMessage(msg);
    }

    protected DataConnectionTracker(PhoneBase phone) {
        this.mPhone = phone;
        IntentFilter filter = new IntentFilter();
        filter.addAction(this.getActionIntentReconnectAlarm());
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction(INTENT_SET_FAIL_DATA_SETUP_COUNTER);
        this.mUserDataEnabled = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "mobile_data", 1) == 1;
        this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        this.dataEnabled[0] = SystemProperties.getBoolean(DEFALUT_DATA_ON_BOOT_PROP, true);
        if (this.dataEnabled[0]) {
            ++this.enabledCount;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        this.mAutoAttachOnCreation = sp.getBoolean("disabled_on_boot_key", false);
        this.mDataRoamingSettingObserver = new DataRoamingSettingObserver(this.mPhone);
        this.mDataRoamingSettingObserver.register(this.mPhone.getContext());
    }

    public void dispose() {
        for (DataConnectionAc dcac : this.mDataConnectionAsyncChannels.values()) {
            dcac.disconnect();
        }
        this.mDataConnectionAsyncChannels.clear();
        this.mIsDisposed = true;
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.mDataRoamingSettingObserver.unregister(this.mPhone.getContext());
    }

    protected void broadcastMessenger() {
        Intent intent = new Intent(ACTION_DATA_CONNECTION_TRACKER_MESSENGER);
        intent.putExtra(EXTRA_MESSENGER, new Messenger(this));
        this.mPhone.getContext().sendBroadcast(intent);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public boolean isApnTypeActive(String type) {
        ApnSetting dunApn;
        if ("dun".equals(type) && (dunApn = this.fetchDunApn()) != null) {
            return this.mActiveApn != null && dunApn.toString().equals(this.mActiveApn.toString());
        }
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    protected ApnSetting fetchDunApn() {
        Context c = this.mPhone.getContext();
        String apnData = Settings.Secure.getString(c.getContentResolver(), "tether_dun_apn");
        ApnSetting dunSetting = ApnSetting.fromString(apnData);
        if (dunSetting != null) {
            return dunSetting;
        }
        apnData = c.getResources().getString(17039385);
        return ApnSetting.fromString(apnData);
    }

    public String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    public String getActiveApnString(String apnType) {
        String result = null;
        if (this.mActiveApn != null) {
            result = this.mActiveApn.apn;
        }
        return result;
    }

    public void setDataOnRoamingEnabled(boolean enabled) {
        if (this.getDataOnRoamingEnabled() != enabled) {
            ContentResolver resolver = this.mPhone.getContext().getContentResolver();
            Settings.Secure.putInt(resolver, "data_roaming", enabled ? 1 : 0);
        }
    }

    public boolean getDataOnRoamingEnabled() {
        try {
            ContentResolver resolver = this.mPhone.getContext().getContentResolver();
            return Settings.Secure.getInt(resolver, "data_roaming") != 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return false;
        }
    }

    private void handleDataOnRoamingChange() {
        if (this.mPhone.getServiceState().getRoaming()) {
            if (this.getDataOnRoamingEnabled()) {
                this.resetAllRetryCounts();
            }
            this.sendMessage(this.obtainMessage(270347));
        }
    }

    protected abstract String getActionIntentReconnectAlarm();

    protected abstract String getActionIntentDataStallAlarm();

    protected abstract void startNetStatPoll();

    protected abstract void stopNetStatPoll();

    protected abstract void restartRadio();

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    protected abstract boolean isDataAllowed();

    protected abstract boolean isApnTypeAvailable(String var1);

    public abstract State getState(String var1);

    protected abstract void setState(State var1);

    protected abstract void gotoIdleAndNotifyDataConnection(String var1);

    protected abstract boolean onTrySetupData(String var1);

    protected abstract void onRoamingOff();

    protected abstract void onRoamingOn();

    protected abstract void onRadioAvailable();

    protected abstract void onRadioOffOrNotAvailable();

    protected abstract void onDataSetupComplete(AsyncResult var1);

    protected abstract void onDisconnectDone(int var1, AsyncResult var2);

    protected abstract void onVoiceCallStarted();

    protected abstract void onVoiceCallEnded();

    protected abstract void onCleanUpConnection(boolean var1, int var2, String var3);

    protected abstract void onCleanUpAllConnections(String var1);

    protected abstract boolean isDataPossible(String var1);

    protected void onDataStallAlarm(int tag) {
        this.loge("onDataStallAlarm: not impleted tag=" + tag);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 69636: {
                this.log("DISCONNECTED_CONNECTED: msg=" + msg);
                DataConnectionAc dcac = (DataConnectionAc)msg.obj;
                this.mDataConnectionAsyncChannels.remove(dcac.dataConnection.getDataConnectionId());
                dcac.disconnected();
                break;
            }
            case 270349: {
                this.onEnableApn(msg.arg1, msg.arg2);
                break;
            }
            case 270339: {
                String reason = null;
                if (msg.obj instanceof String) {
                    reason = (String)msg.obj;
                }
                this.onTrySetupData(reason);
                break;
            }
            case 270353: {
                this.onDataStallAlarm(msg.arg1);
                break;
            }
            case 270348: {
                if (!this.getDataOnRoamingEnabled()) {
                    this.resetAllRetryCounts();
                }
                this.onRoamingOff();
                break;
            }
            case 270347: {
                this.onRoamingOn();
                break;
            }
            case 270337: {
                this.onRadioAvailable();
                break;
            }
            case 270342: {
                this.onRadioOffOrNotAvailable();
                break;
            }
            case 270336: {
                this.mCidActive = msg.arg1;
                this.onDataSetupComplete((AsyncResult)msg.obj);
                break;
            }
            case 270351: {
                this.log("DataConnectoinTracker.handleMessage: EVENT_DISCONNECT_DONE msg=" + msg);
                this.onDisconnectDone(msg.arg1, (AsyncResult)msg.obj);
                break;
            }
            case 270343: {
                this.onVoiceCallStarted();
                break;
            }
            case 270344: {
                this.onVoiceCallEnded();
                break;
            }
            case 270366: {
                this.onCleanUpAllConnections((String)msg.obj);
                break;
            }
            case 270360: {
                boolean tearDown = msg.arg1 != 0;
                this.onCleanUpConnection(tearDown, msg.arg2, (String)msg.obj);
                break;
            }
            case 270363: {
                boolean enabled = msg.arg1 == 1;
                this.onSetInternalDataEnabled(enabled);
                break;
            }
            case 270364: {
                this.log("EVENT_RESET_DONE");
                this.onResetDone((AsyncResult)msg.obj);
                break;
            }
            case 270365: {
                boolean enabled = msg.arg1 == 1;
                this.log("CMD_SET_USER_DATA_ENABLE enabled=" + enabled);
                this.onSetUserDataEnabled(enabled);
                break;
            }
            case 270367: {
                String apnType;
                boolean met = msg.arg1 == 1;
                this.log("CMD_SET_DEPENDENCY_MET met=" + met);
                Bundle bundle = msg.getData();
                if (bundle == null || (apnType = (String)bundle.get(APN_TYPE_KEY)) == null) break;
                this.onSetDependencyMet(apnType, met);
                break;
            }
            case 270368: {
                boolean enabled = msg.arg1 == 1;
                this.onSetPolicyDataEnabled(enabled);
                break;
            }
            default: {
                Log.e("DATA", "Unidentified event msg=" + msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAnyDataEnabled() {
        boolean result;
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            result = this.mInternalDataEnabled && this.mUserDataEnabled && sPolicyDataEnabled && this.enabledCount != 0;
        }
        if (!result) {
            this.log("getAnyDataEnabled " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEmergency() {
        boolean result;
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            result = this.mPhone.isInEcm() || this.mPhone.isInEmergencyCall();
        }
        this.log("isEmergency: result=" + result);
        return result;
    }

    protected int apnTypeToId(String type) {
        if (TextUtils.equals(type, "default")) {
            return 0;
        }
        if (TextUtils.equals(type, "mms")) {
            return 1;
        }
        if (TextUtils.equals(type, "supl")) {
            return 2;
        }
        if (TextUtils.equals(type, "dun")) {
            return 3;
        }
        if (TextUtils.equals(type, "hipri")) {
            return 4;
        }
        if (TextUtils.equals(type, "ims")) {
            return 5;
        }
        if (TextUtils.equals(type, "fota")) {
            return 6;
        }
        if (TextUtils.equals(type, "cbs")) {
            return 7;
        }
        return -1;
    }

    protected String apnIdToType(int id2) {
        switch (id2) {
            case 0: {
                return "default";
            }
            case 1: {
                return "mms";
            }
            case 2: {
                return "supl";
            }
            case 3: {
                return "dun";
            }
            case 4: {
                return "hipri";
            }
            case 5: {
                return "ims";
            }
            case 6: {
                return "fota";
            }
            case 7: {
                return "cbs";
            }
        }
        this.log("Unknown id (" + id2 + ") in apnIdToType");
        return "default";
    }

    protected LinkProperties getLinkProperties(String apnType) {
        int id2 = this.apnTypeToId(apnType);
        if (this.isApnIdEnabled(id2)) {
            DataConnectionAc dcac = this.mDataConnectionAsyncChannels.get(0);
            return dcac.getLinkPropertiesSync();
        }
        return new LinkProperties();
    }

    protected LinkCapabilities getLinkCapabilities(String apnType) {
        int id2 = this.apnTypeToId(apnType);
        if (this.isApnIdEnabled(id2)) {
            DataConnectionAc dcac = this.mDataConnectionAsyncChannels.get(0);
            return dcac.getLinkCapabilitiesSync();
        }
        return new LinkCapabilities();
    }

    protected void notifyDataConnection(String reason) {
        for (int id2 = 0; id2 < 8; ++id2) {
            if (!this.dataEnabled[id2]) continue;
            this.mPhone.notifyDataConnection(reason, this.apnIdToType(id2));
        }
        this.notifyOffApnsOfAvailability(reason);
    }

    private void notifyApnIdUpToCurrent(String reason, int apnId) {
        switch (this.mState) {
            case IDLE: 
            case INITING: {
                break;
            }
            case CONNECTING: 
            case SCANNING: {
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.CONNECTING);
                break;
            }
            case CONNECTED: 
            case DISCONNECTING: {
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.CONNECTING);
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.CONNECTED);
            }
        }
    }

    private void notifyApnIdDisconnected(String reason, int apnId) {
        this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.DISCONNECTED);
    }

    protected void notifyOffApnsOfAvailability(String reason) {
        this.log("notifyOffApnsOfAvailability - reason= " + reason);
        for (int id2 = 0; id2 < 8; ++id2) {
            if (this.isApnIdEnabled(id2)) continue;
            this.notifyApnIdDisconnected(reason, id2);
        }
    }

    public boolean isApnTypeEnabled(String apnType) {
        if (apnType == null) {
            return false;
        }
        return this.isApnIdEnabled(this.apnTypeToId(apnType));
    }

    protected synchronized boolean isApnIdEnabled(int id2) {
        if (id2 != -1) {
            return this.dataEnabled[id2];
        }
        return false;
    }

    public synchronized int enableApnType(String type) {
        int id2 = this.apnTypeToId(type);
        if (id2 == -1) {
            return 3;
        }
        this.log("enableApnType(" + type + "), isApnTypeActive = " + this.isApnTypeActive(type) + ", isApnIdEnabled =" + this.isApnIdEnabled(id2) + " and state = " + (Object)((Object)this.mState));
        if (!this.isApnTypeAvailable(type)) {
            this.log("type not available");
            return 2;
        }
        if (this.isApnIdEnabled(id2)) {
            return 0;
        }
        this.setEnabled(id2, true);
        return 1;
    }

    public synchronized int disableApnType(String type) {
        this.log("disableApnType(" + type + ")");
        int id2 = this.apnTypeToId(type);
        if (id2 == -1) {
            return 3;
        }
        if (this.isApnIdEnabled(id2)) {
            this.setEnabled(id2, false);
            if (this.isApnTypeActive("default")) {
                if (this.dataEnabled[0]) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return 3;
    }

    protected void setEnabled(int id2, boolean enable) {
        this.log("setEnabled(" + id2 + ", " + enable + ") with old state = " + this.dataEnabled[id2] + " and enabledCount = " + this.enabledCount);
        Message msg = this.obtainMessage(270349);
        msg.arg1 = id2;
        msg.arg2 = enable ? 1 : 0;
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEnableApn(int apnId, int enabled) {
        this.log("EVENT_APN_ENABLE_REQUEST apnId=" + apnId + ", apnType=" + this.apnIdToType(apnId) + ", enabled=" + enabled + ", dataEnabled = " + this.dataEnabled[apnId] + ", enabledCount = " + this.enabledCount + ", isApnTypeActive = " + this.isApnTypeActive(this.apnIdToType(apnId)));
        if (enabled == 1) {
            DataConnectionTracker dataConnectionTracker = this;
            synchronized (dataConnectionTracker) {
                if (!this.dataEnabled[apnId]) {
                    this.dataEnabled[apnId] = true;
                    ++this.enabledCount;
                }
            }
            String type = this.apnIdToType(apnId);
            if (!this.isApnTypeActive(type)) {
                this.mRequestedApnType = type;
                this.onEnableNewApn();
            } else {
                this.notifyApnIdUpToCurrent("apnSwitched", apnId);
            }
        } else {
            boolean didDisable = false;
            DataConnectionTracker dataConnectionTracker = this;
            synchronized (dataConnectionTracker) {
                if (this.dataEnabled[apnId]) {
                    this.dataEnabled[apnId] = false;
                    --this.enabledCount;
                    didDisable = true;
                }
            }
            if (didDisable && this.enabledCount == 0) {
                this.onCleanUpConnection(true, apnId, "dataDisabled");
                this.notifyApnIdDisconnected("dataDisabled", apnId);
                if (this.dataEnabled[0] && !this.isApnTypeActive("default")) {
                    this.mRequestedApnType = "default";
                    this.onEnableNewApn();
                }
            }
        }
    }

    protected void onEnableNewApn() {
    }

    protected void onResetDone(AsyncResult ar) {
        this.log("EVENT_RESET_DONE");
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(reason);
    }

    public boolean setInternalDataEnabled(boolean enable) {
        this.log("setInternalDataEnabled(" + enable + ")");
        Message msg = this.obtainMessage(270363);
        msg.arg1 = enable ? 1 : 0;
        this.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetInternalDataEnabled(boolean enabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            this.mInternalDataEnabled = enabled;
            if (enabled) {
                this.log("onSetInternalDataEnabled: changed to enabled, try to setup data call");
                this.resetAllRetryCounts();
                this.onTrySetupData("dataEnabled");
            } else {
                this.log("onSetInternalDataEnabled: changed to disabled, cleanUpAllConnections");
                this.cleanUpAllConnections(null);
            }
        }
    }

    public void cleanUpAllConnections(String cause) {
        Message msg = this.obtainMessage(270366);
        msg.obj = cause;
        this.sendMessage(msg);
    }

    public abstract boolean isDisconnected();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetUserDataEnabled(boolean enabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            boolean prevEnabled = this.getAnyDataEnabled();
            if (this.mUserDataEnabled != enabled) {
                this.mUserDataEnabled = enabled;
                Settings.Secure.putInt(this.mPhone.getContext().getContentResolver(), "mobile_data", enabled ? 1 : 0);
                if (prevEnabled != this.getAnyDataEnabled()) {
                    if (!prevEnabled) {
                        this.resetAllRetryCounts();
                        this.onTrySetupData("dataEnabled");
                    } else {
                        this.onCleanUpAllConnections("dataDisabled");
                    }
                }
            }
        }
    }

    protected void onSetDependencyMet(String apnType, boolean met) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetPolicyDataEnabled(boolean enabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            boolean prevEnabled = this.getAnyDataEnabled();
            if (sPolicyDataEnabled != enabled) {
                sPolicyDataEnabled = enabled;
                if (prevEnabled != this.getAnyDataEnabled()) {
                    if (!prevEnabled) {
                        this.resetAllRetryCounts();
                        this.onTrySetupData("dataEnabled");
                    } else {
                        this.onCleanUpAllConnections("dataDisabled");
                    }
                }
            }
        }
    }

    protected String getReryConfig(boolean forDefault) {
        int rt = this.mPhone.getServiceState().getRadioTechnology();
        if (rt == 4 || rt == 5 || rt == 6 || rt == 7 || rt == 8 || rt == 12 || rt == 13) {
            return SystemProperties.get("ro.cdma.data_retry_config");
        }
        if (forDefault) {
            return SystemProperties.get("ro.gsm.data_retry_config");
        }
        return SystemProperties.get("ro.gsm.2nd_data_retry_config");
    }

    protected void resetAllRetryCounts() {
        for (DataConnection dc : this.mDataConnections.values()) {
            dc.resetRetryCount();
        }
    }

    public class TxRxSum {
        public long txPkts;
        public long rxPkts;

        public TxRxSum() {
            this.reset();
        }

        public TxRxSum(long txPkts, long rxPkts) {
            this.txPkts = txPkts;
            this.rxPkts = rxPkts;
        }

        public TxRxSum(TxRxSum sum) {
            this.txPkts = sum.txPkts;
            this.rxPkts = sum.rxPkts;
        }

        public void reset() {
            this.txPkts = -1L;
            this.rxPkts = -1L;
        }

        public String toString() {
            return "{txSum=" + this.txPkts + " rxSum=" + this.rxPkts + "}";
        }

        public void updateTxRxSum() {
            boolean txUpdated = false;
            boolean rxUpdated = false;
            long txSum = 0L;
            long rxSum = 0L;
            for (ApnContext apnContext : DataConnectionTracker.this.mApnContexts.values()) {
                String iface;
                LinkProperties linkProp;
                DataConnectionAc dcac;
                if (apnContext.getState() != State.CONNECTED || (dcac = apnContext.getDataConnectionAc()) == null || (linkProp = dcac.getLinkPropertiesSync()) == null || (iface = linkProp.getInterfaceName()) == null) continue;
                long stats = TrafficStats.getTxPackets(iface);
                if (stats > 0L) {
                    txUpdated = true;
                    txSum += stats;
                }
                if ((stats = TrafficStats.getRxPackets(iface)) <= 0L) continue;
                rxUpdated = true;
                rxSum += stats;
            }
            if (txUpdated) {
                this.txPkts = txSum;
            }
            if (rxUpdated) {
                this.rxPkts = rxSum;
            }
        }
    }

    private class DataRoamingSettingObserver
    extends ContentObserver {
        public DataRoamingSettingObserver(Handler handler) {
            super(handler);
        }

        public void register(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("data_roaming"), false, this);
        }

        public void unregister(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.unregisterContentObserver(this);
        }

        public void onChange(boolean selfChange) {
            DataConnectionTracker.this.handleDataOnRoamingChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Activity {
        NONE,
        DATAIN,
        DATAOUT,
        DATAINANDOUT,
        DORMANT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        INITING,
        CONNECTING,
        SCANNING,
        CONNECTED,
        DISCONNECTING,
        FAILED;

    }
}

