/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.EventLog;

public class EventLogTags {
    public static final int PDP_BAD_DNS_ADDRESS = 50100;
    public static final int PDP_RADIO_RESET_COUNTDOWN_TRIGGERED = 50101;
    public static final int PDP_RADIO_RESET = 50102;
    public static final int PDP_CONTEXT_RESET = 50103;
    public static final int PDP_REREGISTER_NETWORK = 50104;
    public static final int PDP_SETUP_FAIL = 50105;
    public static final int CALL_DROP = 50106;
    public static final int DATA_NETWORK_REGISTRATION_FAIL = 50107;
    public static final int DATA_NETWORK_STATUS_ON_RADIO_OFF = 50108;
    public static final int PDP_NETWORK_DROP = 50109;
    public static final int CDMA_DATA_SETUP_FAILED = 50110;
    public static final int CDMA_DATA_DROP = 50111;
    public static final int GSM_RAT_SWITCHED = 50112;
    public static final int GSM_DATA_STATE_CHANGE = 50113;
    public static final int GSM_SERVICE_STATE_CHANGE = 50114;
    public static final int CDMA_DATA_STATE_CHANGE = 50115;
    public static final int CDMA_SERVICE_STATE_CHANGE = 50116;
    public static final int BAD_IP_ADDRESS = 50117;
    public static final int DATA_STALL_RECOVERY_GET_DATA_CALL_LIST = 50118;
    public static final int DATA_STALL_RECOVERY_CLEANUP = 50119;
    public static final int DATA_STALL_RECOVERY_REREGISTER = 50120;
    public static final int DATA_STALL_RECOVERY_RADIO_RESTART = 50121;
    public static final int DATA_STALL_RECOVERY_RADIO_RESTART_WITH_PROP = 50122;

    private EventLogTags() {
    }

    public static void writePdpBadDnsAddress(String dnsAddress) {
        EventLog.writeEvent(50100, dnsAddress);
    }

    public static void writePdpRadioResetCountdownTriggered(int outPacketCount) {
        EventLog.writeEvent(50101, outPacketCount);
    }

    public static void writePdpRadioReset(int outPacketCount) {
        EventLog.writeEvent(50102, outPacketCount);
    }

    public static void writePdpContextReset(int outPacketCount) {
        EventLog.writeEvent(50103, outPacketCount);
    }

    public static void writePdpReregisterNetwork(int outPacketCount) {
        EventLog.writeEvent(50104, outPacketCount);
    }

    public static void writePdpSetupFail(int cause, int cid, int networkType) {
        EventLog.writeEvent(50105, cause, cid, networkType);
    }

    public static void writeCallDrop(int cause, int cid, int networkType) {
        EventLog.writeEvent(50106, cause, cid, networkType);
    }

    public static void writeDataNetworkRegistrationFail(int opNumeric, int cid) {
        EventLog.writeEvent(50107, opNumeric, cid);
    }

    public static void writeDataNetworkStatusOnRadioOff(String dcState, int enable) {
        EventLog.writeEvent(50108, dcState, enable);
    }

    public static void writePdpNetworkDrop(int cid, int networkType) {
        EventLog.writeEvent(50109, cid, networkType);
    }

    public static void writeCdmaDataSetupFailed(int cause, int cid, int networkType) {
        EventLog.writeEvent(50110, cause, cid, networkType);
    }

    public static void writeCdmaDataDrop(int cid, int networkType) {
        EventLog.writeEvent(50111, cid, networkType);
    }

    public static void writeGsmRatSwitched(int cid, int networkFrom, int networkTo) {
        EventLog.writeEvent(50112, cid, networkFrom, networkTo);
    }

    public static void writeGsmDataStateChange(String oldstate, String newstate) {
        EventLog.writeEvent(50113, oldstate, newstate);
    }

    public static void writeGsmServiceStateChange(int oldstate, int oldgprsstate, int newstate, int newgprsstate) {
        EventLog.writeEvent(50114, oldstate, oldgprsstate, newstate, newgprsstate);
    }

    public static void writeCdmaDataStateChange(String oldstate, String newstate) {
        EventLog.writeEvent(50115, oldstate, newstate);
    }

    public static void writeCdmaServiceStateChange(int oldstate, int olddatastate, int newstate, int newdatastate) {
        EventLog.writeEvent(50116, oldstate, olddatastate, newstate, newdatastate);
    }

    public static void writeBadIpAddress(String ipAddress) {
        EventLog.writeEvent(50117, ipAddress);
    }

    public static void writeDataStallRecoveryGetDataCallList(int outPacketCount) {
        EventLog.writeEvent(50118, outPacketCount);
    }

    public static void writeDataStallRecoveryCleanup(int outPacketCount) {
        EventLog.writeEvent(50119, outPacketCount);
    }

    public static void writeDataStallRecoveryReregister(int outPacketCount) {
        EventLog.writeEvent(50120, outPacketCount);
    }

    public static void writeDataStallRecoveryRadioRestart(int outPacketCount) {
        EventLog.writeEvent(50121, outPacketCount);
    }

    public static void writeDataStallRecoveryRadioRestartWithProp(int outPacketCount) {
        EventLog.writeEvent(50122, outPacketCount);
    }
}

