/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.Context;
import android.util.Log;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IccSmsInterfaceManager
extends ISms.Stub {
    protected PhoneBase mPhone;
    protected Context mContext;
    protected SMSDispatcher mDispatcher;

    protected IccSmsInterfaceManager(PhoneBase phone) {
        this.mPhone = phone;
        this.mContext = phone.getContext();
    }

    protected void enforceReceiveAndSend(String message) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", message);
        this.mContext.enforceCallingPermission("android.permission.SEND_SMS", message);
    }

    @Override
    public void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            this.log("sendData: destAddr=" + destAddr + " scAddr=" + scAddr + " destPort=" + destPort + " data='" + HexDump.toHexString(data) + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        this.mDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
    }

    @Override
    public void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.mPhone.getContext().enforceCallingOrSelfPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            this.log("sendText: destAddr=" + destAddr + " scAddr=" + scAddr + " text='" + text + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        this.mDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent);
    }

    @Override
    public void sendMultipartText(String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            int i = 0;
            for (String part : parts) {
                this.log("sendMultipartText: destAddr=" + destAddr + ", srAddr=" + scAddr + ", part[" + i++ + "]=" + part);
            }
        }
        this.mDispatcher.sendMultipartText(destAddr, scAddr, (ArrayList)parts, (ArrayList)sentIntents, (ArrayList)deliveryIntents);
    }

    protected ArrayList<SmsRawData> buildValidRawData(ArrayList<byte[]> messages) {
        int count = messages.size();
        ArrayList<SmsRawData> ret = new ArrayList<SmsRawData>(count);
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] == 0) {
                ret.add(null);
                continue;
            }
            ret.add(new SmsRawData(messages.get(i)));
        }
        return ret;
    }

    protected byte[] makeSmsRecordData(int status, byte[] pdu) {
        byte[] data = new byte[176];
        data[0] = (byte)(status & 7);
        System.arraycopy(pdu, 0, data, 1, pdu.length);
        for (int j = pdu.length + 1; j < 176; ++j) {
            data[j] = -1;
        }
        return data;
    }

    protected abstract void log(String var1);
}

