/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.provider.Settings;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsUsageMonitor {
    private static final String TAG = "SmsStorageMonitor";
    private static final int DEFAULT_SMS_CHECK_PERIOD = 3600000;
    private static final int DEFAULT_SMS_MAX_COUNT = 100;
    private final int mCheckPeriod;
    private final int mMaxAllowed;
    private final HashMap<String, ArrayList<Long>> mSmsStamp = new HashMap();

    public SmsUsageMonitor(ContentResolver resolver) {
        this.mMaxAllowed = Settings.Secure.getInt(resolver, "sms_outgoing_check_max_count", 100);
        this.mCheckPeriod = Settings.Secure.getInt(resolver, "sms_outgoing_check_interval_ms", 3600000);
    }

    void dispose() {
        this.mSmsStamp.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String appName, int smsWaiting) {
        HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
        synchronized (hashMap) {
            this.removeExpiredTimestamps();
            ArrayList<Long> sentList = this.mSmsStamp.get(appName);
            if (sentList == null) {
                sentList = new ArrayList();
                this.mSmsStamp.put(appName, sentList);
            }
            return this.isUnderLimit(sentList, smsWaiting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredTimestamps() {
        long beginCheckPeriod = System.currentTimeMillis() - (long)this.mCheckPeriod;
        HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, ArrayList<Long>>> iter = this.mSmsStamp.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ArrayList<Long>> entry = iter.next();
                ArrayList<Long> oldList = entry.getValue();
                if (!oldList.isEmpty() && oldList.get(oldList.size() - 1) >= beginCheckPeriod) continue;
                iter.remove();
            }
        }
    }

    private boolean isUnderLimit(ArrayList<Long> sent, int smsWaiting) {
        Long ct = System.currentTimeMillis();
        long beginCheckPeriod = ct - (long)this.mCheckPeriod;
        Log.d(TAG, "SMS send size=" + sent.size() + " time=" + ct);
        while (!sent.isEmpty() && sent.get(0) < beginCheckPeriod) {
            sent.remove(0);
        }
        if (sent.size() + smsWaiting <= this.mMaxAllowed) {
            for (int i = 0; i < smsWaiting; ++i) {
                sent.add(ct);
            }
            return true;
        }
        return false;
    }
}

