/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.BerTlv;
import com.android.internal.telephony.cat.CallSetupParams;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.DisplayTextParams;
import com.android.internal.telephony.cat.Duration;
import com.android.internal.telephony.cat.GetInputParams;
import com.android.internal.telephony.cat.IconId;
import com.android.internal.telephony.cat.IconLoader;
import com.android.internal.telephony.cat.Input;
import com.android.internal.telephony.cat.ItemsIconId;
import com.android.internal.telephony.cat.LaunchBrowserMode;
import com.android.internal.telephony.cat.LaunchBrowserParams;
import com.android.internal.telephony.cat.Menu;
import com.android.internal.telephony.cat.PlayToneParams;
import com.android.internal.telephony.cat.PresentationType;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.RilMessageDecoder;
import com.android.internal.telephony.cat.SelectItemParams;
import com.android.internal.telephony.cat.TextMessage;
import com.android.internal.telephony.cat.Tone;
import com.android.internal.telephony.cat.ValueParser;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandParamsFactory
extends Handler {
    private static CommandParamsFactory sInstance = null;
    private IconLoader mIconLoader;
    private CommandParams mCmdParams = null;
    private int mIconLoadState = 0;
    private RilMessageDecoder mCaller = null;
    static final int MSG_ID_LOAD_ICON_DONE = 1;
    static final int LOAD_NO_ICON = 0;
    static final int LOAD_SINGLE_ICON = 1;
    static final int LOAD_MULTI_ICONS = 2;
    static final int REFRESH_NAA_INIT_AND_FULL_FILE_CHANGE = 0;
    static final int REFRESH_NAA_INIT_AND_FILE_CHANGE = 2;
    static final int REFRESH_NAA_INIT = 3;
    static final int REFRESH_UICC_RESET = 4;
    static final int DTTZ_SETTING = 3;
    static final int LANGUAGE_SETTING = 4;

    static synchronized CommandParamsFactory getInstance(RilMessageDecoder caller, IccFileHandler fh) {
        if (sInstance != null) {
            return sInstance;
        }
        if (fh != null) {
            return new CommandParamsFactory(caller, fh);
        }
        return null;
    }

    private CommandParamsFactory(RilMessageDecoder caller, IccFileHandler fh) {
        this.mCaller = caller;
        this.mIconLoader = IconLoader.getInstance(this, fh);
    }

    private CommandDetails processCommandDetails(List<ComprehensionTlv> ctlvs) {
        ComprehensionTlv ctlvCmdDet;
        CommandDetails cmdDet = null;
        if (ctlvs != null && (ctlvCmdDet = this.searchForTag(ComprehensionTlvTag.COMMAND_DETAILS, ctlvs)) != null) {
            try {
                cmdDet = ValueParser.retrieveCommandDetails(ctlvCmdDet);
            }
            catch (ResultException e) {
                CatLog.d(this, "Failed to procees command details");
            }
        }
        return cmdDet;
    }

    void make(BerTlv berTlv) {
        if (berTlv == null) {
            return;
        }
        this.mCmdParams = null;
        this.mIconLoadState = 0;
        if (berTlv.getTag() != 208) {
            this.sendCmdParams(ResultCode.CMD_TYPE_NOT_UNDERSTOOD);
            return;
        }
        boolean cmdPending = false;
        List<ComprehensionTlv> ctlvs = berTlv.getComprehensionTlvs();
        CommandDetails cmdDet = this.processCommandDetails(ctlvs);
        if (cmdDet == null) {
            this.sendCmdParams(ResultCode.CMD_TYPE_NOT_UNDERSTOOD);
            return;
        }
        AppInterface.CommandType cmdType = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
        if (cmdType == null) {
            this.mCmdParams = new CommandParams(cmdDet);
            this.sendCmdParams(ResultCode.BEYOND_TERMINAL_CAPABILITY);
            return;
        }
        try {
            switch (cmdType) {
                case SET_UP_MENU: {
                    cmdPending = this.processSelectItem(cmdDet, ctlvs);
                    break;
                }
                case SELECT_ITEM: {
                    cmdPending = this.processSelectItem(cmdDet, ctlvs);
                    break;
                }
                case DISPLAY_TEXT: {
                    cmdPending = this.processDisplayText(cmdDet, ctlvs);
                    break;
                }
                case SET_UP_IDLE_MODE_TEXT: {
                    cmdPending = this.processSetUpIdleModeText(cmdDet, ctlvs);
                    break;
                }
                case GET_INKEY: {
                    cmdPending = this.processGetInkey(cmdDet, ctlvs);
                    break;
                }
                case GET_INPUT: {
                    cmdPending = this.processGetInput(cmdDet, ctlvs);
                    break;
                }
                case SEND_DTMF: 
                case SEND_SMS: 
                case SEND_SS: 
                case SEND_USSD: {
                    cmdPending = this.processEventNotify(cmdDet, ctlvs);
                    break;
                }
                case SET_UP_CALL: {
                    cmdPending = this.processSetupCall(cmdDet, ctlvs);
                    break;
                }
                case REFRESH: {
                    this.processRefresh(cmdDet, ctlvs);
                    cmdPending = false;
                    break;
                }
                case LAUNCH_BROWSER: {
                    cmdPending = this.processLaunchBrowser(cmdDet, ctlvs);
                    break;
                }
                case PLAY_TONE: {
                    cmdPending = this.processPlayTone(cmdDet, ctlvs);
                    break;
                }
                case PROVIDE_LOCAL_INFORMATION: {
                    cmdPending = this.processProvideLocalInfo(cmdDet, ctlvs);
                    break;
                }
                default: {
                    this.mCmdParams = new CommandParams(cmdDet);
                    this.sendCmdParams(ResultCode.BEYOND_TERMINAL_CAPABILITY);
                    return;
                }
            }
        }
        catch (ResultException e) {
            this.mCmdParams = new CommandParams(cmdDet);
            this.sendCmdParams(e.result());
            return;
        }
        if (!cmdPending) {
            this.sendCmdParams(ResultCode.OK);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.sendCmdParams(this.setIcons(msg.obj));
            }
        }
    }

    private ResultCode setIcons(Object data) {
        Bitmap[] icons = null;
        boolean iconIndex = false;
        if (data == null) {
            return ResultCode.PRFRMD_ICON_NOT_DISPLAYED;
        }
        switch (this.mIconLoadState) {
            case 1: {
                this.mCmdParams.setIcon((Bitmap)data);
                break;
            }
            case 2: {
                for (Bitmap icon : icons = (Bitmap[])data) {
                    this.mCmdParams.setIcon(icon);
                }
                break;
            }
        }
        return ResultCode.OK;
    }

    private void sendCmdParams(ResultCode resCode) {
        this.mCaller.sendMsgParamsDecoded(resCode, this.mCmdParams);
    }

    private ComprehensionTlv searchForTag(ComprehensionTlvTag tag, List<ComprehensionTlv> ctlvs) {
        Iterator<ComprehensionTlv> iter = ctlvs.iterator();
        return this.searchForNextTag(tag, iter);
    }

    private ComprehensionTlv searchForNextTag(ComprehensionTlvTag tag, Iterator<ComprehensionTlv> iter) {
        int tagValue = tag.value();
        while (iter.hasNext()) {
            ComprehensionTlv ctlv = iter.next();
            if (ctlv.getTag() != tagValue) continue;
            return ctlv;
        }
        return null;
    }

    private boolean processDisplayText(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process DisplayText");
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv != null) {
            textMsg.text = ValueParser.retrieveTextString(ctlv);
        }
        if (textMsg.text == null) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.IMMEDIATE_RESPONSE, ctlvs);
        if (ctlv != null) {
            textMsg.responseNeeded = false;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.DURATION, ctlvs)) != null) {
            textMsg.duration = ValueParser.retrieveDuration(ctlv);
        }
        textMsg.isHighPriority = (cmdDet.commandQualifier & 1) != 0;
        textMsg.userClear = (cmdDet.commandQualifier & 0x80) != 0;
        this.mCmdParams = new DisplayTextParams(cmdDet, textMsg);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processSetUpIdleModeText(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process SetUpIdleModeText");
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv != null) {
            textMsg.text = ValueParser.retrieveTextString(ctlv);
        }
        if (textMsg.text != null && (ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        this.mCmdParams = new DisplayTextParams(cmdDet, textMsg);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processGetInkey(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process GetInkey");
        Input input = new Input();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        input.text = ValueParser.retrieveTextString(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.DURATION, ctlvs)) != null) {
            input.duration = ValueParser.retrieveDuration(ctlv);
        }
        input.minLen = 1;
        input.maxLen = 1;
        input.digitOnly = (cmdDet.commandQualifier & 1) == 0;
        input.ucs2 = (cmdDet.commandQualifier & 2) != 0;
        input.yesNo = (cmdDet.commandQualifier & 4) != 0;
        input.helpAvailable = (cmdDet.commandQualifier & 0x80) != 0;
        input.echo = true;
        this.mCmdParams = new GetInputParams(cmdDet, input);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processGetInput(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process GetInput");
        Input input = new Input();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, ctlvs);
        if (ctlv == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        input.text = ValueParser.retrieveTextString(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.RESPONSE_LENGTH, ctlvs);
        if (ctlv != null) {
            try {
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                input.minLen = rawValue[valueIndex] & 0xFF;
                input.maxLen = rawValue[valueIndex + 1] & 0xFF;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        } else {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.DEFAULT_TEXT, ctlvs);
        if (ctlv != null) {
            input.defaultText = ValueParser.retrieveTextString(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
        }
        input.digitOnly = (cmdDet.commandQualifier & 1) == 0;
        input.ucs2 = (cmdDet.commandQualifier & 2) != 0;
        input.echo = (cmdDet.commandQualifier & 4) == 0;
        input.packed = (cmdDet.commandQualifier & 8) != 0;
        input.helpAvailable = (cmdDet.commandQualifier & 0x80) != 0;
        this.mCmdParams = new GetInputParams(cmdDet, input);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processRefresh(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) {
        CatLog.d(this, "process Refresh");
        switch (cmdDet.commandQualifier) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.mCmdParams = new DisplayTextParams(cmdDet, null);
            }
        }
        return false;
    }

    private boolean processSelectItem(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        boolean presentTypeSpecified;
        CatLog.d(this, "process SelectItem");
        Menu menu2 = new Menu();
        IconId titleIconId = null;
        ItemsIconId itemsIconId = null;
        Iterator<ComprehensionTlv> iter = ctlvs.iterator();
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        if (ctlv != null) {
            menu2.title = ValueParser.retrieveAlphaId(ctlv);
        }
        while ((ctlv = this.searchForNextTag(ComprehensionTlvTag.ITEM, iter)) != null) {
            menu2.items.add(ValueParser.retrieveItem(ctlv));
        }
        if (menu2.items.size() == 0) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.ITEM_ID, ctlvs);
        if (ctlv != null) {
            menu2.defaultItem = ValueParser.retrieveItemId(ctlv) - 1;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            this.mIconLoadState = 1;
            titleIconId = ValueParser.retrieveIconId(ctlv);
            menu2.titleIconSelfExplanatory = titleIconId.selfExplanatory;
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ITEM_ICON_ID_LIST, ctlvs)) != null) {
            this.mIconLoadState = 2;
            itemsIconId = ValueParser.retrieveItemsIconId(ctlv);
            menu2.itemsIconSelfExplanatory = itemsIconId.selfExplanatory;
        }
        boolean bl = presentTypeSpecified = (cmdDet.commandQualifier & 1) != 0;
        if (presentTypeSpecified) {
            menu2.presentationType = (cmdDet.commandQualifier & 2) == 0 ? PresentationType.DATA_VALUES : PresentationType.NAVIGATION_OPTIONS;
        }
        menu2.softKeyPreferred = (cmdDet.commandQualifier & 4) != 0;
        menu2.helpAvailable = (cmdDet.commandQualifier & 0x80) != 0;
        this.mCmdParams = new SelectItemParams(cmdDet, menu2, titleIconId != null);
        switch (this.mIconLoadState) {
            case 0: {
                return false;
            }
            case 1: {
                this.mIconLoader.loadIcon(titleIconId.recordNumber, this.obtainMessage(1));
                break;
            }
            case 2: {
                int[] recordNumbers = itemsIconId.recordNumbers;
                if (titleIconId != null) {
                    recordNumbers = new int[itemsIconId.recordNumbers.length + 1];
                    recordNumbers[0] = titleIconId.recordNumber;
                    System.arraycopy(itemsIconId.recordNumbers, 0, recordNumbers, 1, itemsIconId.recordNumbers.length);
                }
                this.mIconLoader.loadIcons(recordNumbers, this.obtainMessage(1));
            }
        }
        return true;
    }

    private boolean processEventNotify(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process EventNotify");
        TextMessage textMsg = new TextMessage();
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        textMsg.text = ValueParser.retrieveAlphaId(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        textMsg.responseNeeded = false;
        this.mCmdParams = new DisplayTextParams(cmdDet, textMsg);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processSetUpEventList(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) {
        CatLog.d(this, "process SetUpEventList");
        return true;
    }

    private boolean processLaunchBrowser(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        LaunchBrowserMode mode;
        CatLog.d(this, "process LaunchBrowser");
        TextMessage confirmMsg = new TextMessage();
        IconId iconId = null;
        String url = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.URL, ctlvs);
        if (ctlv != null) {
            try {
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                int valueLen = ctlv.getLength();
                url = valueLen > 0 ? GsmAlphabet.gsm8BitUnpackedToString(rawValue, valueIndex, valueLen) : null;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs);
        confirmMsg.text = ValueParser.retrieveAlphaId(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            confirmMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        switch (cmdDet.commandQualifier) {
            default: {
                mode = LaunchBrowserMode.LAUNCH_IF_NOT_ALREADY_LAUNCHED;
                break;
            }
            case 2: {
                mode = LaunchBrowserMode.USE_EXISTING_BROWSER;
                break;
            }
            case 3: {
                mode = LaunchBrowserMode.LAUNCH_NEW_BROWSER;
            }
        }
        this.mCmdParams = new LaunchBrowserParams(cmdDet, confirmMsg, url, mode);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processPlayTone(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process PlayTone");
        Tone tone = null;
        TextMessage textMsg = new TextMessage();
        Duration duration = null;
        IconId iconId = null;
        ComprehensionTlv ctlv = this.searchForTag(ComprehensionTlvTag.TONE, ctlvs);
        if (ctlv != null && ctlv.getLength() > 0) {
            try {
                byte[] rawValue = ctlv.getRawValue();
                int valueIndex = ctlv.getValueIndex();
                byte toneVal = rawValue[valueIndex];
                tone = Tone.fromInt(toneVal);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, ctlvs)) != null) {
            textMsg.text = ValueParser.retrieveAlphaId(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.DURATION, ctlvs)) != null) {
            duration = ValueParser.retrieveDuration(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            iconId = ValueParser.retrieveIconId(ctlv);
            textMsg.iconSelfExplanatory = iconId.selfExplanatory;
        }
        boolean vibrate = (cmdDet.commandQualifier & 1) != 0;
        textMsg.responseNeeded = false;
        this.mCmdParams = new PlayToneParams(cmdDet, textMsg, tone, duration, vibrate);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processSetupCall(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process SetupCall");
        Iterator<ComprehensionTlv> iter = ctlvs.iterator();
        ComprehensionTlv ctlv = null;
        TextMessage confirmMsg = new TextMessage();
        TextMessage callMsg = new TextMessage();
        IconId confirmIconId = null;
        IconId callIconId = null;
        ctlv = this.searchForNextTag(ComprehensionTlvTag.ALPHA_ID, iter);
        confirmMsg.text = ValueParser.retrieveAlphaId(ctlv);
        ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs);
        if (ctlv != null) {
            confirmIconId = ValueParser.retrieveIconId(ctlv);
            confirmMsg.iconSelfExplanatory = confirmIconId.selfExplanatory;
        }
        if ((ctlv = this.searchForNextTag(ComprehensionTlvTag.ALPHA_ID, iter)) != null) {
            callMsg.text = ValueParser.retrieveAlphaId(ctlv);
        }
        if ((ctlv = this.searchForTag(ComprehensionTlvTag.ICON_ID, ctlvs)) != null) {
            callIconId = ValueParser.retrieveIconId(ctlv);
            callMsg.iconSelfExplanatory = callIconId.selfExplanatory;
        }
        this.mCmdParams = new CallSetupParams(cmdDet, confirmMsg, callMsg);
        if (confirmIconId != null || callIconId != null) {
            this.mIconLoadState = 2;
            int[] recordNumbers = new int[]{confirmIconId != null ? confirmIconId.recordNumber : -1, callIconId != null ? callIconId.recordNumber : -1};
            this.mIconLoader.loadIcons(recordNumbers, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processProvideLocalInfo(CommandDetails cmdDet, List<ComprehensionTlv> ctlvs) throws ResultException {
        CatLog.d(this, "process ProvideLocalInfo");
        switch (cmdDet.commandQualifier) {
            case 3: {
                CatLog.d(this, "PLI [DTTZ_SETTING]");
                this.mCmdParams = new CommandParams(cmdDet);
                break;
            }
            case 4: {
                CatLog.d(this, "PLI [LANGUAGE_SETTING]");
                this.mCmdParams = new CommandParams(cmdDet);
                break;
            }
            default: {
                CatLog.d(this, "PLI[" + cmdDet.commandQualifier + "] Command Not Supported");
                this.mCmdParams = new CommandParams(cmdDet);
                throw new ResultException(ResultCode.BEYOND_TERMINAL_CAPABILITY);
            }
        }
        return false;
    }
}

