/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CdmaCall
extends Call {
    ArrayList<Connection> connections = new ArrayList();
    Call.State state = Call.State.IDLE;
    CdmaCallTracker owner;

    static Call.State stateFromDCState(DriverCall.State dcState) {
        switch (dcState) {
            case ACTIVE: {
                return Call.State.ACTIVE;
            }
            case HOLDING: {
                return Call.State.HOLDING;
            }
            case DIALING: {
                return Call.State.DIALING;
            }
            case ALERTING: {
                return Call.State.ALERTING;
            }
            case INCOMING: {
                return Call.State.INCOMING;
            }
            case WAITING: {
                return Call.State.WAITING;
            }
        }
        throw new RuntimeException("illegal call state:" + (Object)((Object)dcState));
    }

    CdmaCall(CdmaCallTracker owner) {
        this.owner = owner;
    }

    public void dispose() {
    }

    @Override
    public List<Connection> getConnections() {
        return this.connections;
    }

    @Override
    public Call.State getState() {
        return this.state;
    }

    @Override
    public Phone getPhone() {
        return this.owner.phone;
    }

    @Override
    public boolean isMultiparty() {
        return this.connections.size() > 1;
    }

    @Override
    public void hangup() throws CallStateException {
        this.owner.hangup(this);
    }

    public String toString() {
        return this.state.toString();
    }

    void attach(Connection conn, DriverCall dc) {
        this.connections.add(conn);
        this.state = CdmaCall.stateFromDCState(dc.state);
    }

    void attachFake(Connection conn, Call.State state) {
        this.connections.add(conn);
        this.state = state;
    }

    void connectionDisconnected(CdmaConnection conn) {
        if (this.state != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.connections.size();
            for (int i = 0; i < s; ++i) {
                if (this.connections.get(i).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.state = Call.State.DISCONNECTED;
            }
        }
    }

    void detach(CdmaConnection conn) {
        this.connections.remove(conn);
        if (this.connections.size() == 0) {
            this.state = Call.State.IDLE;
        }
    }

    boolean update(CdmaConnection conn, DriverCall dc) {
        boolean changed = false;
        Call.State newState = CdmaCall.stateFromDCState(dc.state);
        if (newState != this.state) {
            this.state = newState;
            changed = true;
        }
        return changed;
    }

    boolean isFull() {
        return this.connections.size() == 1;
    }

    void onHangupLocal() {
        int s = this.connections.size();
        for (int i = 0; i < s; ++i) {
            CdmaConnection cn = (CdmaConnection)this.connections.get(i);
            cn.onHangupLocal();
        }
        this.state = Call.State.DISCONNECTING;
    }

    void clearDisconnected() {
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            CdmaConnection cn = (CdmaConnection)this.connections.get(i);
            if (cn.getState() != Call.State.DISCONNECTED) continue;
            this.connections.remove(i);
        }
        if (this.connections.size() == 0) {
            this.state = Call.State.IDLE;
        }
    }
}

