/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.cdma.CDMAPhone;

public class CdmaDataConnection
extends DataConnection {
    private static final String LOG_TAG = "CDMA";

    private CdmaDataConnection(CDMAPhone phone, String name, int id2, RetryManager rm) {
        super(phone, name, id2, rm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CdmaDataConnection makeDataConnection(CDMAPhone phone, int id2, RetryManager rm) {
        Object object = mCountLock;
        synchronized (object) {
        }
        CdmaDataConnection cdmaDc = new CdmaDataConnection(phone, "CdmaDC-" + ++mCount, id2, rm);
        cdmaDc.start();
        cdmaDc.log("Made " + cdmaDc.getName());
        return cdmaDc;
    }

    protected void onConnect(DataConnection.ConnectionParams cp) {
        int dataProfile;
        this.log("CdmaDataConnection Connecting...");
        this.mApn = cp.apn;
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        if (cp.apn != null && cp.apn.types.length > 0 && cp.apn.types[0] != null && cp.apn.types[0].equals("dun")) {
            this.log("CdmaDataConnection using DUN");
            dataProfile = 1;
        } else {
            dataProfile = 0;
        }
        Message msg = this.obtainMessage(262145, cp);
        msg.obj = cp;
        this.phone.mCM.setupDataCall(Integer.toString(this.getRadioTechnology(0)), Integer.toString(dataProfile), null, null, null, Integer.toString(3), "IP", msg);
    }

    public String toString() {
        return "State=" + this.getCurrentState().getName() + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFasilCause=" + (Object)((Object)this.lastFailCause);
    }

    protected boolean isDnsOk(String[] domainNameServers) {
        return !"0.0.0.0".equals(domainNameServers[0]) || !"0.0.0.0".equals(domainNameServers[1]) || this.phone.isDnsCheckDisabled();
    }

    protected void log(String s) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }
}

