/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.gsm.SIMRecords;
import com.android.internal.telephony.ims.IsimRecords;
import com.android.internal.telephony.ims.IsimUiccRecords;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;

public final class CdmaLteUiccRecords
extends SIMRecords {
    private byte[] mEFpl = null;
    private byte[] mEFli = null;
    boolean mCsimSpnDisplayCondition = false;
    private String mMdn;
    private String mMin;
    private String mPrlVersion;
    private String mHomeSystemId;
    private String mHomeNetworkId;
    private final IsimUiccRecords mIsimUiccRecords = new IsimUiccRecords();

    public CdmaLteUiccRecords(PhoneBase p) {
        super(p);
    }

    protected void onRecordLoaded() {
        --this.recordsToLoad;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.recordsToLoad < 0) {
            Log.e("GSM", "SIMRecords: recordsToLoad <0, programmer error suspected");
            this.recordsToLoad = 0;
        }
    }

    protected void onAllRecordsLoaded() {
        this.setLocaleFromCsim();
        super.onAllRecordsLoaded();
    }

    protected void fetchSimRecords() {
        IccFileHandler iccFh = this.phone.getIccFileHandler();
        this.recordsRequested = true;
        this.phone.mCM.getIMSI(this.obtainMessage(3));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28589, this.obtainMessage(9));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded()));
        ++this.recordsToLoad;
        new AdnRecordLoader(this.phone).loadFromEF(28480, 28490, 1, this.obtainMessage(10));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28472, this.obtainMessage(17));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28474, this.obtainMessage(100, new EfCsimLiLoaded()));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28481, this.obtainMessage(100, new EfCsimSpnLoaded()));
        ++this.recordsToLoad;
        iccFh.loadEFLinearFixed(28484, 1, this.obtainMessage(100, new EfCsimMdnLoaded()));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28450, this.obtainMessage(100, new EfCsimImsimLoaded()));
        ++this.recordsToLoad;
        iccFh.loadEFLinearFixedAll(28456, this.obtainMessage(100, new EfCsimCdmaHomeLoaded()));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28506, this.obtainMessage(100, new EfCsimEprlLoaded()));
        ++this.recordsToLoad;
        this.recordsToLoad += this.mIsimUiccRecords.fetchIsimRecords(iccFh, this);
    }

    private int adjstMinDigits(int digits) {
        digits = (digits += 111) % 10 == 0 ? digits - 10 : digits;
        digits = digits / 10 % 10 == 0 ? digits - 100 : digits;
        digits = digits / 100 % 10 == 0 ? digits - 1000 : digits;
        return digits;
    }

    private void onGetCSimEprlDone(AsyncResult ar) {
        byte[] data = (byte[])ar.result;
        this.log("CSIM_EPRL=" + IccUtils.bytesToHexString(data));
        if (data.length > 3) {
            int prlId = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            this.mPrlVersion = Integer.toString(prlId);
        }
        this.log("CSIM PRL version=" + this.mPrlVersion);
    }

    private void setLocaleFromCsim() {
        String prefLang = null;
        prefLang = this.findBestLanguage(this.mEFli);
        if (prefLang == null) {
            prefLang = this.findBestLanguage(this.mEFpl);
        }
        if (prefLang != null) {
            String imsi = this.getIMSI();
            String country = null;
            if (imsi != null) {
                country = MccTable.countryCodeForMcc(Integer.parseInt(imsi.substring(0, 3)));
            }
            this.log("Setting locale to " + prefLang + "_" + country);
            this.phone.setSystemLocale(prefLang, country, false);
        } else {
            this.log("No suitable CSIM selected locale");
        }
    }

    private String findBestLanguage(byte[] languages) {
        Object bestMatch = null;
        String[] locales = this.phone.getContext().getAssets().getLocales();
        if (languages == null || locales == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < languages.length) {
            try {
                String lang = new String(languages, i, 2, "ISO-8859-1");
                for (int j = 0; j < locales.length; ++j) {
                    if (locales[j] == null || locales[j].length() < 2 || !locales[j].substring(0, 2).equals(lang)) continue;
                    return lang;
                }
                if (bestMatch != null) {
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log("Failed to parse SIM language records");
            }
            i += 2;
        }
        return null;
    }

    protected void log(String s) {
        Log.d("GSM", "[CSIM] " + s);
    }

    protected void loge(String s) {
        Log.e("GSM", "[CSIM] " + s);
    }

    public String getMdn() {
        return this.mMdn;
    }

    public String getMin() {
        return this.mMin;
    }

    public String getSid() {
        return this.mHomeSystemId;
    }

    public String getNid() {
        return this.mHomeNetworkId;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    public boolean getCsimSpnDisplayCondition() {
        return this.mCsimSpnDisplayCondition;
    }

    public IsimRecords getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    public boolean isProvisioned() {
        if (SystemProperties.getBoolean("persist.radio.test-csim", false)) {
            return true;
        }
        return !this.phone.mIccCard.isApplicationOnIcc(IccCardApplication.AppType.APPTYPE_CSIM) || this.mMdn != null && this.mMin != null;
    }

    protected int dispatchGsmMessage(SmsMessageBase message) {
        return ((CDMALTEPhone)this.phone).m3gppSMS.dispatchMessage(message);
    }

    static /* synthetic */ byte[] access$002(CdmaLteUiccRecords x0, byte[] x1) {
        x0.mEFpl = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(CdmaLteUiccRecords x0, byte[] x1) {
        x0.mEFli = x1;
        return x1;
    }

    private class EfCsimEprlLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimEprlLoaded() {
        }

        public String getEfName() {
            return "EF_CSIM_EPRL";
        }

        public void onRecordLoaded(AsyncResult ar) {
            CdmaLteUiccRecords.this.onGetCSimEprlDone(ar);
        }
    }

    private class EfCsimCdmaHomeLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimCdmaHomeLoaded() {
        }

        public String getEfName() {
            return "EF_CSIM_CDMAHOME";
        }

        public void onRecordLoaded(AsyncResult ar) {
            ArrayList dataList = (ArrayList)ar.result;
            CdmaLteUiccRecords.this.log("CSIM_CDMAHOME data size=" + dataList.size());
            if (dataList.isEmpty()) {
                return;
            }
            StringBuilder sidBuf = new StringBuilder();
            StringBuilder nidBuf = new StringBuilder();
            for (byte[] data : dataList) {
                if (data.length != 5) continue;
                int sid = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                int nid = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
                sidBuf.append(sid).append(',');
                nidBuf.append(nid).append(',');
            }
            sidBuf.setLength(sidBuf.length() - 1);
            nidBuf.setLength(nidBuf.length() - 1);
            CdmaLteUiccRecords.this.mHomeSystemId = sidBuf.toString();
            CdmaLteUiccRecords.this.mHomeNetworkId = nidBuf.toString();
        }
    }

    private class EfCsimImsimLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimImsimLoaded() {
        }

        public String getEfName() {
            return "EF_CSIM_IMSIM";
        }

        public void onRecordLoaded(AsyncResult ar) {
            boolean provisioned;
            byte[] data = (byte[])ar.result;
            CdmaLteUiccRecords.this.log("CSIM_IMSIM=" + IccUtils.bytesToHexString(data));
            boolean bl = provisioned = (data[7] & 0x80) == 128;
            if (provisioned) {
                int first3digits = ((3 & data[2]) << 8) + (0xFF & data[1]);
                int second3digits = ((0xFF & data[5]) << 8 | 0xFF & data[4]) >> 6;
                int digit7 = 0xF & data[4] >> 2;
                if (digit7 > 9) {
                    digit7 = 0;
                }
                int last3digits = (3 & data[4]) << 8 | 0xFF & data[3];
                first3digits = CdmaLteUiccRecords.this.adjstMinDigits(first3digits);
                second3digits = CdmaLteUiccRecords.this.adjstMinDigits(second3digits);
                last3digits = CdmaLteUiccRecords.this.adjstMinDigits(last3digits);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(Locale.US, "%03d", first3digits));
                builder.append(String.format(Locale.US, "%03d", second3digits));
                builder.append(String.format(Locale.US, "%d", digit7));
                builder.append(String.format(Locale.US, "%03d", last3digits));
                CdmaLteUiccRecords.this.mMin = builder.toString();
                CdmaLteUiccRecords.this.log("min present=" + CdmaLteUiccRecords.this.mMin);
            } else {
                CdmaLteUiccRecords.this.log("min not present");
            }
        }
    }

    private class EfCsimMdnLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimMdnLoaded() {
        }

        public String getEfName() {
            return "EF_CSIM_MDN";
        }

        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            CdmaLteUiccRecords.this.log("CSIM_MDN=" + IccUtils.bytesToHexString(data));
            int mdnDigitsNum = 0xF & data[0];
            CdmaLteUiccRecords.this.mMdn = IccUtils.cdmaBcdToString(data, 1, mdnDigitsNum);
            CdmaLteUiccRecords.this.log("CSIM MDN=" + CdmaLteUiccRecords.this.mMdn);
        }
    }

    private class EfCsimSpnLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimSpnLoaded() {
        }

        public String getEfName() {
            return "EF_CSIM_SPN";
        }

        public void onRecordLoaded(AsyncResult ar) {
            int numBytes;
            byte[] data = (byte[])ar.result;
            CdmaLteUiccRecords.this.log("CSIM_SPN=" + IccUtils.bytesToHexString(data));
            CdmaLteUiccRecords.this.mCsimSpnDisplayCondition = (1 & data[0]) != 0;
            byte encoding = data[1];
            byte language = data[2];
            byte[] spnData = new byte[32];
            System.arraycopy(data, 3, spnData, 0, data.length < 32 ? data.length : 32);
            for (numBytes = 0; numBytes < spnData.length && (spnData[numBytes] & 0xFF) != 255; ++numBytes) {
            }
            if (numBytes == 0) {
                CdmaLteUiccRecords.this.spn = "";
                return;
            }
            try {
                switch (encoding) {
                    case 0: 
                    case 8: {
                        CdmaLteUiccRecords.this.spn = new String(spnData, 0, numBytes, "ISO-8859-1");
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 9: {
                        CdmaLteUiccRecords.this.spn = GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7);
                        break;
                    }
                    case 4: {
                        CdmaLteUiccRecords.this.spn = new String(spnData, 0, numBytes, "utf-16");
                        break;
                    }
                    default: {
                        CdmaLteUiccRecords.this.log("SPN encoding not supported");
                        break;
                    }
                }
            }
            catch (Exception e) {
                CdmaLteUiccRecords.this.log("spn decode error: " + e);
            }
            CdmaLteUiccRecords.this.log("spn=" + CdmaLteUiccRecords.this.spn);
            CdmaLteUiccRecords.this.log("spnCondition=" + CdmaLteUiccRecords.this.mCsimSpnDisplayCondition);
            CdmaLteUiccRecords.this.phone.setSystemProperty("gsm.sim.operator.alpha", CdmaLteUiccRecords.this.spn);
        }
    }

    private class EfCsimLiLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimLiLoaded() {
        }

        public String getEfName() {
            return "EF_CSIM_LI";
        }

        public void onRecordLoaded(AsyncResult ar) {
            CdmaLteUiccRecords.access$102(CdmaLteUiccRecords.this, (byte[])ar.result);
            block9: for (int i = 0; i < CdmaLteUiccRecords.this.mEFli.length; i += 2) {
                switch (CdmaLteUiccRecords.this.mEFli[i + 1]) {
                    case 1: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 101;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 110;
                        continue block9;
                    }
                    case 2: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 102;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 114;
                        continue block9;
                    }
                    case 3: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 101;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 115;
                        continue block9;
                    }
                    case 4: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 106;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 97;
                        continue block9;
                    }
                    case 5: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 107;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 111;
                        continue block9;
                    }
                    case 6: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 122;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 104;
                        continue block9;
                    }
                    case 7: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 104;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 101;
                        continue block9;
                    }
                    default: {
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i] = 32;
                        ((CdmaLteUiccRecords)CdmaLteUiccRecords.this).mEFli[i + 1] = 32;
                    }
                }
            }
            CdmaLteUiccRecords.this.log("EF_LI=" + IccUtils.bytesToHexString(CdmaLteUiccRecords.this.mEFli));
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded {
        private EfPlLoaded() {
        }

        public String getEfName() {
            return "EF_PL";
        }

        public void onRecordLoaded(AsyncResult ar) {
            CdmaLteUiccRecords.access$002(CdmaLteUiccRecords.this, (byte[])ar.result);
            CdmaLteUiccRecords.this.log("EF_PL=" + IccUtils.bytesToHexString(CdmaLteUiccRecords.this.mEFpl));
        }
    }
}

