/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import java.util.Arrays;
import java.util.HashMap;

final class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CDMA";
    private byte[] mLastDispatchedSmsFingerprint;
    private byte[] mLastAcknowledgedSmsFingerprint;
    private final boolean mCheckForDuplicatePortsInOmadmWapPush = Resources.getSystem().getBoolean(17891373);

    CdmaSMSDispatcher(CDMAPhone phone, SmsStorageMonitor storageMonitor, SmsUsageMonitor usageMonitor) {
        super(phone, storageMonitor, usageMonitor);
        this.mCm.setOnNewCdmaSms(this, 1, null);
    }

    public void dispose() {
        this.mCm.unSetOnNewCdmaSms(this);
    }

    protected String getFormat() {
        return "3gpp2";
    }

    private void handleCdmaStatusReport(SmsMessage sms) {
        int count = this.deliveryPendingList.size();
        for (int i = 0; i < count; ++i) {
            SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
            if (tracker.mMessageRef != sms.messageRef) continue;
            this.deliveryPendingList.remove(i);
            PendingIntent intent = tracker.mDeliveryIntent;
            Intent fillIn = new Intent();
            fillIn.putExtra("pdu", sms.getPdu());
            fillIn.putExtra("format", "3gpp2");
            try {
                intent.send(this.mContext, -1, fillIn);
            }
            catch (PendingIntent.CanceledException ex) {}
            break;
        }
    }

    public int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            Log.e(TAG, "dispatchMessage: message is null");
            return 2;
        }
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        if (inEcm.equals("true")) {
            return -1;
        }
        if (this.mSmsReceiveDisabled) {
            Log.d(TAG, "Received short message on device which doesn't support receiving SMS. Ignored.");
            return 1;
        }
        SmsMessage sms = (SmsMessage)smsb;
        this.mLastDispatchedSmsFingerprint = sms.getIncomingSmsFingerprint();
        if (this.mLastAcknowledgedSmsFingerprint != null && Arrays.equals(this.mLastDispatchedSmsFingerprint, this.mLastAcknowledgedSmsFingerprint)) {
            return 1;
        }
        sms.parseSms();
        int teleService = sms.getTeleService();
        boolean handled = false;
        if (4099 == teleService || 262144 == teleService) {
            int voicemailCount = sms.getNumOfVoicemails();
            Log.d(TAG, "Voicemail count=" + voicemailCount);
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            SharedPreferences.Editor editor = sp.edit();
            editor.putInt("vm_count_key_cdma", voicemailCount);
            editor.apply();
            this.mPhone.setVoiceMessageWaiting(1, voicemailCount);
            handled = true;
        } else if ((4098 == teleService || 4101 == teleService) && sms.isStatusReportMessage()) {
            this.handleCdmaStatusReport(sms);
            handled = true;
        } else if (sms.getUserData() == null) {
            handled = true;
        }
        if (handled) {
            return 1;
        }
        if (!this.mStorageMonitor.isStorageAvailable() && sms.getMessageClass() != SmsMessage.MessageClass.CLASS_0) {
            return 3;
        }
        if (4100 == teleService) {
            return this.processCdmaWapPdu(sms.getUserData(), sms.messageRef, sms.getOriginatingAddress());
        }
        if (4098 != teleService && 4101 != teleService && 1 != sms.getMessageType()) {
            return 4;
        }
        return this.dispatchNormalMessage(smsb);
    }

    protected int processCdmaWapPdu(byte[] pdu, int referenceNumber, String address) {
        int totalSegments;
        int segment;
        int msgType;
        int index = 0;
        if ((msgType = 0xFF & pdu[index++]) != 0) {
            Log.w(TAG, "Received a WAP SMS which is not WDP. Discard.");
            return 1;
        }
        if ((segment = 0xFF & pdu[index++]) >= (totalSegments = 0xFF & pdu[index++])) {
            Log.e(TAG, "WDP bad segment #" + segment + " expecting 0-" + (totalSegments - 1));
            return 1;
        }
        int sourcePort = 0;
        int destinationPort = 0;
        if (segment == 0) {
            sourcePort = (0xFF & pdu[index++]) << 8;
            sourcePort |= 0xFF & pdu[index++];
            destinationPort = (0xFF & pdu[index++]) << 8;
            destinationPort |= 0xFF & pdu[index++];
            if (this.mCheckForDuplicatePortsInOmadmWapPush && CdmaSMSDispatcher.checkDuplicatePortOmadmWappush(pdu, index)) {
                index += 4;
            }
        }
        Log.i(TAG, "Received WAP PDU. Type = " + msgType + ", originator = " + address + ", src-port = " + sourcePort + ", dst-port = " + destinationPort + ", ID = " + referenceNumber + ", segment# = " + segment + '/' + totalSegments);
        byte[] userData = new byte[pdu.length - index];
        System.arraycopy(pdu, index, userData, 0, pdu.length - index);
        return this.processMessagePart(userData, address, referenceNumber, segment, totalSegments, 0L, destinationPort, true);
    }

    protected void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        this.sendSubmitPdu(pdu, sentIntent, deliveryIntent);
    }

    protected void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null, null);
        this.sendSubmitPdu(pdu, sentIntent, deliveryIntent);
    }

    protected SmsMessageBase.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(messageBody, use7bitOnly);
    }

    protected void sendNewSubmitPdu(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart) {
        UserData uData = new UserData();
        uData.payloadStr = message;
        uData.userDataHeader = smsHeader;
        uData.msgEncoding = encoding == 1 ? 9 : 4;
        uData.msgEncodingSet = true;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(destinationAddress, uData, deliveryIntent != null && lastPart);
        this.sendSubmitPdu(submitPdu, sentIntent, deliveryIntent);
    }

    protected void sendSubmitPdu(SmsMessage.SubmitPdu pdu, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (SystemProperties.getBoolean("ril.cdma.inecmmode", false)) {
            if (sentIntent != null) {
                try {
                    sentIntent.send(4);
                }
                catch (PendingIntent.CanceledException ex) {
                    // empty catch block
                }
            }
            return;
        }
        this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
    }

    protected void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        this.mCm.sendCdmaSms(pdu, reply);
    }

    protected void acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        if (inEcm.equals("true")) {
            return;
        }
        int causeCode = CdmaSMSDispatcher.resultToCause(result);
        this.mCm.acknowledgeLastIncomingCdmaSms(success, causeCode, response);
        if (causeCode == 0) {
            this.mLastAcknowledgedSmsFingerprint = this.mLastDispatchedSmsFingerprint;
        }
        this.mLastDispatchedSmsFingerprint = null;
    }

    private static int resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 35;
            }
            case 4: {
                return 4;
            }
        }
        return 96;
    }

    private static boolean checkDuplicatePortOmadmWappush(byte[] origPdu, int index) {
        byte[] omaPdu = new byte[origPdu.length - (index += 4)];
        System.arraycopy(origPdu, index, omaPdu, 0, omaPdu.length);
        WspTypeDecoder pduDecoder = new WspTypeDecoder(omaPdu);
        int wspIndex = 2;
        if (!pduDecoder.decodeUintvarInteger(wspIndex)) {
            return false;
        }
        if (!pduDecoder.decodeContentType(wspIndex += pduDecoder.getDecodedDataLength())) {
            return false;
        }
        String mimeType = pduDecoder.getValueString();
        return mimeType != null && mimeType.equals("application/vnd.syncml.notification");
    }
}

