/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Message;
import android.util.Log;
import android.util.Patterns;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;

public class GsmDataConnection
extends DataConnection {
    private static final String LOG_TAG = "GSM";
    protected int mProfileId = 0;
    protected String mActiveApnType = "default";

    private GsmDataConnection(PhoneBase phone, String name, int id2, RetryManager rm) {
        super(phone, name, id2, rm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GsmDataConnection makeDataConnection(PhoneBase phone, int id2, RetryManager rm) {
        Object object = mCountLock;
        synchronized (object) {
        }
        GsmDataConnection gsmDc = new GsmDataConnection(phone, "GsmDC-" + ++mCount, id2, rm);
        gsmDc.start();
        gsmDc.log("Made " + gsmDc.getName());
        return gsmDc;
    }

    protected void onConnect(DataConnection.ConnectionParams cp) {
        this.mApn = cp.apn;
        this.log("Connecting to carrier: '" + this.mApn.carrier + "' APN: '" + this.mApn.apn + "' proxy: '" + this.mApn.proxy + "' port: '" + this.mApn.port);
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        Message msg = this.obtainMessage(262145, cp);
        msg.obj = cp;
        int authType = this.mApn.authType;
        if (authType == -1) {
            authType = this.mApn.user != null ? 3 : 0;
        }
        String protocol = this.phone.getServiceState().getRoaming() ? this.mApn.roamingProtocol : this.mApn.protocol;
        this.phone.mCM.setupDataCall(Integer.toString(this.getRadioTechnology(1)), Integer.toString(this.mProfileId), this.mApn.apn, this.mApn.user, this.mApn.password, Integer.toString(authType), protocol, msg);
    }

    public void setProfileId(int profileId) {
        this.mProfileId = profileId;
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public void setActiveApnType(String apnType) {
        this.mActiveApnType = apnType;
    }

    public String toString() {
        return "State=" + this.getCurrentState().getName() + " Apn=" + this.mApn + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFailCause=" + (Object)((Object)this.lastFailCause);
    }

    protected boolean isDnsOk(String[] domainNameServers) {
        if (!(!"0.0.0.0".equals(domainNameServers[0]) || !"0.0.0.0".equals(domainNameServers[1]) || this.phone.isDnsCheckDisabled() || this.mApn.types[0].equals("mms") && this.isIpAddress(this.mApn.mmsProxy))) {
            this.log(String.format("isDnsOk: return false apn.types[0]=%s APN_TYPE_MMS=%s isIpAddress(%s)=%s", this.mApn.types[0], "mms", this.mApn.mmsProxy, this.isIpAddress(this.mApn.mmsProxy)));
            return false;
        }
        return true;
    }

    protected void log(String s) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }

    private boolean isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return Patterns.IP_ADDRESS.matcher(address).matches();
    }
}

