/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.telephony.gsm.GsmCellLocation;
import android.util.Log;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.gsm.SmsCbHeader;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.gsm.UsimDataDownloadHandler;
import com.android.internal.telephony.gsm.UsimServiceTable;
import java.util.HashMap;
import java.util.Iterator;

public final class GsmSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "GSM";
    private static final int EVENT_NEW_SMS_STATUS_REPORT = 100;
    private static final int EVENT_NEW_BROADCAST_SMS = 101;
    private static final int EVENT_WRITE_SMS_COMPLETE = 102;
    private final UsimDataDownloadHandler mDataDownloadHandler;
    private final HashMap<SmsCbConcatInfo, byte[][]> mSmsCbPageMap = new HashMap();

    public GsmSMSDispatcher(PhoneBase phone, SmsStorageMonitor storageMonitor, SmsUsageMonitor usageMonitor) {
        super(phone, storageMonitor, usageMonitor);
        this.mDataDownloadHandler = new UsimDataDownloadHandler(this.mCm);
        this.mCm.setOnNewGsmSms(this, 1, null);
        this.mCm.setOnSmsStatus(this, 100, null);
        this.mCm.setOnNewGsmBroadcastSms(this, 101, null);
    }

    public void dispose() {
        this.mCm.unSetOnNewGsmSms(this);
        this.mCm.unSetOnSmsStatus(this);
        this.mCm.unSetOnNewGsmBroadcastSms(this);
    }

    protected String getFormat() {
        return "3gpp";
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.handleStatusReport((AsyncResult)msg.obj);
                break;
            }
            case 101: {
                this.handleBroadcastSms((AsyncResult)msg.obj);
                break;
            }
            case 102: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    Log.d(TAG, "Successfully wrote SMS-PP message to UICC");
                    this.mCm.acknowledgeLastIncomingGsmSms(true, 0, null);
                    break;
                }
                Log.d(TAG, "Failed to write SMS-PP message to UICC", ar.exception);
                this.mCm.acknowledgeLastIncomingGsmSms(false, 255, null);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private void handleStatusReport(AsyncResult ar) {
        String pduString = (String)ar.result;
        SmsMessage sms = SmsMessage.newFromCDS(pduString);
        if (sms != null) {
            int tpStatus = sms.getStatus();
            int messageRef = sms.messageRef;
            int count = this.deliveryPendingList.size();
            for (int i = 0; i < count; ++i) {
                SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (tracker.mMessageRef != messageRef) continue;
                if (tpStatus >= 64 || tpStatus < 32) {
                    this.deliveryPendingList.remove(i);
                }
                PendingIntent intent = tracker.mDeliveryIntent;
                Intent fillIn = new Intent();
                fillIn.putExtra("pdu", IccUtils.hexStringToBytes(pduString));
                fillIn.putExtra("format", "3gpp");
                try {
                    intent.send(this.mContext, -1, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {}
                break;
            }
        }
        this.acknowledgeLastIncomingSms(true, 1, null);
    }

    public int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            Log.e(TAG, "dispatchMessage: message is null");
            return 2;
        }
        SmsMessage sms = (SmsMessage)smsb;
        if (sms.isTypeZero()) {
            Log.d(TAG, "Received short message type 0, Don't display or store it. Send Ack");
            return 1;
        }
        if (sms.isUsimDataDownload()) {
            UsimServiceTable ust = this.mPhone.getUsimServiceTable();
            if (ust != null && ust.isAvailable(UsimServiceTable.UsimService.DATA_DL_VIA_SMS_PP)) {
                Log.d(TAG, "Received SMS-PP data download, sending to UICC.");
                return this.mDataDownloadHandler.startDataDownload(sms);
            }
            Log.d(TAG, "DATA_DL_VIA_SMS_PP service not available, storing message to UICC.");
            String smsc = IccUtils.bytesToHexString(PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(sms.getServiceCenterAddress()));
            this.mCm.writeSmsToSim(3, smsc, IccUtils.bytesToHexString(sms.getPdu()), this.obtainMessage(102));
            return -1;
        }
        if (this.mSmsReceiveDisabled) {
            Log.d(TAG, "Received short message on device which doesn't support SMS service. Ignored.");
            return 1;
        }
        boolean handled = false;
        if (sms.isMWISetMessage()) {
            this.mPhone.setVoiceMessageWaiting(1, -1);
            handled = sms.isMwiDontStore();
        } else if (sms.isMWIClearMessage()) {
            this.mPhone.setVoiceMessageWaiting(1, 0);
            handled = sms.isMwiDontStore();
        }
        if (handled) {
            return 1;
        }
        if (!this.mStorageMonitor.isStorageAvailable() && sms.getMessageClass() != SmsMessage.MessageClass.CLASS_0) {
            return 3;
        }
        return this.dispatchNormalMessage(smsb);
    }

    protected void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        if (pdu != null) {
            this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
        } else {
            Log.e(TAG, "GsmSMSDispatcher.sendData(): getSubmitPdu() returned null");
        }
    }

    protected void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null);
        if (pdu != null) {
            this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
        } else {
            Log.e(TAG, "GsmSMSDispatcher.sendText(): getSubmitPdu() returned null");
        }
    }

    protected SmsMessageBase.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(messageBody, use7bitOnly);
    }

    protected void sendNewSubmitPdu(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, deliveryIntent != null, SmsHeader.toByteArray(smsHeader), encoding, smsHeader.languageTable, smsHeader.languageShiftTable);
        if (pdu != null) {
            this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
        } else {
            Log.e(TAG, "GsmSMSDispatcher.sendNewSubmitPdu(): getSubmitPdu() returned null");
        }
    }

    protected void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        byte[] smsc = (byte[])map.get("smsc");
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        this.mCm.sendSMS(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
    }

    protected void acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        this.mCm.acknowledgeLastIncomingGsmSms(success, GsmSMSDispatcher.resultToCause(result), response);
    }

    private static int resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 211;
            }
        }
        return 255;
    }

    private void handleBroadcastSms(AsyncResult ar) {
        try {
            Object pdus;
            byte[] receivedPdu = (byte[])ar.result;
            SmsCbHeader header = new SmsCbHeader(receivedPdu);
            String plmn = SystemProperties.get("gsm.operator.numeric");
            GsmCellLocation cellLocation = (GsmCellLocation)this.mPhone.getCellLocation();
            int lac = cellLocation.getLac();
            int cid = cellLocation.getCid();
            if (header.nrOfPages > 1) {
                SmsCbConcatInfo concatInfo = new SmsCbConcatInfo(header, plmn, lac, cid);
                pdus = this.mSmsCbPageMap.get(concatInfo);
                if (pdus == null) {
                    pdus = new byte[header.nrOfPages][];
                    this.mSmsCbPageMap.put(concatInfo, (byte[][])pdus);
                }
                pdus[header.pageIndex - 1] = receivedPdu;
                for (int i = 0; i < ((byte[][])pdus).length; ++i) {
                    if (pdus[i] != null) continue;
                    return;
                }
                this.mSmsCbPageMap.remove(concatInfo);
            } else {
                pdus = new byte[][]{receivedPdu};
            }
            boolean isEmergencyMessage = SmsCbHeader.isEmergencyMessage(header.messageIdentifier);
            this.dispatchBroadcastPdus((byte[][])pdus, isEmergencyMessage);
            Iterator<SmsCbConcatInfo> iter = this.mSmsCbPageMap.keySet().iterator();
            while (iter.hasNext()) {
                SmsCbConcatInfo info = iter.next();
                if (info.matchesLocation(plmn, lac, cid)) continue;
                iter.remove();
            }
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error in decoding SMS CB pdu", e);
        }
    }

    private static final class SmsCbConcatInfo {
        private final SmsCbHeader mHeader;
        private final String mPlmn;
        private final int mLac;
        private final int mCid;

        public SmsCbConcatInfo(SmsCbHeader header, String plmn, int lac, int cid) {
            this.mHeader = header;
            this.mPlmn = plmn;
            this.mLac = lac;
            this.mCid = cid;
        }

        public int hashCode() {
            return this.mHeader.messageIdentifier * 31 + this.mHeader.updateNumber;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SmsCbConcatInfo) {
                SmsCbConcatInfo other = (SmsCbConcatInfo)obj;
                if (this.mHeader.geographicalScope == other.mHeader.geographicalScope && this.mHeader.messageCode == other.mHeader.messageCode && this.mHeader.updateNumber == other.mHeader.updateNumber && this.mHeader.messageIdentifier == other.mHeader.messageIdentifier && this.mHeader.dataCodingScheme == other.mHeader.dataCodingScheme && this.mHeader.nrOfPages == other.mHeader.nrOfPages) {
                    return this.matchesLocation(other.mPlmn, other.mLac, other.mCid);
                }
            }
            return false;
        }

        public boolean matchesLocation(String plmn, int lac, int cid) {
            switch (this.mHeader.geographicalScope) {
                case 0: 
                case 3: {
                    if (this.mCid != cid) {
                        return false;
                    }
                }
                case 2: {
                    if (this.mLac != lac) {
                        return false;
                    }
                }
                case 1: {
                    return this.mPlmn != null && this.mPlmn.equals(plmn);
                }
            }
            return false;
        }
    }
}

