/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.os.AsyncResult;
import android.os.Handler;
import android.util.Log;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.ims.IsimRecords;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class IsimUiccRecords
implements IsimRecords {
    protected static final String LOG_TAG = "GSM";
    private static final boolean DBG = true;
    private static final boolean DUMP_RECORDS = false;
    private String mIsimImpi;
    private String mIsimDomain;
    private String[] mIsimImpu;
    private static final int TAG_ISIM_VALUE = 128;

    public int fetchIsimRecords(IccFileHandler iccFh, Handler h) {
        iccFh.loadEFTransparent(28418, h.obtainMessage(100, new EfIsimImpiLoaded()));
        iccFh.loadEFLinearFixedAll(28420, h.obtainMessage(100, new EfIsimImpuLoaded()));
        iccFh.loadEFTransparent(28419, h.obtainMessage(100, new EfIsimDomainLoaded()));
        return 3;
    }

    private static String isimTlvToString(byte[] record) {
        SimTlv tlv = new SimTlv(record, 0, record.length);
        do {
            if (tlv.getTag() != 128) continue;
            return new String(tlv.getData(), Charset.forName("UTF-8"));
        } while (tlv.nextObject());
        Log.e(LOG_TAG, "[ISIM] can't find TLV tag in ISIM record, returning null");
        return null;
    }

    void log(String s) {
        Log.d(LOG_TAG, "[ISIM] " + s);
    }

    void loge(String s) {
        Log.e(LOG_TAG, "[ISIM] " + s);
    }

    public String getIsimImpi() {
        return this.mIsimImpi;
    }

    public String getIsimDomain() {
        return this.mIsimDomain;
    }

    public String[] getIsimImpu() {
        return this.mIsimImpu != null ? (String[])this.mIsimImpu.clone() : null;
    }

    static /* synthetic */ String[] access$202(IsimUiccRecords x0, String[] x1) {
        x0.mIsimImpu = x1;
        return x1;
    }

    private class EfIsimDomainLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimDomainLoaded() {
        }

        public String getEfName() {
            return "EF_ISIM_DOMAIN";
        }

        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimDomain = IsimUiccRecords.isimTlvToString(data);
        }
    }

    private class EfIsimImpuLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimImpuLoaded() {
        }

        public String getEfName() {
            return "EF_ISIM_IMPU";
        }

        public void onRecordLoaded(AsyncResult ar) {
            ArrayList impuList = (ArrayList)ar.result;
            IsimUiccRecords.this.log("EF_IMPU record count: " + impuList.size());
            IsimUiccRecords.access$202(IsimUiccRecords.this, new String[impuList.size()]);
            int i = 0;
            for (byte[] identity : impuList) {
                String impu = IsimUiccRecords.isimTlvToString(identity);
                ((IsimUiccRecords)IsimUiccRecords.this).mIsimImpu[i++] = impu;
            }
        }
    }

    private class EfIsimImpiLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimImpiLoaded() {
        }

        public String getEfName() {
            return "EF_ISIM_IMPI";
        }

        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimImpi = IsimUiccRecords.isimTlvToString(data);
        }
    }
}

