/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.sip.ISipService;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSessionAdapter;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.server.sip.SipSessionGroup;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import com.android.server.sip.SipWakeupTimer;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.sip.SipException;

public final class SipService
extends ISipService.Stub {
    static final String TAG = "SipService";
    static final boolean DEBUG = false;
    private static final int EXPIRY_TIME = 3600;
    private static final int SHORT_EXPIRY_TIME = 10;
    private static final int MIN_EXPIRY_TIME = 60;
    private static final int DEFAULT_KEEPALIVE_INTERVAL = 10;
    private static final int DEFAULT_MAX_KEEPALIVE_INTERVAL = 120;
    private Context mContext;
    private String mLocalIp;
    private String mNetworkType;
    private boolean mConnected;
    private SipWakeupTimer mTimer;
    private WifiManager.WifiLock mWifiLock;
    private boolean mSipOnWifiOnly;
    private IntervalMeasurementProcess mIntervalMeasurementProcess;
    private MyExecutor mExecutor = new MyExecutor();
    private Map<String, SipSessionGroupExt> mSipGroups = new HashMap<String, SipSessionGroupExt>();
    private Map<String, ISipSession> mPendingSessions = new HashMap<String, ISipSession>();
    private ConnectivityReceiver mConnectivityReceiver;
    private SipWakeLock mMyWakeLock;
    private int mKeepAliveInterval;
    private int mLastGoodKeepAliveInterval = 10;

    public static void start(Context context) {
        if (SipManager.isApiSupported(context)) {
            ServiceManager.addService("sip", new SipService(context));
            context.sendBroadcast(new Intent("android.net.sip.SIP_SERVICE_UP"));
        }
    }

    private SipService(Context context) {
        this.mContext = context;
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.mWifiLock = ((WifiManager)context.getSystemService("wifi")).createWifiLock(1, TAG);
        this.mWifiLock.setReferenceCounted(false);
        this.mSipOnWifiOnly = SipManager.isSipWifiOnly(context);
        this.mMyWakeLock = new SipWakeLock((PowerManager)context.getSystemService("power"));
        this.mTimer = new SipWakeupTimer(context, this.mExecutor);
    }

    public synchronized SipProfile[] getListOfProfiles() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        boolean isCallerRadio = this.isCallerRadio();
        ArrayList<SipProfile> profiles = new ArrayList<SipProfile>();
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (!isCallerRadio && !this.isCallerCreator(group)) continue;
            profiles.add(group.getLocalProfile());
        }
        return profiles.toArray(new SipProfile[profiles.size()]);
    }

    public synchronized void open(SipProfile localProfile) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        try {
            boolean addingFirstProfile = this.mSipGroups.isEmpty();
            this.createGroup(localProfile);
            if (addingFirstProfile && !this.mSipGroups.isEmpty()) {
                this.registerReceivers();
            }
        }
        catch (SipException e) {
            Log.e(TAG, "openToMakeCalls()", e);
        }
    }

    public synchronized void open3(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        if (incomingCallPendingIntent == null) {
            Log.w(TAG, "incomingCallPendingIntent cannot be null; the profile is not opened");
            return;
        }
        try {
            boolean addingFirstProfile = this.mSipGroups.isEmpty();
            SipSessionGroupExt group = this.createGroup(localProfile, incomingCallPendingIntent, listener);
            if (addingFirstProfile && !this.mSipGroups.isEmpty()) {
                this.registerReceivers();
            }
            if (localProfile.getAutoRegistration()) {
                group.openToReceiveCalls();
            }
        }
        catch (SipException e) {
            Log.e(TAG, "openToReceiveCalls()", e);
        }
    }

    private boolean isCallerCreator(SipSessionGroupExt group) {
        SipProfile profile = group.getLocalProfile();
        return profile.getCallingUid() == Binder.getCallingUid();
    }

    private boolean isCallerCreatorOrRadio(SipSessionGroupExt group) {
        return this.isCallerRadio() || this.isCallerCreator(group);
    }

    private boolean isCallerRadio() {
        return Binder.getCallingUid() == 1001;
    }

    public synchronized void close(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return;
        }
        if (!this.isCallerCreatorOrRadio(group)) {
            Log.w(TAG, "only creator or radio can close this profile");
            return;
        }
        group = this.mSipGroups.remove(localProfileUri);
        this.notifyProfileRemoved(group.getLocalProfile());
        group.close();
        if (!this.anyOpenedToReceiveCalls()) {
            this.unregisterReceivers();
            this.mMyWakeLock.reset();
        }
    }

    public synchronized boolean isOpened(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return false;
        }
        if (this.isCallerCreatorOrRadio(group)) {
            return true;
        }
        Log.w(TAG, "only creator or radio can query on the profile");
        return false;
    }

    public synchronized boolean isRegistered(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return false;
        }
        if (this.isCallerCreatorOrRadio(group)) {
            return group.isRegistered();
        }
        Log.w(TAG, "only creator or radio can query on the profile");
        return false;
    }

    public synchronized void setRegistrationListener(String localProfileUri, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return;
        }
        if (this.isCallerCreator(group)) {
            group.setListener(listener);
        } else {
            Log.w(TAG, "only creator can set listener on the profile");
        }
    }

    public synchronized ISipSession createSession(SipProfile localProfile, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        if (!this.mConnected) {
            return null;
        }
        try {
            SipSessionGroupExt group = this.createGroup(localProfile);
            return group.createSession(listener);
        }
        catch (SipException e) {
            return null;
        }
    }

    public synchronized ISipSession getPendingSession(String callId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        if (callId == null) {
            return null;
        }
        return this.mPendingSessions.get(callId);
    }

    private String determineLocalIp() {
        try {
            DatagramSocket s = new DatagramSocket();
            s.connect(InetAddress.getByName("192.168.1.1"), 80);
            return s.getLocalAddress().getHostAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    private SipSessionGroupExt createGroup(SipProfile localProfile) throws SipException {
        String key = localProfile.getUriString();
        SipSessionGroupExt group = this.mSipGroups.get(key);
        if (group == null) {
            group = new SipSessionGroupExt(localProfile, null, null);
            this.mSipGroups.put(key, group);
            this.notifyProfileAdded(localProfile);
        } else if (!this.isCallerCreator(group)) {
            throw new SipException("only creator can access the profile");
        }
        return group;
    }

    private SipSessionGroupExt createGroup(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws SipException {
        String key = localProfile.getUriString();
        SipSessionGroupExt group = this.mSipGroups.get(key);
        if (group != null) {
            if (!this.isCallerCreator(group)) {
                throw new SipException("only creator can access the profile");
            }
            group.setIncomingCallPendingIntent(incomingCallPendingIntent);
            group.setListener(listener);
        } else {
            group = new SipSessionGroupExt(localProfile, incomingCallPendingIntent, listener);
            this.mSipGroups.put(key, group);
            this.notifyProfileAdded(localProfile);
        }
        return group;
    }

    private void notifyProfileAdded(SipProfile localProfile) {
        Intent intent = new Intent("com.android.phone.SIP_ADD_PHONE");
        intent.putExtra("android:localSipUri", localProfile.getUriString());
        this.mContext.sendBroadcast(intent);
    }

    private void notifyProfileRemoved(SipProfile localProfile) {
        Intent intent = new Intent("com.android.phone.SIP_REMOVE_PHONE");
        intent.putExtra("android:localSipUri", localProfile.getUriString());
        this.mContext.sendBroadcast(intent);
    }

    private boolean anyOpenedToReceiveCalls() {
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (!group.isOpenedToReceiveCalls()) continue;
            return true;
        }
        return false;
    }

    private void stopPortMappingMeasurement() {
        if (this.mIntervalMeasurementProcess != null) {
            this.mIntervalMeasurementProcess.stop();
            this.mIntervalMeasurementProcess = null;
        }
    }

    private void startPortMappingLifetimeMeasurement(SipProfile localProfile) {
        this.startPortMappingLifetimeMeasurement(localProfile, 120);
    }

    private void startPortMappingLifetimeMeasurement(SipProfile localProfile, int maxInterval) {
        if (this.mIntervalMeasurementProcess == null && this.mKeepAliveInterval == -1 && this.isBehindNAT(this.mLocalIp)) {
            Log.d(TAG, "start NAT port mapping timeout measurement on " + localProfile.getUriString());
            int minInterval = this.mLastGoodKeepAliveInterval;
            if (minInterval >= maxInterval) {
                this.mLastGoodKeepAliveInterval = 10;
                minInterval = 10;
                Log.d(TAG, "  reset min interval to " + minInterval);
            }
            this.mIntervalMeasurementProcess = new IntervalMeasurementProcess(localProfile, minInterval, maxInterval);
            this.mIntervalMeasurementProcess.start();
        }
    }

    private void restartPortMappingLifetimeMeasurement(SipProfile localProfile, int maxInterval) {
        this.stopPortMappingMeasurement();
        this.mKeepAliveInterval = -1;
        this.startPortMappingLifetimeMeasurement(localProfile, maxInterval);
    }

    private synchronized void addPendingSession(ISipSession session) {
        try {
            this.cleanUpPendingSessions();
            this.mPendingSessions.put(session.getCallId(), session);
        }
        catch (RemoteException e) {
            Log.e(TAG, "addPendingSession()", e);
        }
    }

    private void cleanUpPendingSessions() throws RemoteException {
        Map.Entry[] entries;
        for (Map.Entry entry : entries = this.mPendingSessions.entrySet().toArray(new Map.Entry[this.mPendingSessions.size()])) {
            if (((ISipSession)entry.getValue()).getState() == 3) continue;
            this.mPendingSessions.remove(entry.getKey());
        }
    }

    private synchronized boolean callingSelf(SipSessionGroupExt ringingGroup, SipSessionGroup.SipSessionImpl ringingSession) {
        String callId = ringingSession.getCallId();
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (group == ringingGroup || !group.containsSession(callId)) continue;
            return true;
        }
        return false;
    }

    private synchronized void onKeepAliveIntervalChanged() {
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            group.onKeepAliveIntervalChanged();
        }
    }

    private int getKeepAliveInterval() {
        return this.mKeepAliveInterval < 0 ? this.mLastGoodKeepAliveInterval : this.mKeepAliveInterval;
    }

    private boolean isBehindNAT(String address) {
        try {
            byte[] d = InetAddress.getByName(address).getAddress();
            if (d[0] == 10 || (0xFF & d[0]) == 172 && (0xF0 & d[1]) == 16 || (0xFF & d[0]) == 192 && (0xFF & d[1]) == 168) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            Log.e(TAG, "isBehindAT()" + address, e);
        }
        return false;
    }

    private void registerReceivers() {
        this.mContext.registerReceiver(this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void unregisterReceivers() {
        this.mContext.unregisterReceiver(this.mConnectivityReceiver);
        this.mWifiLock.release();
        this.mConnected = false;
    }

    private synchronized void onConnectivityChanged(NetworkInfo info) {
        String networkType;
        if (info == null || info.isConnected() || !info.getTypeName().equals(this.mNetworkType)) {
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            info = cm.getActiveNetworkInfo();
        }
        boolean connected = info != null && info.isConnected() && (!this.mSipOnWifiOnly || info.getType() == 1);
        String string2 = networkType = connected ? info.getTypeName() : "null";
        if (connected == this.mConnected && networkType.equals(this.mNetworkType)) {
            return;
        }
        try {
            if (this.mConnected) {
                this.mLocalIp = null;
                this.stopPortMappingMeasurement();
                for (SipSessionGroupExt group : this.mSipGroups.values()) {
                    group.onConnectivityChanged(false);
                }
            }
            this.mConnected = connected;
            this.mNetworkType = networkType;
            if (connected) {
                this.mLocalIp = this.determineLocalIp();
                this.mKeepAliveInterval = -1;
                this.mLastGoodKeepAliveInterval = 10;
                for (SipSessionGroupExt group : this.mSipGroups.values()) {
                    group.onConnectivityChanged(true);
                }
                if (info.getType() == 1) {
                    this.mWifiLock.acquire();
                } else {
                    this.mWifiLock.release();
                }
            } else {
                this.mWifiLock.acquire();
                this.mMyWakeLock.reset();
            }
        }
        catch (SipException e) {
            Log.e(TAG, "onConnectivityChanged()", e);
        }
    }

    private static Looper createLooper() {
        HandlerThread thread = new HandlerThread("SipService.Executor");
        thread.start();
        return thread.getLooper();
    }

    private class MyExecutor
    extends Handler
    implements Executor {
        MyExecutor() {
            super(SipService.createLooper());
        }

        public void execute(Runnable task) {
            SipService.this.mMyWakeLock.acquire(task);
            Message.obtain(this, 0, task).sendToTarget();
        }

        public void handleMessage(Message msg) {
            if (msg.obj instanceof Runnable) {
                this.executeInternal((Runnable)msg.obj);
            } else {
                Log.w(SipService.TAG, "can't handle msg: " + msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeInternal(Runnable task) {
            try {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    Log.e(SipService.TAG, "run task: " + task, t);
                    Object var4_3 = null;
                    SipService.this.mMyWakeLock.release(task);
                }
                Object var4_2 = null;
                SipService.this.mMyWakeLock.release(task);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                SipService.this.mMyWakeLock.release(task);
                throw throwable;
            }
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                final NetworkInfo info = (NetworkInfo)bundle.get("networkInfo");
                SipService.this.mExecutor.execute(new Runnable(){

                    public void run() {
                        SipService.this.onConnectivityChanged(info);
                    }
                });
            }
        }
    }

    private class AutoRegistrationProcess
    extends SipSessionAdapter
    implements Runnable,
    SipSessionGroup.KeepAliveProcessCallback {
        private static final int MIN_KEEPALIVE_SUCCESS_COUNT = 10;
        private String TAG = "SipAutoReg";
        private SipSessionGroup.SipSessionImpl mSession;
        private SipSessionGroup.SipSessionImpl mKeepAliveSession;
        private SipSessionListenerProxy mProxy = new SipSessionListenerProxy();
        private int mBackoff = 1;
        private boolean mRegistered;
        private long mExpiryTime;
        private int mErrorCode;
        private String mErrorMessage;
        private boolean mRunning = false;
        private int mKeepAliveSuccessCount = 0;

        private AutoRegistrationProcess() {
        }

        private String getAction() {
            return this.toString();
        }

        public void start(SipSessionGroup group) {
            if (!this.mRunning) {
                this.mRunning = true;
                this.mBackoff = 1;
                this.mSession = (SipSessionGroup.SipSessionImpl)group.createSession(this);
                if (this.mSession == null) {
                    return;
                }
                SipService.this.mMyWakeLock.acquire(this.mSession);
                this.mSession.unregister();
                this.TAG = "SipAutoReg:" + this.mSession.getLocalProfile().getUriString();
            }
        }

        private void startKeepAliveProcess(int interval) {
            if (this.mKeepAliveSession == null) {
                this.mKeepAliveSession = this.mSession.duplicate();
            } else {
                this.mKeepAliveSession.stopKeepAliveProcess();
            }
            try {
                this.mKeepAliveSession.startKeepAliveProcess(interval, this);
            }
            catch (SipException e) {
                Log.e(this.TAG, "failed to start keepalive w interval=" + interval, e);
            }
        }

        private void stopKeepAliveProcess() {
            if (this.mKeepAliveSession != null) {
                this.mKeepAliveSession.stopKeepAliveProcess();
                this.mKeepAliveSession = null;
            }
            this.mKeepAliveSuccessCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(boolean portChanged) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (portChanged) {
                    int interval = SipService.this.getKeepAliveInterval();
                    if (this.mKeepAliveSuccessCount < 10) {
                        Log.i(this.TAG, "keepalive doesn't work with interval " + interval + ", past success count=" + this.mKeepAliveSuccessCount);
                        if (interval > 10) {
                            SipService.this.restartPortMappingLifetimeMeasurement(this.mSession.getLocalProfile(), interval);
                            this.mKeepAliveSuccessCount = 0;
                        }
                    } else {
                        this.mKeepAliveSuccessCount /= 2;
                    }
                } else {
                    SipService.this.startPortMappingLifetimeMeasurement(this.mSession.getLocalProfile());
                    ++this.mKeepAliveSuccessCount;
                }
                if (!this.mRunning || !portChanged) {
                    return;
                }
                this.mKeepAliveSession = null;
                SipService.this.mMyWakeLock.acquire(this.mSession);
                this.mSession.register(3600);
            }
        }

        public void onError(int errorCode, String description) {
            this.onResponse(true);
        }

        public void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            SipService.this.mMyWakeLock.release(this.mSession);
            if (this.mSession != null) {
                this.mSession.setListener(null);
                if (SipService.this.mConnected && this.mRegistered) {
                    this.mSession.unregister();
                }
            }
            SipService.this.mTimer.cancel(this);
            this.stopKeepAliveProcess();
            this.mRegistered = false;
            this.setListener(this.mProxy.getListener());
        }

        public void onKeepAliveIntervalChanged() {
            if (this.mKeepAliveSession != null) {
                int newInterval = SipService.this.getKeepAliveInterval();
                this.mKeepAliveSuccessCount = 0;
                this.startKeepAliveProcess(newInterval);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setListener(ISipSessionListener listener) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                this.mProxy.setListener(listener);
                try {
                    int state;
                    int n = state = this.mSession == null ? 0 : this.mSession.getState();
                    if (state == 1 || state == 2) {
                        this.mProxy.onRegistering(this.mSession);
                    } else if (this.mRegistered) {
                        int duration = (int)(this.mExpiryTime - SystemClock.elapsedRealtime());
                        this.mProxy.onRegistrationDone(this.mSession, duration);
                    } else if (this.mErrorCode != 0) {
                        if (this.mErrorCode == -5) {
                            this.mProxy.onRegistrationTimeout(this.mSession);
                        } else {
                            this.mProxy.onRegistrationFailed(this.mSession, this.mErrorCode, this.mErrorMessage);
                        }
                    } else if (!SipService.this.mConnected) {
                        this.mProxy.onRegistrationFailed(this.mSession, -10, "no data connection");
                    } else if (!this.mRunning) {
                        this.mProxy.onRegistrationFailed(this.mSession, -4, "registration not running");
                    } else {
                        this.mProxy.onRegistrationFailed(this.mSession, -9, String.valueOf(state));
                    }
                }
                catch (Throwable t) {
                    Log.w(this.TAG, "setListener(): " + t);
                }
            }
        }

        public boolean isRegistered() {
            return this.mRegistered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                this.mErrorCode = 0;
                this.mErrorMessage = null;
                if (SipService.this.mConnected) {
                    SipService.this.mMyWakeLock.acquire(this.mSession);
                    this.mSession.register(3600);
                }
            }
        }

        private void restart(int duration) {
            Log.d(this.TAG, "Refresh registration " + duration + "s later.");
            SipService.this.mTimer.cancel(this);
            SipService.this.mTimer.set(duration * 1000, this);
        }

        private int backoffDuration() {
            int duration = 10 * this.mBackoff;
            if (duration > 3600) {
                duration = 3600;
            } else {
                this.mBackoff *= 2;
            }
            return duration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistering(ISipSession session) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mRegistered = false;
                this.mProxy.onRegistering(session);
            }
        }

        private boolean notCurrentSession(ISipSession session) {
            if (session != this.mSession) {
                ((SipSessionGroup.SipSessionImpl)session).setListener(null);
                SipService.this.mMyWakeLock.release(session);
                return true;
            }
            return !this.mRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationDone(ISipSession session, int duration) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mProxy.onRegistrationDone(session, duration);
                if (duration > 0) {
                    this.mExpiryTime = SystemClock.elapsedRealtime() + (long)(duration * 1000);
                    if (!this.mRegistered) {
                        this.mRegistered = true;
                        if ((duration -= 60) < 60) {
                            duration = 60;
                        }
                        this.restart(duration);
                        SipProfile localProfile = this.mSession.getLocalProfile();
                        if (this.mKeepAliveSession == null && (SipService.this.isBehindNAT(SipService.this.mLocalIp) || localProfile.getSendKeepAlive())) {
                            this.startKeepAliveProcess(SipService.this.getKeepAliveInterval());
                        }
                    }
                    SipService.this.mMyWakeLock.release(session);
                } else {
                    this.mRegistered = false;
                    this.mExpiryTime = -1L;
                    this.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationFailed(ISipSession session, int errorCode, String message) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                switch (errorCode) {
                    case -12: 
                    case -8: {
                        this.stop();
                        break;
                    }
                    default: {
                        this.restartLater();
                    }
                }
                this.mErrorCode = errorCode;
                this.mErrorMessage = message;
                this.mProxy.onRegistrationFailed(session, errorCode, message);
                SipService.this.mMyWakeLock.release(session);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationTimeout(ISipSession session) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mErrorCode = -5;
                this.mProxy.onRegistrationTimeout(session);
                this.restartLater();
                SipService.this.mMyWakeLock.release(session);
            }
        }

        private void restartLater() {
            this.mRegistered = false;
            this.restart(this.backoffDuration());
        }
    }

    private class IntervalMeasurementProcess
    implements Runnable,
    SipSessionGroup.KeepAliveProcessCallback {
        private static final String TAG = "SipKeepAliveInterval";
        private static final int MIN_INTERVAL = 5;
        private static final int PASS_THRESHOLD = 10;
        private static final int MAX_RETRY_COUNT = 5;
        private static final int NAT_MEASUREMENT_RETRY_INTERVAL = 120;
        private SipProfile mLocalProfile;
        private SipSessionGroupExt mGroup;
        private SipSessionGroup.SipSessionImpl mSession;
        private int mMinInterval;
        private int mMaxInterval;
        private int mInterval;
        private int mPassCount;

        public IntervalMeasurementProcess(SipProfile localProfile, int minInterval, int maxInterval) {
            this.mMaxInterval = maxInterval;
            this.mMinInterval = minInterval;
            this.mLocalProfile = localProfile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.mSession != null) {
                    return;
                }
                this.mInterval = (this.mMaxInterval + this.mMinInterval) / 2;
                this.mPassCount = 0;
                if (this.mInterval < 10 || this.checkTermination()) {
                    Log.w(TAG, "measurement aborted; interval=[" + this.mMinInterval + "," + this.mMaxInterval + "]");
                    return;
                }
                try {
                    Log.d(TAG, "start measurement w interval=" + this.mInterval);
                    this.mGroup = new SipSessionGroupExt(this.mLocalProfile, null, null);
                    this.mGroup.setWakeupTimer(new SipWakeupTimer(SipService.this.mContext, SipService.this.mExecutor));
                    this.mSession = (SipSessionGroup.SipSessionImpl)this.mGroup.createSession(null);
                    this.mSession.startKeepAliveProcess(this.mInterval, this);
                }
                catch (Throwable t) {
                    this.onError(-4, t.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.mSession != null) {
                    this.mSession.stopKeepAliveProcess();
                    this.mSession = null;
                }
                if (this.mGroup != null) {
                    this.mGroup.close();
                    this.mGroup = null;
                }
                SipService.this.mTimer.cancel(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restart() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.mSession == null) {
                    return;
                }
                Log.d(TAG, "restart measurement w interval=" + this.mInterval);
                try {
                    this.mSession.stopKeepAliveProcess();
                    this.mPassCount = 0;
                    this.mSession.startKeepAliveProcess(this.mInterval, this);
                }
                catch (SipException e) {
                    Log.e(TAG, "restart()", e);
                }
            }
        }

        private boolean checkTermination() {
            return this.mMaxInterval - this.mMinInterval < 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(boolean portChanged) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!portChanged) {
                    if (++this.mPassCount != 10) {
                        return;
                    }
                    if (SipService.this.mKeepAliveInterval > 0) {
                        SipService.this.mLastGoodKeepAliveInterval = SipService.this.mKeepAliveInterval;
                    }
                    this.mMinInterval = this.mInterval;
                    SipService.this.mKeepAliveInterval = this.mMinInterval;
                    SipService.this.onKeepAliveIntervalChanged();
                } else {
                    this.mMaxInterval = this.mInterval;
                }
                if (this.checkTermination()) {
                    this.stop();
                    SipService.this.mKeepAliveInterval = this.mMinInterval;
                } else {
                    this.mInterval = (this.mMaxInterval + this.mMinInterval) / 2;
                    this.restart();
                }
            }
        }

        public void onError(int errorCode, String description) {
            Log.w(TAG, "interval measurement error: " + description);
            this.restartLater();
        }

        public void run() {
            SipService.this.mTimer.cancel(this);
            this.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartLater() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                int interval = 120;
                SipService.this.mTimer.cancel(this);
                SipService.this.mTimer.set(interval * 1000, this);
            }
        }
    }

    private class SipSessionGroupExt
    extends SipSessionAdapter {
        private SipSessionGroup mSipGroup;
        private PendingIntent mIncomingCallPendingIntent;
        private boolean mOpenedToReceiveCalls;
        private AutoRegistrationProcess mAutoRegistration;

        public SipSessionGroupExt(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws SipException {
            this.mAutoRegistration = new AutoRegistrationProcess();
            String password = localProfile.getPassword();
            SipProfile p = this.duplicate(localProfile);
            this.mSipGroup = this.createSipSessionGroup(SipService.this.mLocalIp, p, password);
            this.mIncomingCallPendingIntent = incomingCallPendingIntent;
            this.mAutoRegistration.setListener(listener);
        }

        public SipProfile getLocalProfile() {
            return this.mSipGroup.getLocalProfile();
        }

        public boolean containsSession(String callId) {
            return this.mSipGroup.containsSession(callId);
        }

        public void onKeepAliveIntervalChanged() {
            this.mAutoRegistration.onKeepAliveIntervalChanged();
        }

        void setWakeupTimer(SipWakeupTimer timer) {
            this.mSipGroup.setWakeupTimer(timer);
        }

        private SipSessionGroup createSipSessionGroup(String localIp, SipProfile localProfile, String password) throws SipException {
            try {
                return new SipSessionGroup(localIp, localProfile, password, SipService.this.mTimer, SipService.this.mMyWakeLock);
            }
            catch (IOException e) {
                Log.w(SipService.TAG, "createSipSessionGroup(): network disconnected?");
                if (localIp != null) {
                    return this.createSipSessionGroup(null, localProfile, password);
                }
                Log.wtf(SipService.TAG, "impossible! recursive!");
                throw new RuntimeException("createSipSessionGroup");
            }
        }

        private SipProfile duplicate(SipProfile p) {
            try {
                return new SipProfile.Builder(p).setPassword("*").build();
            }
            catch (Exception e) {
                Log.wtf(SipService.TAG, "duplicate()", e);
                throw new RuntimeException("duplicate profile", e);
            }
        }

        public void setListener(ISipSessionListener listener) {
            this.mAutoRegistration.setListener(listener);
        }

        public void setIncomingCallPendingIntent(PendingIntent pIntent) {
            this.mIncomingCallPendingIntent = pIntent;
        }

        public void openToReceiveCalls() throws SipException {
            this.mOpenedToReceiveCalls = true;
            if (SipService.this.mConnected) {
                this.mSipGroup.openToReceiveCalls(this);
                this.mAutoRegistration.start(this.mSipGroup);
            }
        }

        public void onConnectivityChanged(boolean connected) throws SipException {
            this.mSipGroup.onConnectivityChanged();
            if (connected) {
                this.resetGroup(SipService.this.mLocalIp);
                if (this.mOpenedToReceiveCalls) {
                    this.openToReceiveCalls();
                }
            } else {
                this.mSipGroup.close();
                this.mAutoRegistration.stop();
            }
        }

        private void resetGroup(String localIp) throws SipException {
            try {
                this.mSipGroup.reset(localIp);
            }
            catch (IOException e) {
                Log.w(SipService.TAG, "resetGroup(): network disconnected?");
                if (localIp != null) {
                    this.resetGroup(null);
                }
                Log.wtf(SipService.TAG, "impossible!");
                throw new RuntimeException("resetGroup");
            }
        }

        public void close() {
            this.mOpenedToReceiveCalls = false;
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
        }

        public ISipSession createSession(ISipSessionListener listener) {
            return this.mSipGroup.createSession(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRinging(ISipSession s, SipProfile caller, String sessionDescription) {
            SipSessionGroup.SipSessionImpl session = (SipSessionGroup.SipSessionImpl)s;
            SipService sipService = SipService.this;
            synchronized (sipService) {
                try {
                    if (!this.isRegistered() || SipService.this.callingSelf(this, session)) {
                        session.endCall();
                        return;
                    }
                    SipService.this.addPendingSession(session);
                    Intent intent = SipManager.createIncomingCallBroadcast(session.getCallId(), sessionDescription);
                    this.mIncomingCallPendingIntent.send(SipService.this.mContext, 101, intent);
                }
                catch (PendingIntent.CanceledException e) {
                    Log.w(SipService.TAG, "pendingIntent is canceled, drop incoming call");
                    session.endCall();
                }
            }
        }

        public void onError(ISipSession session, int errorCode, String message) {
        }

        public boolean isOpenedToReceiveCalls() {
            return this.mOpenedToReceiveCalls;
        }

        public boolean isRegistered() {
            return this.mAutoRegistration.isRegistered();
        }

        private String getUri() {
            return this.mSipGroup.getLocalProfileUri();
        }
    }
}

