/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.net.sip.SipSession;
import android.net.sip.SipSessionAdapter;
import android.text.TextUtils;
import android.util.Log;
import com.android.server.sip.SipHelper;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import com.android.server.sip.SipWakeupTimer;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.UserCredentials;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.header.extensions.ReferredByHeader;
import gov.nist.javax.sip.header.extensions.ReplacesHeader;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramSocket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.HeaderAddress;
import javax.sip.header.ReferToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;

class SipSessionGroup
implements SipListener {
    private static final String TAG = "SipSession";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PING = false;
    private static final String ANONYMOUS = "anonymous";
    private static final String THREAD_POOL_SIZE = "1";
    private static final int EXPIRY_TIME = 3600;
    private static final int CANCEL_CALL_TIMER = 3;
    private static final int END_CALL_TIMER = 3;
    private static final int KEEPALIVE_TIMEOUT = 5;
    private static final int INCALL_KEEPALIVE_INTERVAL = 10;
    private static final long WAKE_LOCK_HOLDING_TIME = 500L;
    private static final EventObject DEREGISTER = new EventObject("Deregister");
    private static final EventObject END_CALL = new EventObject("End call");
    private static final EventObject HOLD_CALL = new EventObject("Hold call");
    private static final EventObject CONTINUE_CALL = new EventObject("Continue call");
    private final SipProfile mLocalProfile;
    private final String mPassword;
    private SipStack mSipStack;
    private SipHelper mSipHelper;
    private SipSessionImpl mCallReceiverSession;
    private String mLocalIp;
    private SipWakeupTimer mWakeupTimer;
    private SipWakeLock mWakeLock;
    private Map<String, SipSessionImpl> mSessionMap = new HashMap<String, SipSessionImpl>();
    private String mExternalIp;
    private int mExternalPort;

    public SipSessionGroup(String localIp, SipProfile myself, String password, SipWakeupTimer timer, SipWakeLock wakeLock) throws SipException, IOException {
        this.mLocalProfile = myself;
        this.mPassword = password;
        this.mWakeupTimer = timer;
        this.mWakeLock = wakeLock;
        this.reset(localIp);
    }

    void setWakeupTimer(SipWakeupTimer timer) {
        this.mWakeupTimer = timer;
    }

    synchronized void reset(String localIp) throws SipException, IOException {
        this.mLocalIp = localIp;
        if (localIp == null) {
            return;
        }
        SipProfile myself = this.mLocalProfile;
        SipFactory sipFactory = SipFactory.getInstance();
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", this.getStackName());
        properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", THREAD_POOL_SIZE);
        String outboundProxy = myself.getProxyAddress();
        if (!TextUtils.isEmpty(outboundProxy)) {
            Log.v(TAG, "outboundProxy is " + outboundProxy);
            properties.setProperty("javax.sip.OUTBOUND_PROXY", outboundProxy + ":" + myself.getPort() + "/" + myself.getProtocol());
        }
        SipStack stack = this.mSipStack = sipFactory.createSipStack(properties);
        try {
            SipProvider provider = stack.createSipProvider(stack.createListeningPoint(localIp, SipSessionGroup.allocateLocalPort(), myself.getProtocol()));
            provider.addSipListener((SipListener)this);
            this.mSipHelper = new SipHelper(stack, provider);
        }
        catch (InvalidArgumentException e) {
            throw new IOException(e.getMessage());
        }
        catch (TooManyListenersException e) {
            throw new SipException("SipSessionGroup constructor", (Throwable)e);
        }
        Log.d(TAG, " start stack for " + myself.getUriString());
        stack.start();
        this.mCallReceiverSession = null;
        this.mSessionMap.clear();
        this.resetExternalAddress();
    }

    synchronized void onConnectivityChanged() {
        SipSessionImpl[] ss;
        for (SipSessionImpl s : ss = this.mSessionMap.values().toArray(new SipSessionImpl[this.mSessionMap.size()])) {
            s.onError(-10, "data connection lost");
        }
    }

    synchronized void resetExternalAddress() {
        this.mExternalIp = null;
        this.mExternalPort = 0;
    }

    public SipProfile getLocalProfile() {
        return this.mLocalProfile;
    }

    public String getLocalProfileUri() {
        return this.mLocalProfile.getUriString();
    }

    private String getStackName() {
        return "stack" + System.currentTimeMillis();
    }

    public synchronized void close() {
        Log.d(TAG, " close stack for " + this.mLocalProfile.getUriString());
        this.onConnectivityChanged();
        this.mSessionMap.clear();
        this.closeToNotReceiveCalls();
        if (this.mSipStack != null) {
            this.mSipStack.stop();
            this.mSipStack = null;
            this.mSipHelper = null;
        }
    }

    public synchronized boolean isClosed() {
        return this.mSipStack == null;
    }

    public synchronized void openToReceiveCalls(ISipSessionListener listener) {
        if (this.mCallReceiverSession == null) {
            this.mCallReceiverSession = new SipSessionCallReceiverImpl(listener);
        } else {
            this.mCallReceiverSession.setListener(listener);
        }
    }

    public synchronized void closeToNotReceiveCalls() {
        this.mCallReceiverSession = null;
    }

    public ISipSession createSession(ISipSessionListener listener) {
        return this.isClosed() ? null : new SipSessionImpl(listener);
    }

    private static int allocateLocalPort() throws SipException {
        try {
            DatagramSocket s = new DatagramSocket();
            int localPort = s.getLocalPort();
            s.close();
            return localPort;
        }
        catch (IOException e) {
            throw new SipException("allocateLocalPort()", (Throwable)e);
        }
    }

    synchronized boolean containsSession(String callId) {
        return this.mSessionMap.containsKey(callId);
    }

    private synchronized SipSessionImpl getSipSession(EventObject event) {
        String key = SipHelper.getCallId(event);
        SipSessionImpl session = this.mSessionMap.get(key);
        if (session != null && SipSessionGroup.isLoggable(session)) {
            Log.d(TAG, "session key from event: " + key);
            Log.d(TAG, "active sessions:");
            for (String k : this.mSessionMap.keySet()) {
                Log.d(TAG, " ..." + k + ": " + this.mSessionMap.get(k));
            }
        }
        return session != null ? session : this.mCallReceiverSession;
    }

    private synchronized void addSipSession(SipSessionImpl newSession) {
        this.removeSipSession(newSession);
        String key = newSession.getCallId();
        this.mSessionMap.put(key, newSession);
        if (SipSessionGroup.isLoggable(newSession)) {
            Log.d(TAG, "+++  add a session with key:  '" + key + "'");
            for (String k : this.mSessionMap.keySet()) {
                Log.d(TAG, "  " + k + ": " + this.mSessionMap.get(k));
            }
        }
    }

    private synchronized void removeSipSession(SipSessionImpl session) {
        if (session == this.mCallReceiverSession) {
            return;
        }
        String key = session.getCallId();
        SipSessionImpl s = this.mSessionMap.remove(key);
        if (s != null && s != session) {
            Log.w(TAG, "session " + session + " is not associated with key '" + key + "'");
            this.mSessionMap.put(key, s);
            for (Map.Entry entry : this.mSessionMap.entrySet()) {
                if (entry.getValue() != s) continue;
                key = (String)entry.getKey();
                this.mSessionMap.remove(key);
            }
        }
        if (s != null && SipSessionGroup.isLoggable(s)) {
            Log.d(TAG, "remove session " + session + " @key '" + key + "'");
            for (String string2 : this.mSessionMap.keySet()) {
                Log.d(TAG, "  " + string2 + ": " + this.mSessionMap.get(string2));
            }
        }
    }

    public void processRequest(RequestEvent event) {
        if (SipSessionGroup.isRequestEvent("INVITE", (EventObject)event)) {
            this.mWakeLock.acquire(500L);
        }
        this.process((EventObject)event);
    }

    public void processResponse(ResponseEvent event) {
        this.process((EventObject)event);
    }

    public void processIOException(IOExceptionEvent event) {
        this.process((EventObject)event);
    }

    public void processTimeout(TimeoutEvent event) {
        this.process((EventObject)event);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent event) {
        this.process((EventObject)event);
    }

    public void processDialogTerminated(DialogTerminatedEvent event) {
        this.process((EventObject)event);
    }

    private synchronized void process(EventObject event) {
        SipSessionImpl session = this.getSipSession(event);
        try {
            boolean processed;
            boolean isLoggable = SipSessionGroup.isLoggable(session, event);
            boolean bl = processed = session != null && session.process(event);
            if (isLoggable && processed) {
                Log.d(TAG, "new state after: " + SipSession.State.toString(session.mState));
            }
        }
        catch (Throwable e) {
            Log.w(TAG, "event process error: " + event, this.getRootCause(e));
            session.onError(e);
        }
    }

    private String extractContent(Message message) {
        byte[] bytes = message.getRawContent();
        if (bytes != null) {
            try {
                if (message instanceof SIPMessage) {
                    return ((SIPMessage)message).getMessageContent();
                }
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private void extractExternalAddress(ResponseEvent evt) {
        Response response = evt.getResponse();
        ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
        if (viaHeader == null) {
            return;
        }
        int rport = viaHeader.getRPort();
        String externalIp = viaHeader.getReceived();
        if (rport > 0 && externalIp != null) {
            this.mExternalIp = externalIp;
            this.mExternalPort = rport;
        }
    }

    private Throwable getRootCause(Throwable exception) {
        Throwable cause = exception.getCause();
        while (cause != null) {
            exception = cause;
            cause = exception.getCause();
        }
        return exception;
    }

    private SipSessionImpl createNewSession(RequestEvent event, ISipSessionListener listener, ServerTransaction transaction, int newState) throws SipException {
        SipSessionImpl newSession = new SipSessionImpl(listener);
        newSession.mServerTransaction = transaction;
        newSession.mState = newState;
        newSession.mDialog = newSession.mServerTransaction.getDialog();
        newSession.mInviteReceived = event;
        newSession.mPeerProfile = SipSessionGroup.createPeerProfile((HeaderAddress)event.getRequest().getHeader("From"));
        newSession.mPeerSessionDescription = this.extractContent((Message)event.getRequest());
        return newSession;
    }

    private static boolean isRequestEvent(String method, EventObject event) {
        try {
            if (event instanceof RequestEvent) {
                RequestEvent requestEvent = (RequestEvent)event;
                return method.equals(requestEvent.getRequest().getMethod());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String getCseqMethod(Message message) {
        return ((CSeqHeader)message.getHeader("CSeq")).getMethod();
    }

    private static boolean expectResponse(String expectedMethod, EventObject evt) {
        if (evt instanceof ResponseEvent) {
            ResponseEvent event = (ResponseEvent)evt;
            Response response = event.getResponse();
            return expectedMethod.equalsIgnoreCase(SipSessionGroup.getCseqMethod((Message)response));
        }
        return false;
    }

    private static boolean expectResponse(int responseCode, String expectedMethod, EventObject evt) {
        ResponseEvent event;
        Response response;
        if (evt instanceof ResponseEvent && (response = (event = (ResponseEvent)evt).getResponse()).getStatusCode() == responseCode) {
            return expectedMethod.equalsIgnoreCase(SipSessionGroup.getCseqMethod((Message)response));
        }
        return false;
    }

    private static SipProfile createPeerProfile(HeaderAddress header) throws SipException {
        try {
            Address address = header.getAddress();
            SipURI uri = (SipURI)address.getURI();
            String username = uri.getUser();
            if (username == null) {
                username = ANONYMOUS;
            }
            int port = uri.getPort();
            SipProfile.Builder builder = new SipProfile.Builder(username, uri.getHost()).setDisplayName(address.getDisplayName());
            if (port > 0) {
                builder.setPort(port);
            }
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new SipException("createPeerProfile()", (Throwable)e);
        }
        catch (ParseException e) {
            throw new SipException("createPeerProfile()", (Throwable)e);
        }
    }

    private static boolean isLoggable(SipSessionImpl s) {
        if (s != null) {
            switch (s.mState) {
                case 9: {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isLoggable(EventObject evt) {
        return SipSessionGroup.isLoggable(null, evt);
    }

    private static boolean isLoggable(SipSessionImpl s, EventObject evt) {
        if (!SipSessionGroup.isLoggable(s)) {
            return false;
        }
        if (evt == null) {
            return false;
        }
        if (evt instanceof ResponseEvent) {
            Response response = ((ResponseEvent)evt).getResponse();
            if ("OPTIONS".equals(response.getHeader("CSeq"))) {
                return false;
            }
            return false;
        }
        if (evt instanceof RequestEvent) {
            if (SipSessionGroup.isRequestEvent("OPTIONS", evt)) {
                return false;
            }
            return false;
        }
        return false;
    }

    private static String log(EventObject evt) {
        if (evt instanceof RequestEvent) {
            return ((RequestEvent)evt).getRequest().toString();
        }
        if (evt instanceof ResponseEvent) {
            return ((ResponseEvent)evt).getResponse().toString();
        }
        return evt.toString();
    }

    static class KeepAliveProcessCallbackProxy
    implements KeepAliveProcessCallback {
        private KeepAliveProcessCallback mCallback;

        KeepAliveProcessCallbackProxy(KeepAliveProcessCallback callback) {
            this.mCallback = callback;
        }

        private void proxy(Runnable runnable) {
            new Thread(runnable, "SIP-KeepAliveProcessCallbackThread").start();
        }

        public void onResponse(final boolean portChanged) {
            if (this.mCallback == null) {
                return;
            }
            this.proxy(new Runnable(){

                public void run() {
                    try {
                        KeepAliveProcessCallbackProxy.this.mCallback.onResponse(portChanged);
                    }
                    catch (Throwable t) {
                        Log.w(SipSessionGroup.TAG, "onResponse", t);
                    }
                }
            });
        }

        public void onError(final int errorCode, final String description) {
            if (this.mCallback == null) {
                return;
            }
            this.proxy(new Runnable(){

                public void run() {
                    try {
                        KeepAliveProcessCallbackProxy.this.mCallback.onError(errorCode, description);
                    }
                    catch (Throwable t) {
                        Log.w(SipSessionGroup.TAG, "onError", t);
                    }
                }
            });
        }
    }

    private class MakeCallCommand
    extends EventObject {
        private String mSessionDescription;
        private int mTimeout;

        public MakeCallCommand(SipProfile peerProfile, String sessionDescription) {
            this(peerProfile, sessionDescription, -1);
        }

        public MakeCallCommand(SipProfile peerProfile, String sessionDescription, int timeout) {
            super(peerProfile);
            this.mSessionDescription = sessionDescription;
            this.mTimeout = timeout;
        }

        public SipProfile getPeerProfile() {
            return (SipProfile)this.getSource();
        }

        public String getSessionDescription() {
            return this.mSessionDescription;
        }

        public int getTimeout() {
            return this.mTimeout;
        }
    }

    private class RegisterCommand
    extends EventObject {
        private int mDuration;

        public RegisterCommand(int duration) {
            super(SipSessionGroup.this);
            this.mDuration = duration;
        }

        public int getDuration() {
            return this.mDuration;
        }
    }

    class SipSessionImpl
    extends ISipSession.Stub {
        SipProfile mPeerProfile;
        SipSessionListenerProxy mProxy = new SipSessionListenerProxy();
        int mState = 0;
        RequestEvent mInviteReceived;
        Dialog mDialog;
        ServerTransaction mServerTransaction;
        ClientTransaction mClientTransaction;
        String mPeerSessionDescription;
        boolean mInCall;
        SessionTimer mSessionTimer;
        int mAuthenticationRetryCount;
        private KeepAliveProcess mKeepAliveProcess;
        private SipSessionImpl mKeepAliveSession;
        SipSessionImpl mReferSession;
        ReferredByHeader mReferredBy;
        String mReplaces;

        public SipSessionImpl(ISipSessionListener listener) {
            this.setListener(listener);
        }

        SipSessionImpl duplicate() {
            return new SipSessionImpl(this.mProxy.getListener());
        }

        private void reset() {
            this.mInCall = false;
            SipSessionGroup.this.removeSipSession(this);
            this.mPeerProfile = null;
            this.mState = 0;
            this.mInviteReceived = null;
            this.mPeerSessionDescription = null;
            this.mAuthenticationRetryCount = 0;
            this.mReferSession = null;
            this.mReferredBy = null;
            this.mReplaces = null;
            if (this.mDialog != null) {
                this.mDialog.delete();
            }
            this.mDialog = null;
            try {
                if (this.mServerTransaction != null) {
                    this.mServerTransaction.terminate();
                }
            }
            catch (ObjectInUseException e) {
                // empty catch block
            }
            this.mServerTransaction = null;
            try {
                if (this.mClientTransaction != null) {
                    this.mClientTransaction.terminate();
                }
            }
            catch (ObjectInUseException objectInUseException) {
                // empty catch block
            }
            this.mClientTransaction = null;
            this.cancelSessionTimer();
            if (this.mKeepAliveSession != null) {
                this.mKeepAliveSession.stopKeepAliveProcess();
                this.mKeepAliveSession = null;
            }
        }

        public boolean isInCall() {
            return this.mInCall;
        }

        public String getLocalIp() {
            return SipSessionGroup.this.mLocalIp;
        }

        public SipProfile getLocalProfile() {
            return SipSessionGroup.this.mLocalProfile;
        }

        public SipProfile getPeerProfile() {
            return this.mPeerProfile;
        }

        public String getCallId() {
            return SipHelper.getCallId(this.getTransaction());
        }

        private Transaction getTransaction() {
            if (this.mClientTransaction != null) {
                return this.mClientTransaction;
            }
            if (this.mServerTransaction != null) {
                return this.mServerTransaction;
            }
            return null;
        }

        public int getState() {
            return this.mState;
        }

        public void setListener(ISipSessionListener listener) {
            this.mProxy.setListener(listener instanceof SipSessionListenerProxy ? ((SipSessionListenerProxy)listener).getListener() : listener);
        }

        private void doCommandAsync(final EventObject command) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        SipSessionImpl.this.processCommand(command);
                    }
                    catch (Throwable e) {
                        Log.w(SipSessionGroup.TAG, "command error: " + command + ": " + SipSessionGroup.this.mLocalProfile.getUriString(), SipSessionGroup.this.getRootCause(e));
                        SipSessionImpl.this.onError(e);
                    }
                }
            }, "SipSessionAsyncCmdThread").start();
        }

        public void makeCall(SipProfile peerProfile, String sessionDescription, int timeout) {
            this.doCommandAsync(new MakeCallCommand(peerProfile, sessionDescription, timeout));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void answerCall(String sessionDescription, int timeout) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mPeerProfile == null) {
                    return;
                }
                this.doCommandAsync(new MakeCallCommand(this.mPeerProfile, sessionDescription, timeout));
            }
        }

        public void endCall() {
            this.doCommandAsync(END_CALL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeCall(String sessionDescription, int timeout) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mPeerProfile == null) {
                    return;
                }
                this.doCommandAsync(new MakeCallCommand(this.mPeerProfile, sessionDescription, timeout));
            }
        }

        public void register(int duration) {
            this.doCommandAsync(new RegisterCommand(duration));
        }

        public void unregister() {
            this.doCommandAsync(DEREGISTER);
        }

        private void processCommand(EventObject command) throws SipException {
            if (SipSessionGroup.isLoggable(command)) {
                Log.d(SipSessionGroup.TAG, "process cmd: " + command);
            }
            if (!this.process(command)) {
                this.onError(-9, "cannot initiate a new transaction to execute: " + command);
            }
        }

        protected String generateTag() {
            return String.valueOf((long)(Math.random() * 4.294967296E9));
        }

        public String toString() {
            try {
                String s = super.toString();
                return s.substring(s.indexOf("@")) + ":" + SipSession.State.toString(this.mState);
            }
            catch (Throwable e) {
                return super.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(EventObject evt) throws SipException {
            if (SipSessionGroup.isLoggable(this, evt)) {
                Log.d(SipSessionGroup.TAG, " ~~~~~   " + this + ": " + SipSession.State.toString(this.mState) + ": processing " + SipSessionGroup.log(evt));
            }
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                boolean processed;
                if (SipSessionGroup.this.isClosed()) {
                    return false;
                }
                if (this.mKeepAliveProcess != null && this.mKeepAliveProcess.process(evt)) {
                    return true;
                }
                Dialog dialog = null;
                if (evt instanceof RequestEvent) {
                    dialog = ((RequestEvent)evt).getDialog();
                } else if (evt instanceof ResponseEvent) {
                    dialog = ((ResponseEvent)evt).getDialog();
                    SipSessionGroup.this.extractExternalAddress((ResponseEvent)evt);
                }
                if (dialog != null) {
                    this.mDialog = dialog;
                }
                switch (this.mState) {
                    case 1: 
                    case 2: {
                        processed = this.registeringToReady(evt);
                        break;
                    }
                    case 0: {
                        processed = this.readyForCall(evt);
                        break;
                    }
                    case 3: {
                        processed = this.incomingCall(evt);
                        break;
                    }
                    case 4: {
                        processed = this.incomingCallToInCall(evt);
                        break;
                    }
                    case 5: 
                    case 6: {
                        processed = this.outgoingCall(evt);
                        break;
                    }
                    case 7: {
                        processed = this.outgoingCallToReady(evt);
                        break;
                    }
                    case 8: {
                        processed = this.inCall(evt);
                        break;
                    }
                    case 10: {
                        processed = this.endingCall(evt);
                        break;
                    }
                    default: {
                        processed = false;
                    }
                }
                return processed || this.processExceptions(evt);
            }
        }

        private boolean processExceptions(EventObject evt) throws SipException {
            if (SipSessionGroup.isRequestEvent("BYE", evt)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)evt, 200);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("CANCEL", evt)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)evt, 481);
                return true;
            }
            if (evt instanceof TransactionTerminatedEvent) {
                if (this.isCurrentTransaction((TransactionTerminatedEvent)evt)) {
                    if (evt instanceof TimeoutEvent) {
                        this.processTimeout((TimeoutEvent)evt);
                    } else {
                        this.processTransactionTerminated((TransactionTerminatedEvent)evt);
                    }
                    return true;
                }
            } else {
                if (SipSessionGroup.isRequestEvent("OPTIONS", evt)) {
                    SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)evt, 200);
                    return true;
                }
                if (evt instanceof DialogTerminatedEvent) {
                    this.processDialogTerminated((DialogTerminatedEvent)evt);
                    return true;
                }
            }
            return false;
        }

        private void processDialogTerminated(DialogTerminatedEvent event) {
            if (this.mDialog == event.getDialog()) {
                this.onError(new SipException("dialog terminated"));
            } else {
                Log.d(SipSessionGroup.TAG, "not the current dialog; current=" + this.mDialog + ", terminated=" + event.getDialog());
            }
        }

        private boolean isCurrentTransaction(TransactionTerminatedEvent event) {
            ServerTransaction target;
            ServerTransaction current = event.isServerTransaction() ? this.mServerTransaction : this.mClientTransaction;
            Object object = target = event.isServerTransaction() ? event.getServerTransaction() : event.getClientTransaction();
            if (current != target && this.mState != 9) {
                Log.d(SipSessionGroup.TAG, "not the current transaction; current=" + this.toString((Transaction)current) + ", target=" + this.toString((Transaction)target));
                return false;
            }
            if (current != null) {
                Log.d(SipSessionGroup.TAG, "transaction terminated: " + this.toString((Transaction)current));
                return true;
            }
            return true;
        }

        private String toString(Transaction transaction) {
            if (transaction == null) {
                return "null";
            }
            Request request = transaction.getRequest();
            Dialog dialog = transaction.getDialog();
            CSeqHeader cseq = (CSeqHeader)request.getHeader("CSeq");
            return String.format("req=%s,%s,s=%s,ds=%s,", request.getMethod(), cseq.getSeqNumber(), transaction.getState(), dialog == null ? "-" : dialog.getState());
        }

        private void processTransactionTerminated(TransactionTerminatedEvent event) {
            switch (this.mState) {
                case 0: 
                case 8: {
                    Log.d(SipSessionGroup.TAG, "Transaction terminated; do nothing");
                    break;
                }
                default: {
                    Log.d(SipSessionGroup.TAG, "Transaction terminated early: " + this);
                    this.onError(-3, "transaction terminated");
                }
            }
        }

        private void processTimeout(TimeoutEvent event) {
            Log.d(SipSessionGroup.TAG, "processing Timeout...");
            switch (this.mState) {
                case 1: 
                case 2: {
                    this.reset();
                    this.mProxy.onRegistrationTimeout(this);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.onError(-5, event.toString());
                    break;
                }
                default: {
                    Log.d(SipSessionGroup.TAG, "   do nothing");
                }
            }
        }

        private int getExpiryTime(Response response) {
            ExpiresHeader expires;
            int time = -1;
            ContactHeader contact = (ContactHeader)response.getHeader("Contact");
            if (contact != null) {
                time = contact.getExpires();
            }
            if ((expires = (ExpiresHeader)response.getHeader("Expires")) != null && (time < 0 || time > expires.getExpires())) {
                time = expires.getExpires();
            }
            if (time <= 0) {
                time = 3600;
            }
            if ((expires = (ExpiresHeader)response.getHeader("Min-Expires")) != null && time < expires.getExpires()) {
                time = expires.getExpires();
            }
            return time;
        }

        private boolean registeringToReady(EventObject evt) throws SipException {
            if (SipSessionGroup.expectResponse("REGISTER", evt)) {
                ResponseEvent event = (ResponseEvent)evt;
                Response response = event.getResponse();
                int statusCode = response.getStatusCode();
                switch (statusCode) {
                    case 200: {
                        int state = this.mState;
                        this.onRegistrationDone(state == 1 ? this.getExpiryTime(((ResponseEvent)evt).getResponse()) : -1);
                        return true;
                    }
                    case 401: 
                    case 407: {
                        this.handleAuthentication(event);
                        return true;
                    }
                }
                if (statusCode >= 500) {
                    this.onRegistrationFailed(response);
                    return true;
                }
            }
            return false;
        }

        private boolean handleAuthentication(ResponseEvent event) throws SipException {
            Response response = event.getResponse();
            String nonce = this.getNonceFromResponse(response);
            if (nonce == null) {
                this.onError(-2, "server does not provide challenge");
                return false;
            }
            if (this.mAuthenticationRetryCount < 2) {
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.handleChallenge(event, this.getAccountManager());
                this.mDialog = this.mClientTransaction.getDialog();
                ++this.mAuthenticationRetryCount;
                if (SipSessionGroup.isLoggable(this, (EventObject)event)) {
                    Log.d(SipSessionGroup.TAG, "   authentication retry count=" + this.mAuthenticationRetryCount);
                }
                return true;
            }
            if (this.crossDomainAuthenticationRequired(response)) {
                this.onError(-11, this.getRealmFromResponse(response));
            } else {
                this.onError(-8, "incorrect username or password");
            }
            return false;
        }

        private boolean crossDomainAuthenticationRequired(Response response) {
            String realm = this.getRealmFromResponse(response);
            if (realm == null) {
                realm = "";
            }
            return !SipSessionGroup.this.mLocalProfile.getSipDomain().trim().equals(realm.trim());
        }

        private AccountManager getAccountManager() {
            return new AccountManager(){

                public UserCredentials getCredentials(ClientTransaction challengedTransaction, String realm) {
                    return new UserCredentials(){

                        public String getUserName() {
                            String username = SipSessionGroup.this.mLocalProfile.getAuthUserName();
                            return !TextUtils.isEmpty(username) ? username : SipSessionGroup.this.mLocalProfile.getUserName();
                        }

                        public String getPassword() {
                            return SipSessionGroup.this.mPassword;
                        }

                        public String getSipDomain() {
                            return SipSessionGroup.this.mLocalProfile.getSipDomain();
                        }
                    };
                }
            };
        }

        private String getRealmFromResponse(Response response) {
            WWWAuthenticate wwwAuth = (WWWAuthenticate)response.getHeader("WWW-Authenticate");
            if (wwwAuth != null) {
                return wwwAuth.getRealm();
            }
            ProxyAuthenticate proxyAuth = (ProxyAuthenticate)response.getHeader("Proxy-Authenticate");
            return proxyAuth == null ? null : proxyAuth.getRealm();
        }

        private String getNonceFromResponse(Response response) {
            WWWAuthenticate wwwAuth = (WWWAuthenticate)response.getHeader("WWW-Authenticate");
            if (wwwAuth != null) {
                return wwwAuth.getNonce();
            }
            ProxyAuthenticate proxyAuth = (ProxyAuthenticate)response.getHeader("Proxy-Authenticate");
            return proxyAuth == null ? null : proxyAuth.getNonce();
        }

        private String getResponseString(int statusCode) {
            StatusLine statusLine = new StatusLine();
            statusLine.setStatusCode(statusCode);
            statusLine.setReasonPhrase(SIPResponse.getReasonPhrase((int)statusCode));
            return statusLine.encode();
        }

        private boolean readyForCall(EventObject evt) throws SipException {
            if (evt instanceof MakeCallCommand) {
                this.mState = 5;
                MakeCallCommand cmd = (MakeCallCommand)evt;
                this.mPeerProfile = cmd.getPeerProfile();
                if (this.mReferSession != null) {
                    SipSessionGroup.this.mSipHelper.sendReferNotify(this.mReferSession.mDialog, this.getResponseString(100));
                }
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendInvite(SipSessionGroup.this.mLocalProfile, this.mPeerProfile, cmd.getSessionDescription(), this.generateTag(), this.mReferredBy, this.mReplaces);
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.startSessionTimer(cmd.getTimeout());
                this.mProxy.onCalling(this);
                return true;
            }
            if (evt instanceof RegisterCommand) {
                this.mState = 1;
                int duration = ((RegisterCommand)evt).getDuration();
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendRegister(SipSessionGroup.this.mLocalProfile, this.generateTag(), duration);
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.mProxy.onRegistering(this);
                return true;
            }
            if (DEREGISTER == evt) {
                this.mState = 2;
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendRegister(SipSessionGroup.this.mLocalProfile, this.generateTag(), 0);
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.mProxy.onRegistering(this);
                return true;
            }
            return false;
        }

        private boolean incomingCall(EventObject evt) throws SipException {
            if (evt instanceof MakeCallCommand) {
                this.mState = 4;
                this.mServerTransaction = SipSessionGroup.this.mSipHelper.sendInviteOk(this.mInviteReceived, SipSessionGroup.this.mLocalProfile, ((MakeCallCommand)evt).getSessionDescription(), this.mServerTransaction, SipSessionGroup.this.mExternalIp, SipSessionGroup.this.mExternalPort);
                this.startSessionTimer(((MakeCallCommand)evt).getTimeout());
                return true;
            }
            if (END_CALL == evt) {
                SipSessionGroup.this.mSipHelper.sendInviteBusyHere(this.mInviteReceived, this.mServerTransaction);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("CANCEL", evt)) {
                RequestEvent event = (RequestEvent)evt;
                SipSessionGroup.this.mSipHelper.sendResponse(event, 200);
                SipSessionGroup.this.mSipHelper.sendInviteRequestTerminated(this.mInviteReceived.getRequest(), this.mServerTransaction);
                this.endCallNormally();
                return true;
            }
            return false;
        }

        private boolean incomingCallToInCall(EventObject evt) throws SipException {
            if (SipSessionGroup.isRequestEvent("ACK", evt)) {
                String sdp = SipSessionGroup.this.extractContent((Message)((RequestEvent)evt).getRequest());
                if (sdp != null) {
                    this.mPeerSessionDescription = sdp;
                }
                if (this.mPeerSessionDescription == null) {
                    this.onError(-4, "peer sdp is empty");
                } else {
                    this.establishCall(false);
                }
                return true;
            }
            return SipSessionGroup.isRequestEvent("CANCEL", evt);
        }

        private boolean outgoingCall(EventObject evt) throws SipException {
            if (SipSessionGroup.expectResponse("INVITE", evt)) {
                ResponseEvent event = (ResponseEvent)evt;
                Response response = event.getResponse();
                int statusCode = response.getStatusCode();
                switch (statusCode) {
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: {
                        if (this.mState == 5) {
                            this.mState = 6;
                            this.cancelSessionTimer();
                            this.mProxy.onRingingBack(this);
                        }
                        return true;
                    }
                    case 200: {
                        if (this.mReferSession != null) {
                            SipSessionGroup.this.mSipHelper.sendReferNotify(this.mReferSession.mDialog, this.getResponseString(200));
                            this.mReferSession = null;
                        }
                        SipSessionGroup.this.mSipHelper.sendInviteAck(event, this.mDialog);
                        this.mPeerSessionDescription = SipSessionGroup.this.extractContent((Message)response);
                        this.establishCall(true);
                        return true;
                    }
                    case 401: 
                    case 407: {
                        if (this.handleAuthentication(event)) {
                            SipSessionGroup.this.addSipSession(this);
                        }
                        return true;
                    }
                    case 491: {
                        return true;
                    }
                }
                if (this.mReferSession != null) {
                    SipSessionGroup.this.mSipHelper.sendReferNotify(this.mReferSession.mDialog, this.getResponseString(503));
                }
                if (statusCode >= 400) {
                    this.onError(response);
                    return true;
                }
                return statusCode < 300;
                {
                }
            }
            if (END_CALL == evt) {
                this.mState = 7;
                SipSessionGroup.this.mSipHelper.sendCancel(this.mClientTransaction);
                this.startSessionTimer(3);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("INVITE", evt)) {
                RequestEvent event = (RequestEvent)evt;
                SipSessionGroup.this.mSipHelper.sendInviteBusyHere(event, event.getServerTransaction());
                return true;
            }
            return false;
        }

        private boolean outgoingCallToReady(EventObject evt) throws SipException {
            if (evt instanceof ResponseEvent) {
                ResponseEvent event = (ResponseEvent)evt;
                Response response = event.getResponse();
                int statusCode = response.getStatusCode();
                if (SipSessionGroup.expectResponse("CANCEL", evt)) {
                    if (statusCode == 200) {
                        return true;
                    }
                } else if (SipSessionGroup.expectResponse("INVITE", evt)) {
                    switch (statusCode) {
                        case 200: {
                            this.outgoingCall(evt);
                            return true;
                        }
                        case 487: {
                            this.endCallNormally();
                            return true;
                        }
                    }
                } else {
                    return false;
                }
                if (statusCode >= 400) {
                    this.onError(response);
                    return true;
                }
            } else if (evt instanceof TransactionTerminatedEvent) {
                this.onError(new SipException("timed out"));
            }
            return false;
        }

        private boolean processReferRequest(RequestEvent event) throws SipException {
            try {
                ReferToHeader referto = (ReferToHeader)event.getRequest().getHeader("Refer-To");
                Address address = referto.getAddress();
                SipURI uri = (SipURI)address.getURI();
                String replacesHeader = uri.getHeader("Replaces");
                String username = uri.getUser();
                if (username == null) {
                    SipSessionGroup.this.mSipHelper.sendResponse(event, 400);
                    return false;
                }
                SipSessionGroup.this.mSipHelper.sendResponse(event, 202);
                SipSessionImpl newSession = SipSessionGroup.this.createNewSession(event, this.mProxy.getListener(), SipSessionGroup.this.mSipHelper.getServerTransaction(event), 0);
                newSession.mReferSession = this;
                newSession.mReferredBy = (ReferredByHeader)event.getRequest().getHeader("Referred-By");
                newSession.mReplaces = replacesHeader;
                newSession.mPeerProfile = SipSessionGroup.createPeerProfile((HeaderAddress)referto);
                newSession.mProxy.onCallTransferring(newSession, null);
                return true;
            }
            catch (IllegalArgumentException e) {
                throw new SipException("createPeerProfile()", (Throwable)e);
            }
        }

        private boolean inCall(EventObject evt) throws SipException {
            if (END_CALL == evt) {
                this.mState = 10;
                SipSessionGroup.this.mSipHelper.sendBye(this.mDialog);
                this.mProxy.onCallEnded(this);
                this.startSessionTimer(3);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("INVITE", evt)) {
                this.mState = 3;
                RequestEvent event = this.mInviteReceived = (RequestEvent)evt;
                this.mPeerSessionDescription = SipSessionGroup.this.extractContent((Message)event.getRequest());
                this.mServerTransaction = null;
                this.mProxy.onRinging(this, this.mPeerProfile, this.mPeerSessionDescription);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("BYE", evt)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)evt, 200);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("REFER", evt)) {
                return this.processReferRequest((RequestEvent)evt);
            }
            if (evt instanceof MakeCallCommand) {
                this.mState = 5;
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendReinvite(this.mDialog, ((MakeCallCommand)evt).getSessionDescription());
                this.startSessionTimer(((MakeCallCommand)evt).getTimeout());
                return true;
            }
            return evt instanceof ResponseEvent && SipSessionGroup.expectResponse("NOTIFY", evt);
        }

        private boolean endingCall(EventObject evt) throws SipException {
            if (SipSessionGroup.expectResponse("BYE", evt)) {
                ResponseEvent event = (ResponseEvent)evt;
                Response response = event.getResponse();
                int statusCode = response.getStatusCode();
                switch (statusCode) {
                    case 401: 
                    case 407: {
                        if (!this.handleAuthentication(event)) break;
                        return true;
                    }
                }
                this.cancelSessionTimer();
                this.reset();
                return true;
            }
            return false;
        }

        private void startSessionTimer(int timeout) {
            if (timeout > 0) {
                this.mSessionTimer = new SessionTimer();
                this.mSessionTimer.start(timeout);
            }
        }

        private void cancelSessionTimer() {
            if (this.mSessionTimer != null) {
                this.mSessionTimer.cancel();
                this.mSessionTimer = null;
            }
        }

        private String createErrorMessage(Response response) {
            return String.format("%s (%d)", response.getReasonPhrase(), response.getStatusCode());
        }

        private void enableKeepAlive() {
            if (this.mKeepAliveSession != null) {
                this.mKeepAliveSession.stopKeepAliveProcess();
            } else {
                this.mKeepAliveSession = this.duplicate();
            }
            try {
                this.mKeepAliveSession.startKeepAliveProcess(10, this.mPeerProfile, null);
            }
            catch (SipException e) {
                Log.w(SipSessionGroup.TAG, "keepalive cannot be enabled; ignored", e);
                this.mKeepAliveSession.stopKeepAliveProcess();
            }
        }

        private void establishCall(boolean enableKeepAlive) {
            this.mState = 8;
            this.cancelSessionTimer();
            if (!this.mInCall && enableKeepAlive) {
                this.enableKeepAlive();
            }
            this.mInCall = true;
            this.mProxy.onCallEstablished(this, this.mPeerSessionDescription);
        }

        private void endCallNormally() {
            this.reset();
            this.mProxy.onCallEnded(this);
        }

        private void endCallOnError(int errorCode, String message) {
            this.reset();
            this.mProxy.onError(this, errorCode, message);
        }

        private void endCallOnBusy() {
            this.reset();
            this.mProxy.onCallBusy(this);
        }

        private void onError(int errorCode, String message) {
            this.cancelSessionTimer();
            switch (this.mState) {
                case 1: 
                case 2: {
                    this.onRegistrationFailed(errorCode, message);
                    break;
                }
                default: {
                    this.endCallOnError(errorCode, message);
                }
            }
        }

        private void onError(Throwable exception) {
            exception = SipSessionGroup.this.getRootCause(exception);
            this.onError(this.getErrorCode(exception), exception.toString());
        }

        private void onError(Response response) {
            int statusCode = response.getStatusCode();
            if (!this.mInCall && statusCode == 486) {
                this.endCallOnBusy();
            } else {
                this.onError(this.getErrorCode(statusCode), this.createErrorMessage(response));
            }
        }

        private int getErrorCode(int responseStatusCode) {
            switch (responseStatusCode) {
                case 403: 
                case 404: 
                case 406: 
                case 410: 
                case 480: 
                case 488: {
                    return -7;
                }
                case 414: 
                case 484: 
                case 485: {
                    return -6;
                }
                case 408: {
                    return -5;
                }
            }
            if (responseStatusCode < 500) {
                return -4;
            }
            return -2;
        }

        private int getErrorCode(Throwable exception) {
            String message = exception.getMessage();
            if (exception instanceof UnknownHostException) {
                return -12;
            }
            if (exception instanceof IOException) {
                return -1;
            }
            return -4;
        }

        private void onRegistrationDone(int duration) {
            this.reset();
            this.mProxy.onRegistrationDone(this, duration);
        }

        private void onRegistrationFailed(int errorCode, String message) {
            this.reset();
            this.mProxy.onRegistrationFailed(this, errorCode, message);
        }

        private void onRegistrationFailed(Throwable exception) {
            exception = SipSessionGroup.this.getRootCause(exception);
            this.onRegistrationFailed(this.getErrorCode(exception), exception.toString());
        }

        private void onRegistrationFailed(Response response) {
            int statusCode = response.getStatusCode();
            this.onRegistrationFailed(this.getErrorCode(statusCode), this.createErrorMessage(response));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startKeepAliveProcess(int interval, KeepAliveProcessCallback callback) throws SipException {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                this.startKeepAliveProcess(interval, SipSessionGroup.this.mLocalProfile, callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startKeepAliveProcess(int interval, SipProfile peerProfile, KeepAliveProcessCallback callback) throws SipException {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mKeepAliveProcess != null) {
                    throw new SipException("Cannot create more than one keepalive process in a SipSession");
                }
                this.mPeerProfile = peerProfile;
                this.mKeepAliveProcess = new KeepAliveProcess();
                this.mProxy.setListener(this.mKeepAliveProcess);
                this.mKeepAliveProcess.start(interval, callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopKeepAliveProcess() {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mKeepAliveProcess != null) {
                    this.mKeepAliveProcess.stop();
                    this.mKeepAliveProcess = null;
                }
            }
        }

        class KeepAliveProcess
        extends SipSessionAdapter
        implements Runnable {
            private static final String TAG = "SipKeepAlive";
            private boolean mRunning = false;
            private KeepAliveProcessCallback mCallback;
            private boolean mPortChanged = false;
            private int mRPort = 0;
            private int mInterval;

            KeepAliveProcess() {
            }

            void start(int interval, KeepAliveProcessCallback callback) {
                if (this.mRunning) {
                    return;
                }
                this.mRunning = true;
                this.mInterval = interval;
                this.mCallback = new KeepAliveProcessCallbackProxy(callback);
                SipSessionGroup.this.mWakeupTimer.set(interval * 1000, this);
                this.run();
            }

            boolean process(EventObject evt) throws SipException {
                if (this.mRunning && SipSessionImpl.this.mState == 9 && evt instanceof ResponseEvent && this.parseOptionsResult(evt)) {
                    if (this.mPortChanged) {
                        SipSessionGroup.this.resetExternalAddress();
                        this.stop();
                    } else {
                        SipSessionImpl.this.cancelSessionTimer();
                        SipSessionGroup.this.removeSipSession(SipSessionImpl.this);
                    }
                    this.mCallback.onResponse(this.mPortChanged);
                    return true;
                }
                return false;
            }

            public void onError(ISipSession session, int errorCode, String message) {
                this.stop();
                this.mCallback.onError(errorCode, message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                synchronized (sipSessionGroup) {
                    block6: {
                        if (!this.mRunning) {
                            return;
                        }
                        try {
                            this.sendKeepAlive();
                        }
                        catch (Throwable t) {
                            if (!this.mRunning) break block6;
                            SipSessionImpl.this.onError(t);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void stop() {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                synchronized (sipSessionGroup) {
                    this.mRunning = false;
                    SipSessionGroup.this.mWakeupTimer.cancel(this);
                    SipSessionImpl.this.reset();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void sendKeepAlive() throws SipException, InterruptedException {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                synchronized (sipSessionGroup) {
                    SipSessionImpl.this.mState = 9;
                    SipSessionImpl.this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendOptions(SipSessionGroup.this.mLocalProfile, SipSessionImpl.this.mPeerProfile, SipSessionImpl.this.generateTag());
                    SipSessionImpl.this.mDialog = SipSessionImpl.this.mClientTransaction.getDialog();
                    SipSessionGroup.this.addSipSession(SipSessionImpl.this);
                    SipSessionImpl.this.startSessionTimer(5);
                }
            }

            private boolean parseOptionsResult(EventObject evt) {
                if (SipSessionGroup.expectResponse("OPTIONS", evt)) {
                    ResponseEvent event = (ResponseEvent)evt;
                    int rPort = this.getRPortFromResponse(event.getResponse());
                    if (rPort != -1) {
                        if (this.mRPort == 0) {
                            this.mRPort = rPort;
                        }
                        if (this.mRPort != rPort) {
                            this.mPortChanged = true;
                            this.mRPort = rPort;
                        }
                    }
                    return true;
                }
                return false;
            }

            private int getRPortFromResponse(Response response) {
                ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
                return viaHeader == null ? -1 : viaHeader.getRPort();
            }
        }

        class SessionTimer {
            private boolean mRunning = true;

            SessionTimer() {
            }

            void start(final int timeout) {
                new Thread(new Runnable(){

                    public void run() {
                        SessionTimer.this.sleep(timeout);
                        if (SessionTimer.this.mRunning) {
                            SessionTimer.this.timeout();
                        }
                    }
                }, "SipSessionTimerThread").start();
            }

            synchronized void cancel() {
                this.mRunning = false;
                this.notify();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void timeout() {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                synchronized (sipSessionGroup) {
                    SipSessionImpl.this.onError(-5, "Session timed out!");
                }
            }

            private synchronized void sleep(int timeout) {
                try {
                    this.wait(timeout * 1000);
                }
                catch (InterruptedException e) {
                    Log.e(SipSessionGroup.TAG, "session timer interrupted!");
                }
            }
        }
    }

    static interface KeepAliveProcessCallback {
        public void onResponse(boolean var1);

        public void onError(int var1, String var2);
    }

    private class SipSessionCallReceiverImpl
    extends SipSessionImpl {
        public SipSessionCallReceiverImpl(ISipSessionListener listener) {
            super(listener);
        }

        private int processInviteWithReplaces(RequestEvent event, ReplacesHeader replaces) {
            String callId = replaces.getCallId();
            SipSessionImpl session = (SipSessionImpl)SipSessionGroup.this.mSessionMap.get(callId);
            if (session == null) {
                return 481;
            }
            Dialog dialog = session.mDialog;
            if (dialog == null) {
                return 603;
            }
            if (!dialog.getLocalTag().equals(replaces.getToTag()) || !dialog.getRemoteTag().equals(replaces.getFromTag())) {
                return 481;
            }
            ReferredByHeader referredBy = (ReferredByHeader)event.getRequest().getHeader("Referred-By");
            if (referredBy == null || !dialog.getRemoteParty().equals(referredBy.getAddress())) {
                return 481;
            }
            return 200;
        }

        private void processNewInviteRequest(RequestEvent event) throws SipException {
            ReplacesHeader replaces = (ReplacesHeader)event.getRequest().getHeader("Replaces");
            SipSessionImpl newSession = null;
            if (replaces != null) {
                int response = this.processInviteWithReplaces(event, replaces);
                if (response == 200) {
                    SipSessionImpl replacedSession = (SipSessionImpl)SipSessionGroup.this.mSessionMap.get(replaces.getCallId());
                    newSession = SipSessionGroup.this.createNewSession(event, replacedSession.mProxy.getListener(), SipSessionGroup.this.mSipHelper.getServerTransaction(event), 3);
                    newSession.mProxy.onCallTransferring(newSession, newSession.mPeerSessionDescription);
                } else {
                    SipSessionGroup.this.mSipHelper.sendResponse(event, response);
                }
            } else {
                newSession = SipSessionGroup.this.createNewSession(event, this.mProxy, SipSessionGroup.this.mSipHelper.sendRinging(event, this.generateTag()), 3);
                this.mProxy.onRinging(newSession, newSession.mPeerProfile, newSession.mPeerSessionDescription);
            }
            if (newSession != null) {
                SipSessionGroup.this.addSipSession(newSession);
            }
        }

        public boolean process(EventObject evt) throws SipException {
            if (SipSessionGroup.isLoggable(this, evt)) {
                Log.d(SipSessionGroup.TAG, " ~~~~~   " + this + ": " + SipSession.State.toString(this.mState) + ": processing " + SipSessionGroup.log(evt));
            }
            if (SipSessionGroup.isRequestEvent("INVITE", evt)) {
                this.processNewInviteRequest((RequestEvent)evt);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("OPTIONS", evt)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)evt, 200);
                return true;
            }
            return false;
        }
    }
}

