/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;
import android.util.Log;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.Executor;

class SipWakeupTimer
extends BroadcastReceiver {
    private static final String TAG = "_SIP.WkTimer_";
    private static final String TRIGGER_TIME = "TriggerTime";
    private static final boolean DEBUG_TIMER = false;
    private Context mContext;
    private AlarmManager mAlarmManager;
    private TreeSet<MyEvent> mEventQueue = new TreeSet<MyEvent>(new MyEventComparator());
    private PendingIntent mPendingIntent;
    private Executor mExecutor;

    public SipWakeupTimer(Context context, Executor executor) {
        this.mContext = context;
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        IntentFilter filter = new IntentFilter(this.getAction());
        context.registerReceiver(this, filter);
        this.mExecutor = executor;
    }

    public synchronized void stop() {
        this.mContext.unregisterReceiver(this);
        if (this.mPendingIntent != null) {
            this.mAlarmManager.cancel(this.mPendingIntent);
            this.mPendingIntent = null;
        }
        this.mEventQueue.clear();
        this.mEventQueue = null;
    }

    private boolean stopped() {
        if (this.mEventQueue == null) {
            Log.w(TAG, "Timer stopped");
            return true;
        }
        return false;
    }

    private void cancelAlarm() {
        this.mAlarmManager.cancel(this.mPendingIntent);
        this.mPendingIntent = null;
    }

    private void recalculatePeriods() {
        if (this.mEventQueue.isEmpty()) {
            return;
        }
        MyEvent firstEvent = this.mEventQueue.first();
        int minPeriod = firstEvent.mMaxPeriod;
        long minTriggerTime = firstEvent.mTriggerTime;
        for (MyEvent e : this.mEventQueue) {
            e.mPeriod = e.mMaxPeriod / minPeriod * minPeriod;
            int interval = (int)(e.mLastTriggerTime + (long)e.mMaxPeriod - minTriggerTime);
            interval = interval / minPeriod * minPeriod;
            e.mTriggerTime = minTriggerTime + (long)interval;
        }
        TreeSet<MyEvent> newQueue = new TreeSet<MyEvent>(this.mEventQueue.comparator());
        newQueue.addAll(this.mEventQueue);
        this.mEventQueue.clear();
        this.mEventQueue = newQueue;
    }

    private void insertEvent(MyEvent event) {
        long now = SystemClock.elapsedRealtime();
        if (this.mEventQueue.isEmpty()) {
            event.mTriggerTime = now + (long)event.mPeriod;
            this.mEventQueue.add(event);
            return;
        }
        MyEvent firstEvent = this.mEventQueue.first();
        int minPeriod = firstEvent.mPeriod;
        if (minPeriod <= event.mMaxPeriod) {
            event.mPeriod = event.mMaxPeriod / minPeriod * minPeriod;
            int interval = event.mMaxPeriod;
            interval -= (int)(firstEvent.mTriggerTime - now);
            interval = interval / minPeriod * minPeriod;
            event.mTriggerTime = firstEvent.mTriggerTime + (long)interval;
            this.mEventQueue.add(event);
        } else {
            long triggerTime = now + (long)event.mPeriod;
            if (firstEvent.mTriggerTime < triggerTime) {
                event.mTriggerTime = firstEvent.mTriggerTime;
                event.mLastTriggerTime -= (long)event.mPeriod;
            } else {
                event.mTriggerTime = triggerTime;
            }
            this.mEventQueue.add(event);
            this.recalculatePeriods();
        }
    }

    public synchronized void set(int period, Runnable callback) {
        if (this.stopped()) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        MyEvent event = new MyEvent(period, callback, now);
        this.insertEvent(event);
        if (this.mEventQueue.first() == event) {
            if (this.mEventQueue.size() > 1) {
                this.cancelAlarm();
            }
            this.scheduleNext();
        }
        long triggerTime = event.mTriggerTime;
    }

    public synchronized void cancel(Runnable callback) {
        if (this.stopped() || this.mEventQueue.isEmpty()) {
            return;
        }
        MyEvent firstEvent = this.mEventQueue.first();
        Iterator<MyEvent> iter = this.mEventQueue.iterator();
        while (iter.hasNext()) {
            MyEvent event = iter.next();
            if (event.mCallback != callback) continue;
            iter.remove();
        }
        if (this.mEventQueue.isEmpty()) {
            this.cancelAlarm();
        } else if (this.mEventQueue.first() != firstEvent) {
            this.cancelAlarm();
            firstEvent = this.mEventQueue.first();
            firstEvent.mPeriod = firstEvent.mMaxPeriod;
            firstEvent.mTriggerTime = firstEvent.mLastTriggerTime + (long)firstEvent.mPeriod;
            this.recalculatePeriods();
            this.scheduleNext();
        }
    }

    private void scheduleNext() {
        if (this.stopped() || this.mEventQueue.isEmpty()) {
            return;
        }
        if (this.mPendingIntent != null) {
            throw new RuntimeException("pendingIntent is not null!");
        }
        MyEvent event = this.mEventQueue.first();
        Intent intent = new Intent(this.getAction());
        intent.putExtra(TRIGGER_TIME, event.mTriggerTime);
        PendingIntent pendingIntent = this.mPendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
        this.mAlarmManager.set(2, event.mTriggerTime, pendingIntent);
    }

    public synchronized void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (this.getAction().equals(action) && intent.getExtras().containsKey(TRIGGER_TIME)) {
            this.mPendingIntent = null;
            long triggerTime = intent.getLongExtra(TRIGGER_TIME, -1L);
            this.execute(triggerTime);
        } else {
            Log.d(TAG, "unrecognized intent: " + intent);
        }
    }

    private void printQueue() {
        int count = 0;
        for (MyEvent event : this.mEventQueue) {
            Log.d(TAG, "     " + event + ": scheduled at " + this.showTime(event.mTriggerTime) + ": last at " + this.showTime(event.mLastTriggerTime));
            if (++count < 5) continue;
            break;
        }
        if (this.mEventQueue.size() > count) {
            Log.d(TAG, "     .....");
        } else if (count == 0) {
            Log.d(TAG, "     <empty>");
        }
    }

    private void execute(long triggerTime) {
        if (this.stopped() || this.mEventQueue.isEmpty()) {
            return;
        }
        for (MyEvent event : this.mEventQueue) {
            if (event.mTriggerTime != triggerTime) continue;
            event.mLastTriggerTime = triggerTime;
            event.mTriggerTime += (long)event.mPeriod;
            this.mExecutor.execute(event.mCallback);
        }
        this.scheduleNext();
    }

    private String getAction() {
        return this.toString();
    }

    private String showTime(long time) {
        int ms = (int)(time % 1000L);
        int s = (int)(time / 1000L);
        int m = s / 60;
        return String.format("%d.%d.%d", m, s %= 60, ms);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyEventComparator
    implements Comparator<MyEvent> {
        private MyEventComparator() {
        }

        @Override
        public int compare(MyEvent e1, MyEvent e2) {
            if (e1 == e2) {
                return 0;
            }
            int diff = e1.mMaxPeriod - e2.mMaxPeriod;
            if (diff == 0) {
                diff = -1;
            }
            return diff;
        }

        @Override
        public boolean equals(Object that) {
            return this == that;
        }
    }

    private static class MyEvent {
        int mPeriod;
        int mMaxPeriod;
        long mTriggerTime;
        long mLastTriggerTime;
        Runnable mCallback;

        MyEvent(int period, Runnable callback, long now) {
            this.mPeriod = this.mMaxPeriod = period;
            this.mCallback = callback;
            this.mLastTriggerTime = now;
        }

        public String toString() {
            String s = super.toString();
            s = s.substring(s.indexOf("@"));
            return s + ":" + this.mPeriod / 1000 + ":" + this.mMaxPeriod / 1000 + ":" + this.toString(this.mCallback);
        }

        private String toString(Object o) {
            String s = o.toString();
            int index = s.indexOf("$");
            if (index > 0) {
                s = s.substring(index + 1);
            }
            return s;
        }
    }
}

