package edu.uci.ics.seal.xposedentrypoint;

import android.annotation.SuppressLint;
import android.util.Log;
import de.robv.android.xposed.IXposedHookLoadPackage;
import de.robv.android.xposed.XC_MethodHook;
import de.robv.android.xposed.XposedHelpers;
import de.robv.android.xposed.callbacks.XC_LoadPackage.LoadPackageParam;

public final class InputLogger implements IXposedHookLoadPackage{

	@SuppressLint("NewApi")
	public void handleLoadPackage(final LoadPackageParam lpparam)
			throws Throwable {
	<#list apps as app>
		if(lpparam.packageName.contains("${app.package}")){		
			<#list app.entryPoints as entryPoint>
			XposedHelpers.findAndHookMethod("${entryPoint.class}", lpparam.classLoader, "${entryPoint.method}", <#if entryPoint.params?has_content>${entryPoint.params},</#if> new XC_MethodHook() { 
		 	    @Override
			    protected void afterHookedMethod(MethodHookParam param) throws Throwable {
					Log.d("cactus_instrumentation", "App_Entry_Point ### ${entryPoint.sig}");
			    }
			});
            </#list>
		}
	</#list>
	}
}
