import java.io.*;


public class ConsoleInput
{
	public static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));


	public static String readString()
	{
		try
		{
			return in.readLine();
		}
		catch (IOException e)
		{
			throw new InterpreterException("I/O failure");
		}
	}


	public static Integer readInteger()
	{
		try
		{
			return new Integer(Integer.parseInt(in.readLine()));
		}
		catch (IOException e)
		{
			throw new InterpreterException("I/O failure");
		}
		catch (NumberFormatException e)
		{
			throw new InterpreterException("numeric input required");
		}
	}


	public static Boolean readBoolean()
	{
		try
		{
			String s = in.readLine();
			
			if (s.equals("true"))
			{
				return new Boolean(true);
			}
			else if (s.equals("false"))
			{
				return new Boolean(false);
			}
			else
			{
				throw new InterpreterException("boolean input ('true' or 'false') required");
			}
		}
		catch (IOException e)
		{
			throw new InterpreterException("I/O failure");
		}
	}
}
