import java.util.*;


public class Driver
{
	public static void main(String[] args)
	{
		if (args.length != 1)
		{
			System.out.println("Usage: java Driver input_filename");
			return;
		}

		try
		{
			Parser p = new Parser(new Scanner(new java.io.FileReader(args[0])));

			ArrayList ast = (ArrayList) p.parse().value;

			Analyzer a = new Analyzer(ast);
			a.analyze();

			if (ErrorReporter.getSemanticErrorCount() > 0)
			{
				System.out.println("" + ErrorReporter.getSemanticErrorCount() + " semantic error(s) found");
			}
			else
			{
				Interpreter i = new Interpreter(ast);
				i.interpret();
			}
		}
		catch (java.io.FileNotFoundException e)
		{
			System.out.println("Input file " + args[0] + " not found");
		}
		catch (InterpreterException e)
		{
			System.out.println("Run-time error during interpretation:");
			System.out.println(e.getMessage());
			System.out.println("Interpretation aborted");
		}
		catch (ParserError e)
		{
			System.out.println(e.getMessage());
			System.out.println("Analysis aborted");
		}
		catch (ScannerError e)
		{
			System.out.println(e.getMessage());
			System.out.println("Analysis aborted");
		}
		catch (Exception e)
		{
			System.out.println("Analysis aborted due to exception:");
			e.printStackTrace();
		}
	}
}
