import java.util.*;


public class Interpreter
{
	private ArrayList ast;


	public Interpreter(ArrayList ast)
	{
		this.ast = ast;
	}


	public void interpret()
	{
		// Create a new symbol table

		SymbolTable st = new SymbolTable();


		// Initialize it with all the global definitions.  This could
		// theoretically introduce scoping problems (allowing global 
		// variables to be used before declared), but it doesn't in
		// reality, since semantic checking has already eliminated those
		// cases for us.

		for (int i = 0; i < ast.size(); ++i)
		{
			Definition d = (Definition) ast.get(i);
			d.declare(st);
		}


		// Now we call the program() procedure, which gets the program
		// started.

		Subprogram programSub = st.lookupSubprogram("program");
		
		if (programSub == null || !programSub.getParameterTypeList().isEmpty() || programSub.isFunction())
		{
			throw new InterpreterException("Program has no procedure with this signature: procedure program()");
		}
		
		SubprogramDeclaration programSD = programSub.getDeclaration();
		programSD.call(st, new ArrayList());
	}
}
