import java.util.*;


public class Subprogram extends SymbolTableEntry
{
	private ArrayList parameterTypeList;
	private boolean function;
	private Type returnType;
	private SubprogramDeclaration declaration;


	public Subprogram(
		String identifier, ArrayList parameterTypeList,
		boolean isFunction, Type returnType,
		SubprogramDeclaration declaration)
	{
		super(identifier);
		this.parameterTypeList = parameterTypeList;
		this.function = isFunction;
		this.returnType = returnType;
		this.declaration = declaration;
	}


	public ArrayList getParameterTypeList()
	{
		return parameterTypeList;
	}


	public boolean isProcedure()
	{
		return !function;
	}


	public boolean isFunction()
	{
		return function;
	}


	public Type getReturnType()
	{
		return returnType;
	}


	public SubprogramDeclaration getDeclaration()
	{
		return declaration;
	}
}
