import java.util.*;


public class SymbolTable
{
	private HashMap typeMap;
	private HashMap subprogramMap;
	private ArrayList variableMaps;


	public SymbolTable()
	{
		typeMap = new HashMap();

		declareType("integer", new Integer(0));
		declareType("string", "");
		declareType("boolean", new Boolean(false));
		
		subprogramMap = new HashMap();

		declareSubprogram("read_string", new ArrayList(), true, lookupType("string"),
			new PredefinedSubprogramDeclaration("read_string", null, "",
				null, -1, -1, new PredefinedReadStringBody()));

		ArrayList printStringParameterTypeList = new ArrayList();
		printStringParameterTypeList.add(lookupType("string"));
		declareSubprogram("print_string", printStringParameterTypeList, false, null,
			new PredefinedSubprogramDeclaration("print_string", null, "",
				null, -1, -1, new PredefinedPrintBody()));

		declareSubprogram("read_integer", new ArrayList(), true, lookupType("integer"),
			new PredefinedSubprogramDeclaration("read_integer", null, "",
				null, -1, -1, new PredefinedReadIntegerBody()));
		
		ArrayList printIntegerParameterTypeList = new ArrayList();
		printIntegerParameterTypeList.add(lookupType("integer"));
		declareSubprogram("print_integer", printIntegerParameterTypeList, false, null,
			new PredefinedSubprogramDeclaration("print_integer", null, "",
				null, -1, -1, new PredefinedPrintBody()));

		declareSubprogram("read_boolean", new ArrayList(), true, lookupType("boolean"),
			new PredefinedSubprogramDeclaration("read_boolean", null, "",
				null, -1, -1, new PredefinedReadBooleanBody()));
		
		ArrayList printBooleanParameterTypeList = new ArrayList();
		printBooleanParameterTypeList.add(lookupType("boolean"));
		declareSubprogram("print_boolean", printBooleanParameterTypeList, false, null,
			new PredefinedSubprogramDeclaration("print_boolean", null, "",
				null, -1, -1, new PredefinedPrintBody()));
		
		declareSubprogram("print_endline", new ArrayList(), false, null,
			new PredefinedSubprogramDeclaration("print_endline", null, "",
				null, -1, -1, new PredefinedPrintEndlineBody()));

		variableMaps = new ArrayList();
		variableMaps.add(new ArrayList());

		enterScope();
	}


	public void enterScope()
	{
		ArrayList currentMap = (ArrayList) variableMaps.get(variableMaps.size() - 1);
		currentMap.add(new HashMap());
	}
	
	
	public void exitScope()
	{
		ArrayList currentMap = (ArrayList) variableMaps.get(variableMaps.size() - 1);
		currentMap.remove(currentMap.size() - 1);
	}


	public void enterSubprogramCall()
	{
		variableMaps.add(new ArrayList());
		enterScope();
	}
	
	
	public void exitSubprogramCall()
	{
		exitScope();
		variableMaps.remove(variableMaps.size() - 1);
	}


	public Type lookupType(String identifier)
	{
		return (Type) typeMap.get(identifier);
	}


	public void declareType(String identifier, Object initialValue)
	{
		typeMap.put(identifier, new Type(identifier, initialValue));
	}
	
	
	public Subprogram lookupSubprogram(String identifier)
	{
		return (Subprogram) subprogramMap.get(identifier);
	}


	public void declareSubprogram(
		String identifier, ArrayList parameterList,
		boolean isFunction, Type returnType,
		SubprogramDeclaration declaration)
	{
		Subprogram sub = new Subprogram(identifier, parameterList, isFunction, returnType, declaration);
		subprogramMap.put(identifier, sub);
	}
	
	
	public Variable lookupVariable(String identifier)
	{
		ArrayList currentMap = (ArrayList) variableMaps.get(variableMaps.size() - 1);

		for (int i = currentMap.size() - 1; i >= 0; --i)
		{
			HashMap scopeVariableMap = (HashMap) currentMap.get(i);
			
			Variable v = (Variable) scopeVariableMap.get(identifier);
			
			if (v != null)
				return v;
		}

		if (variableMaps.size() > 1)
		{
			ArrayList globalMap = (ArrayList) variableMaps.get(0);
			
			for (int i = globalMap.size() - 1; i >= 0; --i)
			{
				HashMap scopeVariableMap = (HashMap) globalMap.get(i);
				
				Variable v = (Variable) scopeVariableMap.get(identifier);
				
				if (v != null)
					return v;
			}
		}

		return null;
	}


	public Variable lookupLocalVariable(String identifier)
	{
		ArrayList currentMap = (ArrayList) variableMaps.get(variableMaps.size() - 1);
		HashMap localVariableMap = (HashMap) currentMap.get(currentMap.size() - 1);
		return (Variable) localVariableMap.get(identifier);
	}


	public void declareVariable(String identifier, Type type)
	{
		Variable v = new Variable(identifier, type, type != null ? type.getInitialValue() : null);

		ArrayList currentMap = (ArrayList) variableMaps.get(variableMaps.size() - 1);
		HashMap localVariableMap = (HashMap) currentMap.get(currentMap.size() - 1);
		localVariableMap.put(identifier, v);
	}
}
