-- CreateDB.sql
--
-- ICS 184 / EECS 116 Summer 2006
-- Code Example
--
-- This SQL script creates the database used in the JDBC examples from
-- lecture.


DROP DATABASE IF EXISTS jdbc_example;

CREATE DATABASE jdbc_example;

USE jdbc_example;

CREATE TABLE job_title_code(
	job_code INTEGER NOT NULL,
	job_title VARCHAR(50) NOT NULL,
	PRIMARY KEY(job_code),
	UNIQUE(job_title));

CREATE TABLE employee(
	employee_id INTEGER NOT NULL,
	employee_name VARCHAR(50) NOT NULL,
	annual_salary NUMERIC(11, 2) NOT NULL,
	job_code INTEGER,
	PRIMARY KEY(employee_id),
	FOREIGN KEY(job_code) REFERENCES job_title_code(job_code)
		ON DELETE SET NULL
		ON UPDATE CASCADE);

CREATE TABLE paycheck(
	paycheck_id INTEGER AUTO_INCREMENT NOT NULL,
	employee_id INTEGER NOT NULL,
	paycheck_date DATE NOT NULL,
	paycheck_amount NUMERIC(11, 2) NOT NULL,
	PRIMARY KEY(paycheck_id),
	FOREIGN KEY(employee_id) REFERENCES employee(employee_id)
		ON DELETE RESTRICT
		ON UPDATE CASCADE);

INSERT INTO job_title_code VALUES (101, 'Lecturer');
INSERT INTO job_title_code VALUES (102, 'Professor');
INSERT INTO job_title_code VALUES (103, 'Software Developer');
INSERT INTO job_title_code VALUES (104, 'IT Support Engineer');
INSERT INTO job_title_code VALUES (105, 'Database Administrator');
INSERT INTO job_title_code VALUES (106, 'Chief Executive Officer');

INSERT INTO employee VALUES (301, 'Alex Thornton', 300000.00, 101);
INSERT INTO employee VALUES (302, 'Jeremy Heckman', 350000.00, 106);
INSERT INTO employee VALUES (303, 'Sherwood Rowland', 450000.00, 102);
INSERT INTO employee VALUES (304, 'Julian Jones', 500000.00, 103);
INSERT INTO employee VALUES (305, 'Howard Smith', 375000.00, 103);
INSERT INTO employee VALUES (306, 'Mike Brandywine', 400000.00, 105);
INSERT INTO employee VALUES (307, 'Kyle Grunion', 330000.00, 104);
