// JDBCExample1.java
//
// ICS 184 / EECS 116 Summer 2006
// Code Example
//
// This program connects to the jdbc_example database from lecture, looks
// up information about every employee (sorted in ascending order by employee
// ID), and prints the ID and name of each employee to the console.
//
// Before attempting to run this program, be sure that you've created the
// jdbc_example database.  Also, you should replace the password in the
// JDBC connection URL with your root password.
//
// I've made no attempt to handle exceptions properly in this example.


import java.sql.*;


public class JDBCExample1
{
	// A Connection is an object that represents a connection to a database.
	// Before you can issue SQL statements, you must first establish a
	// connection.
	private static Connection connection;

	
	public static void main(String[] args)
	throws Exception
	{
		// Before you can use a JDBC driver, it's necessary for the Java
		// Virtual Machine to load its driver class.  Normally, when you
		// have an expression in a Java program such as "new Driver()",
		// the JVM will automatically load a class.  However, when there
		// is no such statement, you can't use the class without making
		// sure that it's loaded first.  When using a JDBC driver, the
		// most common way to get a connection is to let a static method
		// called DriverManager.getConnection() do the work; it loads up
		// the appropriate driver, given a connection URL, but it won't
		// necessarily work unless the class has first been loaded.
		//
		// The line below is a way to force the JVM to load the class
		// before it's used.

		Class.forName("com.mysql.jdbc.Driver").newInstance();


		// Creates a connection to the database.  Notice that the URL
		// includes the "protocol" (JDBC), an indication of what kind of
		// database you're connecting to (mysql), the name of the machine
		// that's running the database server (where "localhost" represents
		// "this machine"), the name of the database (jdbc_example), the
		// username, and password.  With all of this information, the
		// DriverManager can successfully initiate a connection to a
		// particular database on a particular database server.
		//
		// *** REPLACE THE PASSWORD IN THE CONNECTION URL BELOW WITH YOUR
		//     OWN ROOT PASSWORD BEFORE EXECUTING THE PROGRAM ***

		connection = DriverManager.getConnection(
			"jdbc:mysql://localhost/jdbc_example?user=root&password=password");


		// To execute an SQL statement via JDBC, you first need some kind
		// of statement object.  The simplest flavor of statement object is
		// of type Statement.
		//
		// The creation of a new statement is te responsibility of the
		// connection.  Whenever you want to issue a statement, you first
		// ask the connection for a statement, then execute the statement.
		// The createStatement() method creates and returns an object that
		// implements the Statement interface.
		
		Statement statement = connection.createStatement();


		// One way to use a Statement to execute an SQL statement is to call
		// executeQuery() and pass it an SQL statement as a string parameter.
		// Note that executeQuery() expects the provided SQL statement to be
		// a SELECT statement.
		//
		// Since queries return a set of results -- essentially a table --
		// you get back a ResultSet from executeQuery().
		
		ResultSet rs = statement.executeQuery(
			"SELECT employee_id, employee_name FROM employee ORDER BY employee_id");


		// A ResultSet is somewhat like a collection such as an ArrayList;
		// you can iterate over it one row at a time, pulling information
		// out of columns one at a time in each row.
		// 
		// Initially, a ResultSet's "cursor" is pointing just before the
		// first row.  That cursor can be advanced by calling next() on the
		// ResultSet.  The values in each column of the current row can be
		// accessed by calling the appropriate getXXX() method, where XXX
		// indicates what type of data you expect to get out of the column.
		//
		// That said, this loop goes through all of the rows in the ResultSet,
		// pulling out the employee ID from column 1 and the employee name
		// from column 2, then printing the two values out on one line.

		while (rs.next())
		{
			int employeeId = rs.getInt(1);
			String employeeName = rs.getString(2);
			
			System.out.println(employeeId + ": " + employeeName);
		}


		// It's important to close ResultSets, Statements, and Connections
		// when you're done with them, to ensure that resources are
		// deallocated completely and in a timely way.  Failure to call
		// close() means that the resources won't be deallocated until the
		// ResultSet, Statement, or Connection objects are garbage collected,
		// which could be soon or could be a long time from now; it's hard to
		// predict.  Better to be sure that the resources are deallocated
		// as soon as possible; never forget to close ResultSets, Statements,
		// or Connections as soon as you're done using them.
		
		rs.close();
		statement.close();		
		connection.close();
	}
}
