// JDBCExample2.java
//
// ICS 184 / EECS 116 Summer 2006
// Code Example
//
// This program connects to the jdbc_example database from lecture and
// prints information about all employees who have a particular job title.
//
// The key feature that I used in this example was PreparedStatement.
// PreparedStatements differ from Statements in two ways:
//
// (1) A PreparedStatement is sent to the database server ahead of time,
//     with placeholders used to parameterize the statement, so that it
//     can be used multiple times with different values passed as parameters.
//     The database server parses, compiles, and comes up with an execution
//     plan for a PreparedStatement as soon as it's sent, but before it's
//     actually executed.  The statement can then be executed as many times
//     as you'd like, but the database server won't have to parse it,
//     compile it, or build an execution plan for it again each time.
//
// (2) PreparedStatements also know how to fill in parameters safely, which
//     means, for example, that it won't be necessary for you to replace
//     every single-quote in every string with "\'".  This, alone, makes
//     PreparedStatements very compelling, since it's difficult to construct
//     queries that follow every little rule about, say, string literals or
//     numeric values.
//
// I also added a quick and dirty console-mode user interface that asks the
// user for a job title.


import java.sql.*;
import java.util.Scanner;


public class JDBCExample2
{
	private static Connection connection;
	private static Scanner scanner = new Scanner(System.in);


	public static void main(String[] args)
	throws Exception
	{
		Class.forName("com.mysql.jdbc.Driver").newInstance();


		// *** REPLACE THE PASSWORD IN THE CONNECTION URL BELOW WITH YOUR
		//     OWN ROOT PASSWORD BEFORE EXECUTING THE PROGRAM ***

		connection = DriverManager.getConnection(
			"jdbc:mysql://localhost/jdbc_example?user=root&password=password");


		// To create a new PreparedStatement, you ask the connection to
		// prepare you one.  As a parameter, pass it the query, with "?"
		// representing a placeholder for a parameter that will be passed
		// to the statement before executing it.  You can have as many
		// placeholders as you want, each denoted by "?"; they're indexed,
		// beginning at 1.
		//
		// In this example, we're creating a query with one placeholder,
		// which will be replaced with a job title before the query is
		// executed.

		PreparedStatement ps = connection.prepareStatement(
			"SELECT employee_id, employee_name "
			+ "FROM employee NATURAL JOIN job_title_code "
			+ "WHERE job_title = ? ");


		// Ask the user for the job title
		
		System.out.print("Job title: ");
		String jobTitle = scanner.nextLine();


		// To set parameters in a PreparedStatement before executing it,
		// call the various setXXX() methods on it, with XXX replaced with
		// the type of data you'd like to pass as parameters.  In our case,
		// we'd like to set the parameter to be the job title, which is a
		// string.
		
		ps.setString(1, jobTitle);


		// Note that there's an executeQuery() method in PreparedStatement,
		// just as there's an executeQuery() in Statement, but that it isn't
		// necessary to pass it a parameter, since the PreparedStatement
		// already knows what query to run.
		
		ResultSet rs = ps.executeQuery();

		while (rs.next())
		{
			int employeeId = rs.getInt(1);
			String employeeName = rs.getString(2);
			
			System.out.println(employeeId + ": " + employeeName);
		}
		
		rs.close();
		ps.close();
		connection.close();
	}
}
