// JDBCExample3.java
//
// ICS 184 / EECS 116 Summer 2006
// Code Example
//
// This program connects to the jdbc_example database from lecture and adds
// a new employee to the database, given the employee's name, job title,
// and salary.  The employee is given a "fresh" ID number, using the trick
// of first getting the maximum existing ID number, then adding 1 to it.
// Also new here is the use of a PreparedStatement to perform a database
// update (in the form of an INSERT statement) rather than a query.
//
// (Note that this trick only works if you can be sure that a concurrent
// transaction won't add a new employee between the time you calculate the
// maximum ID and the time you add the employee.  There are better solutions
// to this problem, such as AUTO_INCREMENT columns in MySQL or sequences in
// PostgreSQL.)
//
// As with the previous examples, this program makes no attempt to handle
// exceptions, even "expected" ones such as the job title not existing in
// the database.


import java.sql.*;
import java.math.BigDecimal;


public class JDBCExample3
{
	private static Connection connection;

	
	public static void main(String[] args)
	throws Exception
	{
		Class.forName("com.mysql.jdbc.Driver").newInstance();


		// *** REPLACE THE PASSWORD IN THE CONNECTION URL BELOW WITH YOUR
		//     OWN ROOT PASSWORD BEFORE EXECUTING THE PROGRAM ***

		connection = DriverManager.getConnection(
			"jdbc:mysql://localhost/jdbc_example?user=root&password=password");

		int adminCode = getJobCodeFromTitle("Database Administrator");

		int nextEmployeeID = getNextEmployeeID();
		
		addNewEmployee(nextEmployeeID, "Mick Jagger",
			new BigDecimal("10000000.33"), adminCode);
		
		connection.close();
	}
	
	
	private static int getJobCodeFromTitle(String jobTitle)
	throws Exception
	{
		PreparedStatement ps = connection.prepareStatement(
			"SELECT job_code FROM job_title_code WHERE job_title = ? ");
		
		ps.setString(1, jobTitle);
		
		ResultSet rs = ps.executeQuery();
		
		rs.next();
		
		int jobCode = rs.getInt(1);
		
		rs.close();
		
		return jobCode;
	}


	private static int getNextEmployeeID()
	throws Exception
	{
		PreparedStatement ps = connection.prepareStatement(
			"SELECT MAX(employee_id) FROM employee ");
		
		ResultSet rs = ps.executeQuery();
		
		rs.next();
		
		int maxEmployeeID = rs.getInt(1);
		
		rs.close();
		
		return maxEmployeeID + 1;
	}
	
	
	public static void addNewEmployee(
		int employeeID, String employeeName,
		BigDecimal salary, int jobCode)
	throws Exception
	{
		// PreparedStatements can be used for INSERT, UPDATE, and DELETE
		// statements, in addition to SELECTs.  In the case of INSERT,
		// UPDATE, or DELETE statements, an update is being made to the
		// database, so executeUpdate() is used to execute the statement,
		// rather than executeQuery().  executeUpdate() returns the number
		// of affected rows, if you need to know it; I'm ignoring it in
		// this case.

		PreparedStatement ps = connection.prepareStatement(
			"INSERT INTO employee VALUES (?, ?, ?, ?) ");
		
		ps.setInt(1, employeeID);
		ps.setString(2, employeeName);
		ps.setBigDecimal(3, salary);
		ps.setInt(4, jobCode);
		
		ps.executeUpdate();
		
		ps.close();
	}
}
