# AutoScheduleMailingsForNewCustomer.sql
#
# ICS 184 / EECS 116 Spring 2006
# Code Example
#
# This is an example of a trigger, which is intended to automatically schedule
# "New customer" mailings for newly-created customers.  Unlike the stored
# procedure presented in ScheduleMailingsForNewCustomer.sql, this trigger
# will be called by the database engine automatically every time a new row
# is added to the customer table, which is a handy way of ensuring that, no
# matter where or how customers are added, the mailings will be scheduled
# as appropriate.
#
# The body of the procedure is virtually identical to the body of the
# schedule_mailings_for_new_customer procedure, so I haven't included
# comments below; see that procedure for more information about how it
# works.  For this example, pay special attention to the header information,
# which says "apply the trigger after every INSERT operation on the customer
# table, and apply it for each row that's inserted."
#
# The DELIMITER statements are necessary only so that MySQL is not confused,
# by the presence of semicolons, into thinking that the procedure has ended
# prematurely.


DELIMITER //

CREATE TRIGGER auto_schedule_mailings_for_new_customer
AFTER INSERT ON customer
FOR EACH ROW
BEGIN
    DECLARE mid INTEGER;
    DECLARE mstate CHAR(2);
    DECLARE done INT DEFAULT 0;
    DECLARE m CURSOR FOR SELECT mailing_id, mailing_state
                         FROM mailing
                         WHERE mailing_type = 'NEW';
    DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
    
    OPEN m;
    
    REPEAT
        FETCH m INTO mid, mstate;
        
        IF NOT done THEN
            IF mstate = NEW.customer_state THEN

                INSERT INTO scheduled_mailing
                VALUES (NEW.customer_id, mid, CURDATE());

            END IF;
        END IF;
    UNTIL done END REPEAT;
    
    CLOSE m;
END;//

DELIMITER ;
