# FullName.sql
#
# ICS 184 / EECS 116 Summer 2006
# Code Example
#
# This stored function calculates a full name, given a first and last name,
# taking care to specially handle the case where a first or last name is
# missing.
#
# This example is a variation on the example from lecture, with the first
# and last name passed as parameters, instead of the customer ID being passed;
# there is no longer a need for a SELECT within the function, which will make
# the function run much more efficiently.  It will also make the function more
# general, since it will no longer be restricted to calculating full names for
# only customers.
#
# The CONCAT function is a predefined function provided by MySQL, which takes
# some number of strings as parameters and returns the concatenation of those
# strings.
#
# One could make the argument that this function is really a presentation
# function, one that is purely in the business of taking data and presenting
# it nicely.  One could then extend this argument to say that databases aren't
# in the presentation business at all, which means that this function is not
# appropriate for a database.  This is partly true, though there is a benefit
# in having this function in a database, if you want to be able to write
# certain kinds of queries.  For example, if you wanted a list of the top five
# customers from California, sorted alphabetically by their full name, but
# there was a large number of customers, having this function would allow the
# database to find the five customers, rather than sending all of the customer
# information to the presentation layer (e.g., a web server, probably running
# on a different machine) and making it figure out which five are appropriate.
#
# An example of this kind of query is:
#
#     SELECT customer_id, full_name(first_name, last_name), customer_city
#     FROM customer
#     WHERE customer_state = 'CA'
#     ORDER BY full_name(first_name, last_name)
#     LIMIT 5

DELIMITER //

CREATE FUNCTION full_name(first_name VARCHAR(100), last_name VARCHAR(100))
RETURNS VARCHAR(201)
BEGIN
	IF last_name = '' THEN
		RETURN first_name;
	ELSE IF first_name = '' THEN
		RETURN last_name;
	ELSE
		RETURN CONCAT(first_name, ' ', last_name);
	END IF;
END;//

DELIMITER ;
