# InsertCustomerWithPersonalShopper.sql
#
# ICS 184 / EECS 116 Summer 2006
# Code Example
#
# This stored procedure inserts a customer, along with a personal shopper
# relationship, into the database we've been using as a running example
# all quarter.  It takes enough information as parameters to execute both
# INSERT statements, then arranges the parameters appropriately into them.
#
# This procedure can be called with a CALL statement in SQL, an example of
# which is:
#
#     CALL insert_customer_with_personal_shopper(101, 'Alex', 'Thornton', 201);
#
# The DELIMITER statements are necessary only so that MySQL is not confused,
# by the presence of semicolons, into thinking that the procedure has ended
# prematurely.


DELIMITER //

CREATE PROCEDURE insert_customer_with_personal_shopper(
    cid INTEGER, fname CHAR(20), lname CHAR(20), psid INTEGER)
BEGIN
    INSERT INTO customer VALUES (cid, fname, lname);
    INSERT INTO personal_shopper VALUES (cid, psid);
END;//

DELIMITER ;
