#ifndef PROBLEM2_HPP
#define PROBLEM2_HPP

#include <functional>



template <typename LineType>
class TextLineReader
{
public:
    using LineParser = std::function<LineType(const std::string&)>;

public:
    TextLineReader(const std::string& filePath, LineParser lineParser);
    ~TextLineReader();

    TextLineReader(const TextLineReader& other) = delete;
    TextLineReader& operator=(const TextLineReader& other) = delete;

    bool hasNextLine() const;
    LineType nextLine();
};



#endif

